/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.data.process.dataset.rowset;

import com.kingdee.bos.ctrl.common.util.ArrayUtil;
import com.kingdee.bos.ctrl.common.util.DBUtil;
import com.kingdee.bos.ctrl.data.engine.resultset.BasicResultSet;
import com.kingdee.bos.ctrl.data.engine.resultset.SimpleResultSetMetaData;
import com.kingdee.bos.ctrl.data.process.dataset.AbstractDataSetProcess;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Arrays;

public class SimpleColumnsMerger
extends AbstractDataSetProcess {
    protected ResultSet resultSet;
    protected int[] mergerCols;
    protected String newColName;
    protected int newColIdx;
    protected ResultSetMetaData oldMeta;

    public void setMergerColumns(int[] cols) {
        this.mergerCols = cols;
        for (int i = 0; i < this.mergerCols.length; ++i) {
            if (cols[i] < 1) {
                throw new IllegalArgumentException("Bad column:" + cols[i]);
            }
            for (int j = 0; j < cols.length; ++j) {
                if (i == j || this.mergerCols[i] != cols[j]) continue;
                throw new IllegalArgumentException("Specified a pair of repeated columns:" + cols[i]);
            }
        }
    }

    public void setMergerColumns(String[] cols) throws SQLException {
        if (this.resultSet == null) {
            throw new UnsupportedOperationException("resultSet not set.");
        }
        int[] cols_int = new int[cols.length];
        for (int i = 0; i < cols_int.length; ++i) {
            cols_int[i] = this.resultSet.findColumn(cols[i]);
        }
        this.setMergerColumns(cols_int);
    }

    public void setNewColumn(int newColIndex, String newColName) {
        this.newColIdx = newColIndex;
        this.newColName = newColName;
    }

    public void setResultSet(ResultSet rs) {
        this.resultSet = rs;
    }

    private final ResultSetMetaData makeTargetMetaData() throws SQLException {
        this.oldMeta = this.resultSet.getMetaData();
        SimpleResultSetMetaData newMeta = new SimpleResultSetMetaData(this.oldMeta);
        int type = newMeta.getColumnType(this.mergerCols[0]);
        Arrays.sort(this.mergerCols);
        for (int i = this.mergerCols.length - 1; i >= 0; --i) {
            newMeta.deleteColumn(this.mergerCols[i]);
        }
        newMeta.addColumn(this.newColIdx, this.newColName, type);
        return newMeta;
    }

    @Override
    public Object call() throws SQLException {
        if (this.newColIdx == -1) {
            this.newColIdx = this.resultSet.getMetaData().getColumnCount() - this.mergerCols.length + 1;
        }
        _ResultSet rs = new _ResultSet();
        return rs;
    }

    class _ResultSet
    extends BasicResultSet
    implements ResultSet {
        ResultSetMetaData meta;
        private boolean lastWasNull = false;
        private int eat = 0;
        private Object[] rowsData;
        private Object[] rawRow;

        _ResultSet() throws SQLException {
            this.meta = SimpleColumnsMerger.this.makeTargetMetaData();
            this.rawRow = new Object[SimpleColumnsMerger.this.oldMeta.getColumnCount()];
        }

        @Override
        public ResultSetMetaData getMetaData() {
            return this.meta;
        }

        @Override
        public Object getObject(int columnIndex) throws SQLException {
            super.getObject(columnIndex);
            if (this.rowsData == null) {
                int i;
                DBUtil.readRow((ResultSet)SimpleColumnsMerger.this.resultSet, (Object[])this.rawRow);
                Object[] vals2 = new Object[this.meta.getColumnCount()];
                int targetCol = 1;
                for (i = 0; i < this.rawRow.length; ++i) {
                    if (targetCol == SimpleColumnsMerger.this.newColIdx) {
                        ++targetCol;
                        continue;
                    }
                    if (Arrays.binarySearch(SimpleColumnsMerger.this.mergerCols, i + 1) >= 0) continue;
                    vals2[targetCol - 1] = this.rawRow[i];
                    ++targetCol;
                }
                this.rowsData = new Object[SimpleColumnsMerger.this.mergerCols.length];
                for (i = 0; i < SimpleColumnsMerger.this.mergerCols.length; ++i) {
                    vals2[SimpleColumnsMerger.this.newColIdx - 1] = this.rawRow[SimpleColumnsMerger.this.mergerCols[i] - 1];
                    this.rowsData[i] = ArrayUtil.copyGenericArray((Object[])vals2);
                }
            }
            Object[] rowData = (Object[])this.rowsData[(this.eat - 1) % SimpleColumnsMerger.this.mergerCols.length];
            return rowData[columnIndex - 1];
        }

        @Override
        public boolean next() throws SQLException {
            super.next();
            boolean b = true;
            this.rowsData = null;
            if (this.eat++ % SimpleColumnsMerger.this.mergerCols.length == 0 && !(b = SimpleColumnsMerger.this.resultSet.next())) {
                this.cursorStatus = -2;
            }
            return b;
        }

        @Override
        public boolean wasNull() throws SQLException {
            return this.lastWasNull;
        }

        @Override
        public void close() throws SQLException {
            super.close();
            DBUtil.closeResultSet((ResultSet)SimpleColumnsMerger.this.resultSet);
        }
    }
}

