/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.data.process.dataset.rowset;

import com.kingdee.bos.ctrl.common.NullValue;
import com.kingdee.bos.ctrl.data.engine.resultset.IRowNode;
import com.kingdee.bos.ctrl.data.engine.resultset.SimpleResultSet;
import com.kingdee.bos.ctrl.data.engine.resultset.SimpleResultSetMetaData;
import com.kingdee.bos.ctrl.data.engine.resultset.SimpleRowNode;
import com.kingdee.bos.ctrl.data.process.dataset.AbstractDataSetProcess;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;

public class SimpleProjectionAcross
extends AbstractDataSetProcess {
    protected ResultSet resultSet;
    protected String[] axisValues;
    protected int xAxisMappingField;
    protected String[] yAxisValues;
    protected int yAxisMappingField;
    protected String yAxisFieldName;
    protected int acrossColumn;

    public void setResultSet(ResultSet resultSet) {
        this.resultSet = resultSet;
    }

    public void setXAxisInfo(String[] targetColumns, int mappingField) {
        this.axisValues = targetColumns;
        this.xAxisMappingField = mappingField;
    }

    public void setYAxisInfo(String[] targetRows, int mappingField, String newColName) {
        this.yAxisValues = targetRows;
        this.yAxisMappingField = mappingField;
        this.yAxisFieldName = newColName;
    }

    public void setAcrossColumn(int column) {
        this.acrossColumn = column;
    }

    @Override
    public Object call() throws SQLException {
        HashMap rowsMap = new HashMap();
        HashMap colsMap = new HashMap();
        Object[][] vals = this.buildTable(rowsMap, colsMap);
        while (this.resultSet.next()) {
            Object colPos;
            Object rowPos;
            Object rowVal = this.resultSet.getObject(this.yAxisMappingField);
            if (rowVal == null) {
                rowVal = NullValue.NULL_OBJECT;
            }
            if ((rowPos = rowsMap.get(rowVal)) == null) continue;
            Object colVal = this.resultSet.getObject(this.xAxisMappingField);
            if (colVal == null) {
                colVal = NullValue.NULL_OBJECT;
            }
            if ((colPos = colsMap.get(colVal)) == null) continue;
            vals[((Integer)rowPos).intValue()][((Integer)colPos).intValue()] = this.resultSet.getObject(this.acrossColumn);
        }
        _RowNode firstNode = new _RowNode(0, vals);
        int targetRows = this.yAxisValues.length;
        SimpleResultSet rs = new SimpleResultSet(firstNode, targetRows, this.makeTargetMetaData());
        return rs;
    }

    private final ResultSetMetaData makeTargetMetaData() throws SQLException {
        ResultSetMetaData meta = this.resultSet.getMetaData();
        SimpleResultSetMetaData metaImpl = new SimpleResultSetMetaData();
        metaImpl.addColumn(1, this.yAxisFieldName, meta.getColumnType(this.yAxisMappingField));
        for (int i = 0; i < this.axisValues.length; ++i) {
            metaImpl.addColumn(i + 2, this.axisValues[i], meta.getColumnType(this.acrossColumn));
        }
        return metaImpl;
    }

    private final Object[][] buildTable(HashMap rowsMap, HashMap colsMap) {
        Object key;
        int i;
        Object[][] table = new Object[this.yAxisValues.length][this.axisValues.length + 1];
        for (i = 0; i < this.yAxisValues.length; ++i) {
            key = this.yAxisValues[i];
            if (key == null) {
                key = NullValue.NULL_OBJECT;
            }
            Object object = key;
            table[i][0] = object;
            rowsMap.put(object, new Integer(i));
        }
        for (i = 0; i < this.axisValues.length; ++i) {
            key = this.axisValues[i];
            if (key == null) {
                key = NullValue.NULL_OBJECT;
            }
            colsMap.put(key, new Integer(i + 1));
        }
        return table;
    }

    public static class _RowNode
    extends SimpleRowNode
    implements IRowNode {
        int index;
        Object[][] vals;

        _RowNode(int row, Object[][] rowsData) {
            this.index = row;
            this.vals = rowsData;
            this.rowData = this.vals[this.index];
        }

        @Override
        public IRowNode nextRow() {
            if (this.next == null) {
                this.next = new _RowNode(this.index + 1, this.vals);
            }
            return super.nextRow();
        }
    }
}

