/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.extendcontrols;

import com.kingdee.bos.ctrl.extendcontrols.KDWorkCalendarEvent;
import com.kingdee.bos.ctrl.extendcontrols.KDWorkCalendarEventListener;
import com.kingdee.bos.ctrl.extendcontrols.plaf.KingdeeWorkCalendarUI;
import com.kingdee.bos.ctrl.swing.IKDComponent;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.model.DateTimeModel;
import com.kingdee.bos.ctrl.swing.model.IDateTimeModel;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.event.EventListenerList;

public class KDWorkCalendar
extends JComponent
implements IKDEditor,
IKDComponent {
    private static final long serialVersionUID = -7137757548927388504L;
    public static final int WORKDAY = 1;
    public static final int HOLIDAY = 2;
    public static final int NON_WORKDAY = 3;
    public static final int HALF_WORKDAY = 4;
    private boolean editable = true;
    private List addedYearMonthList = new ArrayList();
    private static final String uiClassID = "WorkCalendarUI";
    private Object userObject = null;
    private IDateTimeModel model = null;
    private int[] activeDayTypes = new int[]{1, 2, 3, 4};
    private boolean resetToDefaultMenuEnabled = true;

    public KDWorkCalendar() {
        this(null);
    }

    public KDWorkCalendar(IDateTimeModel model) {
        if (model == null) {
            this.createDefaultModel();
        } else {
            this.model = model;
        }
        this.setFocusable(true);
        this.setOpaque(true);
        this.updateUI();
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        if (this.editable != editable) {
            boolean oldValue = this.editable;
            this.editable = editable;
            this.firePropertyChange("editable", new Boolean(oldValue), new Boolean(editable));
        }
    }

    public void setModel(IDateTimeModel model) {
        if (model == null) {
            throw new IllegalArgumentException("model is not null.");
        }
        IDateTimeModel oldModel = this.getModel();
        if (oldModel != model) {
            this.model = model;
            oldModel = null;
            this.firePropertyChange("model", oldModel, model);
            this.repaint();
            this.revalidate();
        }
    }

    public IDateTimeModel getModel() {
        return this.model;
    }

    protected void createDefaultModel() {
        this.model = new DateTimeModel();
    }

    public Map getSettedDays() {
        return this.getUI().getSettedDays();
    }

    public void addYearMonth(Date date) {
        if (date != null) {
            GregorianCalendar gCalendar = new GregorianCalendar();
            gCalendar.setTime(date);
            gCalendar.set(5, 1);
            this.addedYearMonthList.add(gCalendar.getTime());
            this.getUI().addYearMonth(date);
        }
    }

    public void addYearMonth(Date[] dates) {
        for (int i = 0; i < dates.length; ++i) {
            this.addYearMonth(dates[i]);
        }
    }

    public void addYearMonth(Date startDate, Date endDate) {
        if (startDate != null && endDate != null) {
            GregorianCalendar startCalendar = new GregorianCalendar();
            GregorianCalendar endCalendar = new GregorianCalendar();
            startCalendar.setTime(startDate);
            endCalendar.setTime(endDate);
            startCalendar.set(5, 1);
            endCalendar.set(5, 1);
            if (startCalendar.equals(endCalendar)) {
                this.addYearMonth(startCalendar.getTime());
            } else if (startCalendar.before(endCalendar)) {
                while (!startCalendar.after(endCalendar)) {
                    this.addYearMonth(startCalendar.getTime());
                    startCalendar.add(2, 1);
                }
            }
        }
    }

    public List getYearMonthList() {
        if (this.addedYearMonthList != null) {
            return this.addedYearMonthList;
        }
        return null;
    }

    public void clearYearMonth() {
        if (this.addedYearMonthList != null && this.addedYearMonthList.size() != 0) {
            this.addedYearMonthList.clear();
        }
        this.getUI().clearYearMonth();
    }

    public void clearSettedDays() {
        this.getUI().clearSettedDays();
    }

    public void setDayType(Date date, int dayType) {
        this.getUI().setDayType(date, dayType);
    }

    public void setDayType(Date[] dates, int dayType) {
        this.getUI().setDayType(dates, dayType);
    }

    public void setDayType(Date startDate, Date endDate, int dayType) {
        this.getUI().setDayType(startDate, endDate, dayType);
    }

    public void setNumberPerRow(int numberPerRow) {
        this.getUI().setNumberPerRow(numberPerRow);
    }

    public int getNumberPerRow() {
        return this.getUI().getNumberPerRow();
    }

    public void setActiveDayTypes(int[] types) {
        if (types == null || types.length > 4) {
            throw new IllegalArgumentException("parameter types[] invalid, check the comment of this method!");
        }
        int[] qualifiedTypes = new int[4];
        for (int i = 0; i < types.length; ++i) {
            if (types[i] < 1 || types[i] > 4) {
                throw new IllegalArgumentException("parameter types[] invalid, check the comment of this method!");
            }
            qualifiedTypes[i] = types[i];
        }
        this.activeDayTypes = qualifiedTypes;
    }

    public int[] getActiveDataTypes() {
        return this.activeDayTypes;
    }

    public void addDataChangeListener(DataChangeListener listener) {
        this.listenerList.add(DataChangeListener.class, listener);
    }

    public void addWorkCalendarEventListener(KDWorkCalendarEventListener listener) {
        this.listenerList.add(KDWorkCalendarEventListener.class, listener);
    }

    public void fireDataChanged(DataChangeEvent event) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != DataChangeListener.class || event == null) continue;
            ((DataChangeListener)listeners[i + 1]).dataChanged(event);
        }
    }

    public Object getValue() {
        if (this.getModel().isEmptyValue()) {
            return null;
        }
        return this.getModel().getValue();
    }

    public boolean isDisplay() {
        return this.isVisible();
    }

    public void removeDataChangeListener(DataChangeListener listener) {
        this.listenerList.remove(DataChangeListener.class, listener);
    }

    public void setDisplay(boolean isDisplay) {
        this.setVisible(isDisplay);
    }

    public void setValue(Object value) {
        if (value != null && !(value instanceof Date)) {
            throw new ClassCastException(value.getClass() + " class is not supported.");
        }
        this.getModel().setValue((Date)value);
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public void setUserObject(Object userObject) {
        this.userObject = userObject;
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    @Override
    public KingdeeWorkCalendarUI getUI() {
        return (KingdeeWorkCalendarUI)this.ui;
    }

    public void setUI(KingdeeWorkCalendarUI ui) {
        super.setUI(ui);
    }

    @Override
    public void updateUI() {
        this.setUI((KingdeeWorkCalendarUI)UIManager.getUI(this));
    }

    public boolean mouseDoubleClicked(int x, int y) {
        return this.getUI().mouseSelectedDay(x, y);
    }

    public void commitComfirm() {
        this.getUI().commitComfirm();
    }

    public EventListenerList getListenerList() {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        return this.listenerList;
    }

    public void fireBackToDefaultEvent() {
        Object[] listeners = this.getListenerList().getListenerList();
        KDWorkCalendarEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != KDWorkCalendarEventListener.class) continue;
            if (e == null) {
                e = new KDWorkCalendarEvent(this);
            }
            ((KDWorkCalendarEventListener)listeners[i + 1]).backToDefault(e);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.ui != null && this.getUIClassID().equals(uiClassID)) {
            this.ui.installUI(this);
        }
        Map additionalValues = (Map)s.readObject();
        this.model = (IDateTimeModel)additionalValues.get("model");
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        HashMap<String, IDateTimeModel> additionalValues = new HashMap<String, IDateTimeModel>(1);
        IDateTimeModel model = this.getModel();
        if (model instanceof Serializable) {
            additionalValues.put("model", model);
        }
        s.writeObject(additionalValues);
        s.defaultWriteObject();
        if (this.ui != null && this.getUIClassID().equals(uiClassID)) {
            this.ui.installUI(this);
        }
    }

    public boolean isResetToDefaultMenuEnabled() {
        return this.resetToDefaultMenuEnabled;
    }

    public void setResetToDefaultMenuEnabled(boolean b) {
        this.resetToDefaultMenuEnabled = b;
    }

    static {
        UIManager.getDefaults().put(uiClassID, "com.kingdee.bos.ctrl.extendcontrols.plaf.KingdeeWorkCalendarUI");
    }
}

