/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.fd2.gui.data;

import com.kingdee.bos.ctrl.common.LanguageManager;
import com.kingdee.bos.ctrl.common.layout.table.Cell;
import com.kingdee.bos.ctrl.common.layout.table.Table;
import com.kingdee.bos.ctrl.common.ui.TypicalDialog;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.common.ui.select.IObjectSelector;
import com.kingdee.bos.ctrl.common.util.CtrlClassUtil;
import com.kingdee.bos.ctrl.common.util.LangUtil;
import com.kingdee.bos.ctrl.common.util.MapUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.data.framework.connection.DataSourceType;
import com.kingdee.bos.ctrl.data.meta.MetaField;
import com.kingdee.bos.ctrl.data.meta.MetaLibrary;
import com.kingdee.bos.ctrl.data.modal.CommonQuery;
import com.kingdee.bos.ctrl.data.modal.DefObj;
import com.kingdee.bos.ctrl.data.modal.IDataDef;
import com.kingdee.bos.ctrl.data.modal.IDefObj;
import com.kingdee.bos.ctrl.data.modal.Outputs;
import com.kingdee.bos.ctrl.data.modal.Parameter;
import com.kingdee.bos.ctrl.data.modal.query.BasicQuery;
import com.kingdee.bos.ctrl.data.modal.query.Column;
import com.kingdee.bos.ctrl.data.modal.query.IQuery;
import com.kingdee.bos.ctrl.data.modal.query.QueryType;
import com.kingdee.bos.ctrl.data.modal.query.framework.bmd.query.BmdQueryQuery;
import com.kingdee.bos.ctrl.data.modal.query.io.Query2Meta;
import com.kingdee.bos.ctrl.data.modal.types.DataSetType;
import com.kingdee.bos.ctrl.data.modal.types.IDataSetTypeProvider;
import com.kingdee.bos.ctrl.data.modal.types.rows.OutputColumn;
import com.kingdee.bos.ctrl.data.modal.types.rows.OutputColumns;
import com.kingdee.bos.ctrl.data.wizard.framework.datadef.DefaultCommonQueryWizardModel;
import com.kingdee.bos.ctrl.data.wizard.framework.datadef.ICommonQueryWizardModel;
import com.kingdee.bos.ctrl.data.wizard.note.NoteCommonQueryWizard;
import com.kingdee.bos.ctrl.data.wizard.note.NoteMetaSelector;
import com.kingdee.bos.ctrl.kdf.data.datasource.DSParam;
import com.kingdee.bos.ctrl.kdf.fd2.gui.data.NewSchemaDialog;
import com.kingdee.bos.ctrl.kdf.fd2.gui.data.ParamEditDialog;
import com.kingdee.bos.ctrl.kdf.fd2.gui.data.QueryChangeListener;
import com.kingdee.bos.ctrl.kdf.fd2.gui.util.MsgBox;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDList;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class QueryManageDialog
extends TypicalDialog {
    private KDList lstQuery;
    private KDWorkButton btnNew;
    private KDWorkButton btnRename;
    private KDWorkButton btnEdit;
    private KDWorkButton btnDel;
    private KDWorkButton btnParam;
    private boolean isChanged = false;
    private boolean fireListSelectionListener = true;
    private MetaLibrary ml;
    private NewSchemaDialog newSchemaDialog;
    private QueryChangeListener listener;
    private static String res = CtrlClassUtil.getPackageName(QueryManageDialog.class) + ".data";

    public QueryManageDialog(Dialog owner) {
        super(owner);
        this.initializtion();
    }

    public QueryManageDialog(Frame owner) {
        super(owner);
        this.initializtion();
    }

    public QueryManageDialog() {
        this.initializtion();
    }

    private void initializtion() {
        this.setSize(400, 300);
        this.setTitle(QueryManageDialog.getMLS("queryManage", "\u67e5\u8be2\u5bf9\u8c61\u7ba1\u7406"));
    }

    public void setData(CommonQuery[] datas, DSParam[] params) {
        this.fireListSelectionListener = false;
        this.lstQuery.removeAllElements();
        if (datas != null) {
            for (int i = 0; i < datas.length; ++i) {
                ListElement le = new ListElement(datas[i]);
                if (params != null) {
                    le.setParam(params[i]);
                }
                this.lstQuery.addElement((Object)le);
            }
        }
        this.fireListSelectionListener = true;
        this.syncBtn();
    }

    public CommonQuery[] getData() {
        CommonQuery[] scms = new CommonQuery[this.lstQuery.getElementCount()];
        int c = this.lstQuery.getElementCount();
        for (int i = 0; i < c; ++i) {
            ListElement listElm = (ListElement)this.lstQuery.getElement(i);
            scms[i] = listElm.getScheme();
            if (!StringUtil.isEmptyString((String)listElm.getOldName())) {
                this.fireQueryIdChanged(listElm.getOldName(), scms[i].getName());
                listElm.setOldName(null);
            }
            if (listElm.getDeletedColumns() == null || listElm.getDeletedColumns().size() <= 0) continue;
            this.fireFieldDeleted(scms[i].getName(), listElm.getDeletedColumns());
            listElm.setDeletedColumns(null);
        }
        return scms;
    }

    public DSParam[] getParams() {
        DSParam[] params = new DSParam[this.lstQuery.getElementCount()];
        int c = this.lstQuery.getElementCount();
        for (int i = 0; i < c; ++i) {
            ListElement listElm = (ListElement)this.lstQuery.getElement(i);
            params[i] = listElm.getParam();
        }
        return params;
    }

    public void setMeta(MetaLibrary metalib) {
        this.ml = metalib;
    }

    protected void todoInit() {
        this.lstQuery = new KDList();
        this.lstQuery.setSelectionMode(0);
        this.btnNew = new KDWorkButton(QueryManageDialog.getMLS("new", "\u65b0\u5efa"));
        this.btnRename = new KDWorkButton(QueryManageDialog.getMLS("rename", "\u6539\u540d"));
        this.btnEdit = new KDWorkButton(QueryManageDialog.getMLS("edit", "\u7f16\u8f91"));
        this.btnDel = new KDWorkButton(QueryManageDialog.getMLS("delete", "\u5220\u9664"));
        this.btnParam = new KDWorkButton(QueryManageDialog.getMLS("param", "\u53c2\u6570"));
        this.btnNew.addActionListener(this.actionListner);
        this.btnRename.addActionListener(this.actionListner);
        this.btnEdit.addActionListener(this.actionListner);
        this.btnDel.addActionListener(this.actionListner);
        this.btnParam.addActionListener(this.actionListner);
        this.lstQuery.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting() || !QueryManageDialog.this.fireListSelectionListener) {
                    return;
                }
                QueryManageDialog.this.syncBtn();
            }
        });
        this.lstQuery.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (evt.getClickCount() == 2 && QueryManageDialog.this.lstQuery.getSelectedIndex() >= 0) {
                    QueryManageDialog.this.doEdit();
                }
            }
        });
    }

    protected void todoAddControls(Container parent, Cell thisCell) {
        KDToolBar toolbar = new KDToolBar();
        this.addToolBar((JToolBar)toolbar);
        toolbar.add((Component)this.btnNew);
        toolbar.add((Component)this.btnRename);
        toolbar.add((Component)this.btnEdit);
        toolbar.add((Component)this.btnDel);
        toolbar.addSeparator();
        toolbar.add((Component)this.btnParam);
        Table tb = thisCell.split(2, 1);
        tb.rowStyle(0).setWidth(60);
        tb.rowStyle(0).setMarginBottom(3);
        tb.rowStyle(1).setPriY(1);
        Table row1 = tb.cell(0).splitCol(5);
        row1.colStyle(1).setMarginRight(3);
        row1.colStyle(2).setMarginRight(3);
        row1.colStyle(3).setMarginRight(3);
        row1.colStyle(0).setPriX(1);
        parent.add((Component)new KDLabel(QueryManageDialog.getMLS("query", "\u67e5\u8be2\u5bf9\u8c61\uff1a")), row1.cell(0));
        parent.add((Component)new KDScrollPane((Component)this.lstQuery), tb.cell(1));
        this.remove((Component)this.btnCancel);
    }

    protected void todoActionPerformed(ActionEvent e) {
        if (e.getSource() == this.btnNew) {
            this.doNew();
        } else if (e.getSource() == this.btnRename) {
            this.doRename();
        } else if (e.getSource() == this.btnEdit) {
            this.doEdit();
        } else if (e.getSource() == this.btnDel) {
            this.doDel();
        } else if (e.getSource() == this.btnParam) {
            this.doEditParam();
        }
    }

    private void doRename() {
        Object objScheme = this.lstQuery.getSelectedValue();
        if (objScheme == null) {
            return;
        }
        CommonQuery xq = ((ListElement)objScheme).getScheme();
        String oldID = xq.getName();
        QueryType type = xq.getQuery().getQueryType();
        NewSchemaDialog dlg = this.getNewSchemeDialog();
        dlg.setTitle(QueryManageDialog.getMLS("rename", "\u91cd\u547d\u540d"));
        dlg.setNewMode(false);
        dlg.setID(oldID);
        Map ps = xq.getProperties();
        HashMap alias = LangUtil.getProperty((Map)ps, (String)"alias");
        HashMap desc = LangUtil.getProperty((Map)ps, (String)"desc");
        dlg.setOldAlias(alias);
        dlg.setOldDesc(desc);
        dlg.setDSType(this.queryType2DSType(type).getName());
        dlg.setQueryType(type);
        if (dlg.showDialog()) {
            if (!StringUtil.equals((String)xq.getName(), (String)dlg.getID())) {
                ((ListElement)objScheme).setOldName(xq.getName());
                xq.setName(dlg.getID());
            }
            LangUtil.setProperty((Map)ps, (String)"alias", (Map)dlg.getNewAlias());
            LangUtil.setProperty((Map)ps, (String)"desc", (Map)dlg.getNewDesc());
            this.isChanged = true;
        }
    }

    private void doDel() {
        int i = this.lstQuery.getSelectedIndex();
        if (i >= 0) {
            ListElement listElm = (ListElement)this.lstQuery.getElement(i);
            StringBuffer prompt = new StringBuffer();
            prompt.append(QueryManageDialog.getMLS("delete", "\u5220\u9664"));
            prompt.append(QueryManageDialog.getMLS("leftQuotation", "\u201c"));
            prompt.append(listElm.getScheme().getAliasName());
            prompt.append(QueryManageDialog.getMLS("rightQuotation", "\u201d"));
            prompt.append(QueryManageDialog.getMLS("comma", "\uff0c"));
            boolean isUsed = false;
            if (this.fireIsQueryUsed(listElm.getScheme().getName())) {
                prompt.append(QueryManageDialog.getMLS("queryUsed", "\u8be5\u67e5\u8be2\u5bf9\u8c61\u5df2\u88ab\u4f7f\u7528\uff0c"));
                isUsed = true;
            }
            prompt.append(QueryManageDialog.getMLS("areYouSure", "\u60a8\u786e\u5b9a\u5417\uff1f"));
            if (WindowUtil.msgboxYesNo((Component)((Object)this), (Object)prompt, (String)this.getTitle())) {
                this.lstQuery.removeElementAt(i);
                this.isChanged = true;
                if (isUsed) {
                    this.fireQueryIdChanged(listElm.getScheme().getName(), "");
                }
            }
        }
    }

    private void doNew() {
        if (!this.isMetaValid(this.ml)) {
            return;
        }
        NewSchemaDialog dlg = this.getNewSchemeDialog();
        dlg.setTitle(QueryManageDialog.getMLS("new", "\u65b0\u5efa"));
        dlg.setNewMode(true);
        dlg.setID("");
        dlg.setOldAlias(null);
        dlg.setOldDesc(null);
        dlg.setDSType(null);
        if (dlg.showDialog()) {
            QueryType queryType = dlg.getQueryType();
            CommonQuery scheme = new CommonQuery();
            scheme.setQuery(BasicQuery.createQuery((QueryType)queryType));
            DefaultCommonQueryWizardModel model = new DefaultCommonQueryWizardModel();
            model.setCommonQuery(scheme);
            model.setObjectSelector((IObjectSelector)new NoteMetaSelector(this.ml));
            NoteCommonQueryWizard wizard = new NoteCommonQueryWizard((Dialog)((Object)this));
            wizard.setDataWizardModel((ICommonQueryWizardModel)model);
            wizard.setTitle(QueryManageDialog.getMLS("new", "\u65b0\u5efa") + QueryManageDialog.getMLS("query", "\u67e5\u8be2\u5bf9\u8c61\uff1a") + dlg.getID());
            if (wizard.showDialog()) {
                CommonQuery bs = scheme;
                bs.setName(dlg.getID());
                HashMap alias = new HashMap();
                MapUtil.subKeyPrefix((Map)bs.getProperties(), (String)"alias.", alias);
                HashMap desc = new HashMap();
                MapUtil.subKeyPrefix((Map)bs.getProperties(), (String)"desc.", desc);
                dlg.setOldAlias(alias);
                dlg.setOldDesc(desc);
                this.lstQuery.addElement((Object)new ListElement(bs));
                this.isChanged = true;
            }
        }
    }

    private void doEdit() {
        Object objScheme = this.lstQuery.getSelectedValue();
        if (objScheme == null) {
            return;
        }
        if (!this.isMetaValid(this.ml)) {
            return;
        }
        ListElement listElm = (ListElement)objScheme;
        CommonQuery scheme = listElm.getScheme();
        CommonQuery commonQueryforEdit = QueryManageDialog.cloneCommonQuery(scheme);
        DefaultCommonQueryWizardModel model = new DefaultCommonQueryWizardModel();
        model.setCommonQuery(commonQueryforEdit);
        model.setObjectSelector((IObjectSelector)new NoteMetaSelector(this.ml));
        NoteCommonQueryWizard wizard = new NoteCommonQueryWizard((Dialog)((Object)this));
        wizard.setDataWizardModel((ICommonQueryWizardModel)model);
        wizard.setTitle(QueryManageDialog.getMLS("edit", "\u7f16\u8f91") + QueryManageDialog.getMLS("query", "\u67e5\u8be2\u5bf9\u8c61\uff1a") + scheme.getName());
        if (wizard.showDialog()) {
            OutputColumns fields1 = new OutputColumns();
            IDataSetTypeProvider ds1 = null;
            Outputs outputs = scheme.getOutputs();
            if (outputs != null && outputs.size() > 0 && (ds1 = (IDataSetTypeProvider)outputs.get(0)).getType().equals((Object)DataSetType.ROWSET)) {
                fields1 = (OutputColumns)ds1;
            }
            OutputColumns fields2 = new OutputColumns();
            CommonQuery cq = commonQueryforEdit;
            IDataSetTypeProvider ds2 = null;
            outputs = cq.getOutputs();
            if (outputs != null && outputs.size() > 0 && (ds2 = (IDataSetTypeProvider)outputs.get(0)).getType().equals((Object)DataSetType.ROWSET)) {
                fields2 = (OutputColumns)ds2;
            }
            ArrayList deleted = this.compareDeletedColumns(fields1, fields2);
            listElm.setDeletedColumns(deleted);
            listElm.setScheme(cq);
            this.isChanged = true;
        }
    }

    private void doEditParam() {
        ListElement listElm;
        CommonQuery[] dss = new CommonQuery[this.lstQuery.getElementCount()];
        int c = this.lstQuery.getElementCount();
        for (int i = 0; i < c; ++i) {
            listElm = (ListElement)this.lstQuery.getElement(i);
            dss[i] = listElm.getScheme();
        }
        listElm = (ListElement)this.lstQuery.getSelectedValue();
        CommonQuery dsCurrent = listElm.getScheme();
        DSParam param = listElm.getParam();
        ParamEditDialog pedlg = (ParamEditDialog)WindowUtil.createWindow(ParamEditDialog.class, (Component)((Object)this));
        pedlg.showValue(param, (IDataDef[])dss, (IDataDef)dsCurrent);
        if (pedlg.showDialog()) {
            listElm.setParam(pedlg.getResultParam());
        }
    }

    private DataSourceType queryType2DSType(QueryType qt) {
        if (qt.getCapital().equals("bos")) {
            return DataSourceType.BOS;
        }
        if (qt.getCapital().equals("sql")) {
            return DataSourceType.DB;
        }
        return null;
    }

    private ArrayList compareDeletedColumns(OutputColumns oldList, OutputColumns newList) {
        ArrayList<MetaField> deletedColumns = new ArrayList<MetaField>();
        for (Column col : oldList) {
            if (QueryManageDialog.getObjByAliasname((ArrayList)newList, col.getAliasName()) == null) {
                deletedColumns.add(Query2Meta.makeMetaField((Column)col));
                continue;
            }
            if (QueryManageDialog.getObjByID((ArrayList)newList, col.getName()) != null) continue;
            deletedColumns.add(Query2Meta.makeMetaField((Column)col));
        }
        return deletedColumns;
    }

    private static DefObj getObjByAliasname(ArrayList list, String aliasname) {
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            DefObj obj = (DefObj)list.get(i);
            if (!aliasname.equals(obj.getAliasName())) continue;
            return obj;
        }
        return null;
    }

    private static DefObj getObjByID(ArrayList list, String id) {
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            DefObj obj = (DefObj)list.get(i);
            if (!id.equals(obj.getName())) continue;
            return obj;
        }
        return null;
    }

    private boolean isMetaValid(MetaLibrary ml) {
        if (ml == null) {
            MsgBox.show((Component)((Object)this), QueryManageDialog.getMLS("noMeta", "\u6ca1\u6709\u5143\u6570\u636e\uff0c\u4e0d\u80fd\u7f16\u8f91\u67e5\u8be2\u5bf9\u8c61\u3002"), this.getTitle(), 33);
            return false;
        }
        return true;
    }

    private void syncBtn() {
        boolean isSelected = this.lstQuery.getSelectedIndex() >= 0;
        boolean hasMeta = this.ml != null;
        this.btnNew.setEnabled(hasMeta);
        this.btnEdit.setEnabled(hasMeta && isSelected);
        this.btnRename.setEnabled(hasMeta && isSelected);
        this.btnDel.setEnabled(isSelected);
        this.btnParam.setEnabled(isSelected);
    }

    private NewSchemaDialog getNewSchemeDialog() {
        if (this.newSchemaDialog == null) {
            this.newSchemaDialog = (NewSchemaDialog)((Object)WindowUtil.createWindow(NewSchemaDialog.class, (Component)((Object)this)));
            this.newSchemaDialog.addVerifyListener(new NewSchemaDialog.VerifyListener(){

                @Override
                public boolean isOK(NewSchemaDialog.VerifyEvent e) {
                    if (!e.getNewMode() && e.getId().equalsIgnoreCase(QueryManageDialog.this.newSchemaDialog.getOldID())) {
                        return true;
                    }
                    CommonQuery scm = null;
                    for (int i = 0; i < QueryManageDialog.this.lstQuery.getElementCount(); ++i) {
                        scm = ((ListElement)QueryManageDialog.this.lstQuery.getElement(i)).getScheme();
                        if (!StringUtil.equalsIgnoreCase((String)e.getId(), (String)scm.getName())) continue;
                        WindowUtil.msgboxError((Object)QueryManageDialog.getMLS("nameExist", "\u540d\u79f0\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\u3002"), (String)QueryManageDialog.this.newSchemaDialog.getTitle(), (Component)((Object)QueryManageDialog.this));
                        return false;
                    }
                    return true;
                }
            });
        }
        return this.newSchemaDialog;
    }

    public boolean isChanged() {
        return this.isChanged;
    }

    public void setQueryChangedListener(QueryChangeListener l) {
        this.listener = l;
    }

    protected boolean fireIsQueryUsed(String queryId) {
        if (this.listener == null) {
            return false;
        }
        return this.listener.isQueryUsed(queryId);
    }

    protected void fireQueryIdChanged(String oldId, String newId) {
        if (this.listener != null) {
            this.listener.queryIdChanged(oldId, newId);
        }
    }

    protected void fireFieldDeleted(String schemeID, ArrayList colLst) {
        if (this.listener != null) {
            this.listener.fieldDeleted(schemeID, colLst);
        }
    }

    private static String getMLS(String key, String defaultValue) {
        return LanguageManager.getLangMessage((String)key, (String)res, (String)defaultValue);
    }

    private static CommonQuery cloneCommonQuery(CommonQuery cq) {
        List ps;
        CommonQuery newInst = new CommonQuery();
        newInst.copy((IDefObj)cq);
        BmdQueryQuery bqq = new BmdQueryQuery();
        newInst.setQuery((IQuery)bqq);
        bqq.setContent(cq.getQuery().getContent());
        Outputs outputs = cq.getOutputs();
        if (outputs != null) {
            Outputs newOutputs = new Outputs();
            OutputColumns newOutputColumns = new OutputColumns();
            newOutputs.add((Object)newOutputColumns);
            newInst.setOutputs(newOutputs);
            OutputColumns outputColumns = (OutputColumns)outputs.get(0);
            for (OutputColumn outputColumn : outputColumns) {
                OutputColumn newOutputColumn = new OutputColumn();
                newOutputColumn.copy((IDefObj)outputColumn);
                newOutputColumns.add((Object)newOutputColumn);
            }
        }
        if ((ps = cq.getParameters()) != null) {
            newInst.setParameters(new ArrayList());
            for (Parameter p : ps) {
                Parameter newP = new Parameter();
                newP.copy(p);
                newInst.getParameters().add(newP);
            }
        }
        return newInst;
    }

    protected class ListElement {
        private CommonQuery scm;
        private DSParam param;
        private String oldName;
        private ArrayList deletedColumns;

        public ListElement(CommonQuery scm) {
            this.scm = scm;
        }

        public CommonQuery getScheme() {
            return this.scm;
        }

        public void setScheme(CommonQuery scm) {
            this.scm = scm;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.scm.getName());
            if (!StringUtil.isEmptyString((String)this.scm.getAlias())) {
                sb.append(" (");
                sb.append(this.scm.getAlias());
                sb.append(")");
            }
            if (!StringUtil.isEmptyString((String)this.scm.getDesc())) {
                sb.append(" -- ");
                sb.append(this.scm.getDesc());
            }
            if (this.param != null) {
                sb.append(" [\u53c2\u6570]");
            }
            return sb.toString();
        }

        public String getOldName() {
            return this.oldName;
        }

        public void setOldName(String oldName) {
            this.oldName = oldName;
        }

        public ArrayList getDeletedColumns() {
            return this.deletedColumns;
        }

        public void setDeletedColumns(ArrayList deletedColumns) {
            this.deletedColumns = deletedColumns;
        }

        public DSParam getParam() {
            return this.param;
        }

        public void setParam(DSParam param) {
            this.param = param;
        }
    }
}

