/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.fd2.gui.propertiesdialog;

import com.kingdee.bos.ctrl.kdf.fd2.KDF;
import com.kingdee.bos.ctrl.kdf.fd2.Location;
import com.kingdee.bos.ctrl.kdf.fd2.SideLocation;
import com.kingdee.bos.ctrl.kdf.fd2.gui.propertiesdialog.AbstractPropPanel;
import com.kingdee.bos.ctrl.kdf.fd2.gui.util.MsgBox;
import com.kingdee.bos.ctrl.kdf.fd2.gui.util.NumberField;
import com.kingdee.bos.ctrl.kdf.fd2.reportelement.IElement;
import com.kingdee.bos.ctrl.kdf.fd2.reportelement.ReportElement;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDTextField;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;

public class LocationPanel
extends AbstractPropPanel {
    private boolean isLeftTypeNeedHandle = true;
    private boolean isRightTypeNeedHandle = true;
    private boolean isTopTypeNeedHandle = true;
    private boolean isBottomTypeNeedHandle = true;
    private KDPanel panel1;
    private KDLabel label1;
    private KDLabel label2;
    private KDLabel label3;
    private KDLabel label4;
    private KDLabel labelleft;
    private KDLabel labelright;
    private KDLabel labeltop;
    private KDLabel labelbottom;
    protected KDComboBox leftType;
    protected KDComboBox rightType;
    protected KDComboBox topType;
    protected KDComboBox bottomType;
    protected KDComboBox leftObject;
    protected KDComboBox rightObject;
    protected KDComboBox topObject;
    protected KDComboBox bottomObject;
    protected KDComboBox leftSide;
    protected KDComboBox rightSide;
    protected KDComboBox topSide;
    protected KDComboBox bottomSide;
    protected NumberField leftEdit;
    protected NumberField rightEdit;
    protected NumberField topEdit;
    protected NumberField bottomEdit;
    protected KDTextField leftFormula;
    protected KDTextField rightFormula;
    protected KDTextField topFormula;
    protected KDTextField bottomFormula;
    private ReportElement re = null;
    private KDF kdf = null;
    private Location templocation;

    public LocationPanel(Component parent) {
        super(parent);
        this.initComponent();
    }

    @Override
    public void setSelectElement(ReportElement re) {
        this.re = re;
        this.kdf = re.getTopContainer().getKDF();
        this.templocation = re.getLocation().cloneMe();
        this.initTypeComboBox();
        this.refreshPaneFormLocation();
    }

    private boolean isHaveAdapte(ReportElement ele) {
        switch (ele.getEleType()) {
            case 5: 
            case 9: 
            case 10: {
                return false;
            }
        }
        return true;
    }

    protected String getTypeString(int index) {
        String ret = "";
        switch (index) {
            case 0: {
                ret = LocationPanel.getMLS("relativeLocation", "\u76f8\u5bf9\u5b9a\u4f4d");
                break;
            }
            case 1: {
                ret = LocationPanel.getMLS("alignLocation", "\u5bf9\u9f50\u5b9a\u4f4d");
                break;
            }
            case 2: {
                ret = LocationPanel.getMLS("customLocation", "\u81ea\u5b9a\u4e49\u516c\u5f0f");
                break;
            }
            case 3: {
                ret = LocationPanel.getMLS("adapterLocation", "\u81ea\u9002\u5e94");
            }
        }
        return ret;
    }

    private void refreshPaneFormLocation() {
        this.initRelativeReportElement();
        this.initVisiable();
        try {
            for (int i = 0; i < 4; ++i) {
                SideLocation sl = this.re.getLocation().getSideLocation(i);
                switch (i) {
                    case 0: {
                        this.isLeftTypeNeedHandle = false;
                        this.leftType.setSelectedItem((Object)this.getTypeString(sl.getType()));
                        this.isLeftTypeNeedHandle = true;
                        this.leftEdit.setValue(sl.getValue());
                        this.leftFormula.setText(sl.getStrFormula());
                        this.changeHLable(sl.getType());
                        break;
                    }
                    case 1: {
                        this.isRightTypeNeedHandle = false;
                        this.rightType.setSelectedItem((Object)this.getTypeString(sl.getType()));
                        this.isRightTypeNeedHandle = true;
                        this.rightEdit.setValue(sl.getValue());
                        this.rightFormula.setText(sl.getStrFormula());
                        break;
                    }
                    case 2: {
                        this.isTopTypeNeedHandle = false;
                        this.topType.setSelectedItem((Object)this.getTypeString(sl.getType()));
                        this.isTopTypeNeedHandle = true;
                        this.topEdit.setValue(sl.getValue());
                        this.topFormula.setText(sl.getStrFormula());
                        this.changeVLabel(sl.getType());
                        break;
                    }
                    case 3: {
                        this.isBottomTypeNeedHandle = false;
                        this.bottomType.setSelectedItem((Object)this.getTypeString(sl.getType()));
                        this.isBottomTypeNeedHandle = true;
                        this.bottomEdit.setValue(sl.getValue());
                        this.bottomFormula.setText(sl.getStrFormula());
                    }
                }
                this.initRelativeSide(this.re, i);
            }
        }
        catch (PropertyVetoException e) {
            e.printStackTrace();
        }
    }

    private void initVisiable() {
        Location loc = this.re.getLocation();
        int type = loc.getSideLocation(0).getType();
        switch (type) {
            case 0: {
                this.leftObject.setVisible(true);
                this.leftSide.setVisible(true);
                this.leftEdit.setVisible(true);
                this.leftFormula.setVisible(false);
                break;
            }
            case 1: {
                this.leftObject.setVisible(true);
                this.leftSide.setVisible(true);
                this.leftEdit.setVisible(false);
                this.leftFormula.setVisible(false);
                this.rightType.setVisible(false);
                this.rightObject.setVisible(false);
                this.rightSide.setVisible(false);
                this.rightFormula.setVisible(false);
                this.rightEdit.setVisible(true);
                break;
            }
            case 2: {
                this.leftObject.setVisible(false);
                this.leftSide.setVisible(false);
                this.leftEdit.setVisible(false);
                this.leftFormula.setVisible(true);
                break;
            }
            case 3: {
                this.leftObject.setVisible(false);
                this.leftSide.setVisible(false);
                this.leftEdit.setVisible(false);
                this.leftFormula.setVisible(false);
            }
        }
        type = loc.getSideLocation(1).getType();
        if (loc.getSideLocation(0).getType() != 1) {
            this.rightType.setVisible(true);
            switch (type) {
                case 0: {
                    this.rightObject.setVisible(true);
                    this.rightSide.setVisible(true);
                    this.rightEdit.setVisible(true);
                    this.rightFormula.setVisible(false);
                    break;
                }
                case 3: {
                    this.rightObject.setVisible(false);
                    this.rightSide.setVisible(false);
                    this.rightEdit.setVisible(false);
                    this.rightFormula.setVisible(false);
                    break;
                }
                case 2: {
                    this.rightObject.setVisible(false);
                    this.rightSide.setVisible(false);
                    this.rightEdit.setVisible(false);
                    this.rightFormula.setVisible(true);
                }
            }
        }
        type = loc.getSideLocation(2).getType();
        switch (type) {
            case 0: {
                this.topObject.setVisible(true);
                this.topSide.setVisible(true);
                this.topEdit.setVisible(true);
                this.topFormula.setVisible(false);
                break;
            }
            case 1: {
                this.topObject.setVisible(true);
                this.topSide.setVisible(true);
                this.topEdit.setVisible(false);
                this.topFormula.setVisible(false);
                this.bottomType.setVisible(false);
                this.bottomObject.setVisible(false);
                this.bottomSide.setVisible(false);
                this.bottomFormula.setVisible(false);
                this.bottomEdit.setVisible(true);
                break;
            }
            case 3: {
                this.topObject.setVisible(false);
                this.topSide.setVisible(false);
                this.topEdit.setVisible(false);
                this.topFormula.setVisible(false);
                break;
            }
            case 2: {
                this.topObject.setVisible(false);
                this.topSide.setVisible(false);
                this.topEdit.setVisible(false);
                this.topFormula.setVisible(true);
            }
        }
        if (loc.getSideLocation(2).getType() != 1) {
            this.bottomType.setVisible(true);
            type = loc.getSideLocation(3).getType();
            switch (type) {
                case 0: {
                    this.bottomObject.setVisible(true);
                    this.bottomSide.setVisible(true);
                    this.bottomEdit.setVisible(true);
                    this.bottomFormula.setVisible(false);
                    break;
                }
                case 3: {
                    this.bottomObject.setVisible(false);
                    this.bottomSide.setVisible(false);
                    this.bottomEdit.setVisible(false);
                    this.bottomFormula.setVisible(false);
                    break;
                }
                case 2: {
                    this.bottomObject.setVisible(false);
                    this.bottomSide.setVisible(false);
                    this.bottomEdit.setVisible(false);
                    this.bottomFormula.setVisible(true);
                }
            }
        }
    }

    private void initComponent() {
        this.panel1 = new KDPanel();
        this.panel1.setOpaque(false);
        this.label1 = new KDLabel(LocationPanel.getMLS("locationType", "\u5b9a\u4f4d\u65b9\u5f0f"));
        this.label2 = new KDLabel(LocationPanel.getMLS("corresponse", "\u76f8\u5bf9\u5bf9\u8c61"));
        this.label3 = new KDLabel(LocationPanel.getMLS("corresponseSide", "\u76f8\u5bf9\u8fb9/\u5bf9\u9f50"));
        this.label4 = new KDLabel(LocationPanel.getMLS("offset", "\u504f\u79fb\u503c(0.1\u6beb\u7c73)"));
        this.labelleft = new KDLabel(LocationPanel.getMLS("leftSide", "\u5de6\u8fb9"));
        this.labelright = new KDLabel(LocationPanel.getMLS("rightSide", "\u53f3\u8fb9"));
        this.labeltop = new KDLabel(LocationPanel.getMLS("topSide", "\u4e0a\u8fb9"));
        this.labelbottom = new KDLabel(LocationPanel.getMLS("bottomSide", "\u4e0b\u8fb9"));
        this.leftType = new KDComboBox();
        this.rightType = new KDComboBox();
        this.topType = new KDComboBox();
        this.bottomType = new KDComboBox();
        this.leftObject = new KDComboBox();
        this.rightObject = new KDComboBox();
        this.topObject = new KDComboBox();
        this.bottomObject = new KDComboBox();
        this.leftSide = new KDComboBox();
        this.rightSide = new KDComboBox();
        this.topSide = new KDComboBox();
        this.bottomSide = new KDComboBox();
        this.leftEdit = new NumberField();
        this.rightEdit = new NumberField();
        this.topEdit = new NumberField();
        this.bottomEdit = new NumberField();
        this.topFormula = new KDTextField();
        this.bottomFormula = new KDTextField();
        this.leftFormula = new KDTextField();
        this.rightFormula = new KDTextField();
        this.setLayout(null);
        this.panel1.setLayout(null);
        this.panel1.add((Component)this.label1);
        this.panel1.add((Component)this.label2);
        this.panel1.add((Component)this.label3);
        this.panel1.add((Component)this.label4);
        this.panel1.add((Component)this.labelleft);
        this.panel1.add((Component)this.labelright);
        this.panel1.add((Component)this.labeltop);
        this.panel1.add((Component)this.labelbottom);
        this.panel1.add((Component)this.leftType);
        this.panel1.add((Component)this.rightType);
        this.panel1.add((Component)this.topType);
        this.panel1.add((Component)this.bottomType);
        this.panel1.add((Component)this.leftObject);
        this.panel1.add((Component)this.rightObject);
        this.panel1.add((Component)this.topObject);
        this.panel1.add((Component)this.bottomObject);
        this.panel1.add((Component)this.leftSide);
        this.panel1.add((Component)this.rightSide);
        this.panel1.add((Component)this.topSide);
        this.panel1.add((Component)this.bottomSide);
        this.panel1.add((Component)((Object)this.leftEdit));
        this.panel1.add((Component)((Object)this.rightEdit));
        this.panel1.add((Component)((Object)this.topEdit));
        this.panel1.add((Component)((Object)this.bottomEdit));
        this.panel1.add((Component)this.leftFormula);
        this.panel1.add((Component)this.rightFormula);
        this.panel1.add((Component)this.topFormula);
        this.panel1.add((Component)this.bottomFormula);
        this.add((Component)this.panel1);
        this.leftEdit.setEnableNegative(true);
        this.rightEdit.setEnableNegative(true);
        this.topEdit.setEnableNegative(true);
        this.bottomEdit.setEnableNegative(true);
        try {
            this.leftEdit.setInteger(true);
            this.rightEdit.setInteger(true);
            this.topEdit.setInteger(true);
            this.bottomEdit.setInteger(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.panel1.setBounds(0, 0, 450, 180);
        this.label1.setBounds(50, 10, 100, 20);
        this.label2.setBounds(153, 10, 100, 20);
        this.label3.setBounds(256, 10, 100, 20);
        this.label4.setBounds(359, 10, 100, 20);
        this.labelleft.setBounds(10, 30, 40, 19);
        this.labelright.setBounds(10, 52, 40, 19);
        this.labeltop.setBounds(10, 77, 40, 19);
        this.labelbottom.setBounds(10, 99, 40, 19);
        this.leftType.setBounds(50, 30, 100, 19);
        this.rightType.setBounds(50, 52, 100, 19);
        this.topType.setBounds(50, 77, 100, 19);
        this.bottomType.setBounds(50, 99, 100, 19);
        this.leftObject.setBounds(153, 30, 100, 19);
        this.rightObject.setBounds(153, 52, 100, 19);
        this.topObject.setBounds(153, 77, 100, 19);
        this.bottomObject.setBounds(153, 99, 100, 19);
        this.leftSide.setBounds(256, 30, 100, 19);
        this.rightSide.setBounds(256, 52, 100, 19);
        this.topSide.setBounds(256, 77, 100, 19);
        this.bottomSide.setBounds(256, 99, 100, 19);
        this.leftEdit.setBounds(359, 30, 80, 19);
        this.rightEdit.setBounds(359, 52, 80, 19);
        this.topEdit.setBounds(359, 77, 80, 19);
        this.bottomEdit.setBounds(359, 99, 80, 19);
        this.leftFormula.setBounds(153, 30, 286, 19);
        this.rightFormula.setBounds(153, 52, 286, 19);
        this.topFormula.setBounds(153, 77, 286, 19);
        this.bottomFormula.setBounds(153, 99, 286, 19);
        this.leftFormula.setVisible(false);
        this.rightFormula.setVisible(false);
        this.topFormula.setVisible(false);
        this.bottomFormula.setVisible(false);
        this.installListener();
        this.ctrlList.add(this.leftType);
        this.ctrlList.add(this.leftFormula);
        this.ctrlList.add(this.leftObject);
        this.ctrlList.add(this.leftSide);
        this.ctrlList.add(this.leftEdit);
        this.ctrlList.add(this.rightType);
        this.ctrlList.add(this.rightFormula);
        this.ctrlList.add(this.rightObject);
        this.ctrlList.add(this.rightSide);
        this.ctrlList.add(this.rightEdit);
        this.ctrlList.add(this.topType);
        this.ctrlList.add(this.topFormula);
        this.ctrlList.add(this.topObject);
        this.ctrlList.add(this.topSide);
        this.ctrlList.add(this.topEdit);
        this.ctrlList.add(this.bottomType);
        this.ctrlList.add(this.bottomFormula);
        this.ctrlList.add(this.bottomObject);
        this.ctrlList.add(this.bottomSide);
        this.ctrlList.add(this.bottomEdit);
        this.reactFocusPolicy();
    }

    private void installListener() {
        this.leftType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                LocationPanel.this.leftTypeStateChanged(e);
            }
        });
        this.topType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                LocationPanel.this.topTypeStateChanged(e);
            }
        });
        this.rightType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                LocationPanel.this.rightTypeStateChanged(e);
            }
        });
        this.bottomType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                LocationPanel.this.bottomTypeStateChanged(e);
            }
        });
        this.rightObject.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                LocationPanel.this.rightObjectStateChanged(e);
            }
        });
        this.bottomObject.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                LocationPanel.this.bottomObjectStateChanged(e);
            }
        });
        this.leftObject.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                LocationPanel.this.leftObjectStateChanged(e);
            }
        });
        this.topObject.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                LocationPanel.this.topObjectStateChanged(e);
            }
        });
        this.leftEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LocationPanel.this.leftEditChanged(e);
            }
        });
        this.rightEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LocationPanel.this.rightEditChanged(e);
            }
        });
        this.topEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LocationPanel.this.topEditChanged(e);
            }
        });
        this.bottomEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LocationPanel.this.bottomEditChanged(e);
            }
        });
        this.rightSide.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                LocationPanel.this.rightSideStateChanged(e);
            }
        });
        this.bottomSide.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                LocationPanel.this.bottomSideStateChanged(e);
            }
        });
        this.leftSide.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                LocationPanel.this.leftSideStateChanged(e);
            }
        });
        this.topSide.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                LocationPanel.this.topSideStateChanged(e);
            }
        });
        this.leftFormula.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                LocationPanel.this.customFormulaChanged(e, 0);
            }
        });
        this.rightFormula.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                LocationPanel.this.customFormulaChanged(e, 1);
            }
        });
        this.topFormula.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                LocationPanel.this.customFormulaChanged(e, 2);
            }
        });
        this.bottomFormula.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                LocationPanel.this.customFormulaChanged(e, 3);
            }
        });
    }

    private void initTypeComboBox() {
        DefaultComboBoxModel<String> leftTypeModel = new DefaultComboBoxModel<String>();
        leftTypeModel.addElement(LocationPanel.getMLS("relativeLocation", "\u76f8\u5bf9\u5b9a\u4f4d"));
        leftTypeModel.addElement(LocationPanel.getMLS("alignLocation", "\u5bf9\u9f50\u5b9a\u4f4d"));
        leftTypeModel.addElement(LocationPanel.getMLS("customLocation", "\u81ea\u5b9a\u4e49\u516c\u5f0f"));
        this.leftType.setModel(leftTypeModel);
        DefaultComboBoxModel<String> rightTypeModel = new DefaultComboBoxModel<String>();
        rightTypeModel.addElement(LocationPanel.getMLS("relativeLocation", "\u76f8\u5bf9\u5b9a\u4f4d"));
        rightTypeModel.addElement(LocationPanel.getMLS("customLocation", "\u81ea\u5b9a\u4e49\u516c\u5f0f"));
        this.rightType.setModel(rightTypeModel);
        DefaultComboBoxModel<String> topTypeModel = new DefaultComboBoxModel<String>();
        topTypeModel.addElement(LocationPanel.getMLS("relativeLocation", "\u76f8\u5bf9\u5b9a\u4f4d"));
        topTypeModel.addElement(LocationPanel.getMLS("alignLocation", "\u5bf9\u9f50\u5b9a\u4f4d"));
        topTypeModel.addElement(LocationPanel.getMLS("customLocation", "\u81ea\u5b9a\u4e49\u516c\u5f0f"));
        this.topType.setModel(topTypeModel);
        DefaultComboBoxModel<String> bottomTypeModel = new DefaultComboBoxModel<String>();
        bottomTypeModel.addElement(LocationPanel.getMLS("relativeLocation", "\u76f8\u5bf9\u5b9a\u4f4d"));
        bottomTypeModel.addElement(LocationPanel.getMLS("customLocation", "\u81ea\u5b9a\u4e49\u516c\u5f0f"));
        this.bottomType.setModel(bottomTypeModel);
        if (this.re != null && this.isHaveAdapte(this.re)) {
            leftTypeModel.addElement(LocationPanel.getMLS("adapterLocation", "\u81ea\u9002\u5e94"));
            rightTypeModel.addElement(LocationPanel.getMLS("adapterLocation", "\u81ea\u9002\u5e94"));
            topTypeModel.addElement(LocationPanel.getMLS("adapterLocation", "\u81ea\u9002\u5e94"));
            bottomTypeModel.addElement(LocationPanel.getMLS("adapterLocation", "\u81ea\u9002\u5e94"));
        }
    }

    private void leftTypeStateChanged(ItemEvent e) {
        if (!this.isLeftTypeNeedHandle) {
            return;
        }
        if (e.getStateChange() == 1) {
            int type = ((KDComboBox)e.getSource()).getSelectedIndex();
            SideLocation leftSide = this.templocation.getSideLocation(0);
            int oldType = leftSide.getType();
            if (type != 1 && oldType == 1) {
                leftSide.setContextValue(0);
                leftSide.setRelativeObjectID(this.re.getParent().getName());
            }
            leftSide.setType(type);
            switch (type) {
                case 1: {
                    leftSide.setContextValue(1);
                    leftSide.setRelativeObjectID(this.re.getParent().getName());
                    break;
                }
            }
            this.changeHLable(type);
            LocationPanel.lockObjectPos(this.re, this.templocation);
            this.applyLocation();
            this.refreshPaneFormLocation();
        }
    }

    private void changeHLable(int leftSideType) {
        if (leftSideType == 1) {
            this.labelleft.setText(LocationPanel.getMLS("horizontal", "\u6c34\u5e73"));
            this.labelright.setText(LocationPanel.getMLS("width", "\u5bbd\u5ea6"));
        } else {
            this.labelleft.setText(LocationPanel.getMLS("leftSide", "\u5de6\u8fb9"));
            this.labelright.setText(LocationPanel.getMLS("rightSide", "\u53f3\u8fb9"));
        }
    }

    private void changeVLabel(int topSideType) {
        if (topSideType == 1) {
            this.labeltop.setText(LocationPanel.getMLS("vertical", "\u5782\u76f4"));
            this.labelbottom.setText(LocationPanel.getMLS("height", "\u9ad8\u5ea6"));
        } else {
            this.labeltop.setText(LocationPanel.getMLS("topSide", "\u4e0a\u8fb9"));
            this.labelbottom.setText(LocationPanel.getMLS("bottomSide", "\u4e0b\u8fb9"));
        }
    }

    private void topTypeStateChanged(ItemEvent e) {
        if (!this.isTopTypeNeedHandle) {
            return;
        }
        if (e.getStateChange() == 1) {
            int type = ((KDComboBox)e.getSource()).getSelectedIndex();
            SideLocation topSide = this.templocation.getSideLocation(2);
            int oldType = topSide.getType();
            if (type != 1 && oldType == 1) {
                topSide.setContextValue(2);
                topSide.setRelativeObjectID(this.re.getParent().getName());
            }
            topSide.setType(type);
            switch (type) {
                case 1: {
                    topSide.setContextValue(4);
                    topSide.setRelativeObjectID(this.re.getParent().getName());
                    break;
                }
            }
            this.changeVLabel(type);
            this.checkPageBottomSelfAdapt(this.re, this.templocation);
            LocationPanel.lockObjectPos(this.re, this.templocation);
            this.applyLocation();
            this.refreshPaneFormLocation();
        }
    }

    private void rightTypeStateChanged(ItemEvent e) {
        if (!this.isRightTypeNeedHandle) {
            return;
        }
        if (e.getStateChange() == 1) {
            int type = ((KDComboBox)e.getSource()).getSelectedIndex();
            if (type > 0) {
                ++type;
            }
            this.templocation.getSideLocation(1).setType(type);
            LocationPanel.lockObjectPos(this.re, this.templocation);
            this.applyLocation();
            this.refreshPaneFormLocation();
        }
    }

    private void bottomTypeStateChanged(ItemEvent e) {
        if (!this.isBottomTypeNeedHandle) {
            return;
        }
        if (e.getStateChange() == 1) {
            int type = ((KDComboBox)e.getSource()).getSelectedIndex();
            if (type > 0) {
                ++type;
            }
            this.templocation.getSideLocation(3).setType(type);
            LocationPanel.lockObjectPos(this.re, this.templocation);
            this.applyLocation();
            this.refreshPaneFormLocation();
        }
    }

    private void rightObjectStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1 && this.templocation != null) {
            this.templocation.getSideLocation(1).setRelativeObjectID(((ReportElement)this.rightObject.getSelectedItem()).getName());
            LocationPanel.lockObjectPos(this.re, this.templocation);
            this.applyLocation();
            this.refreshPaneFormLocation();
        }
    }

    private void bottomObjectStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1 && this.templocation != null) {
            this.templocation.getSideLocation(3).setRelativeObjectID(((ReportElement)this.bottomObject.getSelectedItem()).getName());
            this.checkPageBottomSelfAdapt(this.re, this.templocation);
            LocationPanel.lockObjectPos(this.re, this.templocation);
            this.applyLocation();
            this.refreshPaneFormLocation();
        }
    }

    private void leftObjectStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1 && this.templocation != null) {
            this.templocation.getSideLocation(0).setRelativeObjectID(((ReportElement)this.leftObject.getSelectedItem()).getName());
            LocationPanel.lockObjectPos(this.re, this.templocation);
            this.applyLocation();
            this.refreshPaneFormLocation();
        }
    }

    private void topObjectStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1 && this.templocation != null) {
            this.templocation.getSideLocation(2).setRelativeObjectID(((ReportElement)this.topObject.getSelectedItem()).getName());
            this.checkPageBottomSelfAdapt(this.re, this.templocation);
            LocationPanel.lockObjectPos(this.re, this.templocation);
            this.applyLocation();
            this.refreshPaneFormLocation();
        }
    }

    private void initRelativeReportElement() {
        if (this.re != null) {
            DefaultComboBoxModel<IElement> leftObjectModel = new DefaultComboBoxModel<IElement>();
            DefaultComboBoxModel<IElement> rightObjectModel = new DefaultComboBoxModel<IElement>();
            DefaultComboBoxModel<IElement> topObjectModel = new DefaultComboBoxModel<IElement>();
            DefaultComboBoxModel<IElement> bottomObjectModel = new DefaultComboBoxModel<IElement>();
            leftObjectModel.addElement(this.re.getParent());
            rightObjectModel.addElement(this.re.getParent());
            topObjectModel.addElement(this.re.getParent());
            bottomObjectModel.addElement(this.re.getParent());
            for (ReportElement reTemp : this.re.getParent().getChildren()) {
                if (reTemp == this.re) {
                    if (this.re.getLocation().getSideLocation(0).getType() != 1) {
                        leftObjectModel.addElement(reTemp);
                    }
                    if (this.re.getLocation().getSideLocation(2).getType() != 1) {
                        rightObjectModel.addElement(reTemp);
                    }
                    topObjectModel.addElement(reTemp);
                    bottomObjectModel.addElement(reTemp);
                    continue;
                }
                leftObjectModel.addElement(reTemp);
                rightObjectModel.addElement(reTemp);
                topObjectModel.addElement(reTemp);
                bottomObjectModel.addElement(reTemp);
            }
            leftObjectModel.setSelectedItem(this.kdf.getElementsNameMap().get(this.re.getLocation().getSideLocation(0).getRelativeObjectID()));
            rightObjectModel.setSelectedItem(this.kdf.getElementsNameMap().get(this.re.getLocation().getSideLocation(1).getRelativeObjectID()));
            topObjectModel.setSelectedItem(this.kdf.getElementsNameMap().get(this.re.getLocation().getSideLocation(2).getRelativeObjectID()));
            bottomObjectModel.setSelectedItem(this.kdf.getElementsNameMap().get(this.re.getLocation().getSideLocation(3).getRelativeObjectID()));
            this.leftObject.setModel(leftObjectModel);
            this.rightObject.setModel(rightObjectModel);
            this.topObject.setModel(topObjectModel);
            this.bottomObject.setModel(bottomObjectModel);
        }
    }

    private String getSideString(int type, int value) {
        if (type == 0) {
            switch (value) {
                case 2: {
                    return LocationPanel.getMLS("topSide", "\u4e0a\u8fb9");
                }
                case 3: {
                    return LocationPanel.getMLS("bottomSide", "\u4e0b\u8fb9");
                }
                case 0: {
                    return LocationPanel.getMLS("leftSide", "\u5de6\u8fb9");
                }
                case 1: {
                    return LocationPanel.getMLS("rightSide", "\u53f3\u8fb9");
                }
            }
        } else if (type == 1) {
            switch (value) {
                case 3: {
                    return LocationPanel.getMLS("alignTop", "\u4e0a\u5bf9\u9f50");
                }
                case 4: {
                    return LocationPanel.getMLS("alignMiddle", "\u5782\u76f4\u5c45\u4e2d");
                }
                case 5: {
                    return LocationPanel.getMLS("alignBottom", "\u4e0b\u5bf9\u9f50");
                }
                case 0: {
                    return LocationPanel.getMLS("alignLeft", "\u5de6\u5bf9\u9f50");
                }
                case 1: {
                    return LocationPanel.getMLS("alignCenter", "\u6c34\u5e73\u5c45\u4e2d");
                }
                case 2: {
                    return LocationPanel.getMLS("alignRight", "\u53f3\u5bf9\u9f50");
                }
            }
        }
        return "";
    }

    private void initRelativeSide(ReportElement re, int index) {
        SideLocation sl = re.getLocation().getSideLocation(index);
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        switch (index) {
            case 0: {
                if (sl.getType() == 0) {
                    if (!sl.getRelativeObjectID().equals(re.getName())) {
                        model.addElement(LocationPanel.getMLS("leftSide", "\u5de6\u8fb9"));
                        model.addElement(LocationPanel.getMLS("rightSide", "\u53f3\u8fb9"));
                    } else {
                        model.addElement(LocationPanel.getMLS("rightSide", "\u53f3\u8fb9"));
                    }
                    model.setSelectedItem(this.getSideString(0, sl.getContextValue()));
                } else {
                    model.addElement(LocationPanel.getMLS("alignLeft", "\u5de6\u5bf9\u9f50"));
                    model.addElement(LocationPanel.getMLS("alignCenter", "\u6c34\u5e73\u5c45\u4e2d"));
                    model.addElement(LocationPanel.getMLS("alignRight", "\u53f3\u5bf9\u9f50"));
                    model.setSelectedItem(this.getSideString(1, sl.getContextValue()));
                }
                this.leftSide.setModel(model);
                break;
            }
            case 1: {
                if (sl.getType() == 0) {
                    if (!sl.getRelativeObjectID().equals(re.getName())) {
                        model.addElement(LocationPanel.getMLS("leftSide", "\u5de6\u8fb9"));
                        model.addElement(LocationPanel.getMLS("rightSide", "\u53f3\u8fb9"));
                    } else {
                        model.addElement(LocationPanel.getMLS("leftSide", "\u5de6\u8fb9"));
                    }
                    model.setSelectedItem(this.getSideString(0, sl.getContextValue()));
                }
                this.rightSide.setModel(model);
                break;
            }
            case 2: {
                if (sl.getType() == 0) {
                    if (!sl.getRelativeObjectID().equals(re.getName())) {
                        model.addElement(LocationPanel.getMLS("topSide", "\u4e0a\u8fb9"));
                        model.addElement(LocationPanel.getMLS("bottomSide", "\u4e0b\u8fb9"));
                    } else {
                        model.addElement(LocationPanel.getMLS("bottomSide", "\u4e0b\u8fb9"));
                    }
                    model.setSelectedItem(this.getSideString(0, sl.getContextValue()));
                } else {
                    model.addElement(LocationPanel.getMLS("alignTop", "\u4e0a\u5bf9\u9f50"));
                    model.addElement(LocationPanel.getMLS("alignMiddle", "\u5782\u76f4\u5c45\u4e2d"));
                    model.addElement(LocationPanel.getMLS("alignBottom", "\u4e0b\u5bf9\u9f50"));
                    model.setSelectedItem(this.getSideString(1, sl.getContextValue()));
                }
                this.topSide.setModel(model);
                break;
            }
            case 3: {
                this.bottomSide.removeAllItems();
                if (sl.getType() == 0) {
                    if (!sl.getRelativeObjectID().equals(re.getName())) {
                        model.addElement(LocationPanel.getMLS("topSide", "\u4e0a\u8fb9"));
                        model.addElement(LocationPanel.getMLS("bottomSide", "\u4e0b\u8fb9"));
                    } else {
                        model.addElement(LocationPanel.getMLS("topSide", "\u4e0a\u8fb9"));
                    }
                    model.setSelectedItem(this.getSideString(0, sl.getContextValue()));
                }
                this.bottomSide.setModel(model);
            }
        }
    }

    private void leftEditChanged(ActionEvent e) {
        if (this.templocation != null) {
            this.templocation.getSideLocation(0).setValue((int)this.leftEdit.getValue());
            this.applyLocation();
            try {
                this.leftEdit.setValue(this.templocation.getSideLocation(0).getValue());
            }
            catch (PropertyVetoException e1) {
                e1.printStackTrace();
            }
        }
    }

    private void rightEditChanged(ActionEvent e) {
        if (this.templocation != null) {
            this.templocation.getSideLocation(1).setValue((int)this.rightEdit.getValue());
            this.applyLocation();
            try {
                this.rightEdit.setValue(this.templocation.getSideLocation(1).getValue());
            }
            catch (PropertyVetoException e1) {
                e1.printStackTrace();
            }
        }
    }

    private void topEditChanged(ActionEvent e) {
        if (this.templocation != null) {
            this.templocation.getSideLocation(2).setValue((int)this.topEdit.getValue());
            this.applyLocation();
            try {
                this.topEdit.setValue(this.templocation.getSideLocation(2).getValue());
            }
            catch (PropertyVetoException e1) {
                e1.printStackTrace();
            }
        }
    }

    private void bottomEditChanged(ActionEvent e) {
        if (this.templocation != null) {
            this.templocation.getSideLocation(3).setValue((int)this.bottomEdit.getValue());
            this.applyLocation();
            try {
                this.bottomEdit.setValue(this.templocation.getSideLocation(3).getValue());
            }
            catch (PropertyVetoException e1) {
                e1.printStackTrace();
            }
        }
    }

    private void leftSideStateChanged(ItemEvent e) {
        if (this.templocation != null && e.getStateChange() == 1) {
            this.templocation.getSideLocation(0).setContextValue(this.leftSide.getSelectedIndex());
            LocationPanel.lockObjectPos(this.re, this.templocation);
            this.applyLocation();
            this.refreshPaneFormLocation();
        }
    }

    private void rightSideStateChanged(ItemEvent e) {
        if (this.templocation != null && e.getStateChange() == 1) {
            this.templocation.getSideLocation(1).setContextValue(this.rightSide.getSelectedIndex());
            LocationPanel.lockObjectPos(this.re, this.templocation);
            this.applyLocation();
            this.refreshPaneFormLocation();
        }
    }

    private void topSideStateChanged(ItemEvent e) {
        if (this.templocation != null && e.getStateChange() == 1) {
            int off = 0;
            if (this.templocation.getSideLocation(2).getType() == 0) {
                off = 2;
            }
            if (this.templocation.getSideLocation(2).getType() == 1) {
                off = 3;
            }
            this.templocation.getSideLocation(2).setContextValue(this.topSide.getSelectedIndex() + off);
            this.checkPageBottomSelfAdapt(this.re, this.templocation);
            LocationPanel.lockObjectPos(this.re, this.templocation);
            this.applyLocation();
            this.refreshPaneFormLocation();
        }
    }

    private void bottomSideStateChanged(ItemEvent e) {
        if (this.templocation != null && e.getStateChange() == 1) {
            int off = 0;
            if (this.templocation.getSideLocation(2).getType() == 0) {
                off = 2;
            }
            if (this.templocation.getSideLocation(2).getType() == 1) {
                off = 3;
            }
            this.templocation.getSideLocation(3).setContextValue(this.bottomSide.getSelectedIndex() + off);
            this.checkPageBottomSelfAdapt(this.re, this.templocation);
            LocationPanel.lockObjectPos(this.re, this.templocation);
            this.applyLocation();
            this.refreshPaneFormLocation();
        }
    }

    private void applyLocation() {
        if (this.re != null) {
            if (!this.re.setLocation(this.templocation)) {
                this.forceParentDialogNotHide();
                MsgBox.show(this.getParent(), LocationPanel.getMLS("errorLocPrompt", "\u5faa\u73af\u5f15\u7528\uff0c\u8bbe\u7f6e\u65e0\u6548\u3002"), LocationPanel.getMLS("error", "\u9519\u8bef"), 17);
                this.unforceParentDialogNotHide();
            } else {
                this.re.getTopContainer().getKDF().getKDFFrame().repaint();
            }
            this.templocation = this.re.getLocation().cloneMe();
        }
    }

    public static void lockObjectPos(ReportElement re) {
        LocationPanel.lockObjectPos(re, re.getLocation());
    }

    private static void lockObjectPos(ReportElement re, Location location) {
        if (location != null) {
            switch (location.getSideLocation(0).getType()) {
                case 0: {
                    LocationPanel.lockObjectLeft(re, location);
                    break;
                }
                case 1: {
                    location.getSideLocation(1).setValue(re.getWidthLom());
                }
            }
            switch (location.getSideLocation(1).getType()) {
                case 0: {
                    if (location.getSideLocation(0).getType() == 1) break;
                    LocationPanel.lockObjectRight(re, location);
                }
            }
            switch (location.getSideLocation(2).getType()) {
                case 0: {
                    LocationPanel.lockObjectTop(re, location);
                    break;
                }
                case 1: {
                    location.getSideLocation(3).setValue(re.getHeightLom());
                }
            }
            switch (location.getSideLocation(3).getType()) {
                case 0: {
                    if (location.getSideLocation(2).getType() == 1) break;
                    LocationPanel.lockObjectBottom(re, location);
                }
            }
        }
    }

    private static void lockObjectLeft(ReportElement reEle, Location location) {
        KDF kdf = reEle.getTopContainer().getKDF();
        SideLocation side = location.getSideLocation(0);
        if (side.getRelativeObjectID().equals(reEle.getParent().getName())) {
            if (side.getContextValue() == 0) {
                side.setValue(reEle.getPosLom().x);
            } else {
                side.setValue(reEle.getPosLom().x - reEle.getParent().getWidthLom());
            }
        } else if (side.getRelativeObjectID().equals(reEle.getName())) {
            side.setValue(-reEle.getWidthLom());
        } else {
            ReportElement reOther = (ReportElement)kdf.getElementsNameMap().get(side.getRelativeObjectID());
            if (reOther != null) {
                if (side.getContextValue() == 0) {
                    side.setValue(reEle.getPosLom().x - reOther.getPosLom().x);
                } else {
                    side.setValue(reEle.getPosLom().x - reOther.getPosLom().x - reOther.getWidthLom());
                }
            } else {
                side.setRelativeObjectID(reEle.getParent().getName());
                side.setContextValue(0);
                side.setValue(reEle.getPosLom().x);
            }
        }
    }

    private static void lockObjectRight(ReportElement reEle, Location location) {
        KDF kdf = reEle.getTopContainer().getKDF();
        SideLocation side = location.getSideLocation(1);
        if (side.getRelativeObjectID().equals(reEle.getParent().getName())) {
            if (side.getContextValue() == 0) {
                side.setValue(reEle.getPosLom().x + reEle.getWidthLom());
            } else {
                side.setValue(reEle.getPosLom().x + reEle.getWidthLom() - reEle.getParent().getWidthLom());
            }
        } else if (side.getRelativeObjectID().equals(reEle.getName())) {
            side.setValue(reEle.getWidthLom());
        } else {
            ReportElement reOther = (ReportElement)kdf.getElementsNameMap().get(side.getRelativeObjectID());
            if (reOther != null) {
                if (side.getContextValue() == 0) {
                    side.setValue(reEle.getWidthLom() + reEle.getPosLom().x - reOther.getPosLom().x);
                } else {
                    side.setValue(reEle.getWidthLom() + reEle.getPosLom().x - reOther.getPosLom().x - reOther.getWidthLom());
                }
            } else {
                side.setRelativeObjectID(reEle.getParent().getName());
                side.setContextValue(0);
                side.setValue(reEle.getWidthLom());
            }
        }
    }

    private static void lockObjectTop(ReportElement reEle, Location location) {
        KDF kdf = reEle.getTopContainer().getKDF();
        SideLocation side = location.getSideLocation(2);
        if (side.getRelativeObjectID().equals(reEle.getParent().getName())) {
            if (side.getContextValue() == 2) {
                side.setValue(reEle.getPosLom().y);
            } else {
                side.setValue(reEle.getPosLom().y - reEle.getParent().getHeightLom());
            }
        } else if (side.getRelativeObjectID().equals(reEle.getName())) {
            side.setValue(-reEle.getHeightLom());
        } else {
            ReportElement reOther = (ReportElement)kdf.getElementsNameMap().get(side.getRelativeObjectID());
            if (reOther != null) {
                if (side.getContextValue() == 2) {
                    side.setValue(reEle.getPosLom().y - reOther.getPosLom().y);
                } else {
                    side.setValue(reEle.getPosLom().y - reOther.getPosLom().y - reOther.getHeightLom());
                }
            } else {
                side.setRelativeObjectID(reEle.getParent().getName());
                side.setContextValue(2);
                side.setValue(reEle.getPosLom().y);
            }
        }
    }

    private static void lockObjectBottom(ReportElement reEle, Location location) {
        KDF kdf = reEle.getTopContainer().getKDF();
        SideLocation side = location.getSideLocation(3);
        if (side.getRelativeObjectID().equals(reEle.getParent().getName())) {
            if (side.getContextValue() == 2) {
                side.setValue(reEle.getPosLom().y + reEle.getHeightLom());
            } else {
                side.setValue(reEle.getPosLom().y + reEle.getHeightLom() - reEle.getParent().getHeightLom());
            }
        } else if (side.getRelativeObjectID().equals(reEle.getName())) {
            side.setValue(reEle.getHeightLom());
        } else {
            ReportElement reOther = (ReportElement)kdf.getElementsNameMap().get(side.getRelativeObjectID());
            if (reOther != null) {
                if (side.getContextValue() == 2) {
                    side.setValue(reEle.getPosLom().y - reOther.getPosLom().y + reEle.getHeightLom());
                } else {
                    side.setValue(reEle.getHeightLom() + reEle.getPosLom().y - reOther.getPosLom().y - reOther.getHeightLom());
                }
            } else {
                side.setRelativeObjectID(reEle.getParent().getName());
                side.setContextValue(2);
                side.setValue(reEle.getWidthLom());
            }
        }
    }

    @Override
    public void setSelectElement(ArrayList res) {
    }

    private void customFormulaChanged(FocusEvent e, int side) {
        String text = ((KDTextField)e.getSource()).getText();
        this.templocation.getSideLocation(side).setStrFormula(text);
        this.applyLocation();
    }

    private void checkPageBottomSelfAdapt(ReportElement re, Location loc) {
        if (re.getParent() != re.getTopContainer() || !re.getTopContainer().getKDF().isHeightLimitless()) {
            return;
        }
        SideLocation top = loc.getSideLocation(2);
        SideLocation btm = loc.getSideLocation(3);
        if (top.getType() == 1 && top.getRelativeObjectID().equals(re.getParent().getName()) && top.getContextValue() != 3 || top.getType() == 0 && top.getRelativeObjectID().equals(re.getParent().getName()) && top.getContextValue() == 3 || btm.getType() == 0 && btm.getRelativeObjectID().equals(re.getParent().getName()) && btm.getContextValue() == 3) {
            this.forceParentDialogNotHide();
            MsgBox.show(this.getParent(), LocationPanel.getMLS("promptRelaPageBtm", "\u9875\u65e0\u9650\u957f\uff0c\u5176\u4e0b\u8fb9\u4e0d\u80fd\u786e\u5b9a\uff0c\u5efa\u8bae\u4e0d\u8981\u76f8\u5bf9\u4e8e\u9875\u7684\u4e0b\u8fb9\u5b9a\u4f4d\u3002"), LocationPanel.getMLS("error", "\u91d1\u8776\u63d0\u793a"), 129);
            this.unforceParentDialogNotHide();
        }
    }
}

