/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.fd2.gui.stick;

import com.kingdee.bos.ctrl.kdf.fd2.TransType;
import com.kingdee.bos.ctrl.kdf.fd2.gui.stick.MaxMinPair;
import com.kingdee.bos.ctrl.kdf.fd2.gui.stick.StickParm;
import com.kingdee.bos.ctrl.kdf.fd2.gui.util.Line;
import com.kingdee.bos.ctrl.kdf.fd2.reportelement.IContainer;
import com.kingdee.bos.ctrl.kdf.fd2.reportelement.IElement;
import com.kingdee.bos.ctrl.kdf.fd2.reportelement.Page;
import com.kingdee.bos.ctrl.kdf.fd2.reportelement.ReportElement;
import com.kingdee.bos.ctrl.kdf.fd2.reportelement.Table;
import java.awt.Point;
import java.awt.Rectangle;

public class StickUtil {
    private static int STICK_ARG = 10;
    private static int NEAR_ARG = 60;
    private static int THRUM = 15;

    public static Line[] moveStickTo(IElement ele, Point mouseOffset) {
        MaxMinPair pair;
        int nearestX = -32767;
        int nearestY = -32767;
        int minDistanceX = STICK_ARG;
        int minDistanceY = STICK_ARG;
        IElement eleStickToX = null;
        IElement eleStickToY = null;
        boolean isLeft = false;
        boolean isTop = false;
        Point posEle = (Point)ele.getPosition().clone();
        posEle.translate(mouseOffset.x, mouseOffset.y);
        IContainer parent = ele.getParent();
        for (IElement eleBrother : parent.getChildren()) {
            if (ele == eleBrother) continue;
            Point posBrother = eleBrother.getPosition();
            if (StickUtil.isNearEnough(posEle.y, ele.getHeight(), posBrother.y, eleBrother.getHeight())) {
                int tempX = posBrother.x;
                int tempDistanceX = Math.abs(posEle.x - tempX);
                if (tempDistanceX < minDistanceX) {
                    minDistanceX = tempDistanceX;
                    nearestX = tempX;
                    eleStickToX = eleBrother;
                    isLeft = true;
                } else {
                    tempX = posBrother.x + eleBrother.getWidth();
                    tempDistanceX = Math.abs(posEle.x - tempX);
                    if (tempDistanceX < minDistanceX) {
                        minDistanceX = tempDistanceX;
                        nearestX = tempX;
                        eleStickToX = eleBrother;
                        isLeft = true;
                    } else {
                        tempX = posBrother.x + eleBrother.getWidth() - ele.getWidth();
                        tempDistanceX = Math.abs(posEle.x - tempX);
                        if (tempDistanceX < minDistanceX) {
                            minDistanceX = tempDistanceX;
                            nearestX = tempX;
                            eleStickToX = eleBrother;
                            isLeft = false;
                        } else {
                            tempX = posBrother.x - ele.getWidth();
                            tempDistanceX = Math.abs(posEle.x - tempX);
                            if (tempDistanceX < minDistanceX) {
                                minDistanceX = tempDistanceX;
                                nearestX = tempX;
                                eleStickToX = eleBrother;
                                isLeft = false;
                            }
                        }
                    }
                }
            }
            if (!StickUtil.isNearEnough(posEle.x, ele.getWidth(), posBrother.x, eleBrother.getWidth())) continue;
            int tempY = posBrother.y;
            int tempDistanceY = Math.abs(posEle.y - tempY);
            if (tempDistanceY < minDistanceY) {
                minDistanceY = tempDistanceY;
                nearestY = tempY;
                eleStickToY = eleBrother;
                isTop = true;
                continue;
            }
            tempY = posBrother.y + eleBrother.getHeight();
            tempDistanceY = Math.abs(posEle.y - tempY);
            if (tempDistanceY < minDistanceY) {
                minDistanceY = tempDistanceY;
                nearestY = tempY;
                eleStickToY = eleBrother;
                isTop = true;
                continue;
            }
            tempY = posBrother.y + eleBrother.getHeight() - ele.getHeight();
            tempDistanceY = Math.abs(posEle.y - tempY);
            if (tempDistanceY < minDistanceY) {
                minDistanceY = tempDistanceY;
                nearestY = tempY;
                eleStickToY = eleBrother;
                isTop = false;
                continue;
            }
            tempY = posBrother.y - ele.getHeight();
            tempDistanceY = Math.abs(posEle.y - tempY);
            if (tempDistanceY >= minDistanceY) continue;
            minDistanceY = tempDistanceY;
            nearestY = tempY;
            eleStickToY = eleBrother;
            isTop = false;
        }
        if (nearestX < 0 && nearestY < 0) {
            return null;
        }
        Point ptRelaPage = ((ReportElement)ele).getCorrespondTopPos();
        Line[] lines = new Line[2];
        if (nearestX >= 0) {
            mouseOffset.x += nearestX - posEle.x;
            if (null != eleStickToX) {
                int yEleStickTo = eleStickToX.getPosition().y;
                pair = MaxMinPair.createPair(yEleStickTo, yEleStickTo + eleStickToX.getHeight(), posEle.y, posEle.y + ele.getHeight());
                int x = nearestX + (isLeft ? 0 : ele.getWidth()) + ptRelaPage.x;
                lines[0] = new Line(x, pair.getMin() - THRUM + ptRelaPage.y, x, pair.getMax() + THRUM + ptRelaPage.y);
            }
        }
        if (nearestY >= 0) {
            mouseOffset.y += nearestY - posEle.y;
            if (null != eleStickToY) {
                int xEleStickTo = eleStickToY.getPosition().x;
                pair = MaxMinPair.createPair(xEleStickTo, xEleStickTo + eleStickToY.getWidth(), posEle.x, posEle.x + ele.getWidth());
                int y = nearestY + (isTop ? 0 : ele.getHeight()) + ptRelaPage.y;
                lines[1] = new Line(pair.getMin() - THRUM + ptRelaPage.x, y, pair.getMax() + THRUM + ptRelaPage.x, y);
            }
        }
        return lines;
    }

    public static Line[] resizeStickTo(IElement ele, Rectangle rect, int resizeType, Point ptMouseEnd, int transType) {
        MaxMinPair pair;
        int jump;
        int nearestX = -32767;
        int nearestY = -32767;
        int minDistanceX = STICK_ARG;
        int minDistanceY = STICK_ARG;
        IElement eleStickToX = null;
        IElement eleStickToY = null;
        Point ptRelaPage = ((ReportElement)ele).getCorrespondTopPos();
        IContainer parent = ele.getParent();
        for (IElement eleBrother : parent.getChildren()) {
            int tempDistanceY;
            int tempY;
            if (ele == eleBrother) continue;
            Point posBrother = ((ReportElement)eleBrother).getRelativePagePosition();
            if (StickUtil.isNearEnough(rect.y, rect.height, posBrother.y, eleBrother.getHeight())) {
                int tempDistanceX;
                int tempX;
                if (TransType.containsWest(transType)) {
                    tempX = posBrother.x;
                    tempDistanceX = Math.abs(rect.x - tempX);
                    if (tempDistanceX < minDistanceX) {
                        minDistanceX = tempDistanceX;
                        nearestX = tempX;
                        eleStickToX = eleBrother;
                    } else {
                        tempX = posBrother.x + eleBrother.getWidth();
                        tempDistanceX = Math.abs(rect.x - tempX);
                        if (tempDistanceX < minDistanceX) {
                            minDistanceX = tempDistanceX;
                            nearestX = tempX;
                            eleStickToX = eleBrother;
                        }
                    }
                } else if (TransType.containsEast(transType)) {
                    int right = rect.x + rect.width;
                    tempX = posBrother.x + eleBrother.getWidth();
                    tempDistanceX = Math.abs(right - tempX);
                    if (tempDistanceX < minDistanceX) {
                        minDistanceX = tempDistanceX;
                        nearestX = tempX;
                        eleStickToX = eleBrother;
                    } else {
                        tempX = posBrother.x;
                        tempDistanceX = Math.abs(right - tempX);
                        if (tempDistanceX < minDistanceX) {
                            minDistanceX = tempDistanceX;
                            nearestX = tempX;
                            eleStickToX = eleBrother;
                        }
                    }
                }
            }
            if (!StickUtil.isNearEnough(rect.x, rect.width, posBrother.x, eleBrother.getWidth())) continue;
            if (TransType.containsNorth(transType)) {
                tempY = posBrother.y;
                tempDistanceY = Math.abs(rect.y - tempY);
                if (tempDistanceY < minDistanceY) {
                    minDistanceY = tempDistanceY;
                    nearestY = tempY;
                    eleStickToY = eleBrother;
                    continue;
                }
                tempY = posBrother.y + eleBrother.getHeight();
                tempDistanceY = Math.abs(rect.y - tempY);
                if (tempDistanceY >= minDistanceY) continue;
                minDistanceY = tempDistanceY;
                nearestY = tempY;
                eleStickToY = eleBrother;
                continue;
            }
            if (!TransType.containsSouth(transType)) continue;
            int bottom = rect.y + rect.height;
            tempY = posBrother.y + eleBrother.getHeight();
            tempDistanceY = Math.abs(bottom - tempY);
            if (tempDistanceY < minDistanceY) {
                minDistanceY = tempDistanceY;
                nearestY = tempY;
                eleStickToY = eleBrother;
                continue;
            }
            tempY = posBrother.y;
            tempDistanceY = Math.abs(bottom - tempY);
            if (tempDistanceY >= minDistanceY) continue;
            minDistanceY = tempDistanceY;
            nearestY = tempY;
            eleStickToY = eleBrother;
        }
        if (nearestX < 0 && nearestY < 0) {
            return null;
        }
        Line[] lines = new Line[2];
        if (nearestX >= 0) {
            if (TransType.containsWest(transType)) {
                jump = nearestX - rect.x;
                rect.width -= jump;
                rect.x = nearestX;
            } else {
                jump = nearestX - (rect.x + rect.width);
                rect.width += jump;
            }
            ptMouseEnd.x += jump;
            if (null != eleStickToX) {
                int yEleStickTo = eleStickToX.getPosition().y;
                pair = MaxMinPair.createPair(yEleStickTo + ptRelaPage.y, yEleStickTo + eleStickToX.getHeight() + ptRelaPage.y, rect.y, rect.y + rect.height);
                int x = nearestX;
                lines[0] = new Line(x, pair.getMin() - THRUM, x, pair.getMax() + THRUM);
            }
        }
        if (nearestY >= 0) {
            if (TransType.containsNorth(transType)) {
                jump = nearestY - rect.y;
                rect.height -= jump;
                rect.y = nearestY;
            } else {
                jump = nearestY - (rect.y + rect.height);
                rect.height += jump;
            }
            ptMouseEnd.y += jump;
            if (null != eleStickToY) {
                int xEleStickTo = eleStickToY.getPosition().x;
                pair = MaxMinPair.createPair(xEleStickTo + ptRelaPage.x, xEleStickTo + eleStickToY.getWidth() + ptRelaPage.x, rect.x, rect.x + rect.width);
                int y = nearestY;
                lines[1] = new Line(pair.getMin() - THRUM, y, pair.getMax() + THRUM, y);
            }
        }
        return lines;
    }

    public static Line tableLineStickTo(Table ele, boolean isCol, Point ptValue, MaxMinPair range) {
        IContainer container = ele.getParent();
        while (!(container instanceof Page)) {
            container = container.getParent();
        }
        int value = isCol ? ptValue.x : ptValue.y;
        StickParm parm = StickUtil.loopTableLineStickTo(container, ele, isCol, value, range, null);
        if (parm == null) {
            return null;
        }
        if (value != parm.getNearestValue()) {
            value = parm.getNearestValue();
            if (isCol) {
                ptValue.x = value;
            } else {
                ptValue.y = value;
            }
        }
        Point ptEle = ele.getRelativePagePosition();
        Point ptReferEle = ((ReportElement)parm.getReferenceElement()).getRelativePagePosition();
        if (isCol) {
            MaxMinPair pair = MaxMinPair.createPair(ptEle.y, ptEle.y + ele.getHeight(), ptReferEle.y, ptReferEle.y + parm.getReferenceElement().getHeight());
            return new Line(value, pair.getMin() - THRUM, value, pair.getMax() + THRUM);
        }
        MaxMinPair pair = MaxMinPair.createPair(ptEle.x, ptEle.x + ele.getWidth(), ptReferEle.x, ptReferEle.x + parm.getReferenceElement().getWidth());
        return new Line(pair.getMin() - THRUM, value, pair.getMax() + THRUM, value);
    }

    private static StickParm loopTableLineStickTo(IContainer container, Table ele, boolean isCol, int value, MaxMinPair range, StickParm parm) {
        for (IElement child : container.getChildren()) {
            if (child == ele) continue;
            if (child instanceof Table) {
                parm = StickUtil.stickTableLine(ele, (Table)child, isCol, value, range, parm);
            }
            if (!(child instanceof IContainer)) continue;
            parm = StickUtil.loopTableLineStickTo((IContainer)child, ele, isCol, value, range, parm);
        }
        return parm;
    }

    private static StickParm stickTableLine(Table eleOri, Table eleRefer, boolean isCol, int value, MaxMinPair range, StickParm parm) {
        StickParm tempParm;
        int referValue;
        Point posEleOri = eleOri.getRelativePagePosition();
        Point posEleRefer = eleRefer.getRelativePagePosition();
        boolean isNearEnough = false;
        if (isCol) {
            if (StickUtil.isNearEnough(posEleOri.y, eleOri.getHeight(), posEleRefer.y, eleRefer.getHeight())) {
                isNearEnough = true;
            }
        } else if (StickUtil.isNearEnough(posEleOri.x, eleOri.getWidth(), posEleRefer.x, eleRefer.getWidth())) {
            isNearEnough = true;
        }
        if (isNearEnough && (referValue = eleRefer.getNearestTableLineLocation(value, isCol)) > 0 && Math.abs(referValue - value) < STICK_ARG && referValue < range.getMax() && referValue > range.getMin() && (tempParm = StickParm.create(parm, value, referValue, eleRefer)) != null) {
            parm = tempParm;
        }
        return parm;
    }

    private static boolean isNearEnough(int startOri, int lengthOri, int startRefer, int lengthRefer) {
        return startOri >= startRefer - lengthOri - NEAR_ARG && startOri <= startRefer + lengthRefer + NEAR_ARG;
    }
}

