/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.fd2.gui.util;

import com.kingdee.bos.ctrl.kdf.fd2.gui.util.NumberDocument;
import com.kingdee.bos.ctrl.swing.KDTextField;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyVetoException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.text.Document;

public class NumberField
extends KDTextField
implements FocusListener {
    private int decimals = 2;
    private boolean integer = false;
    private double value = 0.0;
    private NumberFormat numberFormat = null;
    private boolean grouping = true;
    private boolean isEnableNegative = false;
    private boolean bEx = false;
    private boolean isAllowNullState = false;

    public NumberField(boolean bEx) {
        this.setEnabledPopup(false);
        this.addFocusListener(this);
        this.numberFormat = NumberFormat.getInstance();
        this.numberFormat.setMaximumFractionDigits(2);
        this.numberFormat.setMinimumFractionDigits(2);
        this.numberFormat.setGroupingUsed(true);
        this.setText(this.numberFormat.format(0L));
        this.bEx = bEx;
        ((NumberDocument)this.getDocument()).setEx(bEx);
    }

    public NumberField() {
        this(false);
    }

    protected Document createDefaultModel() {
        return new NumberDocument();
    }

    public int getDecimals() {
        return this.decimals;
    }

    public void setDecimals(int decimals) throws PropertyVetoException {
        this.decimals = decimals;
        if (!this.isInteger()) {
            this.numberFormat.setMaximumFractionDigits(decimals);
            this.numberFormat.setMinimumFractionDigits(decimals);
        }
        this.setText(this.numberFormat.format(this.getValue()));
    }

    public boolean isInteger() {
        return this.integer;
    }

    public void setInteger(boolean integer) throws PropertyVetoException {
        if (integer) {
            this.numberFormat = new DecimalFormat("#");
        } else {
            StringBuffer sb = new StringBuffer("#.");
            for (int i = this.getDecimals(); i > 0; --i) {
                sb.append("#");
            }
            this.numberFormat = new DecimalFormat(sb.toString());
        }
        this.integer = integer;
        this.setText(this.numberFormat.format(this.value));
    }

    public double getValue() {
        if (this.bEx && this.getText().equals("*")) {
            this.value = -1.0;
        } else if (this.getText().equals("")) {
            this.value = 0.0;
        } else if (!String.valueOf(this.value).equals(this.getText())) {
            try {
                this.value = this.numberFormat.parse(this.getText()).doubleValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.value;
    }

    public void setValue(double value) throws PropertyVetoException {
        this.value = value;
        if (value < 0.0 && this.bEx) {
            this.setText("*");
        } else {
            this.setText(this.numberFormat.format(value));
        }
    }

    public void setValue(int value) throws PropertyVetoException {
        this.setValue((double)value);
    }

    @Override
    public void focusGained(FocusEvent e) {
        if (this.isAllowNullState) {
            return;
        }
        this.numberFormat.setGroupingUsed(false);
        if (this.value < 0.0 && this.bEx) {
            this.setText("*");
        } else {
            this.setText(this.numberFormat.format(this.value));
        }
        this.numberFormat.setGroupingUsed(this.isGrouping());
    }

    @Override
    public void focusLost(FocusEvent e) {
        double oldValue = this.value;
        try {
            this.value = this.numberFormat.parse(this.getText()).doubleValue();
        }
        catch (ParseException ex) {
            if (this.getText().equals("*")) {
                this.setText("*");
                this.value = -1.0;
            } else {
                this.value = this.getText().equals("") ? 0.0 : oldValue;
            }
            return;
        }
        this.setText(this.numberFormat.format(this.value));
        this.fireActionPerformed();
    }

    public boolean isGrouping() {
        return this.grouping;
    }

    public void setGrouping(boolean grouping) throws PropertyVetoException {
        this.grouping = grouping;
    }

    public void setText(String t) {
        String oldText = this.getText();
        if (!t.equals(oldText)) {
            super.setText(t);
        }
    }

    public boolean isEnableNegative() {
        return this.isEnableNegative;
    }

    public void setEnableNegative(boolean isEnableNegative) {
        this.isEnableNegative = isEnableNegative;
        ((NumberDocument)this.getDocument()).setEnableNegative(isEnableNegative);
    }

    public void setAllowNullState(boolean b) {
        this.isAllowNullState = b;
    }
}

