/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.fd2.reportelement;

import com.kingdee.bos.ctrl.kdf.fd2.icons.Icons;
import com.kingdee.bos.ctrl.kdf.fd2.reportelement.GraphicElement;
import com.kingdee.bos.ctrl.kdf.fd2.reportelement.ReportElement;
import com.kingdee.bos.ctrl.kdf.util.BMPReader;
import com.kingdee.bos.ctrl.kdf.util.render.CellImageRender;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.StyleUtil;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import javax.swing.ImageIcon;

public class ImageElement
extends GraphicElement
implements ImageObserver {
    private Image imgDraw = null;
    private Image img = null;
    private static Image defimg = null;
    private String imageExpression;
    private boolean isLinked = true;
    private int scale = 0;
    private static final CellImageRender cr = new CellImageRender();

    public ImageElement(String name, int x, int y, int width, int height) {
        super(name, x, y, width, height);
        if (defimg == null) {
            defimg = Icons.createImage("layout/img.gif");
        }
        this.setImageExpression("");
        this.eletype = 2;
        this.setStyleAttribute(Styles.getEmptySA());
    }

    @Override
    public void drawGraphicsElement(Graphics2D g, double zoom_factor) {
        this.zoom_factor = zoom_factor;
        if (this.imgDraw != null) {
            g.drawImage(this.imgDraw, this.position.x, this.position.y, this.width, this.height, this);
        }
    }

    public String getImageExpression() {
        return this.imageExpression;
    }

    public void setImageExpression(String imageExpression) {
        this.imageExpression = imageExpression;
        try {
            URL urlOfData = new URL(imageExpression);
            String url = urlOfData.toString();
            String suffix = url.substring(url.length() - 3, url.length());
            this.img = urlOfData.getProtocol().equalsIgnoreCase("file") ? ("bmp".equalsIgnoreCase(suffix) || "dib".equalsIgnoreCase(suffix) ? BMPReader.loadBitMap((String)url.substring(7)) : new ImageIcon(url.substring(7)).getImage()) : ("bmp".equalsIgnoreCase(suffix) || "dib".equalsIgnoreCase(suffix) ? BMPReader.loadBitMap((InputStream)new FileInputStream(new File(new URI(urlOfData.toString())))) : new ImageIcon(urlOfData).getImage());
            this.reDrawImage();
        }
        catch (Exception e) {
            this.img = defimg;
            this.reDrawImage();
        }
        this.firePropertyChange(null);
    }

    protected void reDrawImage() {
        Image imgx = this.img;
        if (this.img == null) {
            imgx = defimg;
        }
        if (this.height > 0 && this.width > 0) {
            Rectangle rect = new Rectangle(0, 0, this.getZoomedDim(this.width), this.getZoomedDim(this.height));
            BufferedImage imagetemp = new BufferedImage(rect.width, rect.height, 7);
            Graphics2D imageg = (Graphics2D)imagetemp.getGraphics();
            cr.setMode((short)this.scale);
            cr.draw((Graphics)imageg, (Shape)rect, (Object)imgx, this.style);
            this.imgDraw = imagetemp;
        }
    }

    public Image getImg() {
        return this.img;
    }

    public Image getImgDef() {
        return defimg;
    }

    public void setImg(Image img) {
        this.img = img;
        this.reDrawImage();
        this.firePropertyChange(null);
    }

    @Override
    public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
        return true;
    }

    public static void setImgDef(Image defImg) {
        defimg = defImg;
    }

    @Override
    public void setStyleAttribute(StyleAttributes sa) {
        super.setStyleAttribute(sa);
        this.reDrawImage();
    }

    @Override
    public void setHeight(int value) {
        if (this.height != value) {
            this.height = value;
            this.heightLom = (int)StyleUtil.pixelToLom((long)value);
            this.reDrawImage();
        }
    }

    @Override
    public void setHeightLom(int value) {
        if (this.heightLom != value) {
            super.setHeightLom(value);
            this.reDrawImage();
        }
    }

    @Override
    public void setWidth(int value) {
        if (this.width != value) {
            this.width = value;
            this.widthLom = (int)StyleUtil.pixelToLom((long)value);
            this.reDrawImage();
        }
    }

    @Override
    public void setWidthLom(int value) {
        if (this.widthLom != value) {
            super.setWidthLom(value);
            this.reDrawImage();
        }
    }

    @Override
    public Point trasform(Point delta, int type) {
        int oldHeight = this.height;
        int oldWidth = this.width;
        Point pt = super.trasform(delta, type);
        if (oldHeight != this.height || oldWidth != this.width) {
            this.reDrawImage();
        }
        return pt;
    }

    public boolean isLinked() {
        return this.isLinked;
    }

    public void setLinked(boolean isLinked) {
        this.isLinked = isLinked;
        this.firePropertyChange(null);
    }

    public int getScale() {
        return this.scale;
    }

    public void setScale(int scale) {
        this.scale = scale;
        this.reDrawImage();
    }

    @Override
    public ReportElement cloneMe() {
        ImageElement newReportElement = new ImageElement(this.name, 0, 0, this.width, this.height);
        newReportElement.isLinked = this.isLinked;
        newReportElement.scale = this.scale;
        newReportElement.img = this.img;
        newReportElement.imageExpression = this.imageExpression;
        newReportElement.imgDraw = this.imgDraw;
        this.copyBaseReportElement(newReportElement, this);
        return newReportElement;
    }
}

