/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.fd2.reportelement;

import com.kingdee.bos.ctrl.kdf.fd2.TableLocation;
import com.kingdee.bos.ctrl.kdf.fd2.gui.stick.MaxMinPair;
import com.kingdee.bos.ctrl.kdf.fd2.reportelement.AbstractGroup;
import com.kingdee.bos.ctrl.kdf.fd2.reportelement.ReportElement;
import com.kingdee.bos.ctrl.kdf.form.Column;
import com.kingdee.bos.ctrl.kdf.form.ColumnCollection;
import com.kingdee.bos.ctrl.kdf.form.Row;
import com.kingdee.bos.ctrl.kdf.form.RowCollection;
import com.kingdee.bos.ctrl.kdf.util.style.LineStyle;
import com.kingdee.bos.ctrl.kdf.util.style.Pattern;
import com.kingdee.bos.ctrl.kdf.util.style.PenStyle;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.StyleUtil;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;

public class Table
extends AbstractGroup {
    static Stroke stroke = new BasicStroke(1.0f);
    private boolean isSamedWidth = true;
    private boolean isSamedHeight = true;
    public static final String LAYOUT_AUTO = "auto";
    public static final String LAYOUT_WIDTH_AUTO = "widthAuto";
    public static final String LAYOUT_HEIGHT_AUTO = "heightAuto";
    public static final String LAYOUT_NON_AUTO = "nonAuto";
    private boolean[] rowSelfAdapt;
    private boolean[] colSelfAdapt;
    private int[] rowPos;
    private int[] colPos;
    private int[] rowHeightLom;
    private int[] colWidthLom;

    public Table(String name, int top, int left, int width, int height) {
        this(name, top, left, width, height, 1, 5);
        StyleAttributes sa = Styles.getEmptySA();
        sa.setBackground(Color.WHITE);
        sa.setPattern(Pattern.Solid);
        sa.setPatternColor(Color.BLACK);
        sa.setBorderPenStyle(Styles.Position.LEFT, PenStyle.PS_SOLID);
        sa.setBorderPenStyle(Styles.Position.RIGHT, PenStyle.PS_SOLID);
        sa.setBorderPenStyle(Styles.Position.TOP, PenStyle.PS_SOLID);
        sa.setBorderPenStyle(Styles.Position.BOTTOM, PenStyle.PS_SOLID);
        sa.setBorderLineStyle(Styles.Position.LEFT, LineStyle.NULL_LINE);
        sa.setBorderLineStyle(Styles.Position.RIGHT, LineStyle.NULL_LINE);
        sa.setBorderLineStyle(Styles.Position.TOP, LineStyle.NULL_LINE);
        sa.setBorderLineStyle(Styles.Position.BOTTOM, LineStyle.NULL_LINE);
        sa.setBorderColor(Styles.Position.LEFT, Color.BLACK);
        sa.setBorderColor(Styles.Position.RIGHT, Color.BLACK);
        sa.setBorderColor(Styles.Position.TOP, Color.BLACK);
        sa.setBorderColor(Styles.Position.BOTTOM, Color.BLACK);
        this.ssa = Styles.getSSA((StyleAttributes)sa);
        this.style = Styles.getStyle((ShareStyleAttributes)this.ssa);
        this.eletype = 10;
    }

    public Table(String name, int top, int left, int width, int height, int rows, int cols) {
        super(name, top, left, width, height);
        int i;
        this.rowPos = new int[rows + 1];
        this.colPos = new int[cols + 1];
        this.rowHeightLom = new int[rows];
        this.colWidthLom = new int[cols];
        this.rowSelfAdapt = new boolean[rows];
        this.colSelfAdapt = new boolean[cols];
        for (i = 0; i < rows; ++i) {
            this.rowSelfAdapt[i] = false;
        }
        for (i = 0; i < cols; ++i) {
            this.colSelfAdapt[i] = false;
        }
        this.calcColWidths();
        this.calcRowHeights();
        this.refreshGridPos();
    }

    public void refreshGridPos() {
        this.refreshGridPos(true);
    }

    public void refreshGridPos(boolean widthCheck) {
        int i;
        if (this.colPos == null || this.rowPos == null) {
            return;
        }
        this.colPos[0] = 0;
        this.rowPos[0] = 0;
        int temp = 0;
        for (i = 1; i < this.colWidthLom.length; ++i) {
            this.colPos[i] = (int)StyleUtil.lomToPixel((long)(temp += this.colWidthLom[i - 1]));
            if (!widthCheck || this.colPos[i] <= this.getWidth()) continue;
            this.colPos[i] = this.getWidth();
        }
        this.colPos[this.colWidthLom.length] = this.getWidth();
        temp = 0;
        for (i = 1; i < this.rowHeightLom.length; ++i) {
            this.rowPos[i] = (int)StyleUtil.lomToPixel((long)(temp += this.rowHeightLom[i - 1]));
            if (!widthCheck || this.rowPos[i] <= this.getHeight()) continue;
            this.rowPos[i] = this.getHeight();
        }
        this.rowPos[this.rowHeightLom.length] = this.getHeight();
        this.refreshChildPos();
    }

    public void refreshChildPos() {
        for (ReportElement re : this.allChildren) {
            if (this.isAllZero(this.colPos) && !this.isAllZero(this.colWidthLom) || this.isAllZero(this.rowPos) && !this.isAllZero(this.rowHeightLom)) continue;
            re.position.x = this.colPos[re.getTableLocation().getStartCol()];
            re.posLom.x = (int)StyleUtil.pixelToLom((long)re.position.x);
            re.position.y = this.rowPos[re.getTableLocation().getStartRow()];
            re.posLom.y = (int)StyleUtil.pixelToLom((long)re.position.y);
            re.setWidth(this.colPos[re.getTableLocation().getEndCol()] - this.colPos[re.getTableLocation().getStartCol()]);
            re.setHeight(this.rowPos[re.getTableLocation().getEndRow()] - this.rowPos[re.getTableLocation().getStartRow()]);
            re.updateBounds();
            re.addRelationQuean(re.getTopContainer().deps);
        }
    }

    private boolean isAllZero(int[] data) {
        for (int i = 0; i < data.length; ++i) {
            if (data[i] == 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public void updateBounds() {
        super.updateBounds();
        this.refreshGridPos();
    }

    @Override
    public void drawBorder(Graphics2D g, double zoom_factor) {
        int i;
        super.drawBorder(g, zoom_factor);
        this.zoom_factor = zoom_factor;
        Rectangle rect = new Rectangle(this.getZoomedDim(this.position.x), this.getZoomedDim(this.position.y), this.getZoomedDim(this.width), this.getZoomedDim(this.height));
        Stroke oldStroke = g.getStroke();
        g.setStroke(stroke);
        g.setColor(Color.LIGHT_GRAY);
        if (LineStyle.isNull((LineStyle)this.style.getBorderLineStyle(Styles.Position.LEFT))) {
            g.drawLine(rect.x, rect.y, rect.x, rect.y + rect.height);
        }
        if (LineStyle.isNull((LineStyle)this.style.getBorderLineStyle(Styles.Position.TOP))) {
            g.drawLine(rect.x, rect.y, rect.x + rect.width, rect.y);
        }
        if (LineStyle.isNull((LineStyle)this.style.getBorderLineStyle(Styles.Position.RIGHT))) {
            g.drawLine(rect.x + rect.width, rect.y, rect.x + rect.width, rect.y + rect.height);
        }
        if (LineStyle.isNull((LineStyle)this.style.getBorderLineStyle(Styles.Position.BOTTOM))) {
            g.drawLine(rect.x, rect.y + rect.height, rect.x + rect.width, rect.y + rect.height);
        }
        if (!LineStyle.isNull((LineStyle)this.style.getBorderLineStyle(Styles.Position.DIAGONALLEFT))) {
            g.setStroke(this.style.getStroke(Styles.Position.DIAGONALLEFT));
            g.setColor(this.style.getBorderColor(Styles.Position.DIAGONALLEFT));
        }
        for (i = 1; i < this.colPos.length - 1; ++i) {
            g.drawLine(this.position.x + this.colPos[i], rect.y, this.position.x + this.colPos[i], rect.y + rect.height);
        }
        for (i = 1; i < this.rowPos.length - 1; ++i) {
            g.drawLine(rect.x, this.position.y + this.rowPos[i], rect.x + rect.width, this.position.y + this.rowPos[i]);
        }
        g.setStroke(oldStroke);
    }

    public ColumnCollection getCols() {
        ColumnCollection cols = new ColumnCollection();
        for (int i = 0; i < this.colWidthLom.length; ++i) {
            Column col = new Column();
            if (this.colSelfAdapt[i]) {
                col.getWidth().setOriginString("*");
            } else {
                col.getWidth().setInteger(this.colWidthLom[i]);
                col.getWidth().setOriginString(String.valueOf(this.colWidthLom[i]));
            }
            cols.add(col);
        }
        return cols;
    }

    public void setCols(ColumnCollection cols) {
        this.colPos = new int[cols.size() + 1];
        this.colWidthLom = new int[cols.size()];
        this.colSelfAdapt = new boolean[cols.size()];
        for (int i = 0; i < cols.size(); ++i) {
            try {
                this.colWidthLom[i] = Integer.parseInt(cols.get(i).getWidth().getOriginString());
                this.colSelfAdapt[i] = false;
                continue;
            }
            catch (Exception e) {
                this.colSelfAdapt[i] = true;
            }
        }
    }

    public RowCollection getRows() {
        RowCollection rows = new RowCollection();
        for (int i = 0; i < this.rowHeightLom.length; ++i) {
            Row row = new Row();
            if (this.rowSelfAdapt[i]) {
                row.getHeight().setOriginString("*");
            } else {
                row.getHeight().setInteger(this.rowHeightLom[i]);
                row.getHeight().setOriginString(String.valueOf(this.rowHeightLom[i]));
            }
            rows.add(row);
        }
        return rows;
    }

    public int getRowCount() {
        return this.rowHeightLom.length;
    }

    public void setRowCount(int rowCount) {
        int i;
        int[] tempRow = new int[rowCount];
        boolean[] btempRowSelf = new boolean[rowCount];
        for (i = 0; i < Math.min(rowCount, this.rowHeightLom.length); ++i) {
            tempRow[i] = this.rowHeightLom[i];
            btempRowSelf[i] = this.rowSelfAdapt[i];
        }
        if (rowCount > this.rowHeightLom.length) {
            for (i = this.rowHeightLom.length - 1; i < rowCount; ++i) {
                btempRowSelf[i] = false;
            }
        }
        this.rowHeightLom = tempRow;
        this.rowPos = new int[rowCount + 1];
        this.rowSelfAdapt = btempRowSelf;
        this.calcRowHeights();
        this.refreshGridPos();
        this.firePropertyChange(null);
    }

    public void setRows(RowCollection rows) {
        this.rowPos = new int[rows.size() + 1];
        this.rowHeightLom = new int[rows.size()];
        this.rowSelfAdapt = new boolean[rows.size()];
        for (int i = 0; i < rows.size(); ++i) {
            try {
                this.rowHeightLom[i] = Integer.parseInt(rows.get(i).getHeight().getOriginString());
                this.rowSelfAdapt[i] = false;
                continue;
            }
            catch (Exception e) {
                this.rowSelfAdapt[i] = true;
            }
        }
    }

    public void setColumnCount(int colCount) {
        int i;
        int[] tempCol = new int[colCount];
        boolean[] btempColSelf = new boolean[colCount];
        for (i = 0; i < Math.min(colCount, this.colWidthLom.length); ++i) {
            tempCol[i] = this.colWidthLom[i];
            btempColSelf[i] = this.colSelfAdapt[i];
        }
        if (colCount > this.colWidthLom.length) {
            for (i = this.colWidthLom.length - 1; i < colCount; ++i) {
                btempColSelf[i] = false;
            }
        }
        this.colWidthLom = tempCol;
        this.colPos = new int[colCount + 1];
        this.colSelfAdapt = btempColSelf;
        this.calcColWidths();
        this.refreshGridPos();
        this.firePropertyChange(null);
    }

    public int getColumnCount() {
        return this.colWidthLom.length;
    }

    public void setColWidth(int col, int colwidthLom) {
        if (col < 0 || col > this.colWidthLom.length) {
            throw new IllegalArgumentException();
        }
        this.colSelfAdapt[col] = colwidthLom == -1;
        this.colWidthLom[col] = colwidthLom;
        this.calcColWidths();
        this.refreshGridPos();
        this.firePropertyChange(null);
    }

    private void calcColWidths() {
        block7: {
            int colAdaptCount;
            block8: {
                block6: {
                    if (!this.isSamedWidth) break block6;
                    int remainWidth = this.widthLom;
                    int remainCol = this.getColumnCount();
                    for (int i = 0; i < this.getColumnCount(); ++i) {
                        int currentColWidth = remainWidth / remainCol;
                        --remainCol;
                        remainWidth -= currentColWidth;
                        this.colWidthLom[i] = currentColWidth;
                    }
                    break block7;
                }
                colAdaptCount = this.getAdaptRowColCount(false);
                if (colAdaptCount != 0) break block8;
                int temp = 0;
                for (int i = 0; i < this.getColumnCount(); ++i) {
                    if ((temp += this.colWidthLom[i]) < this.widthLom) continue;
                    this.colWidthLom[i] = this.colWidthLom[i] + this.widthLom - temp;
                    for (int j = i + 1; j < this.getColumnCount(); ++j) {
                        this.colWidthLom[j] = 0;
                    }
                    break;
                }
                if (temp >= this.widthLom) break block7;
                int n = this.getColumnCount() - 1;
                this.colWidthLom[n] = this.colWidthLom[n] + (this.widthLom - temp);
                break block7;
            }
            int temp = 0;
            for (int i = 0; i < this.getColumnCount(); ++i) {
                if (this.colSelfAdapt[i] || (temp += this.colWidthLom[i]) < this.widthLom) continue;
                this.colWidthLom[i] = this.colWidthLom[i] + this.widthLom - temp;
                for (int j = i + 1; j < this.getColumnCount(); ++j) {
                    this.colWidthLom[j] = 0;
                }
                break;
            }
            int value = temp < this.widthLom ? this.widthLom - temp : 0;
            for (int i = 0; i < this.getColumnCount(); ++i) {
                if (!this.colSelfAdapt[i]) continue;
                this.colWidthLom[i] = value / colAdaptCount;
            }
        }
    }

    public void setRowHeight(int row, int rowheightLom) {
        if (row < 0 || row > this.rowHeightLom.length) {
            throw new IllegalArgumentException();
        }
        this.rowHeightLom[row] = rowheightLom;
        this.rowSelfAdapt[row] = rowheightLom == -1;
        this.calcRowHeights();
        this.refreshGridPos();
        this.firePropertyChange(null);
    }

    private void calcRowHeights() {
        block7: {
            int rowAdaptCount;
            block8: {
                block6: {
                    if (!this.isSamedHeight) break block6;
                    int remainHeight = this.heightLom;
                    int remainRow = this.getRowCount();
                    for (int i = 0; i < this.getRowCount(); ++i) {
                        int currentRowHeight = remainHeight / remainRow;
                        --remainRow;
                        remainHeight -= currentRowHeight;
                        this.rowHeightLom[i] = currentRowHeight;
                    }
                    break block7;
                }
                rowAdaptCount = this.getAdaptRowColCount(true);
                if (rowAdaptCount != 0) break block8;
                int temp = 0;
                for (int i = 0; i < this.getRowCount(); ++i) {
                    if ((temp += this.rowHeightLom[i]) < this.heightLom) continue;
                    int n = i;
                    this.rowHeightLom[n] = this.rowHeightLom[n] + (this.heightLom - temp);
                    for (int j = i + 1; j < this.getRowCount(); ++j) {
                        this.rowHeightLom[j] = 0;
                    }
                    break;
                }
                if (temp >= this.heightLom) break block7;
                int n = this.getRowCount() - 1;
                this.rowHeightLom[n] = this.rowHeightLom[n] + (this.heightLom - temp);
                break block7;
            }
            int temp = 0;
            for (int i = 0; i < this.getRowCount(); ++i) {
                if (this.rowSelfAdapt[i] || (temp += this.rowHeightLom[i]) < this.heightLom) continue;
                this.rowHeightLom[i] = this.rowHeightLom[i] + this.heightLom - temp;
                for (int j = i + 1; j < this.getRowCount(); ++j) {
                    this.rowHeightLom[j] = 0;
                }
                break;
            }
            int value = temp < this.heightLom ? this.heightLom - temp : 0;
            for (int i = 0; i < this.getRowCount(); ++i) {
                if (!this.rowSelfAdapt[i]) continue;
                this.rowHeightLom[i] = value / rowAdaptCount;
            }
        }
    }

    private int getAdaptRowColCount(boolean isRow) {
        int ret = 0;
        if (isRow) {
            for (int i = 0; i < this.getRowCount(); ++i) {
                if (!this.rowSelfAdapt[i]) continue;
                ++ret;
            }
        } else {
            for (int i = 0; i < this.getColumnCount(); ++i) {
                if (!this.colSelfAdapt[i]) continue;
                ++ret;
            }
        }
        return ret;
    }

    public Point getNearCrossPoint(int xpos, int ypos, int hScrollValue, int vScrollValue) {
        int i;
        Rectangle rect = new Rectangle(this.getZoomedDim(this.position.x), this.getZoomedDim(this.position.y), this.getZoomedDim(this.width), this.getZoomedDim(this.height));
        Point off = this.getCorrespondTopPos();
        rect.translate(off.x + 10 - hScrollValue, off.y + 10 - vScrollValue);
        int minoff = Math.abs(rect.x - xpos);
        int x = rect.x;
        int y = rect.y;
        int nextpos = rect.x;
        for (i = 0; i < this.colWidthLom.length; ++i) {
            if (Math.abs((nextpos += this.getZoomedDim((int)StyleUtil.lomToPixel((long)this.colWidthLom[i]))) - xpos) < minoff) {
                minoff = Math.abs(nextpos - xpos);
                x = nextpos;
            }
            if (nextpos > rect.x + rect.width) break;
        }
        nextpos = rect.y;
        minoff = Math.abs(rect.y - ypos);
        for (i = 0; i < this.rowHeightLom.length; ++i) {
            if (Math.abs((nextpos += this.getZoomedDim((int)StyleUtil.lomToPixel((long)this.rowHeightLom[i]))) - ypos) < minoff) {
                minoff = Math.abs(nextpos - ypos);
                y = nextpos;
            }
            if (nextpos > rect.y + rect.height) break;
        }
        return new Point(x, y);
    }

    public Point getStartColRowPoint(int xpos, int ypos) {
        Point off = this.getCorrespondTopPos();
        off.translate(this.position.x, this.position.y);
        int i = 0;
        for (i = 0; i < this.colPos.length && this.colPos[i] + off.x <= xpos; ++i) {
        }
        int j = 0;
        for (j = 0; j < this.rowHeightLom.length && this.rowPos[j] + off.y <= ypos; ++j) {
        }
        return new Point(i - 1, j - 1);
    }

    public Point getNearColRowCross(int xpos, int ypos) {
        Point off = this.getCorrespondTopPos();
        off.translate(this.position.x, this.position.y);
        int x = 0;
        int temp = Math.abs(xpos - off.x);
        for (int i = 0; i < this.colPos.length; ++i) {
            if (temp <= Math.abs(xpos - off.x - this.colPos[i])) continue;
            x = i;
            temp = Math.abs(xpos - off.x - this.colPos[i]);
        }
        int y = 0;
        temp = Math.abs(ypos - off.y);
        for (int j = 0; j < this.rowPos.length; ++j) {
            if (temp <= Math.abs(ypos - off.y - this.rowPos[j])) continue;
            y = j;
            temp = Math.abs(ypos - off.y - this.rowPos[j]);
        }
        return new Point(x, y);
    }

    public Point getNearColRowCell(int xpos, int ypos) {
        Point off = this.getCorrespondTopPos();
        off.translate(this.position.x, this.position.y);
        int x = 0;
        if (xpos >= this.colPos[this.colPos.length - 1] + off.x) {
            x = this.colPos.length - 2;
        } else {
            int i = 0;
            while (i < this.colPos.length - 1 && xpos >= this.colPos[i] + off.x) {
                x = i++;
            }
        }
        int y = 0;
        if (ypos >= this.rowPos[this.rowPos.length - 1] + off.y) {
            y = this.rowPos.length - 2;
        } else {
            int i = 0;
            while (i < this.rowPos.length - 1 && ypos >= this.rowPos[i] + off.y) {
                y = i++;
            }
        }
        return new Point(x, y);
    }

    public Point getPointbyColRow(int colNo, int rowNo) {
        if (colNo < 0) {
            colNo = 0;
        }
        if (colNo >= this.colPos.length) {
            colNo = this.colPos.length - 1;
        }
        if (rowNo < 0) {
            rowNo = 0;
        }
        if (rowNo >= this.rowPos.length) {
            rowNo = this.rowPos.length - 1;
        }
        Point retPt = new Point(this.colPos[colNo], this.rowPos[rowNo]);
        retPt.translate(this.position.x, this.position.y);
        Point off = this.getCorrespondTopPos();
        retPt.translate(off.x, off.y);
        return retPt;
    }

    public Point getPointInTableByColRow(int colNo, int rowNo) {
        if (colNo < 0) {
            colNo = 0;
        }
        if (colNo >= this.colPos.length) {
            colNo = this.colPos.length - 1;
        }
        if (rowNo < 0) {
            rowNo = 0;
        }
        if (rowNo >= this.rowPos.length) {
            rowNo = this.rowPos.length - 1;
        }
        Point retPt = new Point(this.colPos[colNo], this.rowPos[rowNo]);
        return retPt;
    }

    @Override
    public void setHeight(int value) {
        super.setHeight(value);
        this.calcRowHeights();
        this.refreshGridPos();
    }

    @Override
    public void setWidth(int value) {
        super.setWidth(value);
        this.calcColWidths();
        this.refreshGridPos();
    }

    @Override
    public void setHeightLom(int value) {
        super.setHeightLom(value);
        this.height = (int)StyleUtil.lomToPixel((long)value);
        this.calcRowHeights();
        this.refreshGridPos();
    }

    @Override
    public void setWidthLom(int value) {
        super.setWidthLom(value);
        this.width = (int)StyleUtil.lomToPixel((long)value);
        this.calcColWidths();
        this.refreshGridPos();
    }

    public boolean isSamedWidth() {
        return this.isSamedWidth;
    }

    public void setSamedWidth(boolean isSamedWidth) {
        if (this.isSamedWidth != isSamedWidth) {
            this.isSamedWidth = isSamedWidth;
            this.setWidthLom(this.getWidthLom());
            for (int i = 0; i < this.colSelfAdapt.length; ++i) {
                this.colSelfAdapt[i] = false;
            }
            this.firePropertyChange(null);
        }
    }

    public boolean isSamedHeight() {
        return this.isSamedHeight;
    }

    public void initSameHeight(boolean isSamedHeight) {
        this.isSamedHeight = isSamedHeight;
    }

    public void initSameWidth(boolean isSameWidth) {
        this.isSamedWidth = isSameWidth;
    }

    public void setSamedHeight(boolean isSamedHeight) {
        if (this.isSamedHeight != isSamedHeight) {
            this.isSamedHeight = isSamedHeight;
            this.setHeightLom(this.getHeightLom());
            for (int i = 0; i < this.rowSelfAdapt.length; ++i) {
                this.rowSelfAdapt[i] = false;
            }
            this.firePropertyChange(null);
        }
    }

    public int getTableCursorFlag(int x, int y) {
        int i;
        x -= this.getCorrespondTopPos().x;
        x -= this.position.x;
        y -= this.getCorrespondTopPos().y;
        y -= this.position.y;
        for (i = 1; i < this.colPos.length - 1; ++i) {
            if (x <= this.colPos[i] - 3 || x >= this.colPos[i] + 3) continue;
            return 1;
        }
        for (i = 1; i < this.rowPos.length - 1; ++i) {
            if (y <= this.rowPos[i] - 3 || y >= this.rowPos[i] + 3) continue;
            return 2;
        }
        return 0;
    }

    public int getDragColRowNo(int x, int y, boolean origin) {
        x -= this.getCorrespondTopPos().x;
        x -= this.position.x;
        y -= this.getCorrespondTopPos().y;
        y -= this.position.y;
        if (origin) {
            int i;
            for (i = 1; i < this.colPos.length - 1; ++i) {
                if (x <= this.colPos[i] - 3 || x >= this.colPos[i] + 3) continue;
                return i;
            }
            for (i = 1; i < this.rowPos.length - 1; ++i) {
                if (y <= this.rowPos[i] - 3 || y >= this.rowPos[i] + 3) continue;
                return i;
            }
        } else {
            int i;
            for (i = this.colPos.length - 2; i >= 1; --i) {
                if (x <= this.colPos[i] - 3 || x >= this.colPos[i] + 3) continue;
                return i;
            }
            for (i = this.rowPos.length - 1; i >= 1; --i) {
                if (y <= this.rowPos[i] - 3 || y >= this.rowPos[i] + 3) continue;
                return i;
            }
        }
        return -1;
    }

    public MaxMinPair getTableLineRange(boolean bCol, int lineNo) {
        int max = 0;
        int min = 0;
        if (bCol) {
            min = this.colPos[lineNo - 1];
            max = this.colPos[lineNo + 1];
            min += this.getCorrespondTopPos().x;
            min += this.position.x;
            max += this.getCorrespondTopPos().x;
            max += this.position.x;
        } else {
            min = this.rowPos[lineNo - 1];
            max = this.rowPos[lineNo + 1];
            min += this.getCorrespondTopPos().y;
            min += this.position.y;
            max += this.getCorrespondTopPos().y;
            max += this.position.y;
        }
        return new MaxMinPair(min, max);
    }

    public void adjustColRow(boolean bCol, int colrowNo, int value) {
        if (bCol) {
            int n = colrowNo - 1;
            this.colWidthLom[n] = (int)((long)this.colWidthLom[n] + StyleUtil.pixelToLom((long)value));
            int n2 = colrowNo;
            this.colWidthLom[n2] = (int)((long)this.colWidthLom[n2] - StyleUtil.pixelToLom((long)value));
            this.colSelfAdapt[colrowNo - 1] = false;
            this.colSelfAdapt[colrowNo] = false;
        } else {
            int n = colrowNo - 1;
            this.rowHeightLom[n] = (int)((long)this.rowHeightLom[n] + StyleUtil.pixelToLom((long)value));
            int n3 = colrowNo;
            this.rowHeightLom[n3] = (int)((long)this.rowHeightLom[n3] - StyleUtil.pixelToLom((long)value));
            this.rowSelfAdapt[colrowNo - 1] = false;
            this.rowSelfAdapt[colrowNo] = false;
        }
        this.refreshGridPos();
    }

    public Rectangle getRangle(int col1, int row1, int col2, int row2) {
        Rectangle rcRet = null;
        rcRet = new Rectangle(this.colPos[col1], this.rowPos[row1], this.colPos[col2] - this.colPos[col1], this.rowPos[row2] - this.rowPos[row1]);
        rcRet.translate(this.position.x, this.position.y);
        Point off = this.getCorrespondTopPos();
        rcRet.translate(off.x, off.y);
        return rcRet;
    }

    @Override
    public ReportElement cloneMe() {
        int i;
        Table newReportElement = new Table(this.name, 0, 0, this.width, this.height, this.getRowCount(), this.getColumnCount());
        newReportElement.dataSource = this.dataSource;
        newReportElement.field = this.field;
        newReportElement.isSamedHeight = this.isSamedHeight();
        newReportElement.isSamedWidth = this.isSamedWidth();
        for (i = 0; i < this.getRowCount(); ++i) {
            newReportElement.rowHeightLom[i] = this.rowHeightLom[i];
            newReportElement.rowPos[i + 1] = this.rowPos[i + 1];
            newReportElement.rowSelfAdapt[i] = this.rowSelfAdapt[i];
        }
        for (i = 0; i < this.getColumnCount(); ++i) {
            newReportElement.colWidthLom[i] = this.colWidthLom[i];
            newReportElement.colPos[i + 1] = this.colPos[i + 1];
            newReportElement.colSelfAdapt[i] = this.colSelfAdapt[i];
        }
        this.copyBaseReportElement(newReportElement, this);
        return newReportElement;
    }

    public int[] getRowHeightLoms() {
        int[] tempRowsHeights = new int[this.getRowCount()];
        for (int i = 0; i < this.getRowCount(); ++i) {
            tempRowsHeights[i] = this.rowSelfAdapt[i] ? -1 : this.rowHeightLom[i];
        }
        return tempRowsHeights;
    }

    public int[] getColWidthLoms() {
        int[] tempColWidth = new int[this.getColumnCount()];
        for (int i = 0; i < this.getColumnCount(); ++i) {
            tempColWidth[i] = this.colSelfAdapt[i] ? -1 : this.colWidthLom[i];
        }
        return tempColWidth;
    }

    public Point getEmptyGrid(boolean isHorizotalSearch) {
        return this.getEmptyGrid(isHorizotalSearch, 1, 1);
    }

    private Point getEmptyGrid(boolean isHorizotalSearch, int col, int row) {
        int j;
        int i;
        if (row < 1) {
            row = 1;
        }
        if (col < 1) {
            col = 1;
        }
        if (this.getChildren().size() == 0) {
            return new Point(col, row);
        }
        boolean[][] mark = new boolean[this.getRowCount()][this.getColumnCount()];
        for (ReportElement re : this.getChildren()) {
            TableLocation tl = re.getTableLocation();
            for (i = tl.getStartRow(); i < tl.getEndRow(); ++i) {
                for (j = tl.getStartCol(); j < tl.getEndCol(); ++j) {
                    mark[i][j] = true;
                }
            }
        }
        if (isHorizotalSearch) {
            for (i = row; i <= this.getRowCount(); ++i) {
                for (j = col; j <= this.getColumnCount(); ++j) {
                    if (mark[i - 1][j - 1]) continue;
                    return new Point(j, i);
                }
            }
            return null;
        }
        for (int j2 = col; j2 <= this.getColumnCount(); ++j2) {
            for (int i2 = row; i2 <= this.getRowCount(); ++i2) {
                if (mark[i2 - 1][j2 - 1]) continue;
                return new Point(j2, i2);
            }
        }
        return null;
    }

    public int getNearestTableLineLocation(int value, boolean isCol) {
        int adjustValue;
        int min = -1;
        int nearestValue = -1;
        if (isCol) {
            int temp;
            adjustValue = this.getCorrespondTopPos().x + this.position.x;
            value -= adjustValue;
            for (int i = 1; i < this.colPos.length - 1 && ((temp = Math.abs(value - this.colPos[i])) < min || min == -1); ++i) {
                min = temp;
                nearestValue = this.colPos[i];
            }
        } else {
            int temp;
            adjustValue = this.getCorrespondTopPos().y + this.position.y;
            value -= adjustValue;
            for (int i = 1; i < this.rowPos.length - 1 && ((temp = Math.abs(value - this.rowPos[i])) < min || min == -1); ++i) {
                min = temp;
                nearestValue = this.rowPos[i];
            }
        }
        if (nearestValue != -1) {
            nearestValue += adjustValue;
        }
        return nearestValue;
    }
}

