/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.freechart.chart.labels;

import com.kingdee.bos.ctrl.freechart.chart.labels.CategoryItemLabelGenerator;
import com.kingdee.bos.ctrl.freechart.chart.labels.StandardCategoryItemLabelGenerator;
import com.kingdee.bos.ctrl.freechart.data.category.CategoryDataset;
import com.kingdee.bos.ctrl.freechart.data.category.IntervalCategoryDataset;
import com.kingdee.bos.ctrl.freechart.util.PublicCloneable;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.NumberFormat;

public class IntervalCategoryItemLabelGenerator
extends StandardCategoryItemLabelGenerator
implements CategoryItemLabelGenerator,
PublicCloneable,
Cloneable,
Serializable {
    private static final long serialVersionUID = 5056909225610630529L;
    public static final String DEFAULT_LABEL_FORMAT_STRING = "({0}, {1}) = {3} - {4}";

    public IntervalCategoryItemLabelGenerator() {
        super(DEFAULT_LABEL_FORMAT_STRING, NumberFormat.getInstance());
    }

    public IntervalCategoryItemLabelGenerator(String labelFormat, NumberFormat formatter) {
        super(labelFormat, formatter);
    }

    public IntervalCategoryItemLabelGenerator(String labelFormat, DateFormat formatter) {
        super(labelFormat, formatter);
    }

    @Override
    protected Object[] createItemArray(CategoryDataset dataset, int row, int column) {
        Object[] result = new Object[5];
        result[0] = dataset.getRowKey(row).toString();
        result[1] = dataset.getColumnKey(column).toString();
        Number value = dataset.getValue(row, column);
        if (value != null) {
            if (this.getNumberFormat() != null) {
                result[2] = this.getNumberFormat().format(value);
            } else if (this.getDateFormat() != null) {
                result[2] = this.getDateFormat().format(value);
            }
        } else {
            result[2] = this.getNullValueString();
        }
        if (dataset instanceof IntervalCategoryDataset) {
            IntervalCategoryDataset icd = (IntervalCategoryDataset)dataset;
            Number start = icd.getStartValue(row, column);
            Number end = icd.getEndValue(row, column);
            if (this.getNumberFormat() != null) {
                result[3] = this.getNumberFormat().format(start);
                result[4] = this.getNumberFormat().format(end);
            } else if (this.getDateFormat() != null) {
                result[3] = this.getDateFormat().format(start);
                result[4] = this.getDateFormat().format(end);
            }
        }
        return result;
    }
}

