/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.freechart.chart.plot;

import com.kingdee.bos.ctrl.freechart.chart.JFreeChart;
import com.kingdee.bos.ctrl.freechart.chart.event.PlotChangeEvent;
import com.kingdee.bos.ctrl.freechart.chart.plot.Plot;
import com.kingdee.bos.ctrl.freechart.chart.plot.PlotRenderingInfo;
import com.kingdee.bos.ctrl.freechart.chart.plot.PlotState;
import com.kingdee.bos.ctrl.freechart.data.TreeDatasetNode;
import com.kingdee.bos.ctrl.freechart.data.general.DefaultTreeDataset;
import com.kingdee.bos.ctrl.freechart.ui.RectangleInsets;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.Hashtable;

public class TreePlot
extends Plot
implements Cloneable,
Serializable {
    public static final int HORIZONTAL_TEXT_ORDER = 0;
    public static final int VERTICAL_TEXT_ORDER = 1;
    public static final RectangleInsets DEFAULT_MARGIN = new RectangleInsets(10.0, 10.0, 10.0, 1.0);
    private static final double VERTICAL_GAP = 20.0;
    private static final double HORIZONTAL_GAP = 5.0;
    private DefaultTreeDataset dataset;
    private Hashtable subtreeWidths;
    private Hashtable originalSubtreeWidth;
    private Hashtable nodeBoundss;
    private double GapH;
    private double GapV;
    private double scaleH;
    private double scaleV;
    private Font font;
    private Color textColor;
    private Color nodeBackground;
    private Color nodeBorder;
    private int textOrder;
    private RectangleInsets margin;

    public TreePlot(DefaultTreeDataset dataset) {
        this.dataset = dataset;
        if (this.dataset != null) {
            this.dataset.addChangeListener(this);
            this.initialize();
        }
    }

    private void initialize() {
        this.GapH = 5.0;
        this.GapV = 20.0;
        this.subtreeWidths = new Hashtable();
        this.originalSubtreeWidth = new Hashtable();
        this.nodeBoundss = new Hashtable();
        this.font = new Font("Dialog", 1, 16);
        this.textColor = Color.decode("#468A9E");
        this.nodeBackground = Color.decode("#FCECAA");
        this.nodeBorder = Color.decode("#C9898D");
        this.scaleH = 1.0;
        this.scaleV = 1.0;
        this.margin = DEFAULT_MARGIN;
    }

    public void setMargin(RectangleInsets m) {
        if (m == null) {
            throw new IllegalArgumentException("null not allowed!");
        }
        this.margin = m;
    }

    public RectangleInsets getMargin() {
        return this.margin;
    }

    public void setTextOrder(int order) {
        if (order != 0 && order != 1) {
            throw new IllegalArgumentException("order must be one of TreePlot.HORIZONTAL_TEXT_ORDER or TreePlot.VERTICAL_TEXT_ORDER");
        }
        this.textOrder = order;
    }

    public int getTextOrder() {
        return this.textOrder;
    }

    public double getVerticalGapForNodes() {
        return this.GapV;
    }

    public double getHorizontalGapForNodes() {
        return this.GapH;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("null not allowed!");
        }
        this.font = font;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public void setTextColor(Color textColor) {
        this.textColor = textColor;
    }

    public Color getNodeBackground() {
        return this.nodeBackground;
    }

    public void setNodeBackground(Color nodeBackground) {
        this.nodeBackground = nodeBackground;
    }

    public Color getNodeBorder() {
        return this.nodeBorder;
    }

    public void setNodeBorder(Color nodeBorder) {
        this.nodeBorder = nodeBorder;
    }

    @Override
    public void draw(Graphics2D g2, Rectangle2D plotArea, Point2D anchor, PlotState parentState, PlotRenderingInfo info) {
        RectangleInsets insets = this.getInsets();
        insets.trim(plotArea);
        if (insets != null) {
            plotArea.setRect(plotArea.getX() + insets.getLeft(), plotArea.getY() + insets.getTop(), plotArea.getWidth() - insets.getLeft() - insets.getRight(), plotArea.getHeight() - insets.getTop() - insets.getBottom());
        }
        this.drawBackground(g2, plotArea);
        this.drawOutline(g2, plotArea);
        Shape savedClip = g2.getClip();
        g2.clip(plotArea);
        Composite originalComposite = g2.getComposite();
        g2.setComposite(AlphaComposite.getInstance(3, this.getForegroundAlpha()));
        if (this.dataset != null) {
            TreeDatasetNode root = (TreeDatasetNode)this.dataset.getRoot();
            Font originalFont = g2.getFont();
            Paint originalPaint = g2.getPaint();
            JFreeChart.adjustForChineseDrawableFont(g2, this.font);
            double preferredWidth = this.calcSubtreeWidth(root, g2);
            double preferredHeight = this.getPreferredMaxNodeHeight(g2) * (double)(root.getDepth() + 1) + 20.0 * (double)root.getDepth();
            this.scaleH = (plotArea.getWidth() - this.margin.getLeft() - this.margin.getRight()) / preferredWidth;
            this.scaleV = (plotArea.getHeight() - this.margin.getTop() - this.margin.getBottom()) / preferredHeight;
            this.GapH = 5.0 * this.scaleH;
            this.GapV = 20.0 * this.scaleV;
            this.positionNodes(root, plotArea.getCenterX() + this.margin.getLeft() - this.margin.getRight(), plotArea.getY() + this.margin.getTop(), g2);
            FontRenderContext frc = g2.getFontRenderContext();
            double size = this.font.getStringBounds("\u5b57", frc).getWidth();
            JFreeChart.adjustForChineseDrawableFont(g2, this.font.deriveFont((float)(size * Math.min(this.scaleH, this.scaleV))));
            this.drawSubTree(root, g2);
            JFreeChart.adjustForChineseDrawableFont(g2, originalFont);
            g2.setPaint(originalPaint);
        } else {
            this.drawNoDataMessage(g2, plotArea);
        }
        g2.setClip(savedClip);
        g2.setComposite(originalComposite);
        this.drawOutline(g2, plotArea);
    }

    private void drawSubTree(TreeDatasetNode node, Graphics2D g2) {
        int nn;
        Rectangle2D nodeBound2D = (Rectangle2D)this.nodeBoundss.get(node);
        Rectangle nodeBound = nodeBound2D.getBounds();
        g2.setPaint(this.nodeBackground);
        g2.fillRoundRect(nodeBound.x, nodeBound.y, nodeBound.width, nodeBound.height, 8, 8);
        g2.setPaint(this.nodeBorder);
        g2.drawRoundRect(nodeBound.x, nodeBound.y, nodeBound.width, nodeBound.height, 8, 8);
        if (node.getParent() != null && node.getParent().getChildCount() > 1) {
            g2.drawLine(nodeBound.x + nodeBound.width / 2, nodeBound.y, nodeBound.x + nodeBound.width / 2, (int)((double)nodeBound.y - this.GapV / 2.0 + 1.0));
        }
        if ((nn = node.getChildCount()) > 0) {
            if (nn > 1) {
                g2.drawLine(nodeBound.x + nodeBound.width / 2, nodeBound.y + nodeBound.height, nodeBound.x + nodeBound.width / 2, (int)((double)(nodeBound.y + nodeBound.height) + this.GapV / 2.0));
                TreeDatasetNode leftNode = (TreeDatasetNode)node.getChildAt(0);
                TreeDatasetNode rightNode = (TreeDatasetNode)node.getChildAt(nn - 1);
                Rectangle lbound = ((Rectangle2D)this.nodeBoundss.get(leftNode)).getBounds();
                Rectangle rbound = ((Rectangle2D)this.nodeBoundss.get(rightNode)).getBounds();
                g2.drawLine(lbound.x + lbound.width / 2, (int)((double)(nodeBound.y + nodeBound.height) + this.GapV / 2.0), rbound.x + rbound.width / 2, (int)((double)(nodeBound.y + nodeBound.height) + this.GapV / 2.0));
            } else {
                g2.drawLine(nodeBound.x + nodeBound.width / 2, nodeBound.y + nodeBound.height, nodeBound.x + nodeBound.width / 2, (int)((double)(nodeBound.y + nodeBound.height) + this.GapV));
            }
        }
        g2.setPaint(this.textColor);
        if (this.getTextOrder() == 1) {
            Object[] data = node.getData();
            int n = data.length;
            int perHeight = nodeBound.height / n;
            for (int i = 0; i < n; ++i) {
                String text = data[i].toString();
                int stringWidth = g2.getFontMetrics().stringWidth(text);
                Rectangle2D.Double fontBound = new Rectangle2D.Double(nodeBound.x, nodeBound.y + i * perHeight + 8, nodeBound2D.getWidth(), perHeight);
                g2.drawString(text, (int)(fontBound.getCenterX() - (double)(stringWidth / 2)), (int)fontBound.getCenterY());
            }
        } else {
            g2.drawString(node.toString(), nodeBound.x, (int)(nodeBound2D.getCenterY() + 4.0));
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            this.drawSubTree((TreeDatasetNode)node.getChildAt(i), g2);
        }
    }

    private void positionNodes(TreeDatasetNode node, double center, double top, Graphics2D g2) {
        Rectangle2D nodeBounds = (Rectangle2D)this.nodeBoundss.get(node);
        double nx = nodeBounds.getX();
        double ny = nodeBounds.getY();
        double nw = nodeBounds.getWidth();
        double nh = nodeBounds.getHeight();
        nx = center - (nw *= this.scaleH) / 2.0;
        ny = top;
        nodeBounds.setRect(nx, ny, nw, nh *= this.scaleV);
        double subtreeWidth = (Double)this.subtreeWidths.get(node) * this.scaleH;
        double originalSubtreeWidth = (Double)this.originalSubtreeWidth.get(node) * this.scaleH;
        double scale = subtreeWidth / originalSubtreeWidth;
        double x = center - subtreeWidth / 2.0;
        for (int i = 0; i < node.getChildCount(); ++i) {
            TreeDatasetNode child = (TreeDatasetNode)node.getChildAt(i);
            double childSubtreeWidth = (Double)this.subtreeWidths.get(child) * scale * this.scaleH;
            this.positionNodes(child, x + childSubtreeWidth / 2.0, top + ((Rectangle2D)this.nodeBoundss.get(child)).getHeight() * this.scaleV + this.GapV, g2);
            x += childSubtreeWidth + this.GapH;
        }
    }

    public double calcSubtreeWidth(TreeDatasetNode node, Graphics2D g2) {
        double width = 0.0;
        double treeWidth = 0.0;
        int n = node.getChildCount();
        for (int i = 0; i < n; ++i) {
            width += this.calcSubtreeWidth((TreeDatasetNode)node.getChildAt(i), g2);
            width += (double)(n - 1) * 5.0;
        }
        Rectangle2D nodeBounds = this.getPreferredNodeSize(node, g2);
        treeWidth = Math.max(width, nodeBounds.getWidth());
        if (width == 0.0) {
            width = nodeBounds.getWidth();
        }
        this.nodeBoundss.put(node, nodeBounds);
        this.subtreeWidths.put(node, new Double(treeWidth));
        this.originalSubtreeWidth.put(node, new Double(width));
        return treeWidth;
    }

    protected Rectangle2D getPreferredNodeSize(TreeDatasetNode node, Graphics2D g2) {
        String text = node.toString();
        FontRenderContext frc = g2.getFontRenderContext();
        Rectangle2D bounds = this.getFont().getStringBounds(text, frc);
        double width = bounds.getWidth();
        double height = bounds.getHeight();
        if (this.getTextOrder() == 1) {
            Object[] data = node.getData();
            for (int i = 0; i < data.length; ++i) {
                String s = data[i].toString();
                if (s.length() <= text.length()) continue;
                text = s;
            }
            width = this.getFont().getStringBounds(text, frc).getWidth();
            height = this.getPreferredMaxNodeHeight(g2);
        }
        bounds.setRect(bounds.getX(), bounds.getY(), width, height);
        return bounds;
    }

    protected double getPreferredMaxNodeHeight(Graphics2D g2) {
        double maxNodeHeight = g2.getFontMetrics().getHeight();
        if (this.getTextOrder() == 0) {
            return maxNodeHeight;
        }
        return maxNodeHeight * (double)this.dataset.getMaxDataLength();
    }

    @Override
    public String getPlotType() {
        return "Tree Plot";
    }
}

