/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.freechart.data.category;

import com.kingdee.bos.ctrl.freechart.data.category.CategoryDataset;
import com.kingdee.bos.ctrl.freechart.data.general.AbstractDataset;
import com.kingdee.bos.ctrl.freechart.data.general.DatasetChangeEvent;
import com.kingdee.bos.ctrl.freechart.data.general.DatasetChangeListener;
import com.kingdee.bos.ctrl.freechart.util.TableOrder;
import java.util.ArrayList;
import java.util.List;

public class SubCategoryDataset
extends AbstractDataset
implements CategoryDataset,
DatasetChangeListener {
    private static final long serialVersionUID = -7531718336328287533L;
    private CategoryDataset source;
    private TableOrder extract;
    private int from;
    private int end;

    public SubCategoryDataset(CategoryDataset source, TableOrder extract, int from, int end) {
        if (extract == null) {
            throw new IllegalArgumentException("Null 'extract' argument.");
        }
        this.source = source;
        if (this.source != null) {
            this.source.addChangeListener(this);
        }
        this.extract = extract;
        this.from = from;
        this.end = end;
    }

    public CategoryDataset getUnderlyingDataset() {
        return this.source;
    }

    public TableOrder getExtractType() {
        return this.extract;
    }

    public int getFrom() {
        return this.from;
    }

    public int getEnd() {
        return this.end;
    }

    @Override
    public void datasetChanged(DatasetChangeEvent event) {
        this.fireDatasetChanged();
    }

    @Override
    public int getColumnIndex(Comparable key) {
        if (this.extract.equals(TableOrder.BY_ROW)) {
            return this.source.getColumnIndex(key);
        }
        return this.source.getColumnIndex(key) - this.from;
    }

    @Override
    public Comparable getColumnKey(int column) {
        if (this.extract.equals(TableOrder.BY_ROW)) {
            return this.source.getColumnKey(column);
        }
        return this.source.getColumnKey(column + this.from);
    }

    @Override
    public List getColumnKeys() {
        if (this.extract.equals(TableOrder.BY_ROW)) {
            return this.source.getColumnKeys();
        }
        ArrayList<Comparable> list = new ArrayList<Comparable>();
        for (int i = this.from; i < this.end; ++i) {
            list.add(this.source.getColumnKey(i));
        }
        return list;
    }

    @Override
    public int getRowIndex(Comparable key) {
        if (this.extract.equals(TableOrder.BY_ROW)) {
            return this.source.getRowIndex(key) - this.from;
        }
        return this.source.getRowIndex(key);
    }

    @Override
    public Comparable getRowKey(int row) {
        if (this.extract.equals(TableOrder.BY_ROW)) {
            return this.source.getRowKey(row + this.from);
        }
        return this.source.getRowKey(row);
    }

    @Override
    public List getRowKeys() {
        if (this.extract.equals(TableOrder.BY_COLUMN)) {
            return this.source.getRowKeys();
        }
        ArrayList<Comparable> list = new ArrayList<Comparable>();
        for (int i = this.from; i < this.end; ++i) {
            list.add(this.source.getRowKey(i));
        }
        return list;
    }

    @Override
    public Number getValue(Comparable rowKey, Comparable columnKey) {
        return this.source.getValue(rowKey, columnKey);
    }

    @Override
    public int getColumnCount() {
        if (this.extract.equals(TableOrder.BY_ROW)) {
            return this.source.getColumnCount();
        }
        return this.end - this.from;
    }

    @Override
    public int getRowCount() {
        if (this.extract.equals(TableOrder.BY_COLUMN)) {
            return this.source.getRowCount();
        }
        return this.end - this.from;
    }

    @Override
    public Number getValue(int row, int column) {
        if (this.extract.equals(TableOrder.BY_COLUMN)) {
            column += this.from;
        } else {
            row += this.from;
        }
        return this.source.getValue(row, column);
    }
}

