/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.data.datasource;

import com.kingdee.bos.ctrl.kdf.data.datasource.BOSQueryDataSource;
import com.kingdee.bos.ctrl.kdf.data.datasource.DSParam;
import com.kingdee.bos.ctrl.kdf.data.datasource.EntityDataSource;
import com.kingdee.bos.ctrl.kdf.data.datasource.JDBCDataSource;
import com.kingdee.bos.ctrl.kdf.data.datasource.ObjectDataSource;
import com.kingdee.bos.ctrl.kdf.data.datasource.ReferencedDataSource;
import com.kingdee.bos.ctrl.kdf.util.file.KDF;
import com.kingdee.bos.ctrl.kdf.util.file.KDFXmlWriter;
import com.kingdee.bos.ctrl.reportone.r1.print.data.R1PrintDataSortItem;
import java.util.ArrayList;
import java.util.List;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.Namespace;

public abstract class DataSource {
    private String ID;
    private ArrayList params;
    private Object userObject;
    private String uri;
    protected List _sorts = new ArrayList();

    public DataSource() {
        this.ID = "";
        this.params = new ArrayList();
    }

    public DataSource(String id) {
        this.ID = id;
        this.params = new ArrayList();
    }

    public String getID() {
        return this.ID;
    }

    public void setID(String strID) {
        this.ID = strID;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public void setUserObject(Object userObject) {
        this.userObject = userObject;
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public ArrayList getParams() {
        return this.params;
    }

    public void setParams(ArrayList list) {
        this.params = list;
    }

    public void addParam(DSParam param) {
        this.params.add(param);
    }

    public abstract String getSource();

    public abstract void setSource(String var1);

    public abstract boolean isLinked();

    public Element createDSNode() {
        Element ds = new Element("DataSource");
        ds.setNamespace(KDFXmlWriter.NS_COMMON);
        return ds;
    }

    public abstract Object readFromNode(Element var1);

    public abstract Element writeToNode();

    public static DataSource buildFromNode(Element dsNode, KDF kdf) {
        DataSource ds;
        Element cNode = (Element)dsNode.getChildren().get(0);
        if ("Reference".equals(cNode.getName().trim())) {
            ds = new ReferencedDataSource(kdf);
        } else if ("ObjectDataSource".equals(cNode.getName().trim())) {
            ds = new ObjectDataSource();
        } else if ("DBConnectionDataSource".equals(cNode.getName().trim())) {
            ds = new JDBCDataSource();
        } else if ("EntityDataSource".equals(cNode.getName().trim())) {
            ds = new EntityDataSource();
        } else if ("BosQueryDataSource".equals(cNode.getName().trim())) {
            ds = new BOSQueryDataSource();
        } else {
            throw new RuntimeException("Not a valid dataSource node type");
        }
        ((DataSource)ds).readFromNode(dsNode);
        return ds;
    }

    protected Element buildParamsNode(Namespace ns) {
        Element nodeParams = new Element("Params", ns);
        for (int i = 0; i < this.params.size(); ++i) {
            DSParam param = (DSParam)this.getParams().get(i);
            Element node = new Element("Param", ns);
            node.setAttribute("dataType", param.getDataType());
            node.setAttribute("source", param.getFrom());
            Element nodeName = new Element("ColName", ns);
            nodeName.setText(param.getColName());
            node.addContent((Content)nodeName);
            Element nodeParent = new Element("Associate", ns);
            nodeParent.setAttribute("dataSourceID", param.getAssociateSource());
            nodeParent.setText(param.getAssociateField());
            if ("value".equalsIgnoreCase(param.getFrom())) {
                nodeParent.setText(param.getValue().toString());
            }
            node.addContent((Content)nodeParent);
            nodeParams.addContent((Content)node);
        }
        return nodeParams;
    }

    protected ArrayList resolveParamsNode(Element node) {
        Namespace ns = node.getNamespace();
        ArrayList<DSParam> list = new ArrayList<DSParam>();
        Element nodeParam = node.getChild("Params", ns);
        List allNodes = nodeParam.getChildren();
        for (int i = 0; i < allNodes.size(); ++i) {
            nodeParam = (Element)allNodes.get(i);
            DSParam param = new DSParam(nodeParam.getChildText("ColName", ns), nodeParam.getChild("Associate", ns).getAttributeValue("dataSourceID"), nodeParam.getChildText("Associate", ns));
            String from = nodeParam.getAttributeValue("source");
            String dataType = nodeParam.getAttributeValue("dataType");
            String value = nodeParam.getChildText("Associate", ns);
            param.setFrom(from);
            param.setDataType(dataType);
            if ("value".equalsIgnoreCase(from)) {
                param.setValue(dataType, value);
            }
            list.add(param);
        }
        return list;
    }

    public R1PrintDataSortItem[] getSortFields() {
        R1PrintDataSortItem[] sis = new R1PrintDataSortItem[this._sorts.size()];
        this._sorts.toArray(sis);
        return sis;
    }
}

