/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.data.impl;

import com.kingdee.bos.ctrl.kdf.data.DataSetVisitor;
import com.kingdee.bos.ctrl.kdf.data.exception.DataSetWrapperException;
import com.kingdee.bos.ctrl.kdf.data.impl.SAXHandler;
import com.kingdee.bos.ctrl.kdf.data.impl.XmlDynamicRowSet;
import com.kingdee.bos.ctrl.kdf.expr.Variant;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

final class XmlDataSetVisitor
implements DataSetVisitor {
    private XmlDynamicRowSet xmlResultSet;
    private int currentPosition;
    private ArrayList currentRow;
    private ArrayList row;
    private boolean isLinked;
    private String encoding = "UNICODE";

    public XmlDataSetVisitor(boolean isLinked) {
        this.isLinked = isLinked;
    }

    public void setDecoder(String encoding) {
        this.encoding = encoding;
    }

    private void parse(String parserSource, boolean isLinked, XmlDynamicRowSet rowSet) throws DataSetWrapperException {
        SAXHandler handler = new SAXHandler(rowSet);
        XMLReader parser = null;
        try {
            parser = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
            parser.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (null != parser) {
            parser.setContentHandler(handler);
            parser.setErrorHandler(handler);
            try {
                if (isLinked) {
                    parser.parse(parserSource);
                } else {
                    ByteArrayInputStream bais = new ByteArrayInputStream(parserSource.getBytes(this.encoding));
                    parser.parse(new InputSource(bais));
                }
            }
            catch (SAXException saxe) {
                throw new DataSetWrapperException(saxe);
            }
            catch (IOException ioe) {
                throw new DataSetWrapperException(ioe);
            }
        }
    }

    @Override
    public boolean execute(String sName, String sQuery) throws DataSetWrapperException {
        this.currentPosition = 0;
        this.xmlResultSet = new XmlDynamicRowSet();
        this.parse(sQuery, this.isLinked, this.xmlResultSet);
        int size = this.xmlResultSet.fields.size();
        this.currentRow = new ArrayList(size);
        for (int i = 0; i < size; ++i) {
            this.currentRow.add(new Variant());
        }
        if (this.currentPosition < this.xmlResultSet.values.size()) {
            this.row = (ArrayList)this.xmlResultSet.values.get(this.currentPosition);
        }
        return true;
    }

    @Override
    public boolean next(ArrayList avOut) throws DataSetWrapperException {
        if (this.row != null) {
            int i;
            int currentRowSize = this.currentRow.size();
            int rowSize = this.row.size();
            int min = Math.min(currentRowSize, rowSize);
            this.currentRow.clear();
            for (i = 0; i < min; ++i) {
                this.currentRow.add(i, this.row.get(i));
            }
            while (i < currentRowSize) {
                this.currentRow.add(new Variant());
                ++i;
            }
        }
        ++this.currentPosition;
        this.row = this.currentPosition >= this.xmlResultSet.values.size() ? null : (ArrayList)this.xmlResultSet.values.get(this.currentPosition);
        if (this.currentRow != null) {
            avOut.clear();
            for (int i = 0; i < this.currentRow.size(); ++i) {
                avOut.add(this.currentRow.get(i));
            }
        }
        return this.isValidRow();
    }

    @Override
    public boolean isValidRow() throws DataSetWrapperException {
        return this.currentPosition <= this.xmlResultSet.values.size();
    }

    @Override
    public int getFieldCount() {
        return this.xmlResultSet.fields.size();
    }

    @Override
    public String[] getAllFieldName() {
        int size = this.xmlResultSet.fields.size();
        String[] result = new String[size];
        for (int index = 0; index < size; ++index) {
            result[index] = this.xmlResultSet.fields.get(index).toString().trim();
        }
        return result;
    }

    @Override
    public int getRecordCount() {
        return this.xmlResultSet.values.size();
    }
}

