/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.data.pool;

import com.kingdee.bos.ctrl.kdf.data.pool.ObjectFile;
import com.kingdee.bos.ctrl.kdf.data.pool.PersistentCache;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;

public class PersistentCacheImpl
implements PersistentCache {
    static long lCount;
    int iMaxCacheSize;
    int iCacheSize;
    HashMap cache = new HashMap();
    ArrayList rows = new ArrayList();
    ObjectFile of;
    String sTmpName;
    CacheEntry firstCacheEntry;
    CacheEntry lastCacheEntry;

    public PersistentCacheImpl(int iCacheSize) {
        this.iMaxCacheSize = iCacheSize;
    }

    private final void openTempFile() throws IOException {
        boolean bInValid = true;
        while (bInValid) {
            this.sTmpName = "tmp" + System.currentTimeMillis() + ++lCount + ".obf";
            File f = new File(this.sTmpName);
            if (f.exists()) continue;
            bInValid = false;
        }
        this.of = new ObjectFile(this.sTmpName);
    }

    @Override
    public final void add(Serializable o) throws IOException {
        StubEntry e = new StubEntry();
        this.rows.add(e);
        if (this.iCacheSize < this.iMaxCacheSize) {
            e.inCache = true;
            CacheEntry ce = new CacheEntry();
            ce.o = o;
            ce.key = new Integer(this.rows.size() - 1);
            this.cache.put(ce.key, ce);
            ++this.iCacheSize;
            if (this.lastCacheEntry != null) {
                ce.next = this.firstCacheEntry;
                this.firstCacheEntry.prev = ce;
                this.firstCacheEntry = ce;
            } else {
                this.firstCacheEntry = this.lastCacheEntry = ce;
            }
        } else {
            if (this.of == null) {
                this.openTempFile();
            }
            e.filePointer = this.of.writeObject(o);
        }
    }

    @Override
    public final Object get(int index) throws IndexOutOfBoundsException, IOException {
        if (index < 0 || index >= this.rows.size()) {
            throw new IndexOutOfBoundsException("Index: " + index + " out of bounds.");
        }
        StubEntry e = (StubEntry)this.rows.get(index);
        Object o = null;
        if (e.inCache) {
            CacheEntry ce = null;
            ce = (CacheEntry)this.cache.get(new Integer(index));
            if (ce == null) {
                throw new IOException("Element at index " + index + " is NULL");
            }
            if (ce.o == null) {
                throw new IOException("Cache Element's object  at index " + index + " NOT in chace");
            }
            o = ce.o;
            if (ce != this.firstCacheEntry) {
                if (ce.next != null) {
                    ce.next.prev = ce.prev;
                } else {
                    this.lastCacheEntry = ce.prev;
                }
                ce.prev.next = ce.next;
                ce.next = this.firstCacheEntry;
                ce.prev = null;
                this.firstCacheEntry.prev = ce;
                this.firstCacheEntry = ce;
            }
        } else {
            e.inCache = true;
            try {
                o = this.of.readObject(e.filePointer);
            }
            catch (ClassNotFoundException cnfe) {
                throw new IOException(cnfe.getMessage());
            }
            if (this.iCacheSize == this.iMaxCacheSize) {
                CacheEntry leastUsed = this.lastCacheEntry;
                if (leastUsed.prev != null) {
                    leastUsed.prev.next = null;
                    this.lastCacheEntry = leastUsed.prev;
                    this.lastCacheEntry.next = null;
                } else {
                    this.lastCacheEntry = null;
                    this.firstCacheEntry = null;
                }
                CacheEntry ce = new CacheEntry();
                ce.o = o;
                ce.key = new Integer(index);
                this.cache.put(ce.key, ce);
                if (this.lastCacheEntry != null) {
                    ce.next = this.firstCacheEntry;
                    this.firstCacheEntry.prev = ce;
                    this.firstCacheEntry = ce;
                } else {
                    this.lastCacheEntry = null;
                    this.firstCacheEntry = null;
                }
                StubEntry outStubEntry = (StubEntry)this.rows.get(leastUsed.key);
                CacheEntry outCacheEntry = (CacheEntry)this.cache.remove(leastUsed.key);
                if (outCacheEntry == null) {
                    throw new RuntimeException("Cache Entry at " + leastUsed.key + " is NULL");
                }
                if (outCacheEntry.o == null) {
                    throw new RuntimeException("Cache object at " + leastUsed.key + " is NULL");
                }
                Object outObject = outCacheEntry.o;
                outStubEntry.inCache = false;
                if (outStubEntry.filePointer == -1L) {
                    outStubEntry.filePointer = this.of.writeObject((Serializable)outObject);
                } else {
                    int iCurrentSize = this.of.getObjectLength(outStubEntry.filePointer);
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    ObjectOutputStream oos = new ObjectOutputStream(baos);
                    oos.writeObject((Serializable)outObject);
                    oos.flush();
                    int datalen = baos.size();
                    if (datalen <= iCurrentSize) {
                        this.of.rewriteObject(outStubEntry.filePointer, baos.toByteArray());
                    } else {
                        outStubEntry.filePointer = this.of.writeObject((Serializable)outObject);
                    }
                    baos = null;
                    oos = null;
                    outObject = null;
                }
            } else {
                CacheEntry ce = new CacheEntry();
                ce.o = o;
                ce.key = new Integer(index);
                this.cache.put(ce.key, ce);
                ++this.iCacheSize;
                if (this.lastCacheEntry != null) {
                    ce.next = this.firstCacheEntry;
                    this.firstCacheEntry.prev = ce;
                    this.firstCacheEntry = ce;
                } else {
                    this.firstCacheEntry = this.lastCacheEntry = ce;
                }
            }
        }
        return o;
    }

    public static void main(String[] args) throws IOException {
        int i;
        PersistentCacheImpl persistent = new PersistentCacheImpl(10);
        for (i = 0; i < 30; ++i) {
            persistent.add(new Integer(i));
        }
        for (i = 0; i < 30; ++i) {
            Integer n = (Integer)persistent.get(i);
        }
    }

    static final class CacheEntry {
        Integer key;
        Object o;
        CacheEntry prev;
        CacheEntry next;

        CacheEntry() {
        }
    }

    static final class StubEntry {
        boolean inCache;
        long filePointer = -1L;

        StubEntry() {
        }
    }
}

