/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.data.query;

import com.kingdee.bos.ctrl.common.LanguageManager;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.kdf.data.query.QueryElement;
import com.kingdee.bos.ctrl.kdf.data.query.SqlType;
import com.kingdee.bos.ctrl.kdf.util.Tools;

public class QueryColumn
extends QueryElement {
    protected String formula;
    protected String formula4Sql;
    protected SqlType type = SqlType.STRING;
    private String oriFormula;
    protected String programID;

    public QueryColumn(String ID, String programID, String alias, String formula) {
        this.ID = ID;
        this.programID = programID;
        this.name = alias;
        this.formula = formula;
        this.formula4Sql = formula;
        this.oriFormula = formula;
    }

    public QueryColumn(String ID, String programID, String alias, String formula, String comment) {
        this.ID = ID;
        this.programID = programID;
        this.name = alias;
        this.formula = formula;
        this.oriFormula = formula;
        this.comment = comment;
    }

    public boolean isFormulaNotChanged() {
        if (this.oriFormula == null || this.oriFormula.trim().length() == 0) {
            return true;
        }
        return this.oriFormula.equals(this.formula);
    }

    public String getFormula() {
        return this.formula;
    }

    public void setFormula(String formula) {
        this.formula = formula;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (obj instanceof QueryColumn) {
            QueryColumn col = (QueryColumn)obj;
            if (!(this.getFormula() != null ? this.getFormula().equals(col.getFormula()) : col.getFormula() == null)) {
                return false;
            }
            return this.getType() != null ? this.getType().equals(col.getType()) : col.getType() == null;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int[] seeds = new int[]{super.hashCode(), this.formula == null ? 0 : this.formula.hashCode(), this.type == null ? 0 : this.type.hashCode()};
        return Tools.hashCalculate((int[])seeds);
    }

    @Override
    public String toString() {
        if (StringUtil.isEmptyString((String)this.name)) {
            return this.formula;
        }
        return this.name;
    }

    public SqlType getType() {
        return this.type;
    }

    public void setType(SqlType type) {
        this.type = type;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        QueryColumn qryCln = (QueryColumn)super.clone();
        return qryCln;
    }

    public String getFormatString() {
        StringBuffer sb = new StringBuffer();
        sb.append("ID: " + this.getProgramID());
        sb.append("\n" + LanguageManager.getLangMessage((String)"name", (String)"com.kingdee.bos.ctrl.kdf.data.wizard.wizard", (String)"\u540d\u5b57") + ": " + this.getName());
        sb.append("\n" + LanguageManager.getLangMessage((String)"comment", (String)"com.kingdee.bos.ctrl.kdf.data.wizard.wizard", (String)"\u6ce8\u91ca") + ": " + this.getComment());
        sb.append("\n" + LanguageManager.getLangMessage((String)"formula2", (String)"com.kingdee.bos.ctrl.kdf.data.wizard.wizard", (String)"\u516c\u5f0f") + ": " + this.getFormula());
        return sb.toString();
    }

    public String getOriFormula() {
        return this.oriFormula;
    }

    public void setOriFormula(String oriFormula) {
        this.oriFormula = oriFormula;
    }

    public String getFormula4Sql() {
        return this.formula4Sql;
    }

    public void setFormula4Sql(String formula4Sql) {
        this.formula4Sql = formula4Sql;
    }

    public String getProgramID() {
        return this.programID;
    }

    public void setProgramID(String string) {
        this.programID = string;
    }
}

