/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.data.query;

import com.kingdee.bos.ctrl.common.LanguageManager;
import com.kingdee.bos.ctrl.kdf.data.query.QueryColumn;
import com.kingdee.bos.ctrl.kdf.data.query.QueryElement;
import com.kingdee.bos.ctrl.kdf.util.Tools;
import java.util.LinkedList;

public class QuerySort
extends QueryElement {
    protected boolean active = false;
    protected LinkedList itemList;

    public LinkedList getItemList() {
        if (this.itemList == null) {
            this.itemList = new LinkedList();
        }
        return this.itemList;
    }

    public QuerySort(String ID, String name, String comment) {
        super(ID);
        this.name = name;
        this.comment = comment;
    }

    public QuerySort(String ID, String name) {
        super(ID);
        this.name = name;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public void addItem(SortItem item) {
        this.getItemList().add(item);
    }

    public boolean removeItem(SortItem item) {
        return this.getItemList().remove(item);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (obj instanceof QuerySort) {
            QuerySort sort = (QuerySort)obj;
            if (this.active != sort.isActive()) {
                return false;
            }
            return this.getItemList() != null ? this.getItemList().equals(sort.getItemList()) : sort.getItemList() == null;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int[] seeds = new int[3];
        seeds[0] = super.hashCode();
        seeds[2] = this.active ? 1 : 0;
        seeds[1] = this.itemList.hashCode();
        return Tools.hashCalculate((int[])seeds);
    }

    @Override
    public String toString() {
        return this.name + (this.active ? " (" + LanguageManager.getLangMessage((String)"on", (String)"com.kingdee.bos.ctrl.kdf.data.wizard.wizard", (String)"\u542f\u7528") + ")" : "");
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        QuerySort qrySort = (QuerySort)super.clone();
        qrySort.itemList = this.itemList != null ? (LinkedList)this.itemList.clone() : null;
        return qrySort;
    }

    public String getFormatString() {
        StringBuffer sb = new StringBuffer();
        sb.append("ID: " + this.getID());
        sb.append("\n" + LanguageManager.getLangMessage((String)"name", (String)"com.kingdee.bos.ctrl.kdf.data.wizard.wizard", (String)"\u540d\u5b57") + ": " + this.getName());
        sb.append("\n" + LanguageManager.getLangMessage((String)"comment", (String)"com.kingdee.bos.ctrl.kdf.data.wizard.wizard", (String)"\u6ce8\u91ca") + ": " + this.getComment());
        sb.append("\n" + LanguageManager.getLangMessage((String)"sortItem", (String)"com.kingdee.bos.ctrl.kdf.data.wizard.wizard", (String)"\u6392\u5e8f\u9879") + ": ");
        int i = 1;
        for (SortItem qrySortItem : this.getItemList()) {
            sb.append("\n    " + LanguageManager.getLangMessage((String)"sortFld", (String)"com.kingdee.bos.ctrl.kdf.data.wizard.wizard", (String)"\u6392\u5e8f\u5b57\u6bb5") + i + ": " + qrySortItem.getColumn().getFormula());
            ++i;
        }
        return sb.toString();
    }

    public static class SortItem
    extends QueryElement {
        protected QueryColumn column;
        protected boolean desc = false;

        public SortItem(String itemID, String itemName, QueryColumn column) {
            super(itemID, itemName);
            this.column = column;
        }

        public SortItem(String itemID, String itemName, QueryColumn column, boolean desc) {
            super(itemID, itemName);
            this.column = column;
            this.desc = desc;
        }

        public QueryColumn getColumn() {
            return this.column;
        }

        public void setColumn(QueryColumn column) {
            this.column = column;
        }

        public boolean isDesc() {
            return this.desc;
        }

        public void setDesc(boolean desc) {
            this.desc = desc;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (obj instanceof SortItem) {
                if (obj instanceof SortItem) {
                    SortItem item = (SortItem)obj;
                    if (!(this.getID() != null ? this.getID().equals(item.getID()) : item.getID() == null)) {
                        return false;
                    }
                    if (!(this.getName() != null ? this.getName().equals(item.getName()) : item.getName() == null)) {
                        return false;
                    }
                    if (!(this.getColumn() != null ? this.column.getID().equals(item.getColumn().getID()) : item.getColumn() == null)) {
                        return false;
                    }
                    return !this.isDesc() != item.isDesc();
                }
                return false;
            }
            return false;
        }

        @Override
        public int hashCode() {
            int[] seeds = new int[]{this.desc ? 1 : 0, this.column == null ? 0 : this.column.hashCode(), this.getID() == null ? 0 : this.getID().hashCode(), this.getName() == null ? 0 : this.getName().hashCode()};
            return Tools.hashCalculate((int[])seeds);
        }

        @Override
        public String toString() {
            return this.getName() + (this.desc ? " DESC" : " ASC");
        }

        @Override
        public Object clone() throws CloneNotSupportedException {
            SortItem sortItem = (SortItem)super.clone();
            sortItem.column = this.column != null ? (QueryColumn)this.column.clone() : null;
            return sortItem;
        }
    }
}

