/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.data.wizard;

import com.kingdee.bos.ctrl.common.LanguageManager;
import com.kingdee.bos.ctrl.kdf.data.datasource.BOSQueryDataSource;
import com.kingdee.bos.ctrl.kdf.data.datasource.DSParam;
import com.kingdee.bos.ctrl.kdf.data.datasource.DataSource;
import com.kingdee.bos.ctrl.kdf.data.datasource.EntityDataSource;
import com.kingdee.bos.ctrl.kdf.data.datasource.JDBCDataSource;
import com.kingdee.bos.ctrl.kdf.data.datasource.ObjectDataSource;
import com.kingdee.bos.ctrl.kdf.data.query.KDBasicQuery;
import com.kingdee.bos.ctrl.kdf.data.query.KDQuery;
import com.kingdee.bos.ctrl.kdf.data.query.KDSourceQuery;
import com.kingdee.bos.ctrl.kdf.data.query.MetaPK;
import com.kingdee.bos.ctrl.kdf.data.query.QueryDir;
import com.kingdee.bos.ctrl.kdf.data.query.QueryParam;
import com.kingdee.bos.ctrl.kdf.data.query.QueryTable;
import com.kingdee.bos.ctrl.kdf.data.wizard.IKDMAdapter;
import com.kingdee.bos.ctrl.kdf.data.wizard.ISQLGenerator;
import com.kingdee.bos.ctrl.kdf.data.wizard.KDDataWizard;
import com.kingdee.bos.ctrl.kdf.data.wizard.KDDataWizardQry2DirPath;
import com.kingdee.bos.ctrl.kdf.data.wizard.KDDataWizardSQLGenerator;
import com.kingdee.bos.ctrl.kdf.data.wizard.KDMParser;
import com.kingdee.bos.ctrl.kdf.data.wizard.QueryXmlTranser;
import com.kingdee.bos.ctrl.kdf.data.wizard.event.DataManipulationListener;
import com.kingdee.bos.ctrl.kdf.data.wizard.event.DeleteEvent;
import com.kingdee.bos.ctrl.kdf.util.CloseUtil;
import com.kingdee.bos.ctrl.kdf.util.SimpleQueue;
import com.kingdee.bos.metadata.MetaDataTypeList;
import java.awt.Dialog;
import java.awt.Frame;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import org.jdom2.Content;
import org.jdom2.Element;

public final class KDDataManager {
    private HashMap querys;
    private HashMap customQuerys;
    private QueryDir dirRoot;
    private QueryDir dirSystem;
    private QueryDir dirCustomer;
    private static HashMap dbImport;
    private IKDMAdapter kdmAdapter;
    private ISQLGenerator sqlGenerator;
    private KDDataWizard dataWizard;
    private QueryXmlTranser writer;
    private ArrayList dataEventListeners = new ArrayList();
    private static long ID_SEED;
    protected static final String DEFAULTTABLENAME = "queryTable";
    protected static final String DEFAULTCOLUMNNAME = "queryColumn";
    private static final String METAPATH;
    private ArrayList metaFileList;

    public KDDataManager() {
        this.kdmAdapter = new KDMParser();
        this.writer = new QueryXmlTranser();
        this.querys = new HashMap();
        this.customQuerys = new HashMap();
        this.getDirRoot().add(this.getDirSystem());
        this.getDirRoot().add(this.getDirCustomer());
    }

    public void setMetaFile(File file) {
        this.metaFileList = new ArrayList();
        this.metaFileList.add(file);
        this.loadMeta();
    }

    public void setMetaFile(String fileName) {
        this.metaFileList = new ArrayList();
        this.metaFileList.add(fileName);
        this.loadMeta();
    }

    public void setMetaFiles(ArrayList list) {
        this.metaFileList = list;
        this.loadMeta();
    }

    public void addDataEventListener(DataManipulationListener listener) {
        this.dataEventListeners.add(listener);
    }

    public void removeDataEventListener(DataManipulationListener listener) {
        this.dataEventListeners.remove(listener);
    }

    protected void fireDataEvent(DeleteEvent evt) {
        for (DataManipulationListener listener : this.dataEventListeners) {
            listener.fireDeleteEvent(evt);
        }
    }

    public ISQLGenerator getSqlGenerator() {
        if (this.sqlGenerator == null) {
            this.sqlGenerator = new KDDataWizardSQLGenerator();
        }
        return this.sqlGenerator;
    }

    public void setSqlGenerator(ISQLGenerator sqlGenerator) {
        this.sqlGenerator = sqlGenerator;
    }

    public KDBasicQuery getQuery(String queryID) {
        return (KDBasicQuery)this.getQuerys().get(queryID);
    }

    public KDBasicQuery removeQuery(String queryID) {
        return (KDBasicQuery)this.getQuerys().remove(queryID);
    }

    public Object addQuery(KDBasicQuery query, QueryDir dir) {
        this.getCustomQuerys().put(query.getID(), query);
        dir.add(query);
        this.getQuerys().put(query.getID(), query);
        return null;
    }

    public HashMap getQuerys() {
        return this.querys;
    }

    public HashMap getCustomQuerys() {
        return this.customQuerys;
    }

    protected void setQuerys(HashMap querys) {
        this.querys = querys;
    }

    public void showWizard(Frame parent) {
        if (this.dataWizard == null) {
            this.dataWizard = new KDDataWizard(parent, this);
        }
        this.dataWizard.setVisible(true);
        this.dataWizard.setModal(true);
    }

    public void showWizard(Dialog parent) {
        if (this.dataWizard == null) {
            this.dataWizard = new KDDataWizard(parent, this);
        }
        this.dataWizard.setVisible(true);
        this.dataWizard.setModal(true);
    }

    public boolean checkHasBeenRefered(KDQuery kdQry) {
        Iterator it = this.getQuerys().values().iterator();
        Iterator itQry = null;
        Object objTemp = null;
        QueryTable QryTab2 = null;
        while (it.hasNext()) {
            objTemp = it.next();
            if (!(objTemp instanceof KDQuery) || kdQry.equals(objTemp)) continue;
            for (QueryTable QryTab2 : ((KDQuery)objTemp).getSubQueryList()) {
                if (!(QryTab2.getBasicQuery() instanceof KDQuery) || !QryTab2.getBasicQuery().getID().equals(kdQry.getID())) continue;
                return true;
            }
        }
        return false;
    }

    public int getReferedQry(QueryDir dir, KDBasicQuery kdQry, String path, SimpleQueue queDelQry, SimpleQueue queDelQryPath, int delCount) {
        Iterator iter = dir.iterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (obj instanceof QueryDir) {
                delCount += this.getReferedQry((QueryDir)obj, kdQry, path + "/" + ((QueryDir)obj).getName(), queDelQry, queDelQryPath, delCount);
                continue;
            }
            if (!(obj instanceof KDQuery) || queDelQry.contains(obj) || kdQry.equals(obj)) continue;
            for (QueryTable QryTab : ((KDQuery)obj).getSubQueryList()) {
                if (!QryTab.getBasicQuery().getID().equals(kdQry.getID())) continue;
                KDDataWizardQry2DirPath qry2path = new KDDataWizardQry2DirPath((KDQuery)obj, dir, path + "/" + ((KDQuery)obj).getName());
                queDelQryPath.put(qry2path);
                queDelQry.put(obj);
                ++delCount;
            }
        }
        return delCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String parseSourceQuery(String fileName) throws FileNotFoundException {
        String string;
        int i = fileName.lastIndexOf(File.separatorChar);
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(fileName);
            string = this.parseSourceQuery(fis, i < 0 ? fileName : fileName.substring(i + 1));
        }
        catch (Throwable throwable) {
            CloseUtil.close((Closeable[])new Closeable[]{fis});
            throw throwable;
        }
        CloseUtil.close((Closeable[])new Closeable[]{fis});
        return string;
    }

    private String parseSourceQuery(InputStream stream, String fileName) {
        this.getKDMAdapter().parseSourceQuery(this, stream, fileName);
        this.setQuerys(this.getDirRoot().getQueryMap());
        return this.getKDMAdapter().getStrErr();
    }

    public IKDMAdapter getKDMAdapter() {
        return this.kdmAdapter;
    }

    public void setKDMAdapter(IKDMAdapter kdmAdapter) {
        this.kdmAdapter = kdmAdapter;
    }

    public String getUniqueID(String prefix, String postfix) {
        String id = KDDataManager.getID(prefix, postfix);
        while (this.getCustomQuerys().containsKey(id)) {
            id = KDDataManager.getID(prefix, postfix);
        }
        return id;
    }

    public static synchronized String getID(String prefix, String postfix) {
        ++ID_SEED;
        if (prefix == null) {
            prefix = "";
        }
        if (postfix == null) {
            postfix = "";
        }
        return prefix + ID_SEED + postfix;
    }

    public static void clearMeta() {
        dbImport.clear();
        dbImport = null;
    }

    private void loadMeta() {
        dbImport = new HashMap();
        if (this.metaFileList != null) {
            ArrayList<String> fl = new ArrayList<String>();
            for (Object item : this.metaFileList) {
                File pFile;
                if (item instanceof String) {
                    pFile = new File((String)item);
                } else {
                    if (!(item instanceof File)) continue;
                    pFile = (File)item;
                }
                if (!pFile.exists() || !pFile.isFile()) continue;
                fl.add(pFile.getAbsolutePath());
            }
            try {
                Iterator itFL = fl.iterator();
                while (itFL.hasNext()) {
                    this.parseSourceQuery((String)itFL.next());
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        } else {
            File pFile = new File(METAPATH);
            if (pFile.exists() && pFile.isDirectory()) {
                ArrayList fl = new ArrayList();
                this.loadFileList(pFile, fl);
                try {
                    Iterator it = fl.iterator();
                    while (it.hasNext()) {
                        this.parseSourceQuery((String)it.next());
                    }
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
            }
        }
        this.getDirSystem().clear();
        for (QueryDir dbDir : dbImport.values()) {
            this.getDirSystem().add(dbDir);
        }
    }

    private void loadFileList(File file, ArrayList fileList) {
        File[] files = file.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (!files[i].isFile()) continue;
            fileList.add(files[i].getAbsolutePath());
        }
    }

    public void saveQuerys(String fileName) {
        this.writer.setTreeRoot(this.getDirCustomer());
        this.writer.save(fileName);
    }

    public void saveQuerys(OutputStream out) {
        this.writer.setTreeRoot(this.getDirCustomer());
        this.writer.save(out);
    }

    public Element buildDataSourceNode(KDBasicQuery query, boolean withQuery) {
        Element node = this.createDataSource(query).writeToNode();
        if (withQuery) {
            node.addContent((Content)this.getWriter().createQueryNode(query));
        }
        return node;
    }

    public void addQueryFromDS(DataSource source) {
        Object obj = source.getUserObject();
        if (obj == null) {
            return;
        }
        if (obj instanceof Element) {
            KDBasicQuery kbq = this.getWriter().parseQuery((Element)obj, this.getDirSystem().getQueryMap(), source);
            this.getDirCustomer().add(kbq);
            this.getCustomQuerys().put(kbq.getID(), kbq);
        }
    }

    public void addQueryFromDS(DataSource[] sources) {
        for (int i = 0; i < sources.length; ++i) {
            this.addQueryFromDS(sources[i]);
        }
        this.getWriter().manageDoNotFindElement();
    }

    public Element buildDataSourceNode(KDBasicQuery query) {
        return this.buildDataSourceNode(query, false);
    }

    public void saveQuerys(Writer out) {
        this.getWriter().setTreeRoot(this.getDirCustomer());
        this.getWriter().save(out);
    }

    public QueryDir getDirRoot() {
        if (this.dirRoot == null) {
            this.dirRoot = new QueryDir("Root", LanguageManager.getLangMessage((String)"root", (String)"com.kingdee.bos.ctrl.kdf.data.wizard.wizard", (String)"\u6839\u76ee\u5f55"));
        }
        return this.dirRoot;
    }

    public void setDirRoot(QueryDir dirRoot) {
        this.dirRoot = dirRoot;
    }

    public DataSource createDataSource(KDBasicQuery query) {
        return this.createDataSource(query, true);
    }

    public DataSource createDataSource(KDBasicQuery query, boolean withQuery) {
        DataSource source = null;
        if (query instanceof KDQuery) {
            KDQuery kdqry = (KDQuery)query;
            switch (query.getQueryType()) {
                case 1: {
                    JDBCDataSource ds = new JDBCDataSource(query.getID(), kdqry.isSelfDefine() ? kdqry.getSelfDefineSQL() : this.getSqlGenerator().getQrySQL(query));
                    source = ds;
                    break;
                }
                case 0: {
                    KDBasicQuery o;
                    BOSQueryDataSource qds = new BOSQueryDataSource(query.getID(), "", "");
                    LinkedList lst = kdqry.getSubQueryList();
                    if (lst.size() > 0 && (o = ((QueryTable)lst.get(0)).getBasicQuery()) instanceof KDSourceQuery && o.getQueryType() == 0) {
                        KDSourceQuery qry = (KDSourceQuery)o;
                        MetaPK mk = (MetaPK)qry.getKey();
                        qds.setPackageName(mk.getPackName());
                        qds.setName(mk.getObjectName());
                        if (mk.getBosType().equals((Object)MetaDataTypeList.ENTITY)) {
                            qds.setType(0);
                        } else {
                            qds.setType(1);
                        }
                    }
                    source = qds;
                    break;
                }
                case 2: {
                    EntityDataSource eds = new EntityDataSource(query.getID(), kdqry.isLinked(), kdqry.getSource());
                    eds.setType(1);
                    source = eds;
                    break;
                }
                case 3: {
                    EntityDataSource xds = new EntityDataSource(query.getID(), kdqry.isLinked(), kdqry.getSource());
                    xds.setType(0);
                    source = xds;
                    break;
                }
                case 4: {
                    ObjectDataSource ods = new ObjectDataSource(query.getID(), kdqry.getSource());
                    source = ods;
                    break;
                }
            }
            if (source != null) {
                for (QueryParam param : kdqry.getParamList()) {
                    DSParam dsparam = new DSParam(param.getName(), param.getSourceQuery().getBasicQuery().getID(), param.getSourceColumn().getProgramID());
                    dsparam.setDataType(param.getTypeName());
                    dsparam.setFrom("associate");
                    source.addParam(dsparam);
                }
                if (withQuery) {
                    source.setUserObject(this.getWriter().createQueryNode(query));
                }
            }
        }
        return source;
    }

    public void loadQuerys(String fileName) throws FileNotFoundException {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(fileName);
            this.loadQuerys(fis, fileName);
        }
        catch (Throwable throwable) {
            CloseUtil.close((Closeable[])new Closeable[]{fis});
            throw throwable;
        }
        CloseUtil.close((Closeable[])new Closeable[]{fis});
    }

    public void loadQuerys(InputStream in, String fileName) {
        QueryXmlTranser transer = new QueryXmlTranser(in);
        this.reloadData(transer, fileName);
    }

    protected void reloadData(QueryXmlTranser reader, String fileName) {
        HashMap sysHashMap = this.getDirSystem().getQueryMap();
        this.dirCustomer = new QueryDir("dirCustomer", LanguageManager.getLangMessage((String)"dirCustomer", (String)"com.kingdee.bos.ctrl.kdf.data.wizard.wizard", (String)"\u7528\u6237\u67e5\u8be2\u5bf9\u8c61"));
        this.setDirCustomer(reader.getTreeRoot(fileName, sysHashMap, this.getDirCustomer()));
        this.setQuerys(this.getDirRoot().getQueryMap());
    }

    public KDDataWizard getDataWizard() {
        return this.dataWizard;
    }

    public void setDataWizard(KDDataWizard dataWizard) {
        this.dataWizard = dataWizard;
    }

    protected QueryXmlTranser getWriter() {
        return this.writer;
    }

    public QueryDir getDirCustomer() {
        if (this.dirCustomer == null) {
            this.dirCustomer = new QueryDir("dirCustomer", LanguageManager.getLangMessage((String)"dirCustomer", (String)"com.kingdee.bos.ctrl.kdf.data.wizard.wizard", (String)"\u7528\u6237\u67e5\u8be2\u5bf9\u8c61"));
        }
        return this.dirCustomer;
    }

    protected void setDirCustomer(QueryDir dirCustomer) {
        this.dirCustomer = dirCustomer;
    }

    public QueryDir getDirSystem() {
        if (this.dirSystem == null) {
            this.dirSystem = new QueryDir("dirSystem", LanguageManager.getLangMessage((String)"dirSystem", (String)"com.kingdee.bos.ctrl.kdf.data.wizard.wizard", (String)"\u7cfb\u7edf\u67e5\u8be2\u5bf9\u8c61"));
        }
        return this.dirSystem;
    }

    protected void setDirSystem(QueryDir dirSystem) {
        this.dirSystem = dirSystem;
    }

    public HashMap getDbImport() {
        if (dbImport == null) {
            dbImport = new HashMap();
        }
        return dbImport;
    }

    static {
        ID_SEED = 1L;
        METAPATH = System.getProperty("user.dir") + File.separator + "conf" + File.separator + "meta";
    }
}

