/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.data.wizard;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.kdf.data.query.DBPK;
import com.kingdee.bos.ctrl.kdf.data.query.KDSourceQuery;
import com.kingdee.bos.ctrl.kdf.data.query.Key;
import com.kingdee.bos.ctrl.kdf.data.query.MetaPK;
import com.kingdee.bos.ctrl.kdf.data.query.QueryColumn;
import com.kingdee.bos.ctrl.kdf.data.query.QueryDir;
import com.kingdee.bos.ctrl.kdf.data.query.SqlType;
import com.kingdee.bos.ctrl.kdf.data.util.KDMXmlOperator;
import com.kingdee.bos.ctrl.kdf.data.wizard.IKDMAdapter;
import com.kingdee.bos.ctrl.kdf.data.wizard.KDDataManager;
import com.kingdee.bos.ctrl.kdf.util.SimpleQueue;
import com.kingdee.bos.util.BOSObjectType;
import java.io.InputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.jdom2.Element;

public class KDMParser
implements IKDMAdapter {
    private KDMXmlOperator kdrReader;
    private KDDataManager manager;
    private HashMap dirCache;
    private String kdfPath;
    private StringBuffer strErr;

    private QueryDir getDirByName(String name) {
        Object obj = this.dirCache.get(name);
        if (obj instanceof QueryDir) {
            return (QueryDir)obj;
        }
        return null;
    }

    private void cacheQueryDir(QueryDir dir) {
        this.dirCache.put(dir.getName(), dir);
    }

    @Override
    public void parseSourceQuery(KDDataManager manager, InputStream stream, String filePath) {
        this.kdrReader = new KDMXmlOperator(stream);
        this.manager = manager;
        this.kdfPath = filePath;
        this.parse();
    }

    @Override
    public void parseSourceQuery(KDDataManager manager, Reader reader) {
        this.kdrReader = new KDMXmlOperator(reader);
        this.manager = manager;
        this.kdfPath = "";
        this.parse();
    }

    private void parse() {
        this.dirCache = new HashMap();
        this.strErr = new StringBuffer();
        List listDB = this.kdrReader.getDataBaseNodes();
        for (Element nodeDB : listDB) {
            this.parseDB(nodeDB);
        }
    }

    private void detectedFileBug() {
        throw new IllegalArgumentException("\u4e0d\u662f\u6709\u6548\u7684XML\u6587\u4ef6\u683c\u5f0f");
    }

    private void parseGroups(Element nodeDB, QueryDir dbDir) {
        Element nodeGroups = nodeDB.getChild("Groups", nodeDB.getNamespace());
        if (nodeGroups == null) {
            return;
        }
        SimpleQueue queue = new SimpleQueue();
        Iterator iter = nodeGroups.getChildren("Group", nodeDB.getNamespace()).iterator();
        while (iter.hasNext()) {
            queue.put(iter.next());
        }
        int size = queue.size();
        while (size > 0) {
            for (int i = 0; i < size; ++i) {
                Element node = (Element)queue.get();
                String attrGroup = node.getAttributeValue("group");
                if (this.isEmptyString(attrGroup)) {
                    dbDir.add(this.parseDir(node));
                    continue;
                }
                QueryDir parent = this.getDirByName(attrGroup);
                if (parent == null) {
                    queue.put(node);
                    continue;
                }
                parent.add(this.parseDir(node));
            }
            if (size == queue.size()) break;
            size = queue.size();
        }
    }

    private QueryDir parseDir(Element node) {
        String name = node.getChildText("Name", node.getNamespace());
        String alias = node.getChildText("Alias", node.getNamespace());
        alias = StringUtil.isEmptyString((String)alias) ? name : alias;
        String comment = node.getChildText("Description", node.getNamespace());
        if (this.isEmptyString(name)) {
            this.detectedFileBug();
        }
        QueryDir dir = new QueryDir(KDDataManager.getID("QueryDir", null), name);
        dir.setAlias(alias);
        dir.setComment(comment);
        this.cacheQueryDir(dir);
        return dir;
    }

    private void parseDB(Element nodeDB) {
        Element nodeTables = nodeDB.getChild("Tables", nodeDB.getNamespace());
        if (nodeTables == null) {
            return;
        }
        String dbName = nodeDB.getChildText("Name");
        String dbDescription = nodeDB.getChildText("Description");
        QueryDir dbDir = new QueryDir(this.kdfPath, dbName, dbDescription);
        this.manager.getDbImport().put(dbDir.getName(), dbDir);
        this.parseGroups(nodeDB, dbDir);
        for (Element nodeTable : nodeTables.getChildren("Table", nodeDB.getNamespace())) {
            String tableName = nodeTable.getChildText("Name");
            String alias = nodeTable.getChildText("Alias");
            String tabtype = nodeTable.getAttributeValue("type");
            if (this.isEmptyString(tableName)) {
                return;
            }
            Key key = null;
            int type = 0;
            if ("entity".equals(tabtype) || "query".equals(tabtype)) {
                String packName = nodeTable.getAttributeValue("packName");
                String name = nodeTable.getAttributeValue("name");
                String bosType = nodeTable.getAttributeValue("bosType");
                if (this.isEmptyString(packName) || this.isEmptyString(name) || this.isEmptyString(bosType)) {
                    return;
                }
                key = new MetaPK(new BOSObjectType(bosType), packName, name);
                type = 0;
            } else {
                key = new DBPK(dbName, tableName);
                type = 1;
            }
            alias = StringUtil.isEmptyString((String)alias) ? tableName : alias;
            KDSourceQuery query = new KDSourceQuery(dbName + "/" + tableName, alias, type, key);
            String comment = nodeTable.getChildText("Description");
            if (!this.isEmptyString(comment)) {
                query.setComment(comment);
            }
            this.parseTableFields(query, nodeTable);
            String group = nodeTable.getAttributeValue("group");
            if (this.isEmptyString(group)) {
                dbDir.add(query);
                continue;
            }
            QueryDir dir = this.getDirByName(group);
            if (null == dir) {
                dbDir.add(query);
                continue;
            }
            dir.add(query);
        }
    }

    private void parseTableFields(KDSourceQuery query, Element nodeTable) {
        Element nodeFields = nodeTable.getChild("Fields");
        if (nodeFields == null) {
            return;
        }
        for (Element nodeField : nodeFields.getChildren("Field")) {
            String formula = nodeField.getChildText("Name");
            String alias = nodeField.getChildText("Alias");
            String comment = nodeField.getChildText("Description");
            SqlType type = SqlType.instance(nodeField.getChildText("Type"));
            alias = StringUtil.isEmptyString((String)alias) ? formula : alias;
            QueryColumn qc = new QueryColumn(KDDataManager.getID("col", null), formula, alias, formula, comment);
            qc.setType(type);
            query.getColumnList().add(qc);
        }
    }

    private boolean isEmptyString(String value) {
        return value == null || value.trim().equals("");
    }

    KDMXmlOperator getKdrReader() {
        if (this.kdrReader == null) {
            this.kdrReader = new KDMXmlOperator();
        }
        return this.kdrReader;
    }

    @Override
    public String getStrErr() {
        if (this.strErr.length() > 0) {
            return this.strErr.toString().substring(0, this.strErr.length() - 1);
        }
        return "";
    }
}

