/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.data.wizard;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.kdf.data.datasource.DataSource;
import com.kingdee.bos.ctrl.kdf.data.query.DBPK;
import com.kingdee.bos.ctrl.kdf.data.query.KDBasicQuery;
import com.kingdee.bos.ctrl.kdf.data.query.KDQuery;
import com.kingdee.bos.ctrl.kdf.data.query.KDSourceQuery;
import com.kingdee.bos.ctrl.kdf.data.query.Key;
import com.kingdee.bos.ctrl.kdf.data.query.MetaPK;
import com.kingdee.bos.ctrl.kdf.data.query.QueryColumn;
import com.kingdee.bos.ctrl.kdf.data.query.QueryDir;
import com.kingdee.bos.ctrl.kdf.data.query.QueryElement;
import com.kingdee.bos.ctrl.kdf.data.query.QueryFilter;
import com.kingdee.bos.ctrl.kdf.data.query.QueryGroup;
import com.kingdee.bos.ctrl.kdf.data.query.QueryJoin;
import com.kingdee.bos.ctrl.kdf.data.query.QueryParam;
import com.kingdee.bos.ctrl.kdf.data.query.QuerySort;
import com.kingdee.bos.ctrl.kdf.data.query.QueryTable;
import com.kingdee.bos.ctrl.kdf.data.query.SqlType;
import com.kingdee.bos.ctrl.kdf.data.wizard.KDDataManager;
import com.kingdee.bos.ctrl.kdf.util.Base64;
import com.kingdee.bos.ctrl.kdf.util.CloseUtil;
import com.kingdee.bos.ctrl.kdf.util.file.KDFXmlReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.xml.sax.InputSource;

public class QueryXmlTranser {
    public static final String INIT_SOURCE = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><DocRoot xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"></DocRoot>";
    static final String OBJECT_CLASS_KDSOURCEQUERY = "KDSourceQuery";
    static final String OBJECT_CLASS_KDQUERY = "KDQuery";
    private InputSource source;
    protected Element root;
    protected Document doc;
    private HashMap nodeCache;
    private HashMap queryCache;
    private HashMap tableCache;
    private HashMap colCache;
    private HashMap sysHashMap;
    private LinkedList lstDoNotFindElement;
    private static final int FIND_QUERY4TABLE = 1;
    private static final int FIND_TABLE4PARAM = 2;
    private static final int FIND_FIELD4PARAM = 3;

    public QueryXmlTranser() {
        this.source = new InputSource(new StringReader(INIT_SOURCE));
    }

    public QueryXmlTranser(String fileName) throws FileNotFoundException {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(fileName);
            this.source = new InputSource(fis);
        }
        catch (Throwable throwable) {
            CloseUtil.close((Closeable[])new Closeable[]{fis});
            throw throwable;
        }
        CloseUtil.close((Closeable[])new Closeable[]{fis});
    }

    public QueryXmlTranser(InputStream in) {
        this.source = new InputSource(in);
    }

    public QueryXmlTranser(Reader in) {
        this.source = new InputSource(in);
    }

    public Element createQueryNode(KDBasicQuery query) {
        Element nodeQuery = new Element("DesignedDataSource", KDFXmlReader.NS_COMMON);
        this.buildQueryNode(nodeQuery, query);
        return nodeQuery;
    }

    private Element buildKeyNode(Key key) {
        Element nodeKey = new Element("Key", KDFXmlReader.NS_COMMON);
        if (key instanceof DBPK) {
            DBPK pk = (DBPK)key;
            this.addAttributeToNode(nodeKey, "dbid", pk.getDbid());
            this.addAttributeToNode(nodeKey, "tableName", pk.getTableName());
        } else if (key instanceof MetaPK) {
            MetaPK pk = (MetaPK)key;
            this.addAttributeToNode(nodeKey, "bosType", pk.getBosType().toString());
            this.addAttributeToNode(nodeKey, "packName", pk.getPackName());
            this.addAttributeToNode(nodeKey, "objectName", pk.getObjectName());
        } else {
            return null;
        }
        return nodeKey;
    }

    private void buildQueryNode(Element node, KDBasicQuery query) {
        this.addAttributeToNode(node, "id", query.getID());
        this.addAttributeToNode(node, "name", query.getName());
        this.addAttributeToNode(node, "queryType", String.valueOf(query.getQueryType()));
        if (!this.isEmptyString(query.getComment())) {
            Element nodeComment = new Element("Comment", KDFXmlReader.NS_COMMON);
            nodeComment.setText(query.getComment());
            node.addContent((Content)nodeComment);
        }
        Element nodeCols = new Element("Columns", KDFXmlReader.NS_COMMON);
        this.buildColumnsNode(nodeCols, query);
        node.addContent((Content)nodeCols);
        if (query instanceof KDSourceQuery) {
            KDSourceQuery sourceQuery = (KDSourceQuery)query;
            this.addAttributeToNode(node, "objectClass", OBJECT_CLASS_KDSOURCEQUERY);
            node.addContent((Content)this.buildKeyNode(sourceQuery.getKey()));
        } else if (query instanceof KDQuery) {
            KDQuery kdq = (KDQuery)query;
            this.addAttributeToNode(node, "objectClass", OBJECT_CLASS_KDQUERY);
            this.addAttributeToNode(node, "isLinked", String.valueOf(kdq.isLinked()));
            this.addAttributeToNode(node, "isSelfDefine", String.valueOf(kdq.isSelfDefine()));
            this.addAttributeToNode(node, "selfDefineSql", Base64.encodeString((String)kdq.getSelfDefineSQL()));
            if (kdq.getSubQueryList().size() != 0) {
                Element nodeSubs = new Element("SubQuerys", KDFXmlReader.NS_COMMON);
                this.buildSubQuerysNode(nodeSubs, kdq.getSubQueryList());
                node.addContent((Content)nodeSubs);
            }
            if (kdq.getFilterList().size() != 0) {
                Element nodeFilters = new Element("Filters", KDFXmlReader.NS_COMMON);
                this.buildFiltersNode(nodeFilters, kdq.getFilterList());
                node.addContent((Content)nodeFilters);
            }
            if (kdq.getJoinList().size() != 0) {
                Element nodeJoins = new Element("Joins", KDFXmlReader.NS_COMMON);
                this.buildJoinsNode(nodeJoins, kdq.getJoinList());
                node.addContent((Content)nodeJoins);
            }
            if (kdq.getSortList().size() != 0) {
                Element nodeSorts = new Element("Sorts", KDFXmlReader.NS_COMMON);
                this.buildSortsNode(nodeSorts, kdq.getSortList());
                node.addContent((Content)nodeSorts);
            }
            if (kdq.getGroupList().size() != 0) {
                Element nodeGroups = new Element("Group", KDFXmlReader.NS_COMMON);
                this.buildGroupNode(nodeGroups, kdq.getGroupList());
                node.addContent((Content)nodeGroups);
            }
            if (kdq.getParamList().size() != 0) {
                Element nodeParams = new Element("Params", KDFXmlReader.NS_COMMON);
                this.buildParamsNode(nodeParams, kdq.getParamList());
                node.addContent((Content)nodeParams);
            }
        }
    }

    private void buildParamsNode(Element node, List paramList) {
        for (QueryParam param : paramList) {
            Element nodeParam = new Element("Param", KDFXmlReader.NS_COMMON);
            this.addQueryElementProperty(nodeParam, param);
            this.addAttributeToNode(nodeParam, "active", String.valueOf(param.isActive()));
            this.addAttributeToNode(nodeParam, "binding", String.valueOf(param.isBinding()));
            this.addAttributeToNode(nodeParam, "columnID", param.getColumn() == null ? "" : param.getColumn().getID());
            this.addAttributeToNode(nodeParam, "subTableID", param.getSourceQuery().getBasicQuery().getID());
            this.addAttributeToNode(nodeParam, "subColumnID", param.getSourceColumn().getID());
            this.addAttributeToNode(nodeParam, "typeName", param.getTypeName());
            node.addContent((Content)nodeParam);
        }
    }

    private void addAttributeToNode(Element node, String attrName, String value) {
        if (!this.isEmptyString(value)) {
            node.setAttribute(attrName, value);
        }
    }

    private boolean isEmptyString(String value) {
        return value == null || value.trim().length() == 0;
    }

    private void buildGroupNode(Element node, List itemList) {
        Iterator iterItems = itemList.iterator();
        while (iterItems.hasNext()) {
            Element nodeItem = new Element("GroupItem", KDFXmlReader.NS_COMMON);
            QueryGroup.GroupItem item = (QueryGroup.GroupItem)iterItems.next();
            this.addAttributeToNode(nodeItem, "id", item.getID());
            this.addAttributeToNode(nodeItem, "name", item.getName());
            this.addAttributeToNode(nodeItem, "desc", String.valueOf(item.isDesc()));
            this.addAttributeToNode(nodeItem, "columnID", item.getColumn().getID());
            node.addContent((Content)nodeItem);
        }
    }

    private void buildSortsNode(Element node, List sortList) {
        for (QuerySort sort : sortList) {
            Element nodeSort = new Element("Sort", KDFXmlReader.NS_COMMON);
            this.addQueryElementProperty(nodeSort, sort);
            this.addAttributeToNode(nodeSort, "active", String.valueOf(sort.isActive()));
            Iterator iterItems = sort.getItemList().iterator();
            while (iterItems.hasNext()) {
                Element nodeItem = new Element("SortItem", KDFXmlReader.NS_COMMON);
                QuerySort.SortItem item = (QuerySort.SortItem)iterItems.next();
                this.addAttributeToNode(nodeItem, "id", item.getID());
                this.addAttributeToNode(nodeItem, "name", item.getName());
                this.addAttributeToNode(nodeItem, "desc", String.valueOf(item.isDesc()));
                this.addAttributeToNode(nodeItem, "columnID", item.getColumn().getID());
                Element nodeFormula = new Element("Formula", KDFXmlReader.NS_COMMON);
                nodeFormula.setText(item.getColumn().getFormula());
                nodeItem.addContent((Content)nodeFormula);
                Element nodeFormula4Sql = new Element("Formula4Sql", KDFXmlReader.NS_COMMON);
                nodeFormula4Sql.setText(item.getColumn().getFormula4Sql());
                nodeItem.addContent((Content)nodeFormula4Sql);
                nodeSort.addContent((Content)nodeItem);
            }
            node.addContent((Content)nodeSort);
        }
    }

    private void addQueryElementProperty(Element node, QueryElement obj) {
        this.addAttributeToNode(node, "id", obj.getID());
        this.addAttributeToNode(node, "name", obj.getName());
        this.setCommentNode(node, obj);
    }

    private void buildJoinsNode(Element node, List joinList) {
        for (QueryJoin join : joinList) {
            Element nodeJoin = new Element("Join", KDFXmlReader.NS_COMMON);
            this.addQueryElementProperty(nodeJoin, join);
            this.addAttributeToNode(nodeJoin, "type", String.valueOf(join.getType()));
            this.addAttributeToNode(nodeJoin, "active", String.valueOf(join.isActive()));
            this.addAttributeToNode(nodeJoin, "firstTableID", join.getFirstTable().getID());
            this.addAttributeToNode(nodeJoin, "secondTableID", join.getSecondTable().getID());
            Element nodeFormula = new Element("Formula", KDFXmlReader.NS_COMMON);
            nodeFormula.setText(join.getFormula());
            nodeJoin.addContent((Content)nodeFormula);
            Element nodeFormula4Sql = new Element("Formula4Sql", KDFXmlReader.NS_COMMON);
            nodeFormula4Sql.setText(join.getFormula4Sql());
            nodeJoin.addContent((Content)nodeFormula4Sql);
            node.addContent((Content)nodeJoin);
        }
    }

    private void buildFiltersNode(Element node, List filterList) {
        for (QueryFilter filter : filterList) {
            Element nodeFilter = new Element("Filter", KDFXmlReader.NS_COMMON);
            this.addQueryElementProperty(nodeFilter, filter);
            this.addAttributeToNode(nodeFilter, "active", String.valueOf(filter.isActive()));
            Element nodeFormula = new Element("Formula", KDFXmlReader.NS_COMMON);
            nodeFormula.setText(filter.getFormula());
            nodeFilter.addContent((Content)nodeFormula);
            Element nodeFormula4Sql = new Element("Formula4Sql", KDFXmlReader.NS_COMMON);
            nodeFormula4Sql.setText(filter.getFormula4Sql());
            nodeFilter.addContent((Content)nodeFormula4Sql);
            node.addContent((Content)nodeFilter);
        }
    }

    private void buildSubQuerysNode(Element node, List subList) {
        for (QueryTable table : subList) {
            Element nodeTable = new Element("SubQuery", KDFXmlReader.NS_COMMON);
            this.addQueryElementProperty(nodeTable, table);
            if (table.getBasicQuery() != null) {
                this.addAttributeToNode(nodeTable, "subQueryID", table.getBasicQuery().getID());
            } else if (StringUtil.isEmptyString((String)table.getSubQueryID())) {
                this.addAttributeToNode(nodeTable, "subQueryID", null);
            } else {
                this.addAttributeToNode(nodeTable, "subQueryID", table.getSubQueryID());
            }
            node.addContent((Content)nodeTable);
        }
    }

    private void setCommentNode(Element node, QueryElement ele) {
        if (!this.isEmptyString(ele.getComment())) {
            Element nodeComment = new Element("Comment", KDFXmlReader.NS_COMMON);
            nodeComment.setText(ele.getComment());
            node.addContent((Content)nodeComment);
        }
    }

    private void buildColumnsNode(Element node, KDBasicQuery query) {
        for (QueryColumn col : query.getColumnList()) {
            Element nodeCol = new Element("Column", KDFXmlReader.NS_COMMON);
            this.addQueryElementProperty(nodeCol, col);
            this.addAttributeToNode(nodeCol, "fieldID", col.getProgramID());
            this.addAttributeToNode(nodeCol, "type", col.getType() == null ? "STRING" : col.getType().toString());
            Element nodeFormula = new Element("Formula", KDFXmlReader.NS_COMMON);
            nodeFormula.setText(col.getFormula());
            nodeCol.addContent((Content)nodeFormula);
            Element nodeFormula4Sql = new Element("Formula4Sql", KDFXmlReader.NS_COMMON);
            nodeFormula4Sql.setText(col.getFormula4Sql());
            nodeCol.addContent((Content)nodeFormula4Sql);
            node.addContent((Content)nodeCol);
        }
    }

    public void save(String fileName) {
        File file = new File(fileName);
        try {
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file, false), "UTF-8");
            Format format = Format.getPrettyFormat();
            format.setEncoding("UTF-8");
            format.setIndent("    ");
            format.setOmitEncoding(true);
            format.setTextMode(Format.TextMode.TRIM_FULL_WHITE);
            XMLOutputter outter = new XMLOutputter(format);
            outter.output(this.getDoc(), (Writer)writer);
            writer.close();
        }
        catch (IOException err) {
            throw new RuntimeException("\u8bd5\u56fe\u5199\u6587\u4ef6[" + file.getName() + "]\u65f6\u51fa\u9519\uff0c\u672a\u80fd\u521b\u5efaFileWriter\u5bf9\u8c61");
        }
    }

    public void save(OutputStream os) {
        try {
            Format format = Format.getPrettyFormat();
            format.setEncoding("UTF-8");
            format.setIndent("    ");
            format.setOmitEncoding(true);
            XMLOutputter outter = new XMLOutputter(format);
            outter.output(this.getDoc(), os);
        }
        catch (IOException err) {
            throw new RuntimeException("\u6d41\u8f93\u51fa\u5931\u8d25\uff1a" + err.getMessage(), err);
        }
        catch (Exception err) {
            err.printStackTrace();
        }
    }

    public void save(Writer writer) {
        try {
            Format format = Format.getPrettyFormat();
            format.setEncoding("UTF-8");
            format.setIndent("    ");
            format.setOmitEncoding(true);
            format.setTextMode(Format.TextMode.TRIM_FULL_WHITE);
            XMLOutputter outter = new XMLOutputter(format);
            outter.output(this.getDoc(), writer);
        }
        catch (IOException err) {
            throw new RuntimeException("\u8f93\u51fa\u5931\u8d25\uff1a" + err.getMessage(), err);
        }
        catch (Exception err) {
            err.printStackTrace();
        }
    }

    public final Element getRoot() {
        if (this.root == null) {
            this.root = this.getDoc().getRootElement();
        }
        return this.root;
    }

    public final Document getDoc() {
        if (this.doc != null) {
            return this.doc;
        }
        try {
            SAXBuilder builder = new SAXBuilder("org.apache.xerces.parsers.SAXParser", false);
            this.doc = builder.build(this.source);
        }
        catch (JDOMException err) {
            throw new AssertionError((Object)("\u5206\u6790XML\u6e90\u51fa\u9519\uff0c\u7cfb\u7edf\u4fe1\u606f\uff1a" + err.getMessage()));
        }
        catch (IOException err) {
            throw new AssertionError((Object)("\u6587\u4ef6\u8bfb\u53d6\u5931\u8d25\uff0c\u7cfb\u7edf\u4fe1\u606f\uff1a" + err.getMessage()));
        }
        return this.doc;
    }

    private KDBasicQuery getQueryByID(String id) {
        return (KDBasicQuery)this.getQueryCache().get(id);
    }

    private QueryTable getTableByID(String id) {
        return (QueryTable)this.getTableCache().get(id);
    }

    private QueryColumn getColByID(String id) {
        return (QueryColumn)this.getColCache().get(id);
    }

    private void cacheQueryNodes(String id, Element node) {
        this.getNodeCache().put(id, node);
    }

    private void cacheQuerys(String id, KDBasicQuery query) {
        this.getQueryCache().put(id, query);
    }

    private void cacheTables(String id, QueryTable table) {
        this.getTableCache().put(id, table);
    }

    private void cacheCols(String id, QueryColumn column) {
        this.getColCache().put(id, column);
    }

    private HashMap getColCache() {
        if (this.colCache == null) {
            this.colCache = new HashMap();
        }
        return this.colCache;
    }

    private HashMap getTableCache() {
        if (this.tableCache == null) {
            this.tableCache = new HashMap();
        }
        return this.tableCache;
    }

    private HashMap getNodeCache() {
        if (this.nodeCache == null) {
            this.nodeCache = new HashMap();
        }
        return this.nodeCache;
    }

    private HashMap getQueryCache() {
        if (this.queryCache == null) {
            this.queryCache = new HashMap();
        }
        return this.queryCache;
    }

    public KDBasicQuery parseQuery(Element nodeQuery, HashMap sysHashMap, Object userObj) {
        this.sysHashMap = sysHashMap;
        return this.parseQuery(nodeQuery, userObj);
    }

    public KDBasicQuery parseQuery(Element nodeQuery, Object userObj) {
        String objTypeName = nodeQuery.getAttributeValue("objectClass");
        if (this.isEmptyString(objTypeName)) {
            throw new IllegalArgumentException("\u63d0\u4f9b\u7684XML\u6e90\u4fe1\u606f\u4e0d\u5b8c\u6574\uff0cQuery\u8282\u70b9\u7f3a\u5c11\u5173\u952e\u5c5e\u6027\uff1aobjectClass");
        }
        String id = nodeQuery.getAttributeValue("id");
        if (this.isEmptyString(id)) {
            throw new IllegalArgumentException("\u63d0\u4f9b\u7684XML\u6e90\u4fe1\u606f\u4e0d\u5b8c\u6574\uff0cQuery\u8282\u70b9\u7f3a\u5c11\u5173\u952e\u5c5e\u6027\uff1aid");
        }
        this.cacheQueryNodes(id, nodeQuery);
        KDQuery query = null;
        if (objTypeName.equalsIgnoreCase(OBJECT_CLASS_KDQUERY)) {
            query = this.parseKDQuery(nodeQuery);
            if (userObj != null) {
                query.setSource(((DataSource)userObj).getSource());
            }
        }
        if (query != null) {
            this.cacheQuerys(query.getID(), query);
        }
        return query;
    }

    private KDQuery parseKDQuery(Element nodeQuery) {
        String id = nodeQuery.getAttributeValue("id");
        String name = nodeQuery.getAttributeValue("name");
        String queryType = nodeQuery.getAttributeValue("queryType");
        if (this.isEmptyString(id) || this.isEmptyString(queryType) || this.isEmptyString(name)) {
            this.detectedFileBug();
        }
        KDQuery query = new KDQuery(id, name, Integer.parseInt(queryType));
        query.setLinked(Boolean.valueOf(nodeQuery.getAttributeValue("isLinked")));
        String isSelfDefine = nodeQuery.getAttributeValue("isSelfDefine");
        if (isSelfDefine != null) {
            query.setSelfDefine(Boolean.valueOf(isSelfDefine));
            if (query.isSelfDefine() && nodeQuery.getAttributeValue("selfDefineSql") != null) {
                query.setSelfDefineSQL(Base64.decodeToString((String)nodeQuery.getAttributeValue("selfDefineSql")));
            }
        }
        this.parseComment(query, nodeQuery);
        this.parseColumns(query, nodeQuery);
        this.parseKDQueryOthers(query, nodeQuery);
        return query;
    }

    private void parseKDQueryOthers(KDQuery query, Element nodeQuery) {
        this.parseSubQuerys(query, nodeQuery);
        this.parseJoins(query, nodeQuery);
        this.parseGroup(query, nodeQuery);
        this.parseFilters(query, nodeQuery);
        this.parseParams(query, nodeQuery);
        this.parseSorts(query, nodeQuery);
        this.getTableCache().clear();
    }

    private void parseJoins(KDQuery query, Element nodeQuery) {
        Element nodeJoins = nodeQuery.getChild("Joins", KDFXmlReader.NS_COMMON);
        if (nodeJoins == null) {
            return;
        }
        for (Element nodeJoin : nodeJoins.getChildren("Join", KDFXmlReader.NS_COMMON)) {
            String formula4Sql;
            Element nodeFormula4Sql;
            String formula;
            Element nodeFormula;
            String type = nodeJoin.getAttributeValue("type");
            String firstTableID = nodeJoin.getAttributeValue("firstTableID");
            String secondTableID = nodeJoin.getAttributeValue("secondTableID");
            if (this.isEmptyString(type) || this.isEmptyString(firstTableID) || this.isEmptyString(secondTableID)) {
                this.detectedFileBug();
            }
            QueryJoin join = new QueryJoin(null, null, Integer.parseInt(type));
            this.parseElementProperty(join, nodeJoin);
            QueryTable leftTab = this.getTableByID(firstTableID);
            join.setFirstTable(leftTab);
            QueryTable rightTab = this.getTableByID(secondTableID);
            join.setSecondTable(rightTab);
            String active = nodeJoin.getAttributeValue("active");
            if (!this.isEmptyString(active)) {
                join.setActive(Boolean.valueOf(active));
            }
            if (null != (nodeFormula = nodeJoin.getChild("Formula", KDFXmlReader.NS_COMMON)) && !this.isEmptyString(formula = nodeFormula.getText())) {
                join.setFormula(formula);
            }
            if (null != (nodeFormula4Sql = nodeJoin.getChild("Formula4Sql", KDFXmlReader.NS_COMMON)) && !this.isEmptyString(formula4Sql = nodeFormula4Sql.getText())) {
                join.setFormula4Sql(formula4Sql);
            }
            query.getJoinList().add(join);
        }
    }

    private void parseFilters(KDQuery query, Element nodeQuery) {
        Element nodeFilters = nodeQuery.getChild("Filters", KDFXmlReader.NS_COMMON);
        if (nodeFilters == null) {
            return;
        }
        for (Element nodeFilter : nodeFilters.getChildren("Filter", KDFXmlReader.NS_COMMON)) {
            String formula4Sql;
            Element nodeFormula4Sql;
            String formula;
            Element nodeFormula;
            QueryFilter filter = new QueryFilter(null, null);
            this.parseElementProperty(filter, nodeFilter);
            String active = nodeFilter.getAttributeValue("active");
            if (!this.isEmptyString(active)) {
                filter.setActive(Boolean.valueOf(active));
            }
            if ((nodeFormula = nodeFilter.getChild("Formula", KDFXmlReader.NS_COMMON)) != null && !this.isEmptyString(formula = nodeFormula.getText())) {
                filter.setFormula(formula);
            }
            if ((nodeFormula4Sql = nodeFilter.getChild("Formula4Sql", KDFXmlReader.NS_COMMON)) != null && !this.isEmptyString(formula4Sql = nodeFormula4Sql.getText())) {
                filter.setFormula4Sql(formula4Sql);
            }
            query.getFilterList().add(filter);
        }
    }

    private void parseParams(KDQuery query, Element nodeQuery) {
        Element nodeParams = nodeQuery.getChild("Params", KDFXmlReader.NS_COMMON);
        if (nodeParams == null) {
            return;
        }
        for (Element nodeParam : nodeParams.getChildren("Param", KDFXmlReader.NS_COMMON)) {
            String binding;
            String active;
            DoNotFindElement dnfe;
            String colID = nodeParam.getAttributeValue("columnID");
            String subTableID = nodeParam.getAttributeValue("subTableID");
            String subColID = nodeParam.getAttributeValue("subColumnID");
            String typeName = nodeParam.getAttributeValue("typeName");
            if (this.isEmptyString(colID) || this.isEmptyString(subColID)) {
                this.detectedFileBug();
            }
            KDBasicQuery bq = this.getQueryByID(subTableID);
            QueryColumn qc = this.getColByID(colID);
            QueryColumn qc2 = this.getColByID(subColID);
            QueryParam param = new QueryParam(null, null, qc, typeName, qc2);
            if (bq != null) {
                QueryTable qt = new QueryTable(KDDataManager.getID("queryTable", null), bq, bq.getName());
                param.setSourceQuery(qt);
            }
            if (bq == null) {
                dnfe = new DoNotFindElement(param, subTableID, 2);
                this.getLstDoNotFindElement().add(dnfe);
            }
            if (qc2 == null) {
                dnfe = new DoNotFindElement(param, subColID, 3);
                this.getLstDoNotFindElement().add(dnfe);
            }
            if (!this.isEmptyString(active = nodeParam.getAttributeValue("active"))) {
                param.setActive(Boolean.valueOf(active));
            }
            if (!this.isEmptyString(binding = nodeParam.getAttributeValue("binding"))) {
                param.setBinding(Boolean.valueOf(binding));
            }
            this.parseElementProperty(param, nodeParam);
            query.getParamList().add(param);
        }
    }

    private void parseSorts(KDQuery query, Element nodeQuery) {
        Element nodeSorts = nodeQuery.getChild("Sorts", KDFXmlReader.NS_COMMON);
        if (nodeSorts == null) {
            return;
        }
        for (Element nodeSort : nodeSorts.getChildren("Sort", KDFXmlReader.NS_COMMON)) {
            QuerySort sort = new QuerySort(null, null);
            this.parseElementProperty(sort, nodeSort);
            String active = nodeSort.getAttributeValue("active");
            if (!this.isEmptyString(active)) {
                sort.setActive(Boolean.valueOf(active));
            }
            for (Element nodeItem : nodeSort.getChildren("SortItem", KDFXmlReader.NS_COMMON)) {
                String formula4Sql;
                Element nodeFormula4Sql;
                String id = nodeItem.getAttributeValue("id");
                String colID = nodeItem.getAttributeValue("columnID");
                String name = nodeItem.getAttributeValue("name");
                if (this.isEmptyString(id) || this.isEmptyString(colID) || this.isEmptyString(name)) {
                    this.detectedFileBug();
                }
                String formula = null;
                Element nodeFormula = nodeItem.getChild("Formula", KDFXmlReader.NS_COMMON);
                if (nodeFormula != null) {
                    formula = nodeFormula.getText();
                }
                QueryColumn qryCln = null;
                String tableName = null;
                String fieldName = null;
                if (null != formula) {
                    tableName = formula.substring(formula.indexOf("[") + 1, formula.indexOf("].["));
                    fieldName = formula.substring(formula.indexOf("].[") + 3, formula.lastIndexOf("]"));
                }
                if (this.getColByID(colID) == null) {
                    Iterator itAllTabelID = this.getTableCache().keySet().iterator();
                    while (itAllTabelID.hasNext()) {
                        QueryTable table = this.getTableByID(itAllTabelID.next().toString());
                        for (QueryColumn col : table.getBasicQuery().getColumnList()) {
                            if (!StringUtil.equalsIgnoreCase((String)tableName, (String)table.getName()) || !StringUtil.equalsIgnoreCase((String)fieldName, (String)col.getName())) continue;
                            try {
                                qryCln = (QueryColumn)col.clone();
                            }
                            catch (CloneNotSupportedException e) {
                                e.printStackTrace();
                            }
                            break;
                        }
                        if (qryCln == null) continue;
                        break;
                    }
                    if (qryCln == null) {
                        this.detectedFileBug();
                    }
                } else {
                    try {
                        qryCln = (QueryColumn)this.getColByID(colID).clone();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        this.detectedFileBug();
                    }
                }
                QuerySort.SortItem item = new QuerySort.SortItem(id, name, qryCln);
                String desc = nodeItem.getAttributeValue("desc");
                if (!this.isEmptyString(desc)) {
                    item.setDesc(Boolean.valueOf(desc));
                }
                if (!this.isEmptyString(formula)) {
                    item.getColumn().setFormula(formula);
                }
                if ((nodeFormula4Sql = nodeItem.getChild("Formula4Sql", KDFXmlReader.NS_COMMON)) != null && !this.isEmptyString(formula4Sql = nodeFormula4Sql.getText())) {
                    item.getColumn().setFormula4Sql(formula4Sql);
                }
                sort.addItem(item);
            }
            query.getSortList().add(sort);
        }
    }

    private void parseSubQuerys(KDQuery query, Element nodeQuery) {
        Element nodeTables = nodeQuery.getChild("SubQuerys", KDFXmlReader.NS_COMMON);
        if (nodeTables == null) {
            return;
        }
        for (Element nodeTable : nodeTables.getChildren("SubQuery", KDFXmlReader.NS_COMMON)) {
            String subID = nodeTable.getAttributeValue("subQueryID");
            String name = nodeTable.getAttributeValue("name");
            if (this.isEmptyString(subID)) {
                throw new IllegalArgumentException("Error: The attribute 'subQueryID' of <SubQuery name = \"" + name + "\"> is empty!");
            }
            KDBasicQuery kdBasicQuery = this.getQueryByID(subID = this.upgrade(subID));
            if (kdBasicQuery == null && this.sysHashMap != null) {
                kdBasicQuery = (KDBasicQuery)this.sysHashMap.get(subID);
            }
            QueryTable table = new QueryTable(null, kdBasicQuery, null);
            if (kdBasicQuery == null) {
                DoNotFindElement dnfe = new DoNotFindElement(table, subID, 1);
                this.getLstDoNotFindElement().add(dnfe);
                table.setSubQueryID(subID);
            }
            this.parseElementProperty(table, nodeTable);
            this.cacheTables(table.getID(), table);
            query.getSubQueryList().add(table);
        }
    }

    private void parseGroup(KDQuery query, Element nodeQuery) {
        Element nodeGroup = nodeQuery.getChild("Group", KDFXmlReader.NS_COMMON);
        if (nodeGroup == null) {
            return;
        }
        for (Element nodeItem : nodeGroup.getChildren("GroupItem", KDFXmlReader.NS_COMMON)) {
            String id = nodeItem.getAttributeValue("id");
            String colID = nodeItem.getAttributeValue("columnID");
            String name = nodeItem.getAttributeValue("name");
            if (this.isEmptyString(id) || this.isEmptyString(colID) || this.isEmptyString(name)) {
                this.detectedFileBug();
            }
            QueryGroup.GroupItem item = new QueryGroup.GroupItem(id, name, this.getColByID(colID));
            String desc = nodeItem.getAttributeValue("desc");
            if (!this.isEmptyString(desc)) {
                item.setDesc(Boolean.valueOf(desc));
            }
            query.getGroupList().add(item);
        }
    }

    private void parseComment(KDBasicQuery query, Element nodeQuery) {
        String comment;
        Element nodeComment = nodeQuery.getChild("Comment", KDFXmlReader.NS_COMMON);
        if (nodeComment != null && !this.isEmptyString(comment = nodeComment.getText())) {
            query.setComment(comment);
        }
    }

    private void parseColumns(KDBasicQuery query, Element nodeQuery) {
        Element nodeCols = nodeQuery.getChild("Columns", KDFXmlReader.NS_COMMON);
        if (nodeCols == null) {
            return;
        }
        Iterator iter = nodeCols.getChildren("Column", KDFXmlReader.NS_COMMON).iterator();
        while (iter.hasNext()) {
            query.getColumnList().add(this.parseColumn(query, (Element)iter.next()));
        }
    }

    private void detectedFileBug() {
        throw new IllegalArgumentException("XML\u6587\u4ef6\u5185\u5bb9\u5df2\u7ecf\u88ab\u7834\u574f");
    }

    private QueryColumn parseColumn(KDBasicQuery query, Element nodeColumn) {
        String formula4Sql;
        Element nodeFormula4Sql;
        String formula;
        QueryColumn col = new QueryColumn(null, null, null, null);
        this.parseElementProperty(col, nodeColumn);
        String fieldID = nodeColumn.getAttributeValue("fieldID");
        col.setProgramID(StringUtil.isEmptyString((String)fieldID) ? col.getName() : fieldID);
        String type = nodeColumn.getAttributeValue("type");
        col.setType(StringUtil.isEmptyString((String)type) ? SqlType.STRING : SqlType.instance(type));
        Element nodeFormula = nodeColumn.getChild("Formula", KDFXmlReader.NS_COMMON);
        if (nodeFormula != null && !this.isEmptyString(formula = nodeFormula.getText())) {
            col.setFormula(formula);
        }
        if ((nodeFormula4Sql = nodeColumn.getChild("Formula4Sql", KDFXmlReader.NS_COMMON)) != null && !this.isEmptyString(formula4Sql = nodeFormula4Sql.getText())) {
            col.setFormula4Sql(formula4Sql);
        }
        this.cacheCols(col.getID(), col);
        return col;
    }

    private void parseElementProperty(QueryElement ele, Element node) {
        String id = node.getAttributeValue("id");
        String name = node.getAttributeValue("name");
        if (this.isEmptyString(id)) {
            this.detectedFileBug();
        }
        ele.setID(id);
        ele.setName(name);
        this.parseElementComment(ele, node);
    }

    private void parseElementComment(QueryElement ele, Element node) {
        String comment;
        Element nodeComment = node.getChild("Comment", KDFXmlReader.NS_COMMON);
        if (nodeComment != null && !this.isEmptyString(comment = nodeComment.getText())) {
            ele.setComment(comment);
        }
    }

    public void clear() {
        this.getRoot().removeChildren("Dir", this.getRoot().getNamespace());
        this.getRoot().removeChildren("Query", this.getRoot().getNamespace());
    }

    public void setTreeRoot(QueryDir root) {
        this.getRoot().removeChildren("Dir", KDFXmlReader.NS_COMMON);
        this.getRoot().removeChildren("Query", KDFXmlReader.NS_COMMON);
        this.buildSubTree(this.getRoot(), root);
    }

    protected void buildSubTree(Element nodeRoot, QueryDir root) {
        Iterator iter = root.iterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (obj instanceof QueryDir) {
                Element node = new Element("Dir", nodeRoot.getNamespace());
                QueryDir dir = (QueryDir)obj;
                this.addAttributeToNode(node, "name", dir.getName());
                this.addAttributeToNode(node, "alias", dir.getAlias());
                this.addAttributeToNode(node, "comment", dir.getComment());
                this.buildSubTree(node, (QueryDir)obj);
                nodeRoot.addContent((Content)node);
                continue;
            }
            if (!(obj instanceof KDBasicQuery)) continue;
            Element nodeQuery = this.createQueryNode((KDBasicQuery)obj);
            nodeRoot.addContent((Content)nodeQuery);
        }
    }

    public QueryDir getTreeRoot(String fileName, HashMap sysHashMap, QueryDir root) {
        this.sysHashMap = sysHashMap;
        this.fillDir(this.getRoot(), root, fileName);
        return root;
    }

    protected void fillDir(Element nodeDir, QueryDir dir, String fileName) {
        for (Element node : nodeDir.getChildren()) {
            KDBasicQuery qry;
            if (node.getName().equals("Dir")) {
                String comment;
                String name = node.getAttributeValue("name");
                if (this.isEmptyString(name)) break;
                QueryDir subDir = new QueryDir(KDDataManager.getID("QueryDir", null), name);
                String alias = node.getAttributeValue("alias");
                if (!this.isEmptyString(alias)) {
                    subDir.setAlias(alias);
                }
                if (!this.isEmptyString(comment = node.getAttributeValue("comment"))) {
                    subDir.setComment(comment);
                }
                this.fillDir(node, subDir, fileName);
                dir.add(subDir);
                continue;
            }
            if (!node.getName().equals("DesignedDataSource") || (qry = this.parseQuery(node, null)) == null) continue;
            dir.add(qry);
        }
        this.manageDoNotFindElement();
    }

    public void manageDoNotFindElement() {
        for (DoNotFindElement dnfe : this.getLstDoNotFindElement()) {
            QueryParam qp;
            if (dnfe.getType() == 1) {
                QueryTable qt = (QueryTable)dnfe.getElement();
                qt.setBasicQuery(this.getQueryByID(dnfe.getElementID()));
                continue;
            }
            if (dnfe.getType() == 2) {
                qp = (QueryParam)dnfe.getElement();
                KDBasicQuery bq = this.getQueryByID(dnfe.getElementID());
                QueryTable qt = new QueryTable(KDDataManager.getID("queryTable", null), bq, bq.getName());
                qp.setSourceQuery(qt);
                continue;
            }
            if (dnfe.getType() != 3) continue;
            qp = (QueryParam)dnfe.getElement();
            qp.setSourceColumn(this.getColByID(dnfe.getElementID()));
        }
    }

    public LinkedList getLstDoNotFindElement() {
        if (this.lstDoNotFindElement == null) {
            this.lstDoNotFindElement = new LinkedList();
        }
        return this.lstDoNotFindElement;
    }

    private String upgrade(String oldSubID) {
        if (oldSubID.matches("^[^\\+]{1,}\\+[^\\+]{1,}\\+[^\\+]{1,}$")) {
            int firstPlus = oldSubID.indexOf("+");
            String newSubID = oldSubID.substring(firstPlus + 1);
            return newSubID.replaceFirst("\\+", "/");
        }
        return oldSubID;
    }

    private static final class DoNotFindElement {
        Object element;
        String elementID;
        int type;

        DoNotFindElement(Object element, String elementID, int type) {
            this.element = element;
            this.elementID = elementID;
            this.type = type;
        }

        public Object getElement() {
            return this.element;
        }

        public String getElementID() {
            return this.elementID;
        }

        public int getType() {
            return this.type;
        }

        public void setElement(Object element) {
            this.element = element;
        }
    }
}

