/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.excel;

import com.kingdee.bos.ctrl.kdf.excel.AbstractDataWrapper;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class MultiPartMergeData {
    private static final String FROMATE_COL_STRING = "col=%d;col2=%d";
    private static final ThreadLocal<MultiPartMergeData> LOCAL = new ThreadLocal<MultiPartMergeData>(){

        @Override
        public MultiPartMergeData initialValue() {
            return new MultiPartMergeData();
        }
    };
    private Map<String, List<AbstractDataWrapper.MergeBlock>> blockMap = new LinkedHashMap<String, List<AbstractDataWrapper.MergeBlock>>();

    public static final MultiPartMergeData getData() {
        return LOCAL.get();
    }

    public String getKey(AbstractDataWrapper.MergeBlock b) {
        return this.getColKey(b.getGpCol1(), b.getGpCol2());
    }

    private String getColKey(int col, int col2) {
        return String.format(FROMATE_COL_STRING, col, col2);
    }

    public boolean merge(AbstractDataWrapper.MergeBlock block) {
        AbstractDataWrapper.MergeBlock b = block;
        boolean flag = false;
        if (null != b) {
            List<AbstractDataWrapper.MergeBlock> blocks = this.blockMap.get(this.getKey(b));
            if (null != blocks) {
                if (!blocks.isEmpty()) {
                    AbstractDataWrapper.MergeBlock tail = blocks.get(blocks.size() - 1);
                    if (this.checkParentCanMerge(block) && this.checkCanMerge(tail, b)) {
                        b = tail.merge(b);
                        blocks.remove(blocks.size() - 1);
                        flag = true;
                    }
                }
                blocks.add(b);
            } else {
                this.addBlock(b);
            }
        }
        return flag;
    }

    public boolean checkParentCanMerge(AbstractDataWrapper.MergeBlock b) {
        for (int i = b.getGpCol1() - 1; i >= 0; --i) {
            String key = this.getColKey(i, i);
            List<AbstractDataWrapper.MergeBlock> pre = this.blockMap.get(key);
            if (null == pre) continue;
            AbstractDataWrapper.MergeBlock tail = pre.get(pre.size() - 1);
            return tail.getRow() < b.getRow();
        }
        return true;
    }

    public List<AbstractDataWrapper.MergeBlock> getBlocks(AbstractDataWrapper.MergeBlock b) {
        if (null == b) {
            return new ArrayList<AbstractDataWrapper.MergeBlock>();
        }
        return this.blockMap.get(this.getKey(b));
    }

    public AbstractDataWrapper.MergeBlock getMergeBlockContains(int row1, int col1, int row2, int col2) {
        List<AbstractDataWrapper.MergeBlock> blocks = this.blockMap.get(this.getColKey(col1, col2));
        if (null != blocks && !blocks.isEmpty()) {
            for (int i = blocks.size() - 1; i >= 0; --i) {
                AbstractDataWrapper.MergeBlock block = blocks.get(i);
                if (!block.contains(row1, col1, row2, col2)) continue;
                return blocks.get(i);
            }
        }
        return null;
    }

    public List<AbstractDataWrapper.MergeBlock> getBlocks(int col1, int col2) {
        return this.blockMap.get(this.getColKey(col1, col2));
    }

    public AbstractDataWrapper.MergeBlock getLastBlock(int col1, int col2) {
        List<AbstractDataWrapper.MergeBlock> mergeBlocks = this.getBlocks(col1, col2);
        if (null != mergeBlocks && !mergeBlocks.isEmpty()) {
            return mergeBlocks.get(mergeBlocks.size() - 1);
        }
        return null;
    }

    private boolean checkCanMerge(AbstractDataWrapper.MergeBlock a, AbstractDataWrapper.MergeBlock b) {
        return a.getRow2() >= b.getRow() - 1 && a.getGroup().equals(b.getGroup());
    }

    public AbstractDataWrapper.MergeBlock getMergeBlock(int row, int col, int row2, int col2, String group) {
        AbstractDataWrapper.MergeBlock block = AbstractDataWrapper.getMergeBlock(row, col, row2, col2);
        block.setGroup(group);
        return new AbstractDataWrapper.MergeBlock(block);
    }

    public void addBlock(AbstractDataWrapper.MergeBlock b) {
        if (null == b) {
            return;
        }
        List<AbstractDataWrapper.MergeBlock> blcoks = this.blockMap.get(this.getKey(b));
        if (null == blcoks) {
            blcoks = new ArrayList<AbstractDataWrapper.MergeBlock>();
            this.blockMap.put(this.getKey(b), blcoks);
        }
        blcoks.add(b);
    }

    public List<AbstractDataWrapper.MergeBlock> getAllBlocks() {
        ArrayList<AbstractDataWrapper.MergeBlock> result = new ArrayList<AbstractDataWrapper.MergeBlock>();
        for (Map.Entry<String, List<AbstractDataWrapper.MergeBlock>> entry : this.blockMap.entrySet()) {
            for (AbstractDataWrapper.MergeBlock block : entry.getValue()) {
                result.add(block);
            }
        }
        return result;
    }

    public Map<String, List<AbstractDataWrapper.MergeBlock>> getBlockMap() {
        return this.blockMap;
    }

    public void clear() {
        this.blockMap.clear();
        LOCAL.remove();
    }
}

