/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.export;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.common.util.UnitConverter;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.MergeBlocks;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.Span;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.kdf.kds.KDSCell;
import com.kingdee.bos.ctrl.kdf.kds.KDSMergeBlock;
import com.kingdee.bos.ctrl.kdf.kds.KDSSheet;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;

public class KDSBookToBook {
    public static Book traslate(KDSBook kdsbook) {
        Book book = Book.Manager.getNewBook(null, (int)0);
        KDSBookToBook.traslate(kdsbook, book);
        return book;
    }

    public static void traslate(KDSBook kdsbook, Book book) {
        if (book == null) {
            book = Book.Manager.getNewBook((String)"", (int)0);
        }
        book.setAutoCalculate(false);
        book.getUndoManager().enable(false);
        book.setSkipListeners(true);
        int count = kdsbook.getSheetCount();
        for (int i = 0; i < count; ++i) {
            KDSSheet kdssheet = kdsbook.getSheet(new Integer(i));
            if (kdssheet == null) continue;
            Sheet sheet = new Sheet(book, kdssheet.getName());
            book.addSheet(sheet, i == 0);
            KDSBookToBook.traslateSheet(kdssheet, sheet);
        }
        book.updatePendingSheet();
        book.clearEmptyCells();
        book.setAutoCalculate(true);
        book.getUndoManager().enable(true);
        book.setSkipListeners(false);
        KDSBookToBook.buildBorders(book);
    }

    private static void buildBorders(Book book) {
        int sheetCount = book.getSheetCount();
        for (int i = 0; i < sheetCount; ++i) {
            Sheet sheet = book.getSheet(i);
            sheet.createCellsFromBorders(sheet.getBorders().getRoot(true), CellBlock.getNewCellBlock((int)0, (int)0, (int)1048575, (int)16383), true, 0, 0);
            sheet.createCellsFromBorders(sheet.getBorders().getRoot(false), CellBlock.getNewCellBlock((int)0, (int)0, (int)1048575, (int)16383), false, 0, 0);
        }
    }

    private static void traslateSheet(KDSSheet kdssheet, Sheet sheet) {
        KDSBookToBook.translateColumns(kdssheet, sheet);
        KDSBookToBook.translateRows(kdssheet, sheet);
        KDSBookToBook.translateCells(kdssheet, sheet);
        KDSBookToBook.translateMerger(kdssheet, sheet);
    }

    private static void translateColumns(KDSSheet kdssheet, Sheet sheet) {
        int size = kdssheet.getExpandedColumns() + 1;
        for (int i = 0; i < size; ++i) {
            double colWidth = UnitConverter.mmToPx((double)kdssheet.getColumnWidth(i));
            sheet.getColSpans().setSpanAttribute(new Span(i, i), kdssheet.getColumnShareStyleAttributes(i), colWidth <= 0.0 ? null : new Integer((int)colWidth), null, null, null, false);
        }
    }

    private static void translateRows(KDSSheet kdssheet, Sheet sheet) {
        int size = kdssheet.getExpandedRows() + 1;
        for (int i = 0; i < size; ++i) {
            double rowHeight = UnitConverter.mmToPx((double)kdssheet.getRowHeight(i));
            sheet.getRowSpans().setSpanAttribute(new Span(i, i), kdssheet.getRowShareStyleAttributes(i), rowHeight <= 0.0 ? null : new Integer((int)rowHeight), null, null, null, false);
        }
    }

    private static boolean isKDTableFormatStr(String str) {
        if (str.startsWith("%")) {
            return true;
        }
        if (str.startsWith("$L") || str.startsWith("$U") || str.startsWith("$P")) {
            return true;
        }
        if (str.startsWith("@") && str.length() > 1) {
            return true;
        }
        return KDSBookToBook.getCharCount(str, ';') > 3;
    }

    private static int getCharCount(String str, char c) {
        int count = 0;
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) != c) continue;
            ++count;
        }
        return count;
    }

    private static void translateCells(KDSSheet kdssheet, Sheet sheet) {
        int colCount = kdssheet.getExpandedColumns() + 1;
        int rowCount = kdssheet.getExpandedRows() + 1;
        for (int i = 0; i < rowCount; ++i) {
            for (int j = 0; j < colCount; ++j) {
                StyleAttributes sa;
                Object value;
                KDSMergeBlock smb;
                KDSCell kdscell = kdssheet.getCell(i, j, false);
                if (kdscell == null || (smb = kdssheet.getMerges().getMergeBlock(i, j)) != KDSMergeBlock.NULL_MERGE && (smb.row != i || smb.col != j)) continue;
                Cell cell = sheet.getCell(i, j, true);
                cell.setSSA(kdscell.getSSA());
                String formula = kdscell.getFormula();
                if (!StringUtil.isEmptyString((String)formula)) {
                    if (formula.charAt(0) != '=') {
                        formula = "=" + formula;
                    }
                    cell.setFormula(formula);
                }
                if ((value = kdscell.getValue()) instanceof String) {
                    if (!StringUtil.isEmptyString((String)((String)value))) {
                        String fmt;
                        String string = fmt = kdscell.getStyle() == null ? null : kdscell.getStyle().getNumberFormat();
                        if (kdscell.getType() == 1 && StringUtil.isEmptyString((String)fmt)) {
                            fmt = "@";
                        }
                        boolean parseDate = kdscell.getType() == 6;
                        Variant var = Cell.parseValue((String)((String)value), (String)fmt, (boolean)parseDate);
                        cell.setValue(var);
                    }
                } else if (value != null) {
                    Variant var;
                    switch (kdscell.getType()) {
                        case 0: {
                            value = new BigDecimal(((Number)value).doubleValue());
                            var = new Variant(value, 10);
                            break;
                        }
                        case 1: {
                            var = new Variant(value, 11);
                            break;
                        }
                        case 6: {
                            Calendar cal = Calendar.getInstance();
                            if (value instanceof Calendar) {
                                cal = (Calendar)value;
                            } else if (value instanceof java.util.Date) {
                                cal.setTime((java.util.Date)value);
                            }
                            var = new Variant((Object)cal, 13);
                            break;
                        }
                        case 4: {
                            var = new Variant(value, 8);
                            break;
                        }
                        default: {
                            var = new Variant(value);
                        }
                    }
                    cell.setValue(var);
                } else {
                    cell.setValue(new Variant(value));
                }
                if (kdscell.getSSA().getNumberFormat() != null && KDSBookToBook.isKDTableFormatStr(kdscell.getSSA().getNumberFormat())) {
                    sa = Styles.getSA((ShareStyleAttributes)cell.getSSA());
                    sa.setNumberFormat(null);
                    cell.setSSA((ShareStyleAttributes)sa);
                }
                if (cell.getValue() == null || !(cell.getValue().getValue() instanceof Date) && !(cell.getValue().getValue() instanceof java.util.Date) && !(cell.getValue().getValue() instanceof Calendar)) continue;
                sa = Styles.getSA((ShareStyleAttributes)cell.getSSA());
                sa.setNumberFormat("yyyy-mm-dd");
                cell.setSSA((ShareStyleAttributes)sa);
            }
        }
    }

    private static void translateMerger(KDSSheet kdssheet, Sheet sheet) {
        MergeBlocks merger = null;
        Iterator iter = kdssheet.getMerges().iterator();
        if (kdssheet.isDoCrossTest()) {
            while (iter.hasNext()) {
                KDSMergeBlock block = (KDSMergeBlock)iter.next();
                if (merger == null) {
                    merger = sheet.getSheetOption().getMerger(true);
                }
                merger.insert((Object)CellBlock.getNewCellBlock((int)block.row, (int)block.col, (int)block.getRow2(), (int)block.getCol2()));
            }
        } else {
            ArrayList<CellBlock> list = new ArrayList<CellBlock>();
            while (iter.hasNext()) {
                KDSMergeBlock block = (KDSMergeBlock)iter.next();
                list.add(CellBlock.getNewCellBlock((int)block.row, (int)block.col, (int)block.getRow2(), (int)block.getCol2()));
            }
            if (merger == null) {
                merger = sheet.getSheetOption().getMerger(true);
            }
            merger.setArray(list.toArray());
        }
    }
}

