/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.export;

import com.kingdee.bos.ctrl.kdf.export.AbstractExporter;
import com.kingdee.bos.ctrl.kdf.export.ExporterParameter;
import com.kingdee.bos.ctrl.kdf.export.RtfExporterParameter;
import com.kingdee.bos.ctrl.kdf.kds.KDSCell;
import com.kingdee.bos.ctrl.kdf.kds.KDSMergeBlock;
import com.kingdee.bos.ctrl.kdf.kds.KDSSheet;
import com.kingdee.bos.ctrl.kdf.util.CloseUtil;
import com.kingdee.bos.ctrl.kdf.util.printout.IndexedPage;
import com.kingdee.bos.ctrl.kdf.util.printout.PrintableBook;
import com.kingdee.bos.ctrl.kdf.util.render.layout.TextLineBreaker;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.kdf.util.style.StyleUtil;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDFont;
import com.lowagie.text.BadElementException;
import com.lowagie.text.Cell;
import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Image;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.Table;
import com.lowagie.text.rtf.RtfWriter2;
import com.lowagie.text.rtf.style.RtfFont;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.TextMeasurer;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.Iterator;
import javax.imageio.ImageIO;

public final class RtfExporter
extends AbstractExporter {
    private PrintableBook printkds = null;
    private Document document = null;
    private boolean isOutTable = true;
    private boolean isFirstPage = true;
    private RtfFont defaultblankft = null;
    private Font defaultawtft = null;
    private float defaultftblankWidth = 0.0f;
    private Graphics g = null;

    private void init() {
        BufferedImage bi = new BufferedImage(1, 1, 1);
        this.defaultblankft = new RtfFont("Times Roman", 9.0f);
        this.g = bi.getGraphics();
        this.defaultftblankWidth = 5.0f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void export() {
        block10: {
            OutputStream os;
            this.printkds = (PrintableBook)this.parameters.get(ExporterParameter.KD_Print);
            Boolean isOutTable = (Boolean)this.parameters.get(RtfExporterParameter.IS_OUTTABLE);
            if (isOutTable != null) {
                this.isOutTable = isOutTable;
            }
            if ((os = (OutputStream)this.parameters.get(ExporterParameter.OUTPUT_STREAM)) != null) {
                this.exportToStream(os);
            } else {
                String fileName;
                File destFile = (File)this.parameters.get(ExporterParameter.OUTPUT_FILE);
                if (destFile == null && (fileName = (String)this.parameters.get(ExporterParameter.OUTPUT_FILE_NAME)) != null) {
                    destFile = new File(fileName);
                }
                os = new FileOutputStream(destFile);
                this.exportToStream(os);
                os.flush();
                CloseUtil.close((Closeable[])new Closeable[]{os});
            }
            break block10;
            catch (FileNotFoundException e) {
                e.printStackTrace();
                CloseUtil.close((Closeable[])new Closeable[]{os});
            }
            catch (IOException e2) {
                e2.printStackTrace();
                {
                    catch (Throwable throwable) {
                        CloseUtil.close((Closeable[])new Closeable[]{os});
                        throw throwable;
                    }
                }
                CloseUtil.close((Closeable[])new Closeable[]{os});
            }
        }
    }

    private void exportToStream(OutputStream os) {
        float[] pagesize = this.printkds.getPaperSize();
        Rectangle rc = new Rectangle((float)StyleUtil.lomToPt((double)(pagesize[0] * 10.0f)), (float)StyleUtil.lomToPt((double)(pagesize[1] * 10.0f)));
        float[] margin = this.printkds.getMargin();
        this.init();
        this.document = new Document(rc, (float)StyleUtil.lomToPt((double)(margin[2] * 10.0f)), (float)StyleUtil.lomToPt((double)(margin[3] * 10.0f)), (float)StyleUtil.lomToPt((double)(margin[0] * 10.0f)), (float)StyleUtil.lomToPt((double)(margin[1] * 10.0f)));
        RtfWriter2.getInstance((Document)this.document, (OutputStream)os);
        this.document.open();
        ArrayList pages = this.printkds.getIndexedPagesNoSavePaper();
        this.pagesToDocument(pages);
        this.document.close();
    }

    private void pagesToDocument(ArrayList pages) {
        if (pages != null && pages.size() > 0) {
            IndexedPage page = null;
            for (int i = 0; i < pages.size(); ++i) {
                page = (IndexedPage)pages.get(i);
                try {
                    if (this.isFirstPage) {
                        this.isFirstPage = false;
                    } else {
                        this.document.newPage();
                    }
                    if (this.isOutTable) {
                        this.exportPage(page);
                        continue;
                    }
                    this.exportPageNoTable(page);
                    continue;
                }
                catch (DocumentException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void exportPage(IndexedPage page) throws DocumentException, IOException {
        IndexedPage.PageBlock pb = (IndexedPage.PageBlock)page.getListBlocks().get(0);
        KDSSheet sheet = pb.getSheet();
        int cols = pb.getEndCol() - pb.getBeginCol();
        int rows = pb.getEndRow() - pb.getBeginRow();
        Table aTable = new Table(cols, rows);
        aTable.setAutoFillEmptyCells(true);
        float[] pagesize = this.printkds.getPaperSize();
        int beginRow = pb.getBeginRow();
        int beginCol = pb.getBeginCol();
        float[] widths = new float[cols];
        float abswidths = 0.0f;
        for (int i = 0; i < cols; ++i) {
            widths[i] = sheet.getColumnWidth(i + beginCol);
            abswidths += widths[i];
        }
        float[] heights = new float[rows];
        for (int i = 0; i < rows; ++i) {
            heights[i] = (float)StyleUtil.lomToPt((double)(sheet.getRowHeight(i + beginRow) * 10.0f));
        }
        aTable.setAlignment(0);
        aTable.setWidth(abswidths / pagesize[0] * 100.0f);
        aTable.setWidths(widths);
        aTable.setBorder(0);
        aTable.setAutoFillEmptyCells(false);
        Cell blankcell = new Cell("");
        this.exportCellsToTable(sheet, cols, rows, aTable, beginRow, beginCol, blankcell);
        this.document.add((Element)aTable);
    }

    private void exportCellsToTable(KDSSheet sheet, int cols, int rows, Table aTable, int beginRow, int beginCol, Cell blankcell) throws BadElementException {
        for (int i = 0; i < cols; ++i) {
            for (int j = 0; j < rows; ++j) {
                if (sheet.getCell(j + beginRow, i + beginCol, false) != null) {
                    KDSCell kdscell = sheet.getCell(j + beginRow, i + beginCol, false);
                    if (kdscell.isMerged()) {
                        Iterator it = sheet.getMerges().iterator();
                        while (it.hasNext()) {
                            KDSMergeBlock merge = (KDSMergeBlock)it.next();
                            if (!merge.include(j + beginRow, i + beginCol) || i + beginCol != merge.col || j + beginRow != merge.row) continue;
                            Cell cell = this.kdsToRtfCell(kdscell);
                            cell.setColspan(merge.getWidth());
                            cell.setRowspan(merge.getHeight());
                            aTable.addCell(cell, j, i);
                        }
                        continue;
                    }
                    Cell cell = this.kdsToRtfCell(kdscell);
                    aTable.addCell(cell, j, i);
                    continue;
                }
                aTable.addCell(blankcell, j, i);
            }
        }
    }

    private void exportPageNoTable(IndexedPage page) throws DocumentException, IOException {
        IndexedPage.PageBlock pb = (IndexedPage.PageBlock)page.getListBlocks().get(0);
        KDSSheet sheet = pb.getSheet();
        int rows = pb.getEndRow() - pb.getBeginRow();
        RtfSheet table = new RtfSheet(sheet, pb);
        for (int i = 0; i < rows; ++i) {
            RtfRow row = table.getRtfRow(i);
            int paracounts = row.emulaterows;
            for (int j = 0; j < paracounts; ++j) {
                Paragraph paragraphs = this.getParagraphs(row, j);
                this.document.add((Element)paragraphs);
            }
        }
    }

    private Paragraph getParagraphs(RtfRow row, int elmulateRow) {
        int blockcount = row.getBlocks().length;
        Paragraph paragraph = new Paragraph();
        for (int i = 0; i < blockcount; ++i) {
            Phrase phrase;
            RtfBlock block = row.getBlocks()[i];
            if (!block.isUsed()) continue;
            try {
                String strtext = this.getLineString(elmulateRow, row.emulaterows, block);
                phrase = this.getSizedPhrase(strtext, block);
                paragraph.add((Element)phrase);
                continue;
            }
            catch (Exception e) {
                phrase = this.getEmulateBlank(block.width);
                paragraph.add((Element)phrase);
            }
        }
        return paragraph;
    }

    private String getLineString(int emulaterow, int totolrows, RtfBlock block) {
        String strRet = "";
        strRet = block.ssa.isWrapText() ? this.getLineFromMultString(emulaterow, totolrows, block) : this.getLineFromSingleString(emulaterow, totolrows, block);
        return strRet;
    }

    private String getLineFromSingleString(int emulaterow, int totolrows, RtfBlock block) {
        String strRet = "";
        Styles.VerticalAlignment align = block.ssa.getVerticalAlign();
        if (align == Styles.VerticalAlignment.TOP) {
            if (emulaterow == 0) {
                strRet = this.getSimpleText((String)block.datas.get(0));
            }
        } else if (align == Styles.VerticalAlignment.MIDDLE) {
            if (emulaterow == totolrows / 2) {
                strRet = this.getSimpleText((String)block.datas.get(0));
            }
        } else if (align == Styles.VerticalAlignment.BOTTOM && emulaterow == totolrows - 1) {
            strRet = this.getSimpleText((String)block.datas.get(0));
        }
        return strRet;
    }

    private String getLineFromMultString(int emulaterow, int totolrows, RtfBlock block) {
        String strRet = "";
        Styles.VerticalAlignment align = block.ssa.getVerticalAlign();
        try {
            if (align == Styles.VerticalAlignment.TOP) {
                strRet = (String)block.datas.get(emulaterow);
            } else if (align == Styles.VerticalAlignment.MIDDLE) {
                strRet = (String)block.datas.get((block.datas.size() - totolrows) / 2 + emulaterow);
            } else if (align == Styles.VerticalAlignment.BOTTOM) {
                strRet = (String)block.datas.get(block.datas.size() + emulaterow - totolrows);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return strRet;
    }

    private String getSimpleText(String strtext) {
        String strRet = strtext;
        int returnPos = strtext.indexOf(13);
        if (returnPos != -1) {
            strRet = strtext.substring(0, returnPos);
        }
        return strRet;
    }

    private Phrase getSizedPhrase(String strtext, RtfBlock block) {
        Phrase pharse = new Phrase();
        int cellWidth = block.width;
        this.defaultawtft = new Font("\u5b8b\u4f53", 0, (int)StyleUtil.ptToPixel((double)block.ssa.getFontSize()));
        FontMetrics fm = this.g.getFontMetrics(this.defaultawtft);
        int strWidth = fm.stringWidth(strtext);
        if (strWidth > cellWidth) {
            this.getSizePhraseFromLongStirng(strtext, pharse, block, cellWidth, strWidth);
        } else {
            Chunk chunk = new Chunk(strtext, this.kdFont2iTextFont(block.ssa));
            if (strWidth == cellWidth) {
                pharse.add((Element)chunk);
            } else {
                this.getSizePhraseShortString(pharse, block.ssa, cellWidth, strWidth, chunk);
            }
        }
        return pharse;
    }

    private void getSizePhraseShortString(Phrase pharse, ShareStyleAttributes ssa, int cellWidth, int strWidth, Chunk chunk) {
        Styles.HorizontalAlignment align = ssa.getHorizontalAlign();
        if (align == Styles.HorizontalAlignment.LEFT) {
            Phrase blankphrase = this.getEmulateBlank(cellWidth - strWidth);
            pharse.add((Element)chunk);
            pharse.add((Element)blankphrase);
        } else if (align == Styles.HorizontalAlignment.CENTER) {
            Phrase blankphrase1 = this.getEmulateBlank((cellWidth - strWidth) / 2);
            pharse.add((Element)blankphrase1);
            pharse.add((Element)chunk);
            Phrase blankphrase2 = this.getEmulateBlank((cellWidth - strWidth) / 2);
            pharse.add((Element)blankphrase2);
        } else if (align == Styles.HorizontalAlignment.RIGHT) {
            Phrase blankphrase = this.getEmulateBlank(cellWidth - strWidth);
            pharse.add((Element)blankphrase);
            pharse.add((Element)chunk);
        }
    }

    private void getSizePhraseFromLongStirng(String strtext, Phrase pharse, RtfBlock block, int cellWidth, int strWidth) {
        int count = strtext.length() * cellWidth / strWidth;
        Styles.HorizontalAlignment align = block.ssa.getHorizontalAlign();
        if (align == Styles.HorizontalAlignment.LEFT) {
            Chunk chunk = new Chunk(strtext.substring(0, count - 1), this.kdFont2iTextFont(block.ssa));
            pharse.add((Element)chunk);
        } else if (align == Styles.HorizontalAlignment.CENTER) {
            Chunk chunk = new Chunk(strtext.substring((strtext.length() - count) / 2, (strtext.length() + count) / 2), this.kdFont2iTextFont(block.ssa));
            pharse.add((Element)chunk);
        } else if (align == Styles.HorizontalAlignment.RIGHT) {
            Chunk chunk = new Chunk(strtext.substring(strtext.length() - count), this.kdFont2iTextFont(block.ssa));
            pharse.add((Element)chunk);
        }
    }

    private com.lowagie.text.Font kdFont2iTextFont(ShareStyleAttributes ssa) {
        int style = 0;
        if (ssa.isBold()) {
            style |= 1;
        }
        if (ssa.isItalic()) {
            style |= 2;
        }
        if (ssa.isUnderline()) {
            style |= 4;
        }
        RtfFont rtfft = new RtfFont("\u5b8b\u4f53", (float)ssa.getFontSize(), style, ssa.getFontColor());
        return rtfft;
    }

    private Phrase getEmulateBlank(int width) {
        StringBuffer sb = new StringBuffer();
        for (int count = (int)((float)width / this.defaultftblankWidth); count > 0; --count) {
            sb.append(" ");
        }
        Phrase phrase = new Phrase(sb.toString(), (com.lowagie.text.Font)this.defaultblankft);
        int rest = (int)((float)width % this.defaultftblankWidth);
        if (rest >= 5) {
            Chunk restchunk = new Chunk(" ", (com.lowagie.text.Font)new RtfFont("New Roman", (float)rest));
            phrase.add((Element)restchunk);
        }
        return phrase;
    }

    private Cell kdsToRtfCell(KDSCell kdscell) {
        Cell cell = new Cell();
        Object cellValue = kdscell.getValue();
        if (cellValue != null && cellValue instanceof BufferedImage) {
            BufferedImage image = (BufferedImage)cellValue;
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)image, "png", out);
                cell.add((Element)Image.getInstance((byte[])out.toByteArray()));
            }
            catch (BadElementException e) {
                e.printStackTrace();
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            cell.add((Element)new Chunk(kdscell.getText(), this.kdFont2iTextFont((ShareStyleAttributes)kdscell.getStyle())));
            cell.setBackgroundColor(kdscell.getStyle().getBackground());
        }
        Styles.HorizontalAlignment hAlign = kdscell.getStyle().getHorizontalAlign();
        if (hAlign == Styles.HorizontalAlignment.LEFT) {
            cell.setHorizontalAlignment(0);
        } else if (hAlign == Styles.HorizontalAlignment.CENTER) {
            cell.setHorizontalAlignment(1);
        } else if (hAlign == Styles.HorizontalAlignment.RIGHT) {
            cell.setHorizontalAlignment(2);
        }
        Styles.VerticalAlignment vAlign = kdscell.getStyle().getVerticalAlign();
        if (vAlign == Styles.VerticalAlignment.TOP) {
            cell.setVerticalAlignment(4);
        } else if (vAlign == Styles.VerticalAlignment.MIDDLE) {
            cell.setVerticalAlignment(5);
        } else if (vAlign == Styles.VerticalAlignment.BOTTOM) {
            cell.setVerticalAlignment(6);
        }
        return cell;
    }

    class RtfSheet {
        RtfRow[] rtfrows;
        int rows = 0;
        int cols = 0;

        RtfSheet(KDSSheet sheet, IndexedPage.PageBlock pb) {
            this.rows = pb.getEndRow() - pb.getBeginRow();
            this.cols = pb.getEndCol() - pb.getBeginCol();
            this.rtfrows = new RtfRow[this.rows];
            for (int i = 0; i < this.rows; ++i) {
                this.rtfrows[i] = new RtfRow(this.cols);
            }
            this.init(sheet, pb);
        }

        RtfRow getRtfRow(int index) {
            if (index < this.rows && index >= 0) {
                return this.rtfrows[index];
            }
            return null;
        }

        void init(KDSSheet sheet, IndexedPage.PageBlock pb) {
            int beginRow = pb.getBeginRow();
            int beginCol = pb.getBeginCol();
            for (int i = beginRow; i < pb.getEndRow(); ++i) {
                RtfRow row = this.rtfrows[i - beginRow];
                for (int j = beginCol; j < pb.getEndCol(); ++j) {
                    KDSCell cell = sheet.getCell(i, j, false);
                    if (cell.isMerged()) {
                        this.initMergeCells(sheet, beginRow, beginCol, i, j, cell);
                        continue;
                    }
                    int cellWidth = (int)StyleUtil.lomToPixel((long)((int)sheet.getColumnWidth(j) * 10));
                    String cText = cell.getText();
                    if (cell.getValue() instanceof java.awt.Image) {
                        cText = "<<Image>>";
                    }
                    String[] temps = this.getSplitText(cellWidth, cText, cell.getStyle(), ((Graphics2D)RtfExporter.this.g).getFontRenderContext());
                    row.blocks[j - beginCol].width = cellWidth;
                    row.blocks[j - beginCol].ssa = cell.getStyle();
                    int emulateRows = this.calcEmulateRows((int)StyleUtil.lomToPixel((long)((int)sheet.getRowHeight(i) * 10)), (ShareStyleAttributes)cell.getStyle());
                    int n = row.emulaterows = emulateRows > row.emulaterows ? emulateRows : row.emulaterows;
                    if (temps == null) continue;
                    for (int itemp = 0; itemp < temps.length; ++itemp) {
                        row.blocks[j - beginCol].datas.add(temps[itemp]);
                    }
                }
            }
        }

        private void initMergeCells(KDSSheet sheet, int beginRow, int beginCol, int i, int j, KDSCell cell) {
            if (this.isMeragedFirst(sheet, i, j)) {
                KDSMergeBlock merge = this.getMerge(sheet, i, j);
                int cellWidth = 0;
                for (int index = merge.col; index <= merge.getCol2(); ++index) {
                    cellWidth = (int)((float)cellWidth + sheet.getColumnWidth(index));
                }
                cellWidth = (int)StyleUtil.lomToPixel((long)(cellWidth * 10));
                String cText = cell.getText();
                if (cell.getValue() instanceof java.awt.Image) {
                    cText = "<<Image>>";
                }
                String[] temps = this.getSplitText(cellWidth, cText, cell.getStyle(), ((Graphics2D)RtfExporter.this.g).getFontRenderContext());
                this.initMergerInsideCell(sheet, beginRow, beginCol, merge, cellWidth, temps, (ShareStyleAttributes)cell.getStyle());
            }
        }

        private void initMergerInsideCell(KDSSheet sheet, int beginRow, int beginCol, KDSMergeBlock merge, int cellWidth, String[] temps, ShareStyleAttributes ssa) {
            for (int index = merge.row; index <= merge.getRow2(); ++index) {
                RtfRow tempRtfRow = this.rtfrows[index - beginRow];
                int emulateRows = this.calcEmulateRows((int)StyleUtil.lomToPixel((long)((int)sheet.getRowHeight(index - 1) * 10)), ssa);
                tempRtfRow.emulaterows = emulateRows > tempRtfRow.emulaterows ? emulateRows : tempRtfRow.emulaterows;
                for (int col = merge.col; col <= merge.getCol2(); ++col) {
                    if (col == merge.col) {
                        this.initMergeBelowCells(sheet, beginCol, merge, cellWidth, temps, ssa, index, tempRtfRow, col);
                        continue;
                    }
                    tempRtfRow.blocks[col - beginCol].isUsed = false;
                }
            }
        }

        private void initMergeBelowCells(KDSSheet sheet, int beginCol, KDSMergeBlock merge, int cellWidth, String[] temps, ShareStyleAttributes ssa, int index, RtfRow tempRtfRow, int col) {
            tempRtfRow.blocks[col - beginCol].ssa = ssa;
            tempRtfRow.blocks[col - beginCol].width = cellWidth;
            String[] celltemp = this.getCellStrings(temps, sheet, merge, index - merge.row, ssa);
            if (celltemp != null) {
                for (int itemp = 0; itemp < celltemp.length; ++itemp) {
                    tempRtfRow.blocks[col - beginCol].datas.add(celltemp[itemp]);
                }
            }
        }

        String[] getCellStrings(String[] mergesStrings, KDSSheet sheet, KDSMergeBlock merge, int index, ShareStyleAttributes ssa) {
            String[] rets = null;
            int cellrows = merge.getHeight();
            int[] lineRows = new int[cellrows];
            int totalRows = 0;
            for (int i = merge.row; i <= merge.getRow2(); ++i) {
                int rowHeight = (int)StyleUtil.lomToPixel((long)((long)sheet.getRowHeight(i) * 10L));
                lineRows[i - merge.row] = this.calcEmulateRows(rowHeight, ssa);
                totalRows += lineRows[i - merge.row];
            }
            Styles.VerticalAlignment align = ssa.getVerticalAlign();
            if (align == Styles.VerticalAlignment.MIDDLE) {
                rets = this.getCellStringMiddle(mergesStrings, index, rets, lineRows, totalRows);
            } else if (align == Styles.VerticalAlignment.TOP) {
                rets = this.getCellStringTop(mergesStrings, index, rets, lineRows);
            } else if (align == Styles.VerticalAlignment.BOTTOM) {
                rets = this.getCellStringBottom(mergesStrings, index, rets, cellrows, lineRows);
            }
            return rets;
        }

        private String[] getCellStringMiddle(String[] mergesStrings, int index, String[] rets, int[] lineRows, int totalRows) {
            int pos = 0;
            for (int i = 0; i < index; ++i) {
                pos += lineRows[i];
            }
            int begin = pos - (totalRows - mergesStrings.length) / 2;
            int end = pos - (totalRows - mergesStrings.length) / 2 + lineRows[index];
            begin = begin > 0 ? begin : 0;
            int n = end = end > mergesStrings.length ? mergesStrings.length : end;
            if (begin < mergesStrings.length && end >= 0 && begin != end) {
                rets = new String[end - begin];
                System.arraycopy(mergesStrings, begin, rets, 0, end - begin);
            }
            return rets;
        }

        private String[] getCellStringTop(String[] mergesStrings, int index, String[] rets, int[] lineRows) {
            int pos = 0;
            for (int i = 0; i < index; ++i) {
                pos += lineRows[i];
            }
            if (pos <= mergesStrings.length) {
                rets = new String[mergesStrings.length - pos];
                int reallength = mergesStrings.length > lineRows[index] ? lineRows[index] : mergesStrings.length;
                System.arraycopy(mergesStrings, pos, rets, 0, reallength);
            }
            return rets;
        }

        private String[] getCellStringBottom(String[] mergesStrings, int index, String[] rets, int cellrows, int[] lineRows) {
            int pos = 0;
            for (int i = cellrows - 1; i > index; --i) {
                pos += lineRows[i];
            }
            if (pos <= mergesStrings.length) {
                rets = new String[mergesStrings.length - pos];
                int begin = mergesStrings.length - pos > lineRows[index] ? mergesStrings.length - pos - lineRows[index] : 0;
                int reallength = mergesStrings.length - pos > lineRows[index] ? lineRows[index] : mergesStrings.length - pos;
                System.arraycopy(mergesStrings, begin, rets, 0, reallength);
            }
            return rets;
        }

        boolean isMeragedFirst(KDSSheet sheet, int row, int col) {
            boolean bret = false;
            Iterator it = sheet.getMerges().iterator();
            while (it.hasNext()) {
                KDSMergeBlock merge = (KDSMergeBlock)it.next();
                if (!merge.include(row, col)) continue;
                if (col == merge.col && row == merge.row) {
                    bret = true;
                    break;
                }
                bret = false;
                break;
            }
            return bret;
        }

        KDSMergeBlock getMerge(KDSSheet sheet, int row, int col) {
            KDSMergeBlock mb = null;
            Iterator it = sheet.getMerges().iterator();
            while (it.hasNext()) {
                KDSMergeBlock merge = (KDSMergeBlock)it.next();
                if (!merge.include(row, col)) continue;
                mb = merge;
                break;
            }
            return mb;
        }

        String[] getSplitText(int widthLimit, String source, Style style, FontRenderContext frc) {
            if (source == null || source.length() == 0) {
                return new String[0];
            }
            if (style.isWrapText()) {
                Font awtft = new Font("\u5b8b\u4f53", 0, (int)StyleUtil.ptToPixel((double)style.getFontSize()));
                TextLineBreaker tlb = new TextLineBreaker(source, awtft, frc);
                ArrayList<String> al = new ArrayList<String>();
                while (tlb.hasNext()) {
                    String line = tlb.nextRowString((double)widthLimit);
                    al.add(line);
                }
                return al.toArray(new String[0]);
            }
            return source.split("\n");
        }

        String[] splitString(String strText, KDFont kdft, int cellWidth) {
            String[] temps = null;
            Font awtft = new Font("\u5b8b\u4f53", 0, (int)StyleUtil.ptToPixel((double)kdft.getSize()));
            FontMetrics fm = RtfExporter.this.g.getFontMetrics(awtft);
            ArrayList<String> splitList = new ArrayList<String>();
            FontRenderContext frc = ((Graphics2D)RtfExporter.this.g).getFontRenderContext();
            temps = strText.indexOf(10) != -1 ? strText.split("\n") : new String[]{strText};
            String strTemp = null;
            block0: for (int i = 0; i < temps.length; ++i) {
                strTemp = temps[i];
                if (fm.stringWidth(strTemp) <= cellWidth) {
                    splitList.add(strTemp);
                    continue;
                }
                AttributedString text = new AttributedString(strTemp);
                TextMeasurer tm = new TextMeasurer(text.getIterator(), frc);
                int pos = 0;
                int oldpos = -1;
                int count = strTemp.length() - 1;
                while (pos < count) {
                    oldpos = pos;
                    if ((pos = tm.getLineBreakIndex(pos, cellWidth)) == 0) {
                        splitList.add(strTemp);
                        continue block0;
                    }
                    splitList.add(strTemp.substring(oldpos, pos));
                }
            }
            int resultSize = splitList.size();
            String[] result = new String[resultSize];
            return splitList.toArray(result);
        }

        boolean hasRowData(int row, KDSSheet sheet, IndexedPage.PageBlock pb) {
            boolean bret = false;
            for (int i = pb.getBeginCol(); i < pb.getEndCol(); ++i) {
                KDSCell cell = sheet.getCell(row, i, false);
                if (cell == null || cell.equals(sheet.getDefaultCell())) continue;
                bret = true;
                break;
            }
            return bret;
        }

        int calcEmulateRows(int height, ShareStyleAttributes ssa) {
            return Math.round((long)height / StyleUtil.ptToPixel((double)ssa.getFontSize()));
        }
    }

    static class RtfRow {
        RtfBlock[] blocks;
        int emulaterows = 0;

        RtfRow(int cols) {
            this.blocks = new RtfBlock[cols];
            for (int i = 0; i < cols; ++i) {
                this.blocks[i] = new RtfBlock();
            }
        }

        RtfBlock[] getBlocks() {
            return this.blocks;
        }
    }

    static class RtfBlock {
        ArrayList datas = new ArrayList();
        boolean isUsed = true;
        int width = 0;
        ShareStyleAttributes ssa;

        RtfBlock() {
        }

        boolean isUsed() {
            return this.isUsed;
        }
    }
}

