/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.form2.ui;

import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.util.ScaleUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.kdf.expr.Variant;
import com.kingdee.bos.ctrl.kdf.form.Area;
import com.kingdee.bos.ctrl.kdf.form.Cell;
import com.kingdee.bos.ctrl.kdf.form.Container;
import com.kingdee.bos.ctrl.kdf.form.Data;
import com.kingdee.bos.ctrl.kdf.form.EventListener;
import com.kingdee.bos.ctrl.kdf.form.Form;
import com.kingdee.bos.ctrl.kdf.form.Page;
import com.kingdee.bos.ctrl.kdf.form.PageInfo;
import com.kingdee.bos.ctrl.kdf.form.Panel;
import com.kingdee.bos.ctrl.kdf.form.Property;
import com.kingdee.bos.ctrl.kdf.form.Table;
import com.kingdee.bos.ctrl.kdf.form2.ui.DivideCharRenderer;
import com.kingdee.bos.ctrl.kdf.form2.ui.DivideCharacter;
import com.kingdee.bos.ctrl.kdf.form2.ui.IFormVarListener;
import com.kingdee.bos.ctrl.kdf.form2.ui.INotePageProvider;
import com.kingdee.bos.ctrl.kdf.form2.ui.VariantValueProvider;
import com.kingdee.bos.ctrl.kdf.util.BMPReader;
import com.kingdee.bos.ctrl.kdf.util.Base64;
import com.kingdee.bos.ctrl.kdf.util.CloseUtil;
import com.kingdee.bos.ctrl.kdf.util.file.KDF;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.print.KDPrinter;
import com.kingdee.bos.ctrl.print.config.IXmlTranslate;
import com.kingdee.bos.ctrl.print.config.IXmlTranslate2;
import com.kingdee.bos.ctrl.print.control.PaperInfo;
import com.kingdee.bos.ctrl.print.printjob.IEconomizePrint;
import com.kingdee.bos.ctrl.print.ui.component.Canvas;
import com.kingdee.bos.ctrl.print.ui.component.IPainter;
import com.kingdee.bos.ctrl.print.ui.component.ImageCell;
import com.kingdee.bos.ctrl.print.ui.component.LabelCell;
import com.kingdee.bos.ctrl.print.ui.component.LineCell;
import com.kingdee.bos.ctrl.print.ui.component.VariantLabelCell;
import com.kingdee.bos.ctrl.print.ui.io.Painter2Xml;
import com.kingdee.bos.ctrl.print.ui.io.Xml2Painter;
import com.kingdee.bos.ctrl.print.util.KDPrinterUtils;
import com.kingdee.bos.ctrl.print.util.SyncPageList;
import java.awt.Image;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;
import org.jdom2.CDATA;
import org.jdom2.Content;
import org.jdom2.Element;

public class FormPageProvider
implements INotePageProvider,
IEconomizePrint {
    private static final Logger log = LogUtil.getPackageLogger(FormPageProvider.class);
    private SyncPageList logicPageList;
    private Form form;
    private int memoryCount = 1;
    private boolean isEconomizePaper;
    private boolean isCrossPrint = false;
    private IFormVarListener formVarListener;
    private INotePageProvider.INotePageProviderListener _listener;

    public void setFormVarListener(IFormVarListener formVarListener) {
        this.formVarListener = formVarListener;
    }

    public FormPageProvider() {
    }

    public FormPageProvider(int memoryCount) {
        this.memoryCount = memoryCount;
    }

    public Form getForm() {
        return this.form;
    }

    @Override
    public void forceStop() {
        if (this.form != null) {
            this.form.forceStop();
        }
    }

    public synchronized SyncPageList getLogicList() {
        if (this.logicPageList == null) {
            try {
                this.logicPageList = new SyncPageList(this.memoryCount);
            }
            catch (IOException ex) {
                ex.printStackTrace();
                return null;
            }
        }
        return this.logicPageList;
    }

    public Map getStyles() {
        return this.logicPageList.getStyles();
    }

    public com.kingdee.bos.ctrl.print.ui.component.Page get(int index, PaperInfo info) {
        log.debug((Object)("Request get page, index: " + index));
        if (index >= this.getLogicList().getPageCount() && this.getLogicList().isCompleted()) {
            log.debug((Object)"No more pages, return null.");
            return null;
        }
        return this.getLogicList().getPage(index);
    }

    public void setCrossPrint(boolean isCrossPrint) {
        this.isCrossPrint = isCrossPrint;
    }

    public void generate(KDF kdf, int pageWidth, int pageHeight) {
        long time = System.currentTimeMillis();
        this.form = (Form)kdf.getForms().iterator().next();
        this.isEconomizePaper = kdf.getPrintInfo().isEconomizePaper();
        int bodyHeight = pageHeight;
        if (this.isEconomizePaper) {
            bodyHeight = (int)kdf.getPrintInfo().getPrintBodyArea().getHeight();
        }
        PageInfo pi = new PageInfo(pageWidth, pageHeight);
        pi.setLocalFrc();
        this.form.initOutput(new FormEventListener(bodyHeight), null, pi);
        time = System.currentTimeMillis() - time;
        log.info((Object)("Generate form used time:" + time));
        this.form = null;
    }

    private static void makeChildren(Container cnt, Canvas cnv) {
        Iterator itr = cnt.iterator();
        while (itr.hasNext()) {
            Container item = (Container)itr.next();
            IPainter pnt = FormPageProvider.makePainter(item);
            if (pnt == null) continue;
            cnv.addPainter(pnt);
        }
    }

    private static IPainter makePainter(Container cnt) {
        if (cnt instanceof Cell) {
            return FormPageProvider.makeCell((Cell)cnt);
        }
        if (cnt instanceof Panel) {
            return FormPageProvider.makePanel((Panel)cnt);
        }
        if (cnt instanceof Table) {
            return FormPageProvider.makeTable((Table)cnt);
        }
        if (cnt instanceof Area) {
            return FormPageProvider.makeArea((Area)cnt);
        }
        return null;
    }

    private static void makeCommon(Container cnt, IPainter pnt) {
        int left = cnt.getLeft().getInteger();
        int top = cnt.getTop().getInteger();
        int right = cnt.getRight().getInteger();
        int bottom = cnt.getBottom().getInteger();
        Style style = Styles.getStyle((ShareStyleAttributes)cnt.getStyles());
        Container p = cnt.getParent();
        int x = p != null ? p.getLeft().getInteger() : 0;
        int y = p != null ? p.getTop().getInteger() : 0;
        float pm10 = KDPrinterUtils.POINTMM10;
        pnt.setPainterBounds((float)KDPrinterUtils.lomToPrintPoint((double)(left - x)), (float)KDPrinterUtils.lomToPrintPoint((double)(top - y)), (float)KDPrinterUtils.lomToPrintPoint((double)((float)(right - left) + pm10)), (float)KDPrinterUtils.lomToPrintPoint((double)((float)(bottom - top) + pm10)));
        pnt.setStyle(style);
        try {
            int layer = Integer.parseInt(cnt.getLayer());
            pnt.setLayer(layer);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private static IPainter makeCell(Cell cell) {
        String dt = cell.getData().getType();
        if ("image".equals(dt) || "linkedImage".equals(dt) || "embeddedImage".equals(dt)) {
            return FormPageProvider.makeImageCell(cell);
        }
        if ("line".equals(dt)) {
            return FormPageProvider.makeLineCell(cell);
        }
        return FormPageProvider.makeLabelCell(cell);
    }

    public static com.kingdee.bos.ctrl.print.ui.component.Page makePage(Page fpg) {
        return FormPageProvider.makePage(fpg, false);
    }

    private static com.kingdee.bos.ctrl.print.ui.component.Page makePage(Page fpg, boolean isEconomizePaper) {
        com.kingdee.bos.ctrl.print.ui.component.Page pg = new com.kingdee.bos.ctrl.print.ui.component.Page();
        FormPageProvider.makeCommon(fpg, (IPainter)pg);
        FormPageProvider.makeChildren(fpg, (Canvas)pg);
        if (isEconomizePaper) {
            FormPageProvider.cutPageBlankTail(pg);
        }
        return pg;
    }

    private static void cutPageBlankTail(com.kingdee.bos.ctrl.print.ui.component.Page page) {
        float maxBottom = 0.0f;
        for (IPainter child : page.getAllPainter()) {
            float bottom = child.getY() + child.getHeight();
            if (!(maxBottom < bottom)) continue;
            maxBottom = bottom;
        }
        if (maxBottom < page.getHeight()) {
            page.setHeight(maxBottom);
        }
    }

    private static Canvas makeArea(Area area) {
        Canvas cnv = new Canvas();
        FormPageProvider.makeCommon(area, (IPainter)cnv);
        FormPageProvider.makeChildren(area, cnv);
        return cnv;
    }

    private static Canvas makePanel(Panel pnl) {
        Canvas cnv = new Canvas();
        FormPageProvider.makeCommon(pnl, (IPainter)cnv);
        FormPageProvider.makeChildren(pnl, cnv);
        return cnv;
    }

    private static Canvas makeTable(Table tbl) {
        Canvas cnv = new Canvas();
        FormPageProvider.makeCommon(tbl, (IPainter)cnv);
        FormPageProvider.makeChildren(tbl, cnv);
        return cnv;
    }

    private static LabelCell makeLabelCell(Cell cell) {
        String val;
        int left = cell.getLeft().getInteger();
        int top = cell.getTop().getInteger();
        int right = cell.getRight().getInteger();
        int bottom = cell.getBottom().getInteger();
        if (right - left <= 0 || bottom - top <= 0) {
            return null;
        }
        NoteLabelCell lbl = new NoteLabelCell();
        lbl.setKeepClip(false);
        if (cell.getDivideCharacter() != null) {
            lbl.setDivideCharacter(cell.getDivideCharacter());
        }
        if ((val = cell.getData().getFormat()) != null) {
            String strVal = val.toString();
            if (strVal.startsWith("&[") && strVal.endsWith("]")) {
                lbl = new VariantLabelCell();
                lbl.setText(strVal);
            } else {
                lbl.setText(strVal);
            }
        }
        FormPageProvider.makeCommon(cell, (IPainter)lbl);
        return lbl;
    }

    private static ImageCell makeImageCell(Cell cell) {
        ImageCell img = new ImageCell();
        FormPageProvider.makeCommon(cell, (IPainter)img);
        img.setImage(FormPageProvider.loadFormCellImage(cell));
        Property scaleProp = cell.getProperties().get("scale");
        if (scaleProp != null) {
            img.setScale(ScaleUtil.toScaleEnum((String)scaleProp.getFormat()));
        }
        return img;
    }

    public static Image loadFormCellImage(Cell cell) {
        Object val;
        Data cellData = cell.getData();
        if (cellData != null && cellData.getValue() != null && (val = ((Variant)cellData.getValue()).getValue()) != null) {
            String dataType = cellData.getType();
            if (dataType.equalsIgnoreCase("image")) {
                byte[] imageData;
                if (val instanceof byte[]) {
                    imageData = (byte[])val;
                } else if (val instanceof Blob) {
                    imageData = FormPageProvider.blobToBytes((Blob)val);
                } else {
                    return null;
                }
                return FormPageProvider.makeImage(imageData);
            }
            if (dataType.equalsIgnoreCase("embeddedImage")) {
                byte[] imageData = Base64.decode((String)((String)val));
                return FormPageProvider.makeImage(imageData);
            }
            if (dataType.equalsIgnoreCase("linkedImage")) {
                try {
                    URL imageUrl = new URL((String)val);
                    return FormPageProvider.makeImage(imageUrl);
                }
                catch (Exception ex) {
                    log.error((Object)ex);
                    return null;
                }
            }
        }
        return null;
    }

    public static Image loadFormCellImage2(Data cellData) {
        if (cellData == null) {
            return null;
        }
        String dataType = cellData.getType();
        if (dataType.equalsIgnoreCase("image")) {
            Object val = ((Variant)cellData.getValue()).getValue();
            if (val != null) {
                byte[] imageData = (byte[])val;
                return FormPageProvider.makeImage(imageData);
            }
        } else {
            if (dataType.equalsIgnoreCase("embeddedImage")) {
                byte[] imageData = Base64.decode((String)cellData.getFormat());
                return FormPageProvider.makeImage(imageData);
            }
            if (dataType.equalsIgnoreCase("linkedImage")) {
                try {
                    URL imageUrl = new URL(cellData.getFormat());
                    return FormPageProvider.makeImage(imageUrl);
                }
                catch (Exception ex) {
                    log.error((Object)ex);
                    return null;
                }
            }
        }
        return null;
    }

    private static final Image makeImage(byte[] data) {
        if (data.length > 1 && data[0] == 66 && data[1] == 77) {
            return BMPReader.loadBitMap(data);
        }
        return new ImageIcon(data).getImage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Image makeImage(URL urlOfData) throws FileNotFoundException, URISyntaxException {
        String url = urlOfData.toString();
        String suffix = url.substring(url.length() - 3, url.length());
        if (urlOfData.getProtocol().equalsIgnoreCase("file")) {
            if ("bmp".equalsIgnoreCase(suffix) || "dib".equalsIgnoreCase(suffix)) {
                return BMPReader.loadBitMap(url.substring(7));
            }
            return new ImageIcon(url.substring(7)).getImage();
        }
        if ("bmp".equalsIgnoreCase(suffix) || "dib".equalsIgnoreCase(suffix)) {
            Image image;
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(new File(new URI(urlOfData.toString())));
                image = BMPReader.loadBitMap(fis);
            }
            catch (Throwable throwable) {
                CloseUtil.close((Closeable[])new Closeable[]{fis});
                throw throwable;
            }
            CloseUtil.close((Closeable[])new Closeable[]{fis});
            return image;
        }
        return new ImageIcon(urlOfData).getImage();
    }

    private static LineCell makeLineCell(Cell cell) {
        LineCell ln = new LineCell();
        FormPageProvider.makeCommon(cell, (IPainter)ln);
        ln.setLine(ln.getX(), ln.getY(), ln.getX() + ln.getWidth() - 1.0f, ln.getY() + ln.getHeight() - 1.0f);
        return ln;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] blobToBytes(Blob blob) {
        ByteArrayOutputStream baos = null;
        InputStream is = null;
        try {
            is = blob.getBinaryStream();
            if (is != null) {
                baos = new ByteArrayOutputStream();
                byte[] c = new byte[1024];
                int len = 0;
                while ((len = is.read(c, 0, c.length)) != -1) {
                    baos.write(c, 0, len);
                }
                byte[] byArray = baos.toByteArray();
                return byArray;
            }
        }
        catch (SQLException sqlEx) {
            log.error((Object)sqlEx);
        }
        catch (IOException ioEx) {
            log.error((Object)ioEx);
        }
        finally {
            try {
                if (null != baos) {
                    baos.close();
                }
            }
            catch (IOException sqlEx) {}
            try {
                if (null != is) {
                    is.close();
                }
            }
            catch (IOException sqlEx) {}
        }
        return new byte[0];
    }

    @Override
    public void setListener(INotePageProvider.INotePageProviderListener l) {
        this._listener = l;
    }

    private void addPage(com.kingdee.bos.ctrl.print.ui.component.Page page) {
        this.getLogicList().addPage(page);
        if (this._listener != null && this.getLogicList().size() == 1) {
            this._listener.firstPagePrepared();
        }
    }

    private void finish() {
        this.getLogicList().close();
        if (this._listener != null && this.getLogicList().size() == 0) {
            this._listener.cancelBeforeOutput();
        }
    }

    public int getHorSpace() {
        return 10;
    }

    public int getVerSpace() {
        return 10;
    }

    public boolean isEconomizePaper() {
        return this.isCrossPrint && this.isEconomizePaper;
    }

    public boolean isHorEconomizePaper() {
        return false;
    }

    public boolean isVerEconomizePaper() {
        return this.isEconomizePaper;
    }

    private static class NoteLabelCell
    extends LabelCell {
        public NoteLabelCell() {
            this.setRender(new DivideCharRenderer());
        }

        public IXmlTranslate createXmlTrans() {
            XmlTranslate xmlTranslate = new XmlTranslate();
            if (KDPrinter.getPainterXmlTranslate((String)xmlTranslate.getName()) == null) {
                KDPrinter.registerPainterXmlTranslate((String)xmlTranslate.getName(), (IXmlTranslate)xmlTranslate);
            }
            return xmlTranslate;
        }

        public DivideCharacter getDivideCharacter() {
            return ((DivideCharRenderer)this.getRender()).getModel();
        }

        public void setDivideCharacter(DivideCharacter divideCharacter) {
            ((DivideCharRenderer)this.getRender()).setModel(divideCharacter);
        }

        class XmlTranslate
        implements IXmlTranslate2 {
            private Painter2Xml painter2Xml;
            private Xml2Painter xml2Painter;

            XmlTranslate() {
            }

            public Element toXmlElement() {
                Element xml = new Element("NoteLabelCell");
                this.painter2Xml.makeCommon((IPainter)NoteLabelCell.this, xml);
                String text = NoteLabelCell.this.getText();
                if (text == null) {
                    text = "";
                }
                try {
                    xml.addContent((Content)new CDATA(text));
                }
                catch (Exception e) {
                    log.info((Object)("\u5c1d\u8bd5\u8fc7\u6ee4\u6389\u4e0d\u5408\u6cd5\u5b57\u7b26\u3002\u5f02\u5e38\u5b57\u7b26\u4e32\uff1a" + text));
                    text = this.filterIllegalChar(text);
                    xml.addContent((Content)new CDATA(text));
                }
                if (NoteLabelCell.this.getDivideCharacter() != null) {
                    int dn = NoteLabelCell.this.getDivideCharacter().getDividedCharNums();
                    if (dn > 0) {
                        xml.setAttribute("dividedCharNums", Integer.toString(dn));
                    }
                    if (NoteLabelCell.this.getDivideCharacter().isDrawCharBorder()) {
                        xml.setAttribute("isDrawCharBorder", "true");
                    }
                }
                return xml;
            }

            private String filterIllegalChar(String in) {
                StringBuffer out = new StringBuffer();
                if (in == null || "".equals(in)) {
                    return "";
                }
                for (int i = 0; i < in.length(); ++i) {
                    char current = in.charAt(i);
                    if (!(current == '\t' || current == '\n' || current == '\r' || current >= ' ' && current <= '\ud7ff' || current >= '\ue000' && current <= '\ufffd' || current >= '\u10000' && current <= '\u10ffff') && current >= '\u0000') continue;
                    out.append(current);
                }
                return out.toString().trim();
            }

            public Object fromXmlElement(Element xml) {
                NoteLabelCell lbl = new NoteLabelCell();
                this.xml2Painter.parseCommon((IPainter)lbl, xml);
                lbl.setText(xml.getText());
                String strDivideCharNums = xml.getAttributeValue("dividedCharNums");
                if (strDivideCharNums != null) {
                    DivideCharacter dc = new DivideCharacter();
                    lbl.setDivideCharacter(dc);
                    dc.setDividedCharNums(Integer.parseInt(strDivideCharNums));
                    String strCurrencyColumnSupport = xml.getAttributeValue("isDrawCharBorder");
                    if (strCurrencyColumnSupport != null) {
                        dc.setDrawCharBorder(true);
                    }
                }
                return lbl;
            }

            public String getName() {
                return "NoteLabelCell";
            }

            public void setPainter2Xml(Painter2Xml handle) {
                this.painter2Xml = handle;
            }

            public void setXml2Painter(Xml2Painter handle) {
                this.xml2Painter = handle;
            }
        }
    }

    private class FormEventListener
    implements EventListener {
        private float bodyHeight;
        private ArrayList tempPages;
        private float remainHeight;

        public FormEventListener(int bodyHeight) {
            this.bodyHeight = (float)KDPrinterUtils.lomToPrintPoint((double)bodyHeight);
        }

        @Override
        public void beginFormOutput(String id) {
            log.debug((Object)(":| Begin Form Output: " + id));
        }

        @Override
        public void beginPageOutput(String id, int idx) {
            log.debug((Object)(":| Begin Page [" + idx + "] Output: " + id));
        }

        @Override
        public void endPageOutput(String id, int idx) {
            if (log.isInfoEnabled()) {
                log.info((Object)(":| End Page Output [" + idx + "] " + id + " ..."));
            }
            com.kingdee.bos.ctrl.print.ui.component.Page pg = FormPageProvider.makePage(FormPageProvider.this.form.getOutputPage(idx), FormPageProvider.this.isEconomizePaper);
            if (!FormPageProvider.this.isCrossPrint && FormPageProvider.this.isEconomizePaper) {
                int index;
                this.getTempPages().add(pg);
                log.debug((Object)("...| End Page Output\uff0c\u8282\u7eb8\u6253\u5370\uff0c\u5c1d\u8bd5\u62fc\u7eb8\u5f20\u5927\u5c0f\u7684\u9875\u3002\u4e34\u65f6\u5217\u8868\u91cc\u9875\u6570\uff1a" + this.getTempPages().size()));
                this.remainHeight = this.bodyHeight;
                boolean isOutput = false;
                int c = this.getTempPages().size();
                for (index = 0; index < c; ++index) {
                    com.kingdee.bos.ctrl.print.ui.component.Page page = (com.kingdee.bos.ctrl.print.ui.component.Page)this.getTempPages().get(index);
                    this.remainHeight -= page.getHeight() - 1.0f;
                    if (!(this.remainHeight < 0.0f)) continue;
                    isOutput = true;
                    break;
                }
                if (isOutput) {
                    log.debug((Object)"...| End Page Output\uff0c\u8282\u7eb8\u6253\u5370\uff0c\u62fc\u7eb8\u5f20\u5927\u5c0f\u7684\u9875\u6210\u529f\u3002");
                    FormPageProvider.this.addPage(this.togetherPage(index));
                }
            } else {
                FormPageProvider.this.addPage(pg);
            }
            if (log.isInfoEnabled()) {
                log.info((Object)":) End Page Output.");
            }
        }

        private com.kingdee.bos.ctrl.print.ui.component.Page togetherPage(int pageCounts) {
            com.kingdee.bos.ctrl.print.ui.component.Page page1 = (com.kingdee.bos.ctrl.print.ui.component.Page)this.getTempPages().remove(0);
            float addedY = page1.getHeight() - 1.0f;
            page1.setHeight(this.bodyHeight);
            for (int i = 1; i < pageCounts; ++i) {
                com.kingdee.bos.ctrl.print.ui.component.Page pageN = (com.kingdee.bos.ctrl.print.ui.component.Page)this.getTempPages().remove(0);
                page1.addPainter((IPainter)pageN);
                pageN.setY(addedY);
                addedY += pageN.getHeight() - 1.0f;
            }
            return page1;
        }

        private ArrayList getTempPages() {
            if (this.tempPages == null) {
                this.tempPages = new ArrayList();
            }
            return this.tempPages;
        }

        @Override
        public void endFormOutput(String id) {
            if (FormPageProvider.this.isEconomizePaper && this.getTempPages().size() > 0) {
                log.debug((Object)"Form\u6267\u884c\u7ed3\u675f\uff0c\u8282\u7eb8\u6253\u5370\uff0c\u6240\u6709\u5269\u4f59\u7684\u9875\u62fc\u6210\u7eb8\u5f20\u5927\u5c0f\u7684\u9875\u8f93\u51fa\u3002");
                FormPageProvider.this.addPage(this.togetherPage(this.getTempPages().size()));
            }
            log.info((Object)"End output form.");
            FormPageProvider.this.finish();
        }

        @Override
        public Data requestVarData(String varName) {
            if (StringUtil.equalsIgnoreCase((String)varName, (String)"Time") || StringUtil.equalsIgnoreCase((String)varName, (String)"Date") || StringUtil.equalsIgnoreCase((String)varName, (String)"PageCount") || StringUtil.equalsIgnoreCase((String)varName, (String)"Page")) {
                return VariantValueProvider.makeVarData(varName);
            }
            return FormPageProvider.this.formVarListener.requestVarData(varName);
        }
    }
}

