/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.form2.ui;

import com.kingdee.bos.ctrl.kdf.form.Data;
import com.kingdee.bos.ctrl.kdf.form.EventListener;
import com.kingdee.bos.ctrl.kdf.form.Form;
import com.kingdee.bos.ctrl.kdf.form.Page;
import com.kingdee.bos.ctrl.kdf.form.PageInfo;
import com.kingdee.bos.ctrl.kdf.form2.ui.AbstractNotePrint;
import com.kingdee.bos.ctrl.kdf.form2.ui.FormPageProvider;
import com.kingdee.bos.ctrl.kdf.form2.ui.IFormVarListener;
import com.kingdee.bos.ctrl.kdf.form2.ui.INotePrintHelper;
import com.kingdee.bos.ctrl.kdf.form2.ui.VariantValueProvider;
import com.kingdee.bos.ctrl.kdf.printprovider.PrintInfo;
import com.kingdee.bos.ctrl.kdf.util.file.HeaderFooterHelper;
import com.kingdee.bos.ctrl.kdf.util.file.KDF;
import com.kingdee.bos.ctrl.print.IPrintActionListener;
import com.kingdee.bos.ctrl.print.config.PrintJobConfig;
import com.kingdee.bos.ctrl.print.config.attribute.FreeMediaSize;
import com.kingdee.bos.ctrl.print.config.attribute.MediaSizeNameExtend;
import com.kingdee.bos.ctrl.print.printjob.BufferPrintJob;
import com.kingdee.bos.ctrl.print.printjob.IPageProvider;
import com.kingdee.bos.ctrl.print.printjob.IPrintJob;
import com.kingdee.bos.ctrl.print.resource.Resources;
import com.kingdee.bos.ctrl.print.ui.component.Canvas;
import com.kingdee.bos.ctrl.print.util.KDPrinterUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.OutputStream;
import java.util.List;
import javax.print.attribute.Attribute;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.OrientationRequested;
import org.jdom2.Element;

public class FormPrintHelper
extends AbstractNotePrint {
    private IFormVarListener formVarListener;
    private INotePrintHelper.ICustomizePrintJobConfig _customizePrintJobConfig;

    public void setFormVarListener(IFormVarListener formVarListener) {
        this.formVarListener = formVarListener;
    }

    public void print(KDF kdf, boolean isPreview, Component owner, String title) {
        this.print(kdf, isPreview, true, owner, title);
    }

    @Override
    public int print(Object templateModel, boolean isPreview, boolean isShowPrinterDialog, Component owner, String title) {
        this.getPrinterCtrl().clear();
        this.initPrintCtrl(templateModel);
        IPrintJob printJob = this.createPrintJob((KDF)templateModel, false, isPreview, owner);
        if (printJob == null) {
            return 2;
        }
        return FormPrintHelper.runPrintCtrl(this.getPrinterCtrl(), isPreview, isShowPrinterDialog, owner, title);
    }

    @Override
    public void initPrintCtrl(Object templateModel) {
        if (!(templateModel instanceof KDF)) {
            throw new IllegalArgumentException("\u53c2\u6570\u5fc5\u987b\u4e3aKDF.");
        }
        KDF kdf = (KDF)templateModel;
        try {
            Form form = (Form)kdf.getForms().iterator().next();
            Page page = form.getPages().get(0);
            Element designedPage = (Element)page.getUserObject();
            if ("true".equals(designedPage.getAttributeValue("background"))) {
                this.fireStateListener(1, Boolean.TRUE);
                this.fireStateListener(2, Boolean.TRUE);
            } else {
                this.fireStateListener(1, Boolean.FALSE);
            }
        }
        catch (Exception ex) {
            this.fireStateListener(1, Boolean.FALSE);
        }
        this.getPrinterCtrl().setDividePage(true);
    }

    @Override
    public void setCustomizePrintJobConfig(INotePrintHelper.ICustomizePrintJobConfig customizePrintJobConfig) {
        this._customizePrintJobConfig = customizePrintJobConfig;
    }

    private void makePrintJobConfig(PrintInfo pi, PrintJobConfig pjc) {
        int leftMagin = pi.getLeftMargin();
        int rightMagin = pi.getRightMargin();
        int topMagin = pi.getTopMargin();
        int bottomMagin = pi.getBottomMargin();
        pjc.setLeftMargin((float)(leftMagin < 0 ? 0 : leftMagin / 10), 1000);
        pjc.setRightMargin((float)(rightMagin < 0 ? 0 : rightMagin / 10), 1000);
        pjc.setBodyTopMargin((float)(topMagin < 0 ? 0 : topMagin / 10), 1000);
        pjc.setBodyBottomMargin((float)(bottomMagin < 0 ? 0 : bottomMagin / 10), 1000);
        MediaSizeName msn = null;
        if (pi.isCustomizedPaperSize()) {
            int oriWidth = pi.getCustomizePaperWidth();
            int oriHeight = pi.getCustomizePaperHeight();
            if (oriHeight == -1) {
                this.getPrinterCtrl().setDynamicPaper(true);
            } else {
                this.getPrinterCtrl().setDynamicPaper(false);
            }
            int width = oriWidth != -1 ? (int)Math.ceil(oriWidth / 10) : 65535;
            int height = oriHeight != -1 ? (int)Math.ceil(oriHeight / 10) : 65535;
            MediaSizeNameExtend media = MediaSizeNameExtend.CUSTOM;
            MediaSize ms = MediaSize.getMediaSizeForName((MediaSizeName)media);
            if (ms instanceof FreeMediaSize) {
                ((FreeMediaSize)ms).setXY((float)width, (float)height, 1000);
            } else if (ms == null) {
                new FreeMediaSize(width, height, 1000, (MediaSizeName)media);
            }
            pjc.addAttribute((Attribute)media);
        } else {
            msn = KDPrinterUtils.getMediaSizeName((String)pi.getNamedPaperSize());
            pjc.addAttribute((Attribute)msn);
        }
        if ("LANDSCAPE".equalsIgnoreCase(pi.getOrientation())) {
            pjc.addAttribute((Attribute)OrientationRequested.LANDSCAPE);
        } else {
            pjc.addAttribute((Attribute)OrientationRequested.PORTRAIT);
        }
        if (this._customizePrintJobConfig != null) {
            this._customizePrintJobConfig.customize(pjc);
        }
    }

    public IPrintJob createPrintJob(KDF kdf, IPageProvider formPages) {
        if (this._customizePrintJobConfig != null) {
            this._customizePrintJobConfig.setConfigChangeHandlerEnabled(false);
        }
        PrintInfo prtInfo = kdf.getPrintInfo();
        Dimension logicSize = prtInfo.getPrintBodyArea();
        BufferPrintJob prtJob = new BufferPrintJob();
        prtJob.setPageProvider(formPages);
        this.getPrinterCtrl().addPrintJob((IPrintJob)prtJob);
        this.makePrintJobConfig(kdf.getPrintInfo(), prtJob.getConfig());
        prtJob.getConfig().setConfigPanesVisible(Resources.getMsg((String)"tree.headerfooter"), false);
        prtJob.getConfig().setPageMarginPanelVisible(this.isShowMarginPanel());
        this.configToolbar();
        if (kdf.getHeaders().length > 0) {
            PageInfo piHeader = new PageInfo(logicSize.width, prtInfo.getHeaderPreferHeight());
            Page kdfHeader = kdf.getHeaders()[0];
            Form formHeader = HeaderFooterHelper.packHeaderFooter(kdfHeader, kdf);
            formHeader.restoreOriginState();
            formHeader.initOutput(VarDataListener.getInstance(), null, piHeader);
            com.kingdee.bos.ctrl.print.ui.component.Page printHeader = FormPageProvider.makePage(formHeader.getOutputPage(0));
            prtJob.getConfig().setHeaderMargin((float)(prtInfo.getHeaderMargin() / 10), 1000);
            prtJob.getConfig().getHeaderFooterModel().setHeader((Canvas)printHeader);
        }
        if (kdf.getFooters().length > 0) {
            PageInfo pageinfo = new PageInfo(logicSize.width, prtInfo.getFooterPreferHeight());
            Page kdfFooter = kdf.getFooters()[0];
            Form formFooter = HeaderFooterHelper.packHeaderFooter(kdfFooter, kdf);
            formFooter.restoreOriginState();
            formFooter.initOutput(VarDataListener.getInstance(), null, pageinfo);
            com.kingdee.bos.ctrl.print.ui.component.Page printFooter = FormPageProvider.makePage(formFooter.getOutputPage(0));
            prtJob.getConfig().setFooterMargin((float)(prtInfo.getFooterMargin() / 10), 1000);
            prtJob.getConfig().getHeaderFooterModel().setFooter((Canvas)printFooter);
        }
        if (this._customizePrintJobConfig != null) {
            this._customizePrintJobConfig.setConfigChangeHandlerEnabled(true);
        }
        return prtJob;
    }

    @Override
    public IPrintJob createPrintJob(Object templateModel) {
        if (templateModel instanceof KDF) {
            return this.createPrintJob((KDF)templateModel, true, true, null);
        }
        throw new IllegalArgumentException("\u53c2\u6570\u5fc5\u987b\u4e3aKDF.");
    }

    private IPrintJob createPrintJob(KDF kdf, boolean sync, boolean isPreview, Component owner) {
        FormPageProvider formPages = new FormPageProvider();
        formPages.setFormVarListener(this.formVarListener);
        final GenerateForm gf = new GenerateForm(formPages, kdf);
        if (sync) {
            gf.generateForm();
        } else {
            AbstractNotePrint.WaitingDialog dlg = null;
            if (isPreview) {
                dlg = AbstractNotePrint.WaitingDialog.create(owner);
                formPages.setListener(new AbstractNotePrint.PageProviderListener(dlg));
            }
            Thread tempThread = new Thread(gf);
            this.getPrinterCtrl().addPreviewActionListener(new IPrintActionListener(){

                public void beforePrintOrPreview() {
                }

                public void beforePreview() {
                }

                public void beforePrint() {
                }

                public void closePreview() {
                    gf.stopPageProvider();
                }
            });
            tempThread.start();
            if (isPreview) {
                dlg.show();
                if (dlg.isUserCancel()) {
                    formPages.forceStop();
                    return null;
                }
            }
        }
        return this.createPrintJob(kdf, formPages);
    }

    @Override
    public void exportPDF(Object templateModel, String file) {
        KDF kdf = (KDF)templateModel;
        this.getPrinterCtrl().clear();
        this.createPrintJob(kdf, true, false, null);
        this.getPrinterCtrl().getIOManager().exportToPdf(file);
    }

    @Override
    public void exportPDF(Object templateModel, OutputStream os) {
        KDF kdf = (KDF)templateModel;
        this.getPrinterCtrl().clear();
        this.createPrintJob(kdf, true, false, null);
        this.getPrinterCtrl().getIOManager().exportToPdf(os);
    }

    @Override
    public void setCrossPrint(boolean isCrossPrint) {
    }

    @Override
    public List<BufferedImage> exportJPG(Object templateModel) {
        return null;
    }

    @Override
    public void exportExecl(Object templateModel, OutputStream outputStream) {
        KDF kdf = (KDF)templateModel;
        this.getPrinterCtrl().clear();
        this.createPrintJob(kdf, true, false, null);
        this.getPrinterCtrl().getIOManager().exportToXls2(outputStream);
    }

    private static class VarDataListener
    implements EventListener {
        private static VarDataListener instance = new VarDataListener();

        public static VarDataListener getInstance() {
            return instance;
        }

        private VarDataListener() {
        }

        @Override
        public Data requestVarData(String varName) {
            return VariantValueProvider.makeVarData(varName);
        }

        @Override
        public void beginFormOutput(String id) {
        }

        @Override
        public void beginPageOutput(String id, int idx) {
        }

        @Override
        public void endFormOutput(String id) {
        }

        @Override
        public void endPageOutput(String id, int idx) {
        }
    }

    private static class GenerateForm
    implements Runnable {
        private FormPageProvider formPageProvider;
        private KDF kdf;

        public GenerateForm(FormPageProvider fpp, KDF kdf) {
            this.formPageProvider = fpp;
            this.kdf = kdf;
        }

        @Override
        public void run() {
            this.generateForm();
        }

        public void generateForm() {
            Dimension logicSize = this.kdf.getPrintInfo().getLogicPageDim();
            this.formPageProvider.generate(this.kdf, logicSize.width, logicSize.height);
        }

        public void stopPageProvider() {
            this.formPageProvider.forceStop();
        }
    }
}

