/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.formbrowser2.gui;

import com.kingdee.bos.ctrl.kdf.formbrowser2.ClientForm;
import com.kingdee.bos.ctrl.kdf.formbrowser2.clientcore.ClientCore;
import com.kingdee.bos.ctrl.kdf.formbrowser2.gui.IPreviewWindow;
import com.kingdee.bos.ctrl.kdf.formbrowser2.resources.Resources;
import com.kingdee.bos.ctrl.kdf.printprovider.gui.BaseComponent;
import com.kingdee.bos.ctrl.swing.KDFrame;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ImageIcon;

public class DefaultPreviewFrame
extends KDFrame
implements IPreviewWindow {
    private static final long serialVersionUID = 6951452186757926962L;
    BaseComponent baseComp;
    ClientForm clientform;
    boolean fExitOnClose;
    boolean isClosed = false;

    public DefaultPreviewFrame(boolean exitOnClose, ClientForm clientform) {
        this.fExitOnClose = exitOnClose;
        this.clientform = clientform;
        ClientCore clientCore = clientform.getClientCore();
        clientCore.setMainFrame(this);
        this.setIconImage(((ImageIcon)Resources.theRes.getObject("titleIcon")).getImage());
        this.baseComp = clientCore.getInitializedBaseComponent();
        clientCore.getUiDelegate().setAvailableUI(this.baseComp);
        this.setContentPane(this.baseComp);
        this.repaint();
        this.setTitle(Resources.theRes.getString("titleName"));
        clientCore.getPrintService().setActionInitializer(clientform.getToolbarBuilder());
        this.setSize(new Dimension(640, 720));
        this.setLocation((Toolkit.getDefaultToolkit().getScreenSize().width - this.getWidth()) / 2, 0);
        this.setExtendedState(6);
        if (this.fExitOnClose) {
            this.setDefaultCloseOperation(3);
        } else {
            this.setDefaultCloseOperation(2);
        }
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                DefaultPreviewFrame.this.onClose();
            }
        });
    }

    protected void onClose() {
        Thread worker = this.clientform.getWorker();
        if (this.clientform.getClientCore().getConfManager().getConf().isStopRetriveAtClose()) {
            if (worker != null) {
                this.clientform.getRawpages().cancelJob(worker);
            }
        } else if (this.fExitOnClose && worker != null) {
            this.clientform.getRawpages().cancelJob(worker);
        }
        this.clientform.getClientCore().getContextOfBrowser().closeDocument();
        this.isClosed = true;
    }

    @Override
    public void showModalFrame() {
        this.isClosed = false;
        this.show();
        this.clientform.getClientCore().getContextOfBrowser().setDataUpdated(true);
        this.clientform.getClientCore().getContextOfBrowser().finishDataUpdate();
        if (!this.clientform.getClientCore().getContextOfBrowser().Goto(0)) {
            this.clientform.getClientCore().getContextOfBrowser().setDataUpdated(false);
        }
        while (!this.isClosed) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                break;
            }
        }
    }

    @Override
    public void closeModalFrame() {
        this.dispose();
        this.onClose();
    }
}

