/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.kdprint;

import com.kingdee.bos.ctrl.kdf.kdprint.GraphicLayer;
import com.kingdee.bos.ctrl.kdf.kdprint.KDPrintbase;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.text.NumberFormat;
import javax.swing.event.MouseInputAdapter;

final class PaperEdgeEditer {
    PaperEdgeGraphicLayer graphicLayer = new PaperEdgeGraphicLayer();
    MousePerformer mousePerformer;
    KDPrintbase base;
    static final double factor = 2.8346456692913384;
    Line2D leftLine;
    Line2D rightLine;
    Line2D topLine;
    Line2D bottomLine;
    Rectangle2D leftLineArea;
    Rectangle2D rightLineArea;
    Rectangle2D topLineArea;
    Rectangle2D bottomLineArea;
    int xLeft = 0;
    int xRight = 0;
    int yTop = 0;
    int yBottom = 0;
    boolean isNeedPaint = false;

    public PaperEdgeEditer(KDPrintbase printbase) {
        this.base = printbase;
        this.mousePerformer = new MousePerformer();
    }

    Rectangle2D lineAreaFromLine(Line2D line, int halfWidth) {
        if (line.getX1() == line.getX2()) {
            return new Rectangle2D.Double(line.getX1() - (double)halfWidth, line.getY1(), halfWidth * 2, line.getY2() - line.getY1());
        }
        if (line.getY1() == line.getY2()) {
            return new Rectangle2D.Double(line.getX1(), line.getY1() - (double)halfWidth, line.getX2() - line.getX1(), halfWidth * 2);
        }
        return null;
    }

    public PaperEdgeGraphicLayer getGraphicLayer() {
        return this.graphicLayer;
    }

    public void enable() {
        this.base.getPreviewPane().addMouseMotionListener(this.mousePerformer);
        this.base.getPreviewPane().addMouseListener(this.mousePerformer);
    }

    public void disable() {
        this.base.getPreviewPane().removeMouseMotionListener(this.mousePerformer);
        this.base.getPreviewPane().removeMouseListener(this.mousePerformer);
        this.base.getStatusHolder().setText("");
    }

    class MousePerformer
    extends MouseInputAdapter {
        Rectangle2D lastMouseInLine = null;
        Cursor saveCursor = null;
        NumberFormat nf = NumberFormat.getNumberInstance();
        String[] statusTip;

        MousePerformer() {
            this.nf.setMaximumIntegerDigits(3);
            this.nf.setMaximumFractionDigits(3);
            this.nf.setMinimumFractionDigits(3);
            this.statusTip = new String[4];
            this.statusTip[0] = " left edge " + this.nf.format(PaperEdgeEditer.this.base.getPrinterAttrManager().getPrintPage().getLeftEdge()) + ";  ";
            this.statusTip[1] = " right edge " + this.nf.format(PaperEdgeEditer.this.base.getPrinterAttrManager().getPrintPage().getRightEdge()) + ";  ";
            this.statusTip[2] = " top edge " + this.nf.format(PaperEdgeEditer.this.base.getPrinterAttrManager().getPrintPage().getTopEdge()) + ";  ";
            this.statusTip[3] = " bottom edge " + this.nf.format(PaperEdgeEditer.this.base.getPrinterAttrManager().getPrintPage().getBottomEdge()) + ";  ";
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (PaperEdgeEditer.this.leftLineArea != null && PaperEdgeEditer.this.leftLineArea.contains(e.getPoint()) && this.saveCursor == null) {
                this.saveCursor = e.getComponent().getCursor();
                e.getComponent().setCursor(new Cursor(10));
                this.lastMouseInLine = PaperEdgeEditer.this.leftLineArea;
            } else if (PaperEdgeEditer.this.rightLineArea != null && PaperEdgeEditer.this.rightLineArea.contains(e.getPoint()) && this.saveCursor == null) {
                this.saveCursor = e.getComponent().getCursor();
                e.getComponent().setCursor(new Cursor(10));
                this.lastMouseInLine = PaperEdgeEditer.this.rightLineArea;
            } else if (PaperEdgeEditer.this.topLineArea != null && PaperEdgeEditer.this.topLineArea.contains(e.getPoint()) && this.saveCursor == null) {
                this.saveCursor = e.getComponent().getCursor();
                e.getComponent().setCursor(new Cursor(8));
                this.lastMouseInLine = PaperEdgeEditer.this.topLineArea;
            } else if (PaperEdgeEditer.this.bottomLineArea != null && PaperEdgeEditer.this.bottomLineArea.contains(e.getPoint()) && this.saveCursor == null) {
                this.saveCursor = e.getComponent().getCursor();
                e.getComponent().setCursor(new Cursor(8));
                this.lastMouseInLine = PaperEdgeEditer.this.bottomLineArea;
            } else if (this.saveCursor != null && !this.lastMouseInLine.contains(e.getPoint())) {
                e.getComponent().setCursor(this.saveCursor);
                this.saveCursor = null;
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (this.saveCursor != null) {
                if (this.lastMouseInLine == PaperEdgeEditer.this.leftLineArea) {
                    double left = (e.getPoint().getX() - PaperEdgeEditer.this.base.getPageLayoutManager().getPosOfPages()[0].getX()) / PaperEdgeEditer.this.base.getPageLayoutManager().getScale();
                    this.statusTip[0] = "left edge " + this.nf.format(left / 2.8346456692913384) + ";  ";
                } else if (this.lastMouseInLine == PaperEdgeEditer.this.rightLineArea) {
                    double right = (PaperEdgeEditer.this.base.getPageLayoutManager().getPosOfPages()[0].getX() + PaperEdgeEditer.this.base.getPageLayoutManager().getPosOfPages()[0].getWidth() - e.getPoint().getX()) / PaperEdgeEditer.this.base.getPageLayoutManager().getScale();
                    this.statusTip[1] = "right edge " + this.nf.format(right / 2.8346456692913384) + ";  ";
                } else if (this.lastMouseInLine == PaperEdgeEditer.this.topLineArea) {
                    double top = (e.getPoint().getY() - PaperEdgeEditer.this.base.getPageLayoutManager().getPosOfPages()[0].getY()) / PaperEdgeEditer.this.base.getPageLayoutManager().getScale();
                    this.statusTip[2] = "top edge " + this.nf.format(top / 2.8346456692913384) + ";  ";
                } else if (this.lastMouseInLine == PaperEdgeEditer.this.bottomLineArea) {
                    double bottom = (PaperEdgeEditer.this.base.getPageLayoutManager().getPosOfPages()[0].getY() + PaperEdgeEditer.this.base.getPageLayoutManager().getPosOfPages()[0].getHeight() - e.getPoint().getY()) / PaperEdgeEditer.this.base.getPageLayoutManager().getScale();
                    this.statusTip[3] = "bottom edge " + this.nf.format(bottom / 2.8346456692913384) + ": ";
                }
                PaperEdgeEditer.this.base.getStatusHolder().setText(this.statusTip[0] + this.statusTip[1] + this.statusTip[2] + this.statusTip[3]);
                this.drawXORLine(e.getPoint(), (Component)e.getSource());
            }
        }

        private void drawXORLine(Point point, Component comp) {
            Graphics2D g2 = (Graphics2D)comp.getGraphics();
            Color oldColor = g2.getColor();
            Stroke oldStroke = g2.getStroke();
            float[] dash1 = new float[]{5.0f};
            BasicStroke dashed = new BasicStroke(1.0f, 0, 0, 5.0f, dash1, 0.0f);
            g2.setStroke(dashed);
            g2.setColor(Color.BLACK);
            g2.setXORMode(Color.WHITE);
            if (this.lastMouseInLine == PaperEdgeEditer.this.leftLineArea) {
                Line2D.Float line = new Line2D.Float(point.x, (float)PaperEdgeEditer.this.leftLine.getY1(), point.x, (float)PaperEdgeEditer.this.leftLine.getY2());
                g2.draw(PaperEdgeEditer.this.leftLine);
                g2.draw(line);
                PaperEdgeEditer.this.leftLine = line;
            } else if (this.lastMouseInLine == PaperEdgeEditer.this.rightLineArea) {
                Line2D.Float line = new Line2D.Float(point.x, (float)PaperEdgeEditer.this.rightLine.getY1(), point.x, (float)PaperEdgeEditer.this.rightLine.getY2());
                g2.draw(PaperEdgeEditer.this.rightLine);
                g2.draw(line);
                PaperEdgeEditer.this.rightLine = line;
            } else if (this.lastMouseInLine == PaperEdgeEditer.this.topLineArea) {
                Line2D.Double line = new Line2D.Double(PaperEdgeEditer.this.topLine.getX1(), point.getY(), PaperEdgeEditer.this.topLine.getX2(), point.getY());
                g2.draw(PaperEdgeEditer.this.topLine);
                g2.draw(line);
                PaperEdgeEditer.this.topLine = line;
            } else if (this.lastMouseInLine == PaperEdgeEditer.this.bottomLineArea) {
                Line2D.Double line = new Line2D.Double(PaperEdgeEditer.this.bottomLine.getX1(), point.getY(), PaperEdgeEditer.this.bottomLine.getX2(), point.getY());
                g2.draw(PaperEdgeEditer.this.bottomLine);
                g2.draw(line);
                PaperEdgeEditer.this.bottomLine = line;
            }
            g2.setColor(oldColor);
            g2.setStroke(oldStroke);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (this.saveCursor != null && (e.getComponent().getCursor().getType() == 10 || e.getComponent().getCursor().getType() == 8)) {
                if (this.lastMouseInLine == PaperEdgeEditer.this.leftLineArea) {
                    double left = (e.getPoint().getX() - PaperEdgeEditer.this.base.getPageLayoutManager().getPosOfPages()[0].getX()) / PaperEdgeEditer.this.base.getPageLayoutManager().getScale();
                    PaperEdgeEditer.this.base.getPrinterAttrManager().getPrintPage().setLeftEdge((float)(left / 2.8346456692913384));
                } else if (this.lastMouseInLine == PaperEdgeEditer.this.rightLineArea) {
                    double right = (PaperEdgeEditer.this.base.getPageLayoutManager().getPosOfPages()[0].getX() + PaperEdgeEditer.this.base.getPageLayoutManager().getPosOfPages()[0].getWidth() - e.getPoint().getX()) / PaperEdgeEditer.this.base.getPageLayoutManager().getScale();
                    PaperEdgeEditer.this.base.getPrinterAttrManager().getPrintPage().setRightEdge((float)(right / 2.8346456692913384));
                } else if (this.lastMouseInLine == PaperEdgeEditer.this.topLineArea) {
                    double top = (e.getPoint().getY() - PaperEdgeEditer.this.base.getPageLayoutManager().getPosOfPages()[0].getY()) / PaperEdgeEditer.this.base.getPageLayoutManager().getScale();
                    PaperEdgeEditer.this.base.getPrinterAttrManager().getPrintPage().setTopEdge((float)(top / 2.8346456692913384));
                } else if (this.lastMouseInLine == PaperEdgeEditer.this.bottomLineArea) {
                    double bottom = (PaperEdgeEditer.this.base.getPageLayoutManager().getPosOfPages()[0].getY() + PaperEdgeEditer.this.base.getPageLayoutManager().getPosOfPages()[0].getHeight() - e.getPoint().getY()) / PaperEdgeEditer.this.base.getPageLayoutManager().getScale();
                    PaperEdgeEditer.this.base.getPrinterAttrManager().getPrintPage().setBottomEdge((float)(bottom / 2.8346456692913384));
                }
                PaperEdgeEditer.this.graphicLayer.setNeedPaint(true);
                PaperEdgeEditer.this.base.getPageGraphics().FlushPageGraphics();
                PaperEdgeEditer.this.base.getPreviewPane().FlushPaneGraphicCache();
                PaperEdgeEditer.this.base.getPreviewPane().repaint();
            }
        }
    }

    class PaperEdgeGraphicLayer
    implements GraphicLayer {
        int layerNumber = 0;

        @Override
        public int getLayerNumber() {
            return this.layerNumber;
        }

        @Override
        public String getName() {
            return null;
        }

        @Override
        public boolean isNeedPaint() {
            return PaperEdgeEditer.this.isNeedPaint;
        }

        @Override
        public void paint(Graphics2D g2) {
            Rectangle2D[] posOfPages = PaperEdgeEditer.this.base.getPageLayoutManager().getPosOfPages();
            double left = (double)PaperEdgeEditer.this.base.getPrinterAttrManager().getPrintPage().getPrintableAreaX() * 2.8346456692913384;
            PaperEdgeEditer.this.xLeft = (int)(left * PaperEdgeEditer.this.base.getPageLayoutManager().getScale() + posOfPages[0].getX());
            int y = (int)posOfPages[0].getHeight();
            PaperEdgeEditer.this.leftLine = new Line2D.Double(PaperEdgeEditer.this.xLeft, (int)posOfPages[0].getY(), PaperEdgeEditer.this.xLeft, (int)(posOfPages[0].getY() + (double)y));
            double right = left + (double)PaperEdgeEditer.this.base.getPrinterAttrManager().getPrintPage().getPrintableAreaW() * 2.8346456692913384;
            PaperEdgeEditer.this.xRight = (int)(right * PaperEdgeEditer.this.base.getPageLayoutManager().getScale() + posOfPages[0].getX());
            PaperEdgeEditer.this.rightLine = new Line2D.Double(PaperEdgeEditer.this.xRight, (int)posOfPages[0].getY(), PaperEdgeEditer.this.xRight, (int)(posOfPages[0].getY() + (double)y));
            double top = (double)PaperEdgeEditer.this.base.getPrinterAttrManager().getPrintPage().getPrintableAreaY() * 2.8346456692913384;
            PaperEdgeEditer.this.yTop = (int)(top * PaperEdgeEditer.this.base.getPageLayoutManager().getScale() + posOfPages[0].getY());
            PaperEdgeEditer.this.topLine = new Line2D.Double(posOfPages[0].getX(), PaperEdgeEditer.this.yTop, posOfPages[0].getX() + posOfPages[0].getWidth(), PaperEdgeEditer.this.yTop);
            double bottom = top + (double)PaperEdgeEditer.this.base.getPrinterAttrManager().getPrintPage().getPrintableAreaH() * 2.8346456692913384;
            PaperEdgeEditer.this.yBottom = (int)(bottom * PaperEdgeEditer.this.base.getPageLayoutManager().getScale() + posOfPages[0].getY());
            PaperEdgeEditer.this.bottomLine = new Line2D.Double(posOfPages[0].getX(), PaperEdgeEditer.this.yBottom, posOfPages[0].getX() + posOfPages[0].getWidth(), PaperEdgeEditer.this.yBottom);
            Stroke oldStroke = g2.getStroke();
            Color oldColor = g2.getColor();
            float[] dash1 = new float[]{5.0f};
            BasicStroke dashed = new BasicStroke(1.0f, 0, 0, 5.0f, dash1, 0.0f);
            g2.setStroke(dashed);
            g2.setColor(Color.BLACK);
            g2.draw(PaperEdgeEditer.this.leftLine);
            g2.draw(PaperEdgeEditer.this.rightLine);
            g2.draw(PaperEdgeEditer.this.topLine);
            g2.draw(PaperEdgeEditer.this.bottomLine);
            g2.setColor(oldColor);
            g2.setStroke(oldStroke);
            PaperEdgeEditer.this.leftLineArea = PaperEdgeEditer.this.lineAreaFromLine(PaperEdgeEditer.this.leftLine, 2);
            PaperEdgeEditer.this.rightLineArea = PaperEdgeEditer.this.lineAreaFromLine(PaperEdgeEditer.this.rightLine, 2);
            PaperEdgeEditer.this.topLineArea = PaperEdgeEditer.this.lineAreaFromLine(PaperEdgeEditer.this.topLine, 2);
            PaperEdgeEditer.this.bottomLineArea = PaperEdgeEditer.this.lineAreaFromLine(PaperEdgeEditer.this.bottomLine, 2);
        }

        @Override
        public void setLayerNumber(int layerNum) {
        }

        @Override
        public void setNeedPaint(boolean needPaint) {
            PaperEdgeEditer.this.isNeedPaint = needPaint;
        }
    }
}

