/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.kdprint;

import com.kingdee.bos.ctrl.kdf.kdprint.KDPrintbase;
import com.kingdee.bos.ctrl.kdf.util.Base64;
import java.awt.geom.Dimension2D;
import java.io.Serializable;
import java.util.List;
import javax.print.attribute.Attribute;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import org.jdom2.CDATA;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class PrinterRecoverManager {
    static final int RECOVER_SUCCEEDED = 0;
    static final int RECOVER_FAILED = 1;
    static final int RECOVER_NOT_SUPPORT_ALL__ATTR = 2;
    KDPrintbase base;
    private static final String namePrinter = "PrintInfo";
    private static final String namePaginationInfo = "PageSetup";
    private static final String namePrinterParam = "PrinterParam";

    public PrinterRecoverManager(KDPrintbase printbase) {
        this.base = printbase;
    }

    public int RecoverFrom(Element printElt) {
        Element pageInfo;
        Namespace ns = Namespace.getNamespace((String)"http://www.kingdee.com/Common");
        HashPrintRequestAttributeSet reqAttrSet = new HashPrintRequestAttributeSet();
        if (printElt.getChild(namePrinterParam) != null) {
            List elts = printElt.getChild(namePrinterParam).getChildren();
            Attribute[] decrAttrs = new Attribute[elts.size()];
            for (int i = 0; i < elts.size(); ++i) {
                decrAttrs[i] = (Attribute)Base64.decodeToObject((String)((Element)elts.get(i)).getText());
                reqAttrSet.add(decrAttrs[i]);
            }
        }
        if ((pageInfo = printElt.getChild(namePaginationInfo, ns)) != null) {
            this.base.getPrinterAttrManager().getPrintPage().recoverPrintPage(pageInfo);
        }
        return 0;
    }

    public Dimension2D caculatePrintableAreaForNode(Element printElt) {
        Namespace ns = Namespace.getNamespace((String)"http://www.kingdee.com/Common");
        Element pageInfo = printElt.getChild(namePaginationInfo, ns);
        if (pageInfo != null) {
            return this.base.getPrinterAttrManager().getPrintPage().caculatePrintableAreaForNode(pageInfo);
        }
        return null;
    }

    public Element getStorage() {
        Element printerElt = new Element(namePrinter);
        Element printerParam = new Element(namePrinterParam);
        Element paginationInfo = this.base.getPrinterAttrManager().getPrintPage().getPrintPageStorage();
        printerElt.addContent((Content)paginationInfo);
        printerElt.addContent((Content)printerParam);
        PrintRequestAttributeSet reqAttrSet = this.base.getPrinterAttrManager().getPrintRequestAttributeSet();
        Attribute[] rAttrs = reqAttrSet.toArray();
        for (int i = 0; i < rAttrs.length; ++i) {
            if (rAttrs[i] == null) continue;
            Element elt = new Element(rAttrs[i].getName());
            elt.addContent((Content)new CDATA(Base64.encodeObject((Serializable)rAttrs[i])));
            printerParam.addContent((Content)elt);
        }
        return printerElt;
    }
}

