/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.kdprint;

import com.kingdee.bos.ctrl.kdf.kdprint.GraphicLayer;
import com.kingdee.bos.ctrl.kdf.kdprint.KDPrintbase;
import com.kingdee.bos.ctrl.kdf.kdprint.MoveViewport;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.EventListenerList;
import javax.swing.event.MouseInputAdapter;

public class Select2Zoom
implements ActionListener {
    private KDPrintbase base;
    PopupListener mouseListener;
    Select2ZoomGraphicLayer graphicLayer = new Select2ZoomGraphicLayer();
    Cursor saveCursor = null;
    MoveViewport moveViewport;
    JMenuItem menuItemZoom;
    JMenuItem menuItemMove;
    JPopupMenu popup = new JPopupMenu();
    EventListenerList listenerlist = new EventListenerList();
    Rectangle2D selectedRect = new Rectangle2D.Float(0.0f, 0.0f, 0.0f, 0.0f);
    Rectangle2D previousRect = null;
    Rectangle2D rectToDraw = null;

    public Select2Zoom() {
        this.createPopupMenu();
    }

    public void enable(KDPrintbase printbase) {
        this.base = printbase;
        this.base.getPageLayoutManager().setRowAndCol(1, 1);
        this.saveCursor = this.base.getPreviewPane().getCursor();
        this.base.getPreviewPane().setCursor(new Cursor(1));
        this.base.getPreviewPane().addMouseListener(this.mouseListener);
    }

    public void disable() {
        this.base.getPreviewPane().removeMouseListener(this.mouseListener);
        this.base.getPreviewPane().setCursor(this.saveCursor);
        this.base = null;
    }

    public void paintAxuiShapes(Graphics2D g2) {
        float[] dash1 = new float[]{10.0f};
        BasicStroke dashed = new BasicStroke(1.0f, 0, 0, 10.0f, dash1, 0.0f);
        Stroke saveStroke = g2.getStroke();
        g2.setStroke(dashed);
        g2.setColor(Color.BLACK);
        if (this.previousRect != null) {
            g2.draw(this.previousRect);
        }
        if (this.rectToDraw != null) {
            g2.setColor(Color.BLACK);
            g2.draw(this.rectToDraw);
        }
        g2.setStroke(saveStroke);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.menuItemZoom) {
            this.saveCursor = this.base.getPreviewPane().getCursor();
            this.base.getPreviewPane().setCursor(new Cursor(1));
            if (this.moveViewport.isEnable()) {
                this.base.getPreviewPane().removeMouseMotionListener(this.moveViewport);
                this.base.getPreviewPane().removeMouseListener(this.moveViewport);
            }
        } else if (e.getSource() == this.menuItemMove) {
            this.saveCursor = this.base.getPreviewPane().getCursor();
            this.base.getPreviewPane().setCursor(new Cursor(12));
            if (this.moveViewport == null) {
                this.moveViewport = new MoveViewport(this.popup);
            }
            this.moveViewport.setEnable(true);
            this.base.getPreviewPane().addMouseMotionListener(this.moveViewport);
            this.base.getPreviewPane().addMouseListener(this.moveViewport);
        }
    }

    public void createPopupMenu() {
        this.menuItemZoom = new JMenuItem("\u7f29\u653e");
        this.menuItemZoom.addActionListener(this);
        this.popup.add(this.menuItemZoom);
        this.menuItemMove = new JMenuItem("\u5e73\u79fb");
        this.menuItemMove.addActionListener(this);
        this.popup.add(this.menuItemMove);
        this.mouseListener = new PopupListener(this.popup);
    }

    public void addActionListener(ActionListener l) {
        this.listenerlist.add(ActionListener.class, l);
    }

    public Rectangle2D getSelectedRect() {
        return this.selectedRect;
    }

    public Rectangle2D getPreviousRect() {
        return this.previousRect;
    }

    public Rectangle2D getRectToDraw() {
        return this.rectToDraw;
    }

    public Select2ZoomGraphicLayer getGraphicLayer() {
        return this.graphicLayer;
    }

    public JPopupMenu getPopup() {
        return this.popup;
    }

    class Select2ZoomGraphicLayer
    implements GraphicLayer {
        int layerNumber;
        boolean isNeedPaint = false;

        @Override
        public int getLayerNumber() {
            return this.layerNumber;
        }

        @Override
        public void setLayerNumber(int layerNum) {
            this.layerNumber = layerNum;
        }

        @Override
        public String getName() {
            return null;
        }

        @Override
        public boolean isNeedPaint() {
            return this.isNeedPaint;
        }

        @Override
        public void paint(Graphics2D g2) {
            Select2Zoom.this.paintAxuiShapes(g2);
            this.setNeedPaint(false);
        }

        @Override
        public void setNeedPaint(boolean needPaint) {
            this.isNeedPaint = needPaint;
        }
    }

    class PopupListener
    extends MouseInputAdapter {
        JPopupMenu popup;
        Point startPoint = null;
        Point endPoint = null;
        String actionCommand = "select a area to zoom ";

        PopupListener(JPopupMenu popupMenu) {
            this.popup = popupMenu;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.getComponent().getCursor().getType() == 1) {
                this.maybeShowPopup(e);
                Select2Zoom.this.base.getPreviewPane().addMouseMotionListener(this);
                this.startPoint = e.getPoint();
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.getComponent().getCursor().getType() == 1) {
                this.maybeShowPopup(e);
                this.endPoint = e.getPoint();
                Select2Zoom.this.selectedRect.setFrameFromDiagonal(this.startPoint, this.endPoint);
                if (Select2Zoom.this.selectedRect.getWidth() < 10.0 || Select2Zoom.this.selectedRect.getHeight() < 10.0) {
                    return;
                }
                ActionEvent ae = null;
                Object[] listeners = Select2Zoom.this.listenerlist.getListenerList();
                for (int i = 0; i < listeners.length; ++i) {
                    if (listeners[i] != ActionListener.class) continue;
                    if (ae == null) {
                        ae = new ActionEvent(Select2Zoom.this, 1001, this.actionCommand, EventQueue.getMostRecentEventTime(), e.getModifiers() + 1);
                    }
                    ((ActionListener)listeners[i + 1]).actionPerformed(ae);
                }
                Select2Zoom.this.graphicLayer.setNeedPaint(true);
                Select2Zoom.this.base.getPreviewPane().FlushPaneGraphicCache();
                Select2Zoom.this.base.getPreviewPane().repaint();
                Select2Zoom.this.base.getPreviewPane().removeMouseMotionListener(this);
                this.startPoint = null;
                this.endPoint = null;
            }
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (e.getComponent().getCursor().getType() == 1) {
                if (Select2Zoom.this.rectToDraw != null) {
                    Select2Zoom.this.previousRect = Select2Zoom.this.rectToDraw;
                } else {
                    Select2Zoom.this.rectToDraw = new Rectangle2D.Float(0.0f, 0.0f, 0.0f, 0.0f);
                }
                Select2Zoom.this.rectToDraw.setFrameFromDiagonal(this.startPoint, e.getPoint());
                Select2Zoom.this.graphicLayer.setNeedPaint(true);
                Select2Zoom.this.base.getPreviewPane().repaint();
            }
        }
    }
}

