/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.printprovider.actions;

import com.kingdee.bos.ctrl.kdf.printprovider.ContextOfPreview;
import com.kingdee.bos.ctrl.kdf.printprovider.ICallBack;
import com.kingdee.bos.ctrl.kdf.printprovider.PrintCompContainer;
import com.kingdee.bos.ctrl.kdf.printprovider.actions.CompositableAction;
import com.kingdee.bos.ctrl.kdf.printprovider.dialogs.SelectMultiPageDialog;
import com.kingdee.bos.ctrl.kdf.printprovider.gui.BaseComponent;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class ViewMultiPageAction
extends AbstractAction
implements CompositableAction,
ICallBack {
    private static final long serialVersionUID = 6352737306496060435L;
    transient ContextOfPreview context;
    transient PrintCompContainer container;
    MouseHander mouseHander = new MouseHander();
    private SelectMultiPageDialog selectDlg;

    public ViewMultiPageAction() {
        ResourceBundle res = BaseComponent.resources;
        this.putValue("Name", res.getString("action.multipage.name"));
        this.putValue("ShortDescription", res.getString("action.multipage.description"));
        this.putValue("MnemonicKey", res.getObject("action.multipage.mnemonic"));
        this.putValue("ICON24", res.getObject("action.multipage.icon"));
        this.putValue("DEFAULT_ENABLE", true);
    }

    @Override
    public void setCompContainer(PrintCompContainer container) {
        this.container = container;
        this.context = container.getPreviewContext();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Frame frame = (Frame)SwingUtilities.getAncestorOfClass(Frame.class, this.container.getBaseComponent());
        if (frame == null) {
            frame = new JFrame();
        }
        if (this.selectDlg == null) {
            this.selectDlg = new SelectMultiPageDialog(frame, 3, 3, 9);
            this.selectDlg.setUndecorated(true);
            this.selectDlg.pack();
            this.selectDlg.register(this, null);
        }
        if (event.getSource() instanceof AbstractButton) {
            AbstractButton button = (AbstractButton)event.getSource();
            int x = button.getLocation().x;
            int y = button.getLocation().y + (int)button.getSize().getHeight();
            for (Container cont = button.getParent(); cont != null && !cont.getClass().isInstance(JFrame.class); cont = cont.getParent()) {
                x += cont.getLocation().x;
                y += cont.getLocation().y;
            }
            this.selectDlg.setLocation(x, y);
            this.selectDlg.setVisible(true);
        }
    }

    @Override
    public Object handleResult(Object param) {
        if (!this.selectDlg.isCancel()) {
            int r = this.selectDlg.getSelRows() + 1;
            int c = this.selectDlg.getSelCols() + 1;
            this.context.setPageColsInView(c);
            this.context.setPageRowsInView(r);
            this.context.setPaneFitStyle(3);
            if (r != 1 || c != 1) {
                this.container.getBaseComponent().setFocusable(true);
                this.container.getBaseComponent().getPreviewPane().addMouseListener(this.mouseHander);
            } else {
                this.container.getBaseComponent().getPreviewPane().removeMouseListener(this.mouseHander);
            }
        }
        return Boolean.TRUE;
    }

    class MouseHander
    extends MouseAdapter {
        MouseHander() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 1) {
                Point p1 = ViewMultiPageAction.this.context.getBeginOfPages();
                int w = (int)((double)(ViewMultiPageAction.this.container.getPrinterAttrManager().getPaperWidth() / ViewMultiPageAction.this.container.getPrinterAttrManager().screenMapRatio) * ViewMultiPageAction.this.context.getZoomFactor() + (double)ViewMultiPageAction.this.context.span);
                int h = (int)((double)(ViewMultiPageAction.this.container.getPrinterAttrManager().getPaperHeight() / ViewMultiPageAction.this.container.getPrinterAttrManager().screenMapRatio) * ViewMultiPageAction.this.context.getZoomFactor() + (double)ViewMultiPageAction.this.context.span);
                Rectangle region = new Rectangle(p1.x, p1.y, w * ViewMultiPageAction.this.context.getPageColsInView(), h * ViewMultiPageAction.this.context.getPageRowsInView());
                if (region.contains(e.getPoint())) {
                    int iCol = (e.getPoint().x - p1.x) / w;
                    int iRow = (e.getPoint().y - p1.y) / h;
                    int curRow = ViewMultiPageAction.this.context.getCurrentPage() / ViewMultiPageAction.this.context.getPageColsInView() % ViewMultiPageAction.this.context.getPageRowsInView();
                    int curCol = ViewMultiPageAction.this.context.getCurrentPage() % ViewMultiPageAction.this.context.getPageColsInView();
                    if (iCol < ViewMultiPageAction.this.context.getPageColsInView() && iRow < ViewMultiPageAction.this.context.getPageRowsInView() && (iCol != curCol || iRow != curRow)) {
                        int inc = (iRow - curRow) * ViewMultiPageAction.this.context.getPageColsInView() + (iCol - curCol);
                        ViewMultiPageAction.this.context.Goto(inc + ViewMultiPageAction.this.context.getCurrentPage());
                    }
                }
            } else if (e.getClickCount() == 2) {
                ViewMultiPageAction.this.context.setPageColsInView(1);
                ViewMultiPageAction.this.context.setPageRowsInView(1);
                ViewMultiPageAction.this.context.setPaneFitStyle(2);
                ViewMultiPageAction.this.container.getBaseComponent().getPreviewPane().removeMouseListener(ViewMultiPageAction.this.mouseHander);
            }
        }
    }
}

