/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.core;

import com.kingdee.bos.ctrl.excel.core.IMouseController;
import com.kingdee.bos.ctrl.excel.core.KDSpread;
import com.kingdee.bos.ctrl.excel.core.OutlineGroupRowTagBarUI;
import com.kingdee.bos.ctrl.excel.core.SpreadView;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.SortedAttributeSpanArray;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.LineMetrics;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultButtonModel;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicButtonListener;

public class OutlineGroupRowTagBar
extends SpreadView {
    private NumberButton[] nbs = new NumberButton[8];

    public OutlineGroupRowTagBar(KDSpread spread) {
        for (int i = 0; i < this.nbs.length; ++i) {
            this.nbs[i] = new NumberButton(i + 1);
        }
        this._spread = spread;
        this.updateUI();
        this.init();
    }

    private void init() {
        this.setLayout(new ColTagBarLayoutManager());
        for (int i = 0; i < this.nbs.length; ++i) {
            this.add(this.nbs[i]);
        }
    }

    @Override
    public IMouseController getMouseController() {
        return null;
    }

    @Override
    public void updateUI() {
        this.setUI(OutlineGroupRowTagBarUI.createUI(this));
    }

    @Override
    public int getViewType() {
        return 7;
    }

    @Override
    public void scrollCellVisible(int row, int col) {
    }

    private class NumberButton
    extends AbstractButton {
        private Border loweredBorder = BorderFactory.createLoweredBevelBorder();
        private Border raisedBorder = BorderFactory.createRaisedBevelBorder();
        private int number = 0;

        private NumberButton(int number) {
            this.setModel(new DefaultButtonModel());
            this.installListeners();
            this.setFont(new Font("Dialog", 0, 10));
            this.number = number;
            this.setText(new Integer(number).toString());
        }

        private void installListeners() {
            BasicButtonListener listener = new BasicButtonListener(this);
            this.addMouseListener(listener);
            this.addMouseMotionListener(listener);
            this.addFocusListener(listener);
            this.addPropertyChangeListener(listener);
            this.addChangeListener(listener);
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SortedAttributeSpanArray sasa = OutlineGroupRowTagBar.this.getSpread().getBook().getActiveSheet().getRowSpans();
                    for (int i = 0; i < sasa.size(); ++i) {
                        SortedAttributeSpanArray.AttributeSpan as = (SortedAttributeSpanArray.AttributeSpan)sasa.get(i);
                        int level = as.getOutlineGroupLevel();
                        if (level > NumberButton.this.number - 1) {
                            OutlineGroupRowTagBar.this.getSpread().getBook().getActiveSheet().getRowRange(as.getStart(), as.getEnd()).setRowHidden(true);
                            continue;
                        }
                        OutlineGroupRowTagBar.this.getSpread().getBook().getActiveSheet().getRowRange(as.getStart(), as.getEnd()).setRowHidden(false);
                    }
                    if (OutlineGroupRowTagBar.this.getSpread().getBook().getActiveSheet().isAboveOfOutlineGroup()) {
                        this.collapseAllBeyondWhenHandlerAbove(NumberButton.this.number - 1);
                    } else {
                        this.collapseAllBeyondWhenHandlerBelow(NumberButton.this.number - 1);
                    }
                }

                private void collapseAllBeyondWhenHandlerBelow(int valve) {
                    Sheet sheet = OutlineGroupRowTagBar.this.getSpread().getBook().getActiveSheet();
                    SortedAttributeSpanArray sasa = sheet.getRowSpans();
                    int firstRowId = sasa.getAttributeSpan(0).getStart();
                    int lastRowId = sasa.getAttributeSpan(sasa.size() - 1).getEnd();
                    for (int rowId = firstRowId; rowId <= lastRowId + 1; ++rowId) {
                        int spanPos = sasa.searchSpan(rowId);
                        int level = -1;
                        if (spanPos < 0) {
                            spanPos = sasa.searchSpan(rowId - 1);
                            if (spanPos < 0 || ((SortedAttributeSpanArray.AttributeSpan)sasa.getSpan(spanPos)).getOutlineGroupLevel() <= 0) continue;
                            level = 0;
                        } else {
                            level = ((SortedAttributeSpanArray.AttributeSpan)sasa.getSpan(spanPos)).getOutlineGroupLevel();
                        }
                        int prevRowLevel = 0;
                        int prevSpanPos = sasa.searchSpan(rowId - 1);
                        if (prevSpanPos >= 0) {
                            prevRowLevel = ((SortedAttributeSpanArray.AttributeSpan)sasa.getSpan(prevSpanPos)).getOutlineGroupLevel();
                        }
                        if (level >= prevRowLevel) continue;
                        if (level == valve) {
                            sheet.getRowRange(rowId, rowId).setRowOutlineGroupCollapse(true);
                            continue;
                        }
                        if (level >= valve) continue;
                        sheet.getRowRange(rowId, rowId).setRowOutlineGroupCollapse(false);
                    }
                }

                private void collapseAllBeyondWhenHandlerAbove(int valve) {
                    Sheet sheet = OutlineGroupRowTagBar.this.getSpread().getBook().getActiveSheet();
                    SortedAttributeSpanArray sasa = sheet.getRowSpans();
                    int firstRowId = sasa.getAttributeSpan(0).getStart();
                    int lastRowId = sasa.getAttributeSpan(sasa.size() - 1).getEnd();
                    for (int rowId = firstRowId - 1; rowId <= lastRowId; ++rowId) {
                        int spanPos = sasa.searchSpan(rowId);
                        int level = -1;
                        if (spanPos < 0) {
                            spanPos = sasa.searchSpan(rowId + 1);
                            if (spanPos < 0 || ((SortedAttributeSpanArray.AttributeSpan)sasa.getSpan(spanPos)).getOutlineGroupLevel() <= 0) continue;
                            level = 0;
                        } else {
                            level = ((SortedAttributeSpanArray.AttributeSpan)sasa.getSpan(spanPos)).getOutlineGroupLevel();
                        }
                        int nextRowLevel = 0;
                        int nextSpanPos = sasa.searchSpan(rowId + 1);
                        if (nextSpanPos >= 0) {
                            nextRowLevel = ((SortedAttributeSpanArray.AttributeSpan)sasa.getSpan(nextSpanPos)).getOutlineGroupLevel();
                        }
                        if (level >= nextRowLevel) continue;
                        if (level == valve) {
                            sheet.getRowRange(rowId, rowId).setRowOutlineGroupCollapse(true);
                            continue;
                        }
                        if (level >= valve) continue;
                        sheet.getRowRange(rowId, rowId).setRowOutlineGroupCollapse(false);
                    }
                }
            });
        }

        @Override
        public Insets getInsets() {
            return new Insets(2, 2, 2, 2);
        }

        @Override
        protected void paintComponent(Graphics g) {
            g.setColor(Color.black);
            Graphics2D g2d = (Graphics2D)g;
            String text = this.getText() == null || this.getText().equals("") ? new Integer(0).toString() : this.getText();
            Font font = this.getFont();
            FontRenderContext frc = g2d.getFontRenderContext();
            LineMetrics lm = g2d.getFont().getLineMetrics(text, frc);
            GlyphVector gv = font.createGlyphVector(frc, text);
            int advance = (int)gv.getGlyphMetrics(0).getAdvance();
            g2d.drawString(text, (float)(this.getWidth() / 2 - advance / 2), (float)(this.getHeight() / 2) + lm.getDescent() + lm.getLeading());
        }

        @Override
        protected void paintBorder(Graphics g) {
            if (this.model.isArmed()) {
                this.loweredBorder.paintBorder(this, g, 0, 0, this.getWidth(), this.getHeight());
            } else {
                this.raisedBorder.paintBorder(this, g, 0, 0, this.getWidth(), this.getHeight());
            }
        }
    }

    private class ColTagBarLayoutManager
    implements LayoutManager {
        private int cellWidth = 15;

        private ColTagBarLayoutManager() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void layoutContainer(Container parent) {
            int i;
            SortedAttributeSpanArray sasa = ((SpreadView)parent).getSpread().getBook().getActiveSheet().getRowSpans();
            int depth = 0;
            for (int i2 = 0; i2 < sasa.size(); ++i2) {
                int level = ((SortedAttributeSpanArray.AttributeSpan)sasa.get(i2)).getOutlineGroupLevel();
                depth = level > depth ? level : depth;
            }
            int basePos = (OutlineGroupRowTagBar.this.getHeight() - this.cellWidth) / 2;
            if (depth == 0) {
                for (i = 0; i < 8; ++i) {
                    OutlineGroupRowTagBar.this.nbs[i].setBounds(-1, -1, 0, 0);
                }
                return;
            }
            OutlineGroupRowTagBar.this.nbs[0].setBounds(4, basePos, this.cellWidth, this.cellWidth);
            OutlineGroupRowTagBar.this.nbs[1].setBounds(this.cellWidth + 4, basePos, this.cellWidth, this.cellWidth);
            for (i = 2; i <= depth; ++i) {
                OutlineGroupRowTagBar.this.nbs[i].setBounds(this.cellWidth * i + 4, basePos, this.cellWidth, this.cellWidth);
            }
            for (i = depth + 1; i < 8; ++i) {
                OutlineGroupRowTagBar.this.nbs[i].setBounds(-1, -1, 0, 0);
            }
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return null;
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return null;
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }
    }
}

