/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.expans.model.data;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.common.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.expans.model.data.ExtColumn;
import com.kingdee.bos.ctrl.excel.expans.model.data.ExtDataSetType;
import com.kingdee.bos.ctrl.excel.expans.model.data.ExtGroup;
import com.kingdee.bos.ctrl.excel.expans.model.data.ExtIndex;
import com.kingdee.bos.ctrl.excel.expans.model.data.ExtRow;
import com.kingdee.bos.ctrl.excel.model.expr.Expr;
import com.kingdee.bos.ctrl.excel.model.expr.ExprContext;
import com.kingdee.bos.ctrl.excel.model.expr.ExprExpressionParam;
import com.kingdee.bos.ctrl.excel.model.expr.IExprNode;
import com.kingdee.bos.ctrl.excel.model.struct.ICalculable;
import com.kingdee.bos.ctrl.excel.model.util.ObjectArray;
import com.kingdee.bos.ctrl.excel.model.util.SortedObjectArray;
import java.util.Locale;

public class ExtDataSet
implements Comparable,
IExprNode {
    private String _name;
    private String _alias;
    private String _upperAlias;
    private String _define;
    private Variant _varDS;
    private SortedObjectArray _columns;
    private Variant[][] _data;
    private int _dataCols;
    private ExtRow _currRow;
    private ExtRow _nullRow;
    private ExtGroup _defGroup;
    private ExtGroup _currGroup;
    private ExtGroup _nullGroup;
    private SortedObjectArray _indexs;

    public ExtDataSet(String name, String define, ExtDataSetType dt) {
        this.setName(name);
        this._upperAlias = name.toUpperCase();
        this._define = dt.getPrefixedString(define);
        this._varDS = new Variant((Object)this, 17);
        this._columns = new SortedObjectArray();
        this._indexs = new SortedObjectArray();
    }

    public String toString() {
        return this.getAlias();
    }

    public int compareTo(Object obj) {
        if (obj instanceof ExtDataSet) {
            return this._upperAlias.compareTo(((ExtDataSet)obj)._upperAlias);
        }
        return this._upperAlias.compareTo(((String)obj).toUpperCase(Locale.ENGLISH));
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getAlias() {
        if (StringUtil.isEmptyString((String)this._alias)) {
            return this._name;
        }
        return this._alias;
    }

    public void setAlias(String alias) {
        this._alias = alias;
        this._upperAlias = this._alias.toUpperCase();
    }

    public ExtDataSetType getDataSetType() {
        return ExtDataSetType.getExtDataSetType(this._define);
    }

    public String getDefine() {
        return this._define;
    }

    public ExtGroup getCurrentGroup() {
        return this._currGroup;
    }

    public void setCurrentGroup(ExtGroup group) {
        this._currGroup = group;
    }

    public ExtRow getCurrentRow() {
        return this._currRow;
    }

    public ExtGroup getNullGroup() {
        if (this._nullGroup == null) {
            this._nullGroup = new ExtGroup(this, new ExtRow[0]);
        }
        return this._nullGroup;
    }

    public ExtRow getNullRow() {
        if (this._nullRow == null) {
            this._nullRow = new ExtRow(this, -1);
            this._nullRow.setValue(Variant.nullVariant);
        }
        return this._nullRow;
    }

    public void setCurrentRow(ExtRow row) {
        this._currRow = row;
    }

    public SortedObjectArray getColumns() {
        return this._columns;
    }

    public int getColumnCount() {
        return this._columns.size();
    }

    public ExtColumn addColumn(ExtColumn col) {
        return (ExtColumn)this._columns.insert((Object)col);
    }

    public final Variant getColumnIndex(String alias) {
        Variant index = Variant.intMinValue;
        int pos = this._columns.search((Object)alias);
        if (pos >= 0) {
            index = ((ExtColumn)this._columns.get(pos)).getIndex();
        }
        return index;
    }

    public int getDataColumns() {
        return this._dataCols;
    }

    public void matchColumnAlias(Object[] oldCols) {
        for (int i = 0; i < oldCols.length; ++i) {
            ExtColumn oldCol = (ExtColumn)oldCols[i];
            int pos = this._columns.search((Object)oldCol.getName());
            if (pos >= 0) {
                ExtColumn newCol = (ExtColumn)this._columns.get(pos);
                oldCol.setIndex(newCol.getIndex());
                oldCol.setDataType(newCol.getDataType());
                continue;
            }
            oldCol.setIndex(Variant.intMinValue);
        }
        this._columns.setArray(oldCols);
    }

    public Variant[] getRowData(int rowIndex) {
        return this._data[rowIndex];
    }

    public void setData(ObjectArray dataArray) {
        if (dataArray == null || dataArray.isEmpty()) {
            this._dataCols = this.getColumnCount();
            this._data = new Variant[0][this._dataCols];
        } else {
            this._dataCols = ((Variant[])dataArray.get(0)).length;
            this._data = new Variant[dataArray.size()][this._dataCols];
            dataArray.toArray((Object[])this._data, 0);
        }
        this._defGroup = null;
    }

    public ExtGroup getDefaultGroup() {
        if (this._defGroup == null || this._defGroup.size() != this._data.length) {
            ExtRow[] rows = new ExtRow[this._data.length];
            for (int i = 0; i < rows.length; ++i) {
                rows[i] = new ExtRow(this, i);
            }
            this._defGroup = new ExtGroup(this, rows);
        }
        return this._defGroup;
    }

    void select(ExtGroup group, ExprContext ctx, Variant selExp) {
        ExtRow[] rows = group.getRows();
        Variant[] values = new Variant[rows.length];
        if (selExp.getVt() == 3) {
            int colIndex = (Integer)selExp.getValue();
            for (int i = 0; i < rows.length; ++i) {
                values[i] = this._data[rows[i].index()][colIndex];
            }
        } else {
            Expr expr = ((ExprExpressionParam)selExp).getExpr();
            ICalculable owner = ctx.getExprOwner();
            for (int i = 0; i < rows.length; ++i) {
                this._currRow = rows[i];
                values[i] = Variant.getBufferedVariant((Variant)expr.execute(ctx, owner));
            }
        }
        group.setValues(values);
    }

    Variant field(ExprContext ctx, Variant selExp, ExtRow currentRow) {
        Variant ret;
        if (selExp.getVt() == 3) {
            int colIndex = (Integer)selExp.getValue();
            ret = this._data[currentRow.index()][colIndex];
        } else {
            Expr expr = ((ExprExpressionParam)selExp).getExpr();
            ICalculable owner = ctx.getExprOwner();
            this._currRow = currentRow;
            ret = expr.execute(ctx, owner);
        }
        return ret;
    }

    public Variant field(int colIndex) {
        return this._data[this._currRow.index()][colIndex];
    }

    public Variant field(ExtRow row, int colIndex) {
        return this._data[row.index()][colIndex];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Variant calc(ExprContext ctx, Variant selExp) {
        if (this._currRow == null || this._currRow.isNullRow()) {
            return Variant.nullVariant;
        }
        if (selExp.getVt() == 3) {
            int colIndex = (Integer)selExp.getValue();
            return this._data[this._currRow.index()][colIndex];
        }
        ExtGroup group = this._currGroup;
        ExtRow row = this._currRow;
        try {
            Expr expr = ((ExprExpressionParam)selExp).getExpr();
            Variant variant = expr.execute(ctx, null);
            return variant;
        }
        finally {
            this._currGroup = group;
            this._currRow = row;
        }
    }

    public ExtGroup intersect(ExtGroup g, ExtGroup g2) {
        Object[] rows = new Object[this._data.length];
        Object[] rs = g.getRows();
        for (int i = 0; i < rs.length; ++i) {
            ExtRow row = rs[i];
            rows[row.index()] = row;
        }
        ObjectArray al = new ObjectArray();
        rs = g2.getRows();
        for (int i = 0; i < rs.length; ++i) {
            ExtRow row = rs[i];
            if (rows[row.index()] == null) continue;
            al.append((Object)row);
        }
        rs = new ExtRow[al.size()];
        al.toArray(rs, 0);
        return new ExtGroup(this, (ExtRow[])rs);
    }

    ExtIndex getExtIndex(int[] indexCols, boolean create) {
        long key = 0L;
        int len = Math.min(8, indexCols.length);
        for (int i = 0; i < len; ++i) {
            key |= ((long)indexCols[i] & 0xFFL) << (7 - i << 3);
        }
        ExtIndex ei = null;
        int pos = this._indexs.search((Object)new Long(key));
        if (pos >= 0) {
            ei = (ExtIndex)this._indexs.get(pos);
        } else if (create) {
            int upIndex = -(pos + 1);
            if (upIndex < this._indexs.size()) {
                ExtIndex e = (ExtIndex)this._indexs.get(upIndex);
                int[] existCols = e.getIndexCols();
                boolean equals = true;
                int cSize = Math.min(existCols.length, indexCols.length);
                for (int c = 0; c < cSize; ++c) {
                    if (existCols[c] == indexCols[c]) continue;
                    equals = false;
                    break;
                }
                if (equals) {
                    ei = e;
                }
            }
            if (ei == null) {
                for (int i = upIndex - 1; i >= 0; --i) {
                    ExtIndex e = (ExtIndex)this._indexs.get(i);
                    int[] existCols = e.getIndexCols();
                    boolean equals = true;
                    int cSize = Math.min(existCols.length, indexCols.length);
                    for (int c = 0; c < cSize; ++c) {
                        if (existCols[c] == indexCols[c]) continue;
                        equals = false;
                        break;
                    }
                    if (!equals) continue;
                    ei = (ExtIndex)this._indexs.removeByPos(i);
                    ei.init(this, indexCols, key);
                    this._indexs.insert((Object)ei);
                    break;
                }
                if (ei == null) {
                    ei = new ExtIndex(this, indexCols, key);
                    this._indexs.insert((Object)ei);
                }
            }
        }
        return ei;
    }

    @Override
    public void action(ExprContext ctx, ICalculable exprOwner) throws SyntaxErrorException {
        ctx.getCurrentExprStack().push(this._varDS);
    }

    @Override
    public String decode(ExprContext ctx, ICalculable exprOwner) {
        return this.getAlias();
    }

    @Override
    public int getExprType() {
        return 524288;
    }
}

