/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.frame;

import com.kingdee.bos.ctrl.excel.frame.LayoutCell;
import com.kingdee.bos.ctrl.excel.frame.MultiViewPane;
import com.kingdee.bos.ctrl.excel.frame.MvpViewManager;
import java.awt.Insets;
import java.awt.Rectangle;

public class MvpLayoutInfoManager {
    static final int SPLIT_BUTTON_SPAN = 6;
    private Rectangle _vSplitButtonRect = new Rectangle();
    private Rectangle _hSplitButtonRect = new Rectangle();
    private boolean _vSplitButtonVisible = true;
    private boolean _hSplitButtonVisible = true;
    private LayoutCell[] _verticals;
    private LayoutCell[] _horizons;
    MultiViewPane _mvp;

    MvpLayoutInfoManager(MultiViewPane mvp) {
        this._mvp = mvp;
        this._verticals = new LayoutCell[this._mvp.getMaxVertCount()];
        this._horizons = new LayoutCell[this._mvp.getMaxHoriCount()];
    }

    public void reset() {
        for (int i = this._mvp.getMaxVertCount() - 1; i >= 0; --i) {
            this.removeVertical(i);
        }
        for (int j = this._mvp.getMaxHoriCount() - 1; j >= 0; --j) {
            this.removeHorizon(j);
        }
    }

    public void update() {
        int i;
        for (i = this._mvp.getVerticalCount(); i < this._mvp.getMaxVertCount(); ++i) {
            this.removeVertical(i);
        }
        for (i = this._mvp.getHorizonCount(); i < this._mvp.getMaxHoriCount(); ++i) {
            this.removeHorizon(i);
        }
    }

    public void addVertical(int vIndex, LayoutCell info) {
        this._verticals[vIndex] = info;
    }

    public void addHorizon(int hIndex, LayoutCell info) {
        this._horizons[hIndex] = info;
    }

    public void removeHorizon(int index) {
        this._horizons[index] = null;
    }

    public void removeVertical(int index) {
        this._verticals[index] = null;
    }

    public LayoutCell getVertical(int vIndex) {
        return this._verticals[vIndex];
    }

    public LayoutCell getHorizon(int hIndex) {
        return this._horizons[hIndex];
    }

    int getLayoutCelllCount(int orientation) {
        int count = 0;
        if (orientation == 1) {
            count = this._mvp.getVerticalCount();
        } else if (orientation == 0) {
            count = this._mvp.getHorizonCount();
        }
        return count;
    }

    LayoutCell getLayoutCell(int orientation, int index) {
        LayoutCell cell = null;
        if (orientation == 1) {
            cell = this.getVertical(index);
        } else if (orientation == 0) {
            cell = this.getHorizon(index);
        }
        return cell;
    }

    void addLayOutCell(int orientation, int index, LayoutCell info) {
        if (orientation == 1) {
            this.addVertical(index, info);
        } else if (orientation == 0) {
            this.addHorizon(index, info);
        }
    }

    void removeLayoutCell(int orientation, int index) {
        if (orientation == 0) {
            this.removeHorizon(index);
        } else if (orientation == 1) {
            this.removeVertical(index);
        }
    }

    public boolean isVSplitButtonVisible() {
        return this._vSplitButtonVisible;
    }

    public void setVSplitButtonVisible(boolean splitButtonVisible) {
        this._vSplitButtonVisible = splitButtonVisible;
    }

    public boolean isHSplitButtonVisible() {
        return this._hSplitButtonVisible;
    }

    public void setHSplitButtonVisible(boolean splitButtonVisible) {
        this._hSplitButtonVisible = splitButtonVisible;
    }

    Rectangle getHSplitButtonRect() {
        return this._hSplitButtonRect;
    }

    Rectangle getVSplitButtonRect() {
        return this._vSplitButtonRect;
    }

    public void setLayoutVisible(int orientation, int index, boolean isVisible) {
        this.getLayoutCell(orientation, index).setVisible(isVisible);
        MvpViewManager vm = this._mvp.getViewManager();
        int count = orientation == 1 ? this._mvp.getHorizonCount() : this._mvp.getVerticalCount();
        for (int i = 0; i < count; ++i) {
            if (orientation == 1) {
                vm.getViewport(index, i).setVisible(isVisible);
                continue;
            }
            if (orientation != 0) continue;
            vm.getViewport(i, index).setVisible(isVisible);
        }
        this._mvp.validate();
    }

    public int getMaxCanSplitRange(int orientation) {
        int max = 0;
        Insets insets = this._mvp.getInsets();
        if (orientation == 0) {
            max = this._mvp.getWidth() - this._mvp.getScrollBarManager().getVScrollPanelWidth() - 6 - insets.right;
        } else if (orientation == 1) {
            max = this._mvp.getHeight() - this._mvp.getScrollBarManager().getHScrollPanelHeight() - 6 - insets.bottom;
        }
        return max;
    }

    public int getMinCanSplitRange(int orientation) {
        int fix = orientation == 0 ? this._mvp.getFixHorizonCount() : this._mvp.getFixVerticalCount();
        int range = 0;
        for (int i = 0; i < fix; ++i) {
            range += this._mvp.getLayoutInfoManager().getLayoutCell(orientation, i).getSpan();
        }
        Insets insets = this._mvp.getInsets();
        if (orientation == 0) {
            range += insets.left;
        } else if (orientation == 1) {
            range += insets.top;
        }
        return range;
    }

    public String toString() {
        LayoutCell cell;
        int i;
        StringBuffer sb = new StringBuffer();
        sb.append("************LayoutInfo*********\n");
        int vCount = this._mvp.getVerticalCount();
        int hCount = this._mvp.getHorizonCount();
        for (i = 0; i < vCount; ++i) {
            cell = this.getVertical(i);
            sb.append("V");
            sb.append(i);
            sb.append(" Index:" + cell.getIndex());
            sb.append(" SplitType:" + cell.getSplitType());
            sb.append(" Start:" + cell.getStart());
            sb.append(" Span:" + cell.getSpan());
            sb.append("\n");
        }
        for (i = 0; i < hCount; ++i) {
            cell = this.getHorizon(i);
            sb.append("h");
            sb.append(i);
            sb.append(" Index:" + cell.getIndex());
            sb.append(" SplitType:" + cell.getSplitType());
            sb.append(" Start:" + cell.getStart());
            sb.append(" Span:" + cell.getSpan());
            sb.append("\n");
        }
        return sb.toString();
    }
}

