/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.impl;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.common.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.impl.icons.ResourceManager;
import com.kingdee.bos.ctrl.excel.model.struct.cformat.ConditionFormatFurther;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import javax.swing.ImageIcon;

class ConditionPatternRender {
    ConditionPatternRender() {
    }

    public boolean draw(Graphics g, Shape clip, String text, Style style, ArrayList<ConditionFormatFurther> cf, Variant var) {
        boolean paintpic = false;
        if (StringUtil.isEmptyString((String)text)) {
            return paintpic;
        }
        if (!(clip instanceof Rectangle2D)) {
            return paintpic;
        }
        MaxMin mm = new MaxMin();
        for (ConditionFormatFurther cff : cf) {
            try {
                if (cff.isIsprocess()) {
                    mm.setProcess_max(cff.get_block_max().floatValue());
                    mm.setProcessmodel(cff.getProcessmodel());
                    mm.setIsprocess(true);
                }
                if (cff.isIscolor()) {
                    mm.setColor_max(cff.get_block_max().floatValue());
                    mm.setColor_min(cff.get_block_min().floatValue());
                    mm.setColormodel(cff.getColormodel());
                    mm.setIscolor(true);
                }
                if (!cff.isIspic()) continue;
                mm.setPic_max(cff.get_block_max().floatValue());
                mm.setPic_min(cff.get_block_min().floatValue());
                mm.setPicmodel(cff.getPicmodel());
                mm.setIspic(true);
            }
            catch (SyntaxErrorException e) {
                e.printStackTrace();
            }
        }
        if (mm.iscolor) {
            ConditionPatternRender.drawColor(this, g, clip, text, style, mm, var);
        }
        if (mm.isprocess) {
            ConditionPatternRender.drawRect(this, g, clip, text, style, mm, var);
        }
        if (mm.ispic) {
            ConditionPatternRender.drawImage(this, g, clip, text, style, mm, var);
            paintpic = true;
        }
        return paintpic;
    }

    private static synchronized void drawColor(ConditionPatternRender render, Graphics g, Shape clip, String text, Style style, MaxMin mm, Variant var) {
        Graphics2D g2d = (Graphics2D)g;
        Color begin = mm.getColormodel()[0];
        Color end = mm.getColormodel()[1];
        float percentcolor = 0.0f;
        try {
            percentcolor = (var.floatValue() - mm.getColor_min()) / (mm.getColor_max() - mm.getColor_min());
        }
        catch (SyntaxErrorException e) {
            e.printStackTrace();
        }
        int rr = begin.getRed() + (int)((float)(end.getRed() - begin.getRed()) * percentcolor + 0.5f);
        int gg = begin.getGreen() + (int)((float)(end.getGreen() - begin.getGreen()) * percentcolor + 0.5f);
        int bb = begin.getBlue() + (int)((float)(end.getBlue() - begin.getBlue()) * percentcolor + 0.5f);
        if (rr > 255) {
            rr = 255;
        } else if (rr < 0) {
            rr = 0;
        }
        if (gg > 255) {
            gg = 255;
        } else if (gg < 0) {
            gg = 0;
        }
        if (bb > 255) {
            bb = 255;
        } else if (bb < 0) {
            bb = 0;
        }
        g2d.setColor(new Color(rr, gg, bb));
        g2d.fill(clip);
    }

    private static synchronized void drawRect(ConditionPatternRender render, Graphics g, Shape clip, String text, Style style, MaxMin mm, Variant var) {
        Graphics2D g2d = (Graphics2D)g;
        Rectangle2D rect = clip.getBounds2D();
        int x = (int)rect.getX();
        int y = (int)rect.getY();
        int width = (int)rect.getWidth();
        int height = (int)rect.getHeight();
        try {
            Point2D.Float start = new Point2D.Float(x, x);
            Point2D.Float end = new Point2D.Float(x + (int)((float)width * (var.floatValue() / mm.getProcess_max())), y + height - 6);
            GradientPaint gradientPaint = new GradientPaint(start, mm.getProcessmodel()[0], end, mm.getProcessmodel()[0]);
            g2d.setPaint(gradientPaint);
            g2d.fillRect(x, y + 3, (int)((float)width * (var.floatValue() / mm.getProcess_max())), height - 6);
        }
        catch (SyntaxErrorException e) {
            e.printStackTrace();
        }
    }

    private static synchronized void drawImage(ConditionPatternRender render, Graphics g, Shape clip, String text, Style style, MaxMin mm, Variant var) {
        Graphics2D g2d = (Graphics2D)g;
        Rectangle2D rect = clip.getBounds2D();
        float percentpic = 0.0f;
        try {
            percentpic = var.floatValue() == mm.getPic_max() ? 1.0f : (var.floatValue() - mm.getPic_min()) / (mm.getPic_max() - mm.getPic_min());
        }
        catch (SyntaxErrorException e) {
            e.printStackTrace();
        }
        ImageIcon icon = ResourceManager.getImageIcon((double)percentpic > 0.67 ? mm.getPicmodel()[0] : ((double)percentpic > 0.33 ? mm.getPicmodel()[1] : mm.getPicmodel()[2]));
        int iconHeight = icon.getIconHeight();
        double height = rect.getHeight();
        icon.paintIcon(null, g2d, (int)rect.getX(), (int)(rect.getY() + (height - (double)iconHeight) / 2.0));
    }

    class MaxMin {
        private float process_max;
        private float process_min;
        private float color_max;
        private float color_min;
        private float pic_max;
        private float pic_min;
        private Color[] processmodel;
        private Color[] colormodel;
        private String[] picmodel;
        private boolean isprocess = false;
        private boolean iscolor = false;
        private boolean ispic = false;

        MaxMin() {
        }

        public float getProcess_max() {
            return this.process_max;
        }

        public void setProcess_max(float process_max) {
            this.process_max = process_max;
        }

        public float getProcess_min() {
            return this.process_min;
        }

        public void setProcess_min(float process_min) {
            this.process_min = process_min;
        }

        public float getColor_max() {
            return this.color_max;
        }

        public void setColor_max(float color_max) {
            this.color_max = color_max;
        }

        public float getColor_min() {
            return this.color_min;
        }

        public void setColor_min(float color_min) {
            this.color_min = color_min;
        }

        public float getPic_max() {
            return this.pic_max;
        }

        public void setPic_max(float pic_max) {
            this.pic_max = pic_max;
        }

        public float getPic_min() {
            return this.pic_min;
        }

        public void setPic_min(float pic_min) {
            this.pic_min = pic_min;
        }

        public boolean isIsprocess() {
            return this.isprocess;
        }

        public void setIsprocess(boolean isprocess) {
            this.isprocess = isprocess;
        }

        public boolean isIscolor() {
            return this.iscolor;
        }

        public void setIscolor(boolean iscolor) {
            this.iscolor = iscolor;
        }

        public boolean isIspic() {
            return this.ispic;
        }

        public void setIspic(boolean ispic) {
            this.ispic = ispic;
        }

        public Color[] getProcessmodel() {
            return this.processmodel;
        }

        public void setProcessmodel(Color[] processmodel) {
            this.processmodel = processmodel;
        }

        public Color[] getColormodel() {
            return this.colormodel;
        }

        public void setColormodel(Color[] colormodel) {
            this.colormodel = colormodel;
        }

        public String[] getPicmodel() {
            return this.picmodel;
        }

        public void setPicmodel(String[] picmodel) {
            this.picmodel = picmodel;
        }
    }
}

