/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.impl;

import com.kingdee.bos.ctrl.excel.core.ICellDisplayProvider;
import com.kingdee.bos.ctrl.excel.core.IExtRender;
import com.kingdee.bos.ctrl.excel.impl.SpreadCellTextRender;
import com.kingdee.bos.ctrl.excel.impl.SpreadContext;
import com.kingdee.bos.ctrl.excel.impl.render.CellCommentRender;
import com.kingdee.bos.ctrl.excel.impl.render.ColExtRender;
import com.kingdee.bos.ctrl.excel.impl.render.DragRubberRender;
import com.kingdee.bos.ctrl.excel.impl.render.OutlineGroupColHeaderExtRender;
import com.kingdee.bos.ctrl.excel.impl.render.OutlineGroupColTagBarExtRender;
import com.kingdee.bos.ctrl.excel.impl.render.OutlineGroupRowHeaderExtRender;
import com.kingdee.bos.ctrl.excel.impl.render.OutlineGroupRowTagBarExtRender;
import com.kingdee.bos.ctrl.excel.impl.render.RowExtRender;
import com.kingdee.bos.ctrl.excel.impl.render.SparkRender;
import com.kingdee.bos.ctrl.excel.impl.render.TableExtRender;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Comment;
import com.kingdee.bos.ctrl.excel.model.struct.DiagonalHeader;
import com.kingdee.bos.ctrl.kdf.util.render.CellBackgroundRender;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.splitrectangle.SplitRectTextRender;
import java.util.ArrayList;

public final class RenderManager {
    private static IBasicRender _backgroundRender;
    private static IBasicRender _textRender;
    private static IBasicRender _commentRender;
    private static IBasicRender _diagonalRender;
    private SpreadContext _context;
    private IExtRender _tableExtRender;
    private IExtRender _colExtRender;
    private IExtRender _rowExtRender;
    private IExtRender _groupColHeaderExtRender;
    private IExtRender _groupRowHeaderExtRender;
    private IExtRender _groupColTagBarExtRender;
    private IExtRender _groupRowTagBarExtRender;
    private SparkRender _sparkRender;
    private DragRubberRender _dragRender;
    private CellDisplayProvider _cllDisplayProvider;

    RenderManager(SpreadContext context) {
        this._context = context;
    }

    public static IBasicRender getBackgroundRender() {
        if (_backgroundRender == null) {
            _backgroundRender = new CellBackgroundRender();
        }
        return _backgroundRender;
    }

    public static IBasicRender getTextRender() {
        if (_textRender == null) {
            _textRender = new SpreadCellTextRender();
        }
        return _textRender;
    }

    public static IBasicRender getCommentRender() {
        if (_commentRender == null) {
            _commentRender = new CellCommentRender();
        }
        return _commentRender;
    }

    public static IBasicRender getDiagonalRender() {
        if (_diagonalRender == null) {
            _diagonalRender = new SplitRectTextRender();
        }
        return _diagonalRender;
    }

    public IExtRender getTableExtRender() {
        if (this._tableExtRender == null) {
            this._tableExtRender = new TableExtRender(this._context);
        }
        return this._tableExtRender;
    }

    public IExtRender getCornerExtRender() {
        return null;
    }

    public IExtRender getRowExtRender() {
        if (this._rowExtRender == null) {
            this._rowExtRender = new RowExtRender(this._context);
        }
        return this._rowExtRender;
    }

    public IExtRender getColExtRender() {
        if (this._colExtRender == null) {
            this._colExtRender = new ColExtRender(this._context);
        }
        return this._colExtRender;
    }

    public IExtRender getGroupColHeaderExtRender() {
        if (this._groupColHeaderExtRender == null) {
            this._groupColHeaderExtRender = new OutlineGroupColHeaderExtRender(this._context);
        }
        return this._groupColHeaderExtRender;
    }

    public IExtRender getGroupRowHeaderExtRender() {
        if (this._groupRowHeaderExtRender == null) {
            this._groupRowHeaderExtRender = new OutlineGroupRowHeaderExtRender(this._context);
        }
        return this._groupRowHeaderExtRender;
    }

    public IExtRender getGroupColTagBarExtRender() {
        if (this._groupColTagBarExtRender == null) {
            this._groupColTagBarExtRender = new OutlineGroupColTagBarExtRender(this._context);
        }
        return this._groupColTagBarExtRender;
    }

    public IExtRender getGroupRowTagBarExtRender() {
        if (this._groupRowTagBarExtRender == null) {
            this._groupRowTagBarExtRender = new OutlineGroupRowTagBarExtRender(this._context);
        }
        return this._groupRowTagBarExtRender;
    }

    public IExtRender getGroupCornerExtRender() {
        return null;
    }

    public SparkRender getSparkRender() {
        if (this._sparkRender == null) {
            this._sparkRender = new SparkRender(this._context);
        }
        return this._sparkRender;
    }

    public DragRubberRender getDraggedRubberRender() {
        if (this._dragRender == null) {
            this._dragRender = new DragRubberRender();
        }
        return this._dragRender;
    }

    public void setUserExtRender(IExtRender userExtRender) {
        ((TableExtRender)this.getTableExtRender()).setUserExtRender(userExtRender);
    }

    public void setUserCellDisplayProvider(ICellDisplayProvider cllDisplayProvider) {
        ((CellDisplayProvider)this.getCellDisplayProvider()).setUserProvider(cllDisplayProvider);
    }

    public ICellDisplayProvider getCellDisplayProvider() {
        if (this._cllDisplayProvider == null) {
            this._cllDisplayProvider = new CellDisplayProvider();
        }
        return this._cllDisplayProvider;
    }

    private class CellDisplayProvider
    implements ICellDisplayProvider {
        private ICellDisplayProvider _userProvider;

        private CellDisplayProvider() {
        }

        public void setUserProvider(ICellDisplayProvider userProvider) {
            this._userProvider = userProvider;
        }

        @Override
        public IBasicRender getBaseRender(Cell cell, int viewMode) {
            IBasicRender rd;
            if (this._userProvider != null && (rd = this._userProvider.getBaseRender(cell, viewMode)) != null) {
                return rd;
            }
            DiagonalHeader d = cell.getDiagonalHeader();
            if (d != null) {
                boolean b;
                CellBlock cb = cell.getMerge(false);
                int r = cell.getRow();
                int c = cell.getCol();
                int r2 = cell.getRow();
                int c2 = cell.getCol();
                if (cb != null) {
                    r2 = cb.getRow2();
                    c2 = cb.getCol2();
                }
                if (b = d.checkValid(r, c, r2, c2)) {
                    return RenderManager.getDiagonalRender();
                }
            }
            return RenderManager.getTextRender();
        }

        @Override
        public Object getBaseValue(Cell cell, int viewMode) {
            Object value;
            if (this._userProvider != null && (value = this._userProvider.getBaseValue(cell, viewMode)) != null) {
                return value;
            }
            DiagonalHeader d = cell.getDiagonalHeader();
            if (d != null) {
                return d;
            }
            if (viewMode == 1) {
                return cell.getDisplayFormula();
            }
            return cell.getText();
        }

        @Override
        public ArrayList getExtRender(Cell cell, int viewMode) {
            Comment comment;
            ArrayList<IBasicRender> al = null;
            if (this._userProvider != null) {
                al = this._userProvider.getExtRender(cell, viewMode);
            }
            if ((comment = cell.getComment()) != null) {
                if (al == null) {
                    al = new ArrayList<IBasicRender>();
                }
                al.add(RenderManager.getCommentRender());
            }
            return al;
        }

        @Override
        public ArrayList getExtValue(Cell cell, int viewMode) {
            Comment comment;
            ArrayList<Comment> al = null;
            if (this._userProvider != null) {
                al = this._userProvider.getExtValue(cell, viewMode);
            }
            if ((comment = cell.getComment()) != null) {
                if (al == null) {
                    al = new ArrayList<Comment>();
                }
                al.add(comment);
            }
            return al;
        }
    }
}

