/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.impl.action;

import com.kingdee.bos.ctrl.common.digitalstyle.Format;
import com.kingdee.bos.ctrl.common.digitalstyle.Formats;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.common.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.impl.SpreadContext;
import com.kingdee.bos.ctrl.excel.impl.action.NFThousandUtil;
import com.kingdee.bos.ctrl.excel.impl.action.SpreadAction;
import com.kingdee.bos.ctrl.excel.impl.facade.MultiLanguageKeys;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Selection;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.util.SortedCellBlockArray;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import java.awt.event.ActionEvent;

class NF_DecimalIns_Action
extends SpreadAction {
    public NF_DecimalIns_Action(SpreadContext context) {
        super(context);
    }

    @Override
    protected void doAction(ActionEvent e) {
        Book book = this._context.getBook();
        Sheet sheet = book.getActiveSheet();
        boolean bBreak = true;
        boolean bComplete = true;
        sheet.getBook().getUndoManager().startGroup();
        Selection sel = sheet.getSheetOption().getSelection();
        SortedCellBlockArray sca = sel.toSortedBlocks();
        int size = sca.size();
        block2: for (int i = 0; i < size; ++i) {
            CellBlock cb = sca.getBlock(i);
            Sheet.ICellsIterator iter = sheet.getCellsIterator(cb, true, true);
            while (iter.hasNext()) {
                String nf;
                int c;
                Cell cell = iter.next();
                int r = cell.getRow();
                Style style = sheet.getCellStyle(r, c = cell.getCol());
                String of = style.getNumberFormat();
                if (Cell.isOldNumberFormat(of)) {
                    if (bBreak) {
                        if (this._context.getFacadeManager().showConfirmMessageBox(MultiLanguageKeys.getLocalText("Key_OldNumberformat"))) {
                            bBreak = false;
                        } else {
                            bComplete = false;
                            break block2;
                        }
                    }
                    of = "";
                }
                if (StringUtil.isEmptyString((String)of)) {
                    int scale = 0;
                    Variant var = cell.getValue();
                    if (var != null && var.isNumber()) {
                        try {
                            scale = var.toBigDecimal().scale();
                        }
                        catch (SyntaxErrorException e1) {
                            scale = 0;
                        }
                    }
                    StyleAttributes sa = Styles.getEmptySA();
                    if (scale <= 0) {
                        sa.setNumberFormat("0.0;-0.0");
                    } else {
                        sa.setNumberFormat(Formats.updateDecimalDigit((Format)Formats.getFormat((String)"0.0;-0.0"), (int)scale));
                    }
                    this._context.getRangeManager().getRange(r, c).setStyle(sa, Styles.getEmptySA());
                    continue;
                }
                if (NFThousandUtil.isThousandFormat(of) || of.equals(nf = Formats.updateDecimalDigit((Format)Formats.getFormat((String)of), (int)1))) continue;
                StyleAttributes sa = Styles.getEmptySA();
                sa.setNumberFormat(nf);
                this._context.getRangeManager().getRange(r, c).setStyle(sa, Styles.getEmptySA());
            }
        }
        if (bComplete) {
            sheet.getBook().getUndoManager().endGroup();
        } else {
            sheet.getBook().getUndoManager().cancelGroup();
        }
    }
}

