/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.impl.action;

import com.codahale.metrics.ConsoleReporter;
import com.codahale.metrics.Counter;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.kingdee.bos.ctrl.excel.impl.SpreadContext;
import com.kingdee.bos.ctrl.excel.impl.statistics.SheetStatPrinter;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.BookFormulaHelper;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDList;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.List;
import java.util.SortedSet;
import java.util.concurrent.TimeUnit;

public class StatDialog
extends KDDialog {
    private static final int REPORTER_TYPE_CONSOLE = 1;
    private static final int REPORTER_TYPE_PANLE = 0;
    private static final String FUNCTION_METER_NAME = "functionCalls";
    private static final String FUNCTION_COUNTER_NAME = "functionNums";
    private static final String FUNCTION_CALC_TIMER = "functionCalcTimer";
    private static final long REPORT_PERIOD = 30L;
    private static final String STATISTICS_SHEET_NAME = "formula statistics";
    private final transient MetricRegistry metricRegistry = new MetricRegistry();
    private transient ConsoleReporter panleReporter;
    private transient ConsoleReporter consoleReporter;
    private KDWorkButton showPanelReport;
    private KDWorkButton showConsoleReport;
    private KDWorkButton showSheetReport;
    private KDWorkButton resetMetrics;
    private KDList list;
    SpreadContext context;

    public StatDialog(Frame parent, SpreadContext context) {
        super(parent, false);
        this.context = context;
        this.init();
        this.initListeners();
        BookFormulaHelper.setConsole(this);
    }

    public StatDialog(Dialog parent, SpreadContext context) {
        super(parent, true);
        this.context = context;
        this.init();
        this.initListeners();
        BookFormulaHelper.setConsole(this);
    }

    private void init() {
        this.setTitle("\u62a5\u8868\u7edf\u8ba1\u9762\u677f");
        this.showPanelReport = new KDWorkButton();
        this.showConsoleReport = new KDWorkButton();
        this.showSheetReport = new KDWorkButton();
        this.resetMetrics = new KDWorkButton();
        KDPanel controlPanel = new KDPanel((LayoutManager)new GridLayout(1, 4));
        this.showPanelReport.setText("\u663e\u793a\u6267\u884c\u62a5\u544a");
        controlPanel.add((Component)this.showPanelReport);
        this.showConsoleReport.setText("\u663e\u793a\u540e\u53f0\u62a5\u544a");
        controlPanel.add((Component)this.showConsoleReport);
        this.showSheetReport.setText("\u5de5\u4f5c\u7c3f\u62a5\u544a");
        controlPanel.add((Component)this.showSheetReport);
        this.resetMetrics.setText("\u91cd\u7f6e\u6267\u884c\u62a5\u544a");
        controlPanel.add((Component)this.resetMetrics);
        List statList = BookFormulaHelper.statBookToList(this.context.getBook());
        this.list = new KDList(statList.toArray());
        KDScrollPane sp = new KDScrollPane((Component)this.list);
        Container c = this.getContentPane();
        c.setLayout(null);
        controlPanel.setPreferredSize(new Dimension(400, 25));
        c.add((Component)controlPanel);
        controlPanel.setBounds(0, 0, 400, 25);
        c.add((Component)sp);
        sp.setPreferredSize(new Dimension(400, 400));
        sp.setBounds(0, 25, 400, 400);
        this.setPreferredSize(new Dimension(407, 400));
        this.setResizable(false);
        this.setDefaultCloseOperation(2);
        this.pack();
        this.setLocationRelativeTo(null);
    }

    private void initListeners() {
        this.showPanelReport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (null == StatDialog.this.panleReporter) {
                    StatDialog.this.startMetricReport(0);
                    StatDialog.this.showPanelReport.setText("\u5173\u95ed\u6267\u884c\u62a5\u544a");
                } else {
                    StatDialog.this.closeMetricReport(0);
                    StatDialog.this.showPanelReport.setText("\u663e\u793a\u6267\u884c\u62a5\u544a");
                }
            }
        });
        this.showConsoleReport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (null == StatDialog.this.consoleReporter) {
                    StatDialog.this.startMetricReport(1);
                    StatDialog.this.showConsoleReport.setText("\u5173\u95ed\u540e\u53f0\u62a5\u544a");
                } else {
                    StatDialog.this.closeMetricReport(1);
                    StatDialog.this.showConsoleReport.setText("\u663e\u793a\u540e\u53f0\u62a5\u544a");
                }
            }
        });
        this.showSheetReport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (null != StatDialog.this.context) {
                    Book book = StatDialog.this.context.getBook();
                    Sheet sheet = book.getSheet(StatDialog.STATISTICS_SHEET_NAME);
                    if (null == sheet) {
                        sheet = new Sheet(book, StatDialog.STATISTICS_SHEET_NAME);
                        book.addSheet(sheet);
                    }
                    SheetStatPrinter print = new SheetStatPrinter(sheet, TimeUnit.MILLISECONDS.toNanos(1L), TimeUnit.SECONDS.toSeconds(1L));
                    print.print(StatDialog.this.metricRegistry);
                }
            }
        });
        this.resetMetrics.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                StatDialog statDialog = StatDialog.this;
                synchronized (statDialog) {
                    SortedSet names = StatDialog.this.metricRegistry.getNames();
                    for (String name : names) {
                        StatDialog.this.metricRegistry.remove(name);
                    }
                }
            }
        });
    }

    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201) {
            BookFormulaHelper.setConsole(null);
            this.closeMetricReport(1);
            this.closeMetricReport(0);
        }
        super.processWindowEvent(e);
    }

    public void markFunctionCalls() {
        Meter meter = this.metricRegistry.meter(FUNCTION_METER_NAME);
        meter.mark();
    }

    public void incressFunctionNums() {
        this.incressCounter(FUNCTION_COUNTER_NAME);
    }

    public Timer getFunctionTimer() {
        return this.getTimer(FUNCTION_CALC_TIMER);
    }

    public Timer getTimer(String name) {
        return this.metricRegistry.timer(name);
    }

    public void decressFunctionNums() {
        this.decressCounter(FUNCTION_COUNTER_NAME);
    }

    public void incressCounter(String counterName) {
        Counter counter = this.metricRegistry.counter(counterName);
        counter.inc();
    }

    public void decressCounter(String counterName) {
        Counter counter = this.metricRegistry.counter(counterName);
        counter.dec();
    }

    private void startMetricReport(int type) {
        if (type == 1 && null == this.consoleReporter) {
            this.consoleReporter = ConsoleReporter.forRegistry((MetricRegistry)this.metricRegistry).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).build();
            this.consoleReporter.start(30L, TimeUnit.SECONDS);
        } else if (type == 0 && null == this.panleReporter) {
            this.panleReporter = ConsoleReporter.forRegistry((MetricRegistry)this.metricRegistry).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).outputTo(new PrintStream(new PrintStream(new ConsoleOutputStream()))).build();
            this.panleReporter.start(30L, TimeUnit.SECONDS);
        }
    }

    private void closeMetricReport(int type) {
        if (type == 1 && null != this.consoleReporter) {
            this.consoleReporter.stop();
            this.consoleReporter = null;
        } else if (type == 0 && null != this.panleReporter) {
            this.panleReporter.stop();
            this.panleReporter = null;
        }
    }

    private class ConsoleOutputStream
    extends OutputStream {
        private int bufferSize = 8192;
        private byte[] buf = new byte[this.bufferSize];
        private int count = 0;

        private ConsoleOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
            if (this.count == this.bufferSize) {
                StatDialog.this.list.addElement((Object)new String(this.buf));
                this.count = 0;
            }
            this.buf[this.count] = (byte)b;
            ++this.count;
        }

        @Override
        public void flush() throws IOException {
            StatDialog.this.list.addElement((Object)new String(this.buf, 0, this.count));
            this.count = 0;
        }

        @Override
        public void close() throws IOException {
            this.flush();
            this.buf = null;
        }
    }
}

