/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.impl.facade.wizzard;

import com.kingdee.bos.ctrl.excel.impl.SpreadContext;
import com.kingdee.bos.ctrl.excel.impl.facade.MultiLanguageKeys;
import com.kingdee.bos.ctrl.excel.impl.facade.rangesel.RangeSelector;
import com.kingdee.bos.ctrl.excel.impl.facade.wizzard.ISpreadWizzard;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.embed.EmbedObject;
import com.kingdee.bos.ctrl.excel.model.struct.embed.EmbedhLayer;
import com.kingdee.bos.ctrl.excel.model.struct.embed.chart.Chart;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDRadioButton;
import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import com.kingdee.bos.ctrl.swing.KDTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import org.jdesktop.layout.GroupLayout;

public class WizzardChartEx
extends KDDialog
implements ISpreadWizzard {
    private SpreadContext _context;
    private Chart _chart;
    private KDTabbedPane tab;
    private ChartAppearancePanel apcPanel;
    private ChartDatasourcePanel dataPanel;
    private ButtonPanel btnPanel;

    public WizzardChartEx(Dialog parent, SpreadContext context) {
        super(parent);
        this._context = context;
        this.init();
        this.setSize(430, 260);
        this.setResizable(false);
        this.setModal(true);
        this.setLocationRelativeTo(parent);
    }

    public WizzardChartEx(Frame parent, SpreadContext context) {
        super(parent);
        this._context = context;
        this.init();
        this.setSize(430, 260);
        this.setResizable(false);
        this.setModal(true);
        this.setLocationRelativeTo(parent);
    }

    private void init() {
        this.tab = new KDTabbedPane();
        this.apcPanel = new ChartAppearancePanel();
        this.dataPanel = new ChartDatasourcePanel();
        this.btnPanel = new ButtonPanel();
        this.tab.addTab(MultiLanguageKeys.getLocalText("Key_EmbededObjectFacade", "\u5916\u89c2"), (Component)((Object)this.apcPanel));
        this.tab.addTab(MultiLanguageKeys.getLocalText("Key_EmbededObjectData", "\u6570\u636e"), (Component)((Object)this.dataPanel));
        Container con = this.getContentPane();
        con.setLayout(new BorderLayout());
        con.add((Component)this.tab);
        con.add((Component)((Object)this.btnPanel), "South");
    }

    @Override
    public void commit() {
    }

    @Override
    public boolean prepare() {
        Sheet sheet = this._context.getBook().getActiveSheet();
        EmbedhLayer gl = sheet.getEmbedments(false);
        if (gl != null) {
            EmbedObject gr = gl.getActiveSelectedEmbed();
            if (gr instanceof Chart) {
                this._chart = (Chart)gr;
                return true;
            }
            return false;
        }
        this._chart = null;
        return true;
    }

    private class ButtonPanel
    extends KDPanel {
        private KDButton cancel;
        private KDButton ok;

        ButtonPanel() {
            this.setPreferredSize(new Dimension(500, 35));
            this.initComps();
            this.initListeners();
        }

        private void initComps() {
            this.cancel = new KDButton();
            this.ok = new KDButton();
            this.cancel.setText(MultiLanguageKeys.getLocalText("KEY_CANCEL", "\u53d6\u6d88"));
            this.ok.setText(MultiLanguageKeys.getLocalText("KEY_OK", "\u786e\u5b9a"));
            GroupLayout layout = new GroupLayout((Container)((Object)this));
            this.setLayout((LayoutManager)layout);
            layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap(392, Short.MAX_VALUE).add((Component)this.ok).addPreferredGap(1).add((Component)this.cancel).addContainerGap()));
            layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.cancel).add((Component)this.ok)).addContainerGap(-1, Short.MAX_VALUE)));
        }

        private void initListeners() {
            this.cancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    WizzardChartEx.this.setVisible(false);
                }
            });
            this.ok.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    WizzardChartEx.this.setVisible(false);
                }
            });
        }
    }

    private class ChartDatasourcePanel
    extends KDPanel {
        private KDLabel angleLbl;
        private KDLabel serialLbl;
        private KDRadioButton byCol;
        private KDRadioButton byRow;
        private KDTextField angle;
        private RangeSelector groupRange;
        private RangeSelector dataRange;

        private ChartDatasourcePanel() {
            this.initComps();
            this.initListeners();
        }

        private void initComps() {
            this.groupRange = new RangeSelector(WizzardChartEx.this._context);
            this.groupRange.setWithOpreatorEqual(true);
            this.dataRange = new RangeSelector(WizzardChartEx.this._context);
            this.dataRange.setWithOpreatorEqual(true);
            this.angle = new KDTextField();
            this.byCol = new KDRadioButton();
            this.byRow = new KDRadioButton();
            this.angleLbl = new KDLabel();
            this.serialLbl = new KDLabel();
            this.setLayout(null);
            KDLabelContainer con = new KDLabelContainer(MultiLanguageKeys.getLocalText("Key_EmbededObjectGroup", "\u7ec4        \u522b    "), (JComponent)this.groupRange);
            con.setBoundLabelUnderline(true);
            this.add((Component)con);
            con.setBounds(20, 30, 200, 21);
            this.angle.setText("0");
            this.add((Component)this.angle);
            this.angle.setBounds(320, 30, 80, 21);
            con = new KDLabelContainer(MultiLanguageKeys.getLocalText("Key_EmbededObjectDataArea", "\u6570\u636e\u533a\u57df    "), (JComponent)this.dataRange);
            con.setBoundLabelUnderline(true);
            this.add((Component)con);
            con.setBounds(20, 100, 200, 21);
            this.byCol.setText(MultiLanguageKeys.getLocalText("Key_EmbededObjectColumn", "\u5217"));
            this.add((Component)this.byCol);
            this.byCol.setBounds(360, 100, 40, 23);
            this.byRow.setText(MultiLanguageKeys.getLocalText("Key_EmbededObjectRow", "\u884c"));
            this.add((Component)this.byRow);
            this.byRow.setBounds(320, 100, 40, 23);
            this.angleLbl.setText(MultiLanguageKeys.getLocalText("Key_EmbededObjectDip", "\u503e\u89d2\uff1a"));
            this.add((Component)this.angleLbl);
            this.angleLbl.setBounds(250, 34, 36, 15);
            this.serialLbl.setText(MultiLanguageKeys.getLocalText("Key_EmbedeObjectSeries", "\u7cfb\u5217\u4ea7\u751f\u5728\uff1a"));
            this.add((Component)this.serialLbl);
            this.serialLbl.setBounds(250, 104, 72, 15);
        }

        private void initListeners() {
        }
    }

    private class ChartAppearancePanel
    extends KDPanel {
        private KDComboBox types;
        private KDTextField chartTitle;
        private KDTextField xTitle;
        private KDTextField yTitle;

        private ChartAppearancePanel() {
            this.initComps();
            this.initListeners();
        }

        private void initComps() {
            this.setLayout(null);
            this.chartTitle = new KDTextField();
            this.xTitle = new KDTextField();
            this.yTitle = new KDTextField();
            this.types = new KDComboBox();
            this.types.setModel(new DefaultComboBoxModel<String>(new String[]{MultiLanguageKeys.getLocalText("Key_EmbededObjectChartType", "\u56fe\u8868\u7c7b\u578b")}));
            KDLabelContainer con = new KDLabelContainer(MultiLanguageKeys.getLocalText("Key_EmbededObjectChartTitle", "\u56fe\u8868\u6807\u9898             "), (JComponent)this.chartTitle);
            con.setBoundLabelUnderline(true);
            this.add((Component)con);
            con.setBounds(30, 10, 360, 21);
            con = new KDLabelContainer(MultiLanguageKeys.getLocalText("Key_EmbededObjectXAxisis", "\u5206\u7c7b(X)\u8f74\u6807\u9898    "), (JComponent)this.xTitle);
            con.setBoundLabelUnderline(true);
            this.add((Component)con);
            con.setBounds(30, 50, 360, 21);
            con = new KDLabelContainer(MultiLanguageKeys.getLocalText("Key_EmbededObjectYAxisis", "\u6570\u503c(Y)\u8f74\u6807\u9898    "), (JComponent)this.yTitle);
            con.setBoundLabelUnderline(true);
            this.add((Component)con);
            con.setBounds(30, 90, 360, 21);
            con = new KDLabelContainer(MultiLanguageKeys.getLocalText("Key_EmbededObjectChartType", "\u56fe\u8868\u7c7b\u578b             "));
            con.setBoundLabelUnderline(true);
            this.add((Component)con);
            con.setBounds(30, 130, 360, 23);
            con.setBoundEditor((JComponent)this.types);
        }

        private void initListeners() {
        }
    }
}

