/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.impl.facade.wizzard;

import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.excel.impl.SpreadContext;
import com.kingdee.bos.ctrl.excel.impl.facade.MultiLanguageKeys;
import com.kingdee.bos.ctrl.excel.impl.facade.rangesel.RangeSelector;
import com.kingdee.bos.ctrl.excel.impl.facade.wizzard.ISpreadWizzard;
import com.kingdee.bos.ctrl.excel.impl.icons.ResourceManager;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.SheetBaseMath;
import com.kingdee.bos.ctrl.excel.model.struct.validate.ValidationList;
import com.kingdee.bos.ctrl.excel.model.struct.validate.util.MessagedValidate;
import com.kingdee.bos.ctrl.excel.model.struct.validate.util.Validate;
import com.kingdee.bos.ctrl.excel.model.util.IntArray;
import com.kingdee.bos.ctrl.excel.model.util.SortedCellBlockArray;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDSeparator;
import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import com.kingdee.bos.ctrl.swing.KDTextArea;
import com.kingdee.bos.ctrl.swing.KDTextField;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Icon;

public final class WizzardValidation
extends KDDialog
implements ISpreadWizzard {
    private static final String panelname = MultiLanguageKeys.getLocalText("KEY_SET", "\u8bbe\u7f6e");
    private static final String inputlabel = MultiLanguageKeys.getLocalText("KEY_VALIDATION_Input_label", "\u8f93\u5165\u6d88\u606f");
    private static final String alertlabel = MultiLanguageKeys.getLocalText("KEY_VALIDATION_Alert_label", "\u51fa\u9519\u8b66\u544a");
    private KDButton _btnOk;
    private KDButton _btnCancel;
    private KDButton _btnClear;
    private KDTabbedPane _tabPanel;
    private ValidatePanel _validatePanel;
    private InputTextPanel _inputTextPanel;
    private ErrorTextPanel _errorTextPanel;
    private Sheet origalSheet;
    private SpreadContext _context;
    private boolean _isMixedValidate;
    private MessagedValidate _oldValidate;

    public WizzardValidation(Frame parent, SpreadContext context) {
        super(parent, true);
        this._context = context;
        this.initComps();
        this.layoutComps();
        this.initListeners();
    }

    public WizzardValidation(Dialog parent, SpreadContext context) {
        super(parent, true);
        this._context = context;
        this.initComps();
        this.layoutComps();
        this.initListeners();
    }

    @Override
    public void commit() {
    }

    @Override
    public boolean prepare() {
        this._isMixedValidate = false;
        this._oldValidate = null;
        Range rg = this._context.getRangeManager().getSelectionRange();
        ValidationList vl = this._context.getBook().getActiveSheet().getValidations();
        this.origalSheet = this._context.getBook().getActiveSheet();
        IntArray intersects = new IntArray();
        boolean allSeted = vl.calcIntersects(rg, intersects);
        int count = intersects.size();
        if (count > 1) {
            this._isMixedValidate = true;
            boolean b = WindowUtil.msgboxYesNo((Component)((Object)this._context), (Object)MultiLanguageKeys.getLocalText("KEY_VALIDATION_Message_MultiValidations", "\u9009\u5b9a\u533a\u57df\u5305\u542b\u591a\u79cd\u6570\u636e\u6709\u6548\u6027\u3002\u662f\u5426\u6e05\u9664\u5f53\u524d\u8bbe\u7f6e\u5e76\u7ee7\u7eed!"), (String)"KDSpread");
            if (!b) {
                return false;
            }
        } else if (count == 1) {
            if (!allSeted) {
                this._isMixedValidate = true;
                int ret = WindowUtil.msgboxYesNoCancel((Component)((Object)this._context), (Object)MultiLanguageKeys.getLocalText("KEY_VALIDATION_Message_SomeNoValidation", "\u9009\u5b9a\u533a\u57df\u67d0\u4e9b\u5355\u5143\u683c\u672a\u8bbe\u7f6e\u6570\u636e\u6709\u6548\u6027\u3002\u662f\u5426\u5bf9\u5176\u5b9e\u65bd\u5f53\u524d\u7684\u6570\u636e\u6709\u6548\u6027\u8bbe\u7f6e"), (String)"KDSpread");
                if (0 == ret) {
                    this._oldValidate = vl.getValidation(intersects.get(0)).getMessagedValidate();
                } else if (2 == ret) {
                    return false;
                }
            } else {
                this._oldValidate = vl.getValidation(intersects.get(0)).getMessagedValidate();
            }
            int offsetX = 0;
            int offsetY = 0;
            this._oldValidate.setOffsetMax(null);
            this._oldValidate.setOffsetMin(null);
            if (rg.isSingleCell()) {
                SortedCellBlockArray blockArray = vl.getValidation(intersects.get(0)).getBlocks();
                CellBlock b = rg.getBlock(0);
                CellBlock block = blockArray.getBlock(0);
                offsetX = b.getCol() - block.getCol();
                offsetY = b.getRow() - block.getRow();
            }
            this._oldValidate.setOffsetMin(SheetBaseMath.getShiftFormula(this._oldValidate.getMin(), this.origalSheet, offsetX, offsetY));
            this._oldValidate.setOffsetMax(SheetBaseMath.getShiftFormula(this._oldValidate.getMax(), this.origalSheet, offsetX, offsetY));
        }
        this.updateByValidate(this._oldValidate);
        return true;
    }

    private void updateByValidate(MessagedValidate mv) {
        this._validatePanel.updatePanelByValidate(mv);
        this._inputTextPanel.updatePanelByValidate(mv);
        this._errorTextPanel.updatePanelByValidate(mv);
    }

    private void initComps() {
        this._btnOk = new KDButton(MultiLanguageKeys.getLocalText("KEY_OK", ""));
        this._btnCancel = new KDButton(MultiLanguageKeys.getLocalText("KEY_CANCEL", ""));
        this._btnClear = new KDButton(MultiLanguageKeys.getLocalText("KEY_CLEARALL", "\u5168\u90e8\u6e05\u9664"));
        this._tabPanel = new KDTabbedPane();
        this._validatePanel = new ValidatePanel(this._context);
        this._inputTextPanel = new InputTextPanel();
        this._errorTextPanel = new ErrorTextPanel();
    }

    private void layoutComps() {
        this.setSize(470, 345);
        this.setResizable(false);
        KDPanel ctrlPanel = new KDPanel();
        this.getContentPane().setLayout(null);
        this.getContentPane().add((Component)this._tabPanel);
        this.getContentPane().add((Component)ctrlPanel);
        ctrlPanel.setLayout(null);
        ctrlPanel.setBounds(0, 285, 470, 30);
        ctrlPanel.setOpaque(false);
        ctrlPanel.add((Component)this._btnOk);
        ctrlPanel.add((Component)this._btnCancel);
        ctrlPanel.add((Component)this._btnClear);
        this._btnClear.setLimitedSize(false);
        this._btnClear.setBounds(10, 0, 95, 21);
        this._btnOk.setLocation(300, 0);
        this._btnCancel.setLocation(376, 0);
        this._tabPanel.setBounds(10, 10, 440, 265);
        this._tabPanel.setOpaque(false);
        this._tabPanel.addTab(panelname, (Component)((Object)this._validatePanel));
        this._tabPanel.addTab(inputlabel, (Component)((Object)this._inputTextPanel));
        this._tabPanel.addTab(alertlabel, (Component)((Object)this._errorTextPanel));
        this._validatePanel.updatePanelByValidate(null);
        this._inputTextPanel.updatePanelByValidate(null);
        this._errorTextPanel.updatePanelByValidate(null);
        this.getContentPane().setBackground(this._validatePanel.getBackground());
    }

    private void initListeners() {
        ButtonActionHandler buttonActionHandler = new ButtonActionHandler();
        this._btnOk.addActionListener((ActionListener)buttonActionHandler);
        this._btnCancel.addActionListener((ActionListener)buttonActionHandler);
        this._btnClear.addActionListener((ActionListener)buttonActionHandler);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                WizzardValidation.this.closeDialog();
            }
        });
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    private boolean isEmptyValidate() {
        return this._validatePanel.isEmptyValidate() && this._inputTextPanel.isEmptyValidate() && this._errorTextPanel.isEmptyValidate();
    }

    private int updateValidate(MessagedValidate validate) {
        int check = this._validatePanel.updateValidate(validate, this._context.getBook().getActiveSheet());
        if (Validate.isOk(check)) {
            this._inputTextPanel.updateValidate(validate, this._context.getBook().getActiveSheet());
            this._errorTextPanel.updateValidate(validate, this._context.getBook().getActiveSheet());
        }
        return check;
    }

    private class ButtonActionHandler
    implements ActionListener {
        private ButtonActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object o = e.getSource();
            if (o == WizzardValidation.this._btnOk) {
                int check;
                MessagedValidate retMV = null;
                boolean isEmpty = WizzardValidation.this.isEmptyValidate();
                if (WizzardValidation.this._isMixedValidate) {
                    if (!isEmpty && !Validate.isOk(check = WizzardValidation.this.updateValidate(retMV = new MessagedValidate()))) {
                        String msg = null;
                        msg = Validate.isSyntaxError(check) ? MultiLanguageKeys.getLocalText("KEY_VALIDATION_Error_syntax", "\u5b57\u6bb5\u7684\u8f93\u5165\u516c\u5f0f\u5b58\u5728\u8bed\u6cd5\u9519\u8bef!") : (Validate.isValueError(check) ? MultiLanguageKeys.getLocalText("KEY_VALIDATION_Error_value", "\u5b57\u6bb5\u7684\u6570\u503c\u65e0\u6cd5\u6b63\u5e38\u89e3\u6790!") : MultiLanguageKeys.getLocalText("KEY_VALIDATION_Error_minmax", "\u63d0\u4ea4\u9519\u8bef:\u6700\u5927\u503c\u5fc5\u987b\u5927\u4e8e\u6216\u7b49\u4e8e\u6700\u5c0f\u503c!"));
                        WizzardValidation.this._context.getFacadeManager().showErrorMessageBox(msg, 64);
                        return;
                    }
                } else if (isEmpty) {
                    if (WizzardValidation.this._oldValidate == null) {
                        WizzardValidation.this.closeDialog();
                        return;
                    }
                } else {
                    retMV = new MessagedValidate();
                    check = WizzardValidation.this.updateValidate(retMV);
                    if (!Validate.isOk(check)) {
                        String msg = null;
                        msg = Validate.isSyntaxError(check) ? MultiLanguageKeys.getLocalText("KEY_VALIDATION_Error_syntax", "\u5b57\u6bb5\u7684\u8f93\u5165\u516c\u5f0f\u5b58\u5728\u8bed\u6cd5\u9519\u8bef!") : (Validate.isValueError(check) ? MultiLanguageKeys.getLocalText("KEY_VALIDATION_Error_value", "\u5b57\u6bb5\u7684\u6570\u503c\u65e0\u6cd5\u6b63\u5e38\u89e3\u6790!") : MultiLanguageKeys.getLocalText("KEY_VALIDATION_Error_minmax", "\u63d0\u4ea4\u9519\u8bef:\u6700\u5927\u503c\u5fc5\u987b\u5927\u4e8e\u6216\u7b49\u4e8e\u6700\u5c0f\u503c!"));
                        WizzardValidation.this._context.getFacadeManager().showErrorMessageBox(msg, 64);
                        return;
                    }
                    if (null != WizzardValidation.this._oldValidate) {
                        String retMin = retMV.getMin();
                        String retMax = retMV.getMax();
                        if (!StringUtil.isEmptyString((String)retMin) && retMin.equals(WizzardValidation.this._oldValidate.getOffsetMin())) {
                            retMV.setMin(WizzardValidation.this._oldValidate.getMin());
                        }
                        if (!StringUtil.isEmptyString((String)retMax) && retMax.equals(WizzardValidation.this._oldValidate.getOffsetMax())) {
                            retMV.setMax(WizzardValidation.this._oldValidate.getMax());
                        }
                    }
                    if (retMV.equals(WizzardValidation.this._oldValidate)) {
                        WizzardValidation.this.closeDialog();
                        return;
                    }
                }
                Range range = WizzardValidation.this.origalSheet.getSelectionRange();
                range.mergeSelf();
                range.insertValidataion(retMV);
                if (retMV != null && retMV.getType() == Validate.Type_List) {
                    WizzardValidation.this._context.getFacadeManager().showPopupListButton(true);
                } else if (retMV == null || retMV.getType() != Validate.Type_List) {
                    WizzardValidation.this._context.getFacadeManager().showPopupListButton(false);
                }
                WizzardValidation.this.closeDialog();
            } else if (o == WizzardValidation.this._btnClear) {
                WizzardValidation.this.updateByValidate(null);
            } else {
                WizzardValidation.this.closeDialog();
            }
        }
    }

    private static class ValidatePanel
    extends KDPanel {
        private final String message_condition = MultiLanguageKeys.getLocalText("KEY_VALIDATION_condition", "\u6709\u6548\u6027\u6761\u4ef6");
        private final String message_ignoreBlank = MultiLanguageKeys.getLocalText("KEY_VALIDATION_ignoreBlank", "\u5ffd\u7565\u7a7a\u503c");
        private final String message_cellrangelist = MultiLanguageKeys.getLocalText("KEY_VALIDATION_cellrangelist", "\u63d0\u4f9b\u4e0b\u62c9\u7bad\u5934");
        private final String message_allow = MultiLanguageKeys.getLocalText("KEY_VALIDATION_allow", "\u5141\u8bb8") + ":";
        private final String message_any = MultiLanguageKeys.getLocalText("KEY_VALIDATION_any", "\u4efb\u4f55\u503c");
        private final String message_whole = MultiLanguageKeys.getLocalText("KEY_VALIDATION_whole", "\u6574\u6570");
        private final String message_decimal = MultiLanguageKeys.getLocalText("KEY_VALIDATION_decimal", "\u5c0f\u6570");
        private final String message_list = MultiLanguageKeys.getLocalText("KEY_VALIDATION_list", "\u5e8f\u5217");
        private final String message_date = MultiLanguageKeys.getLocalText("KEY_VALIDATION_date", "\u65e5\u671f");
        private final String message_time = MultiLanguageKeys.getLocalText("KEY_VALIDATION_time", "\u65f6\u95f4");
        private final String message_textLength = MultiLanguageKeys.getLocalText("KEY_VALIDATION_textLength", "\u6587\u672c\u957f\u5ea6");
        private final String message_custom = MultiLanguageKeys.getLocalText("KEY_VALIDATION_custom", "\u81ea\u5b9a\u4e49");
        private final String message_data = MultiLanguageKeys.getLocalText("KEY_VALIDATION_data", "\u6570\u636e") + ":";
        private final String message_between = MultiLanguageKeys.getLocalText("KEY_VALIDATION_between", "\u4ecb\u4e8e");
        private final String message_notbetween = MultiLanguageKeys.getLocalText("KEY_VALIDATION_notbetween", "\u672a\u4ecb\u4e8e");
        private final String message_equal = MultiLanguageKeys.getLocalText("KEY_VALIDATION_equal", "\u7b49\u4e8e");
        private final String message_notequal = MultiLanguageKeys.getLocalText("KEY_VALIDATION_notequal", "\u4e0d\u7b49\u4e8e");
        private final String message_greater = MultiLanguageKeys.getLocalText("KEY_VALIDATION_greater", "\u5927\u4e8e");
        private final String message_less = MultiLanguageKeys.getLocalText("KEY_VALIDATION_less", "\u5c0f\u4e8e");
        private final String message_greaterorequal = MultiLanguageKeys.getLocalText("KEY_VALIDATION_greaterorequal", "\u5927\u4e8e\u6216\u7b49\u4e8e");
        private final String message_lessorequal = MultiLanguageKeys.getLocalText("KEY_VALIDATION_lessorequal", "\u5c0f\u4e8e\u6216\u7b49\u4e8e");
        private final String message_min = MultiLanguageKeys.getLocalText("KEY_MIN", "\u6700\u5c0f\u503c");
        private final String message_max = MultiLanguageKeys.getLocalText("KEY_MAX", "\u6700\u5927\u503c");
        private final String message_value = MultiLanguageKeys.getLocalText("KEY_VALIDATION_value", "\u6570\u503c");
        private final String message_source = MultiLanguageKeys.getLocalText("KEY_VALIDATION_source", "\u6765\u6e90");
        private final String message_length = MultiLanguageKeys.getLocalText("KEY_VALIDATION_length", "\u957f\u5ea6");
        private final String message_mindate = MultiLanguageKeys.getLocalText("KEY_VALIDATION_mindate", "\u5f00\u59cb\u65e5\u671f");
        private final String message_maxdate = MultiLanguageKeys.getLocalText("KEY_VALIDATION_maxdate", "\u7ed3\u675f\u65e5\u671f");
        private final String message_mintime = MultiLanguageKeys.getLocalText("KEY_VALIDATION_mintime", "\u5f00\u59cb\u65f6\u95f4");
        private final String message_maxtime = MultiLanguageKeys.getLocalText("KEY_VALIDATION_maxtime", "\u7ed3\u675f\u65f6\u95f4");
        private final String message_formula = MultiLanguageKeys.getLocalText("KEY_FORMULA", "\u516c\u5f0f");
        private final String message_setallsame = MultiLanguageKeys.getLocalText("KEY_VALIDATION_setallsame", "\u5bf9\u540c\u6837\u8bbe\u7f6e\u7684\u5176\u4ed6\u5355\u5143\u683c\u5e94\u7528\u8fd9\u4e9b\u66f4\u6539");
        private KDLabel _lbCondition;
        private KDSeparator _sep;
        private KDLabel _lbType;
        private KDComboBox _cbxType;
        private KDLabel _lbQualify;
        private KDComboBox _cbxQualify;
        private KDCheckBox _ckbIgnoreBlank;
        private KDCheckBox _ckbCellRangeList;
        private KDLabel _lbCustom;
        private KDLabel _lbCustom2;
        private RangeSelector _tfCustom;
        private RangeSelector _tfCustom2;
        private KDCheckBox _ckbSetAllSames;
        private ItemListener _itemHandler;
        private SpreadContext _context;

        private ValidatePanel(SpreadContext context) {
            this._context = context;
            this.initComps();
            this.initListeners();
            this.layoutComps();
        }

        private void updatePanelByValidate(Validate validate) {
            this._cbxType.removeItemListener(this._itemHandler);
            this._cbxQualify.removeItemListener(this._itemHandler);
            if (validate != null) {
                String type = validate.getType();
                this._ckbIgnoreBlank.setEnabled(true);
                this._ckbIgnoreBlank.setSelected(!validate.isUseBlank());
                this._lbCustom.setVisible(true);
                this._tfCustom.setVisible(true);
                this._tfCustom.setText(validate.getOffsetMin());
                if (Validate.Type_ANY.equals(type)) {
                    this._cbxType.setSelectedItem((Object)this.message_any);
                    this._cbxQualify.setSelectedItem((Object)this.message_between);
                    this._cbxQualify.setEnabled(false);
                    this._ckbIgnoreBlank.setSelected(true);
                    this._ckbIgnoreBlank.setEnabled(false);
                    this._ckbCellRangeList.setVisible(false);
                    this._lbCustom.setVisible(false);
                    this._tfCustom.setVisible(false);
                    this._tfCustom.setText("");
                    this._lbCustom2.setVisible(false);
                    this._tfCustom2.setVisible(false);
                    this._tfCustom2.setText("");
                } else if (Validate.Type_List.equals(type)) {
                    this._cbxType.setSelectedItem((Object)this.message_list);
                    this._cbxQualify.setEnabled(false);
                    this._ckbCellRangeList.setVisible(true);
                    this._ckbCellRangeList.setSelected(validate.hasCellRangeList());
                    this._lbCustom.setText(this.message_source);
                    this._lbCustom2.setVisible(false);
                    this._tfCustom2.setVisible(false);
                } else if (Validate.Type_Custom.equals(type)) {
                    this._cbxType.setSelectedItem((Object)this.message_custom);
                    this._cbxQualify.setEnabled(false);
                    this._ckbCellRangeList.setVisible(false);
                    this._lbCustom.setText(this.message_formula);
                    this._lbCustom2.setVisible(false);
                    this._tfCustom2.setVisible(false);
                } else {
                    this._ckbCellRangeList.setVisible(false);
                    boolean bDate = false;
                    boolean bTime = false;
                    boolean bTextLength = false;
                    if (Validate.Type_Whole.equals(type)) {
                        this._cbxType.setSelectedItem((Object)this.message_whole);
                    } else if (Validate.Type_Decimal.equals(type)) {
                        this._cbxType.setSelectedItem((Object)this.message_decimal);
                    } else if (Validate.Type_Date.equals(type)) {
                        bDate = true;
                        this._cbxType.setSelectedItem((Object)this.message_date);
                    } else if (Validate.Type_Time.equals(type)) {
                        bTime = true;
                        this._cbxType.setSelectedItem((Object)this.message_time);
                    } else {
                        bTextLength = true;
                        this._cbxType.setSelectedItem((Object)this.message_textLength);
                    }
                    boolean bTwoCustom = false;
                    this._cbxQualify.setEnabled(true);
                    String qualifier = validate.getQualifier();
                    if (Validate.Between.equals(qualifier)) {
                        this._cbxQualify.setSelectedItem((Object)this.message_between);
                        bTwoCustom = true;
                    } else if (Validate.NotBetween.equals(qualifier)) {
                        this._cbxQualify.setSelectedItem((Object)this.message_notbetween);
                        bTwoCustom = true;
                    } else if (Validate.Equal.equals(qualifier)) {
                        this._cbxQualify.setSelectedItem((Object)this.message_equal);
                    } else if (Validate.NotEqual.equals(qualifier)) {
                        this._cbxQualify.setSelectedItem((Object)this.message_notequal);
                    } else if (Validate.Greater.equals(qualifier)) {
                        this._cbxQualify.setSelectedItem((Object)this.message_greater);
                    } else if (Validate.Less.equals(qualifier)) {
                        this._cbxQualify.setSelectedItem((Object)this.message_less);
                    } else if (Validate.GreaterOrEqual.equals(qualifier)) {
                        this._cbxQualify.setSelectedItem((Object)this.message_greaterorequal);
                    } else if (Validate.LessOrEqual.equals(qualifier)) {
                        this._cbxQualify.setSelectedItem((Object)this.message_lessorequal);
                    }
                    if (bTwoCustom) {
                        this._lbCustom2.setVisible(true);
                        this._tfCustom2.setVisible(true);
                        this._tfCustom2.setText(validate.getOffsetMax());
                        if (bDate) {
                            this._lbCustom.setText(this.message_mindate);
                            this._lbCustom2.setText(this.message_maxdate);
                        } else if (bTime) {
                            this._lbCustom.setText(this.message_mintime);
                            this._lbCustom2.setText(this.message_maxtime);
                        } else {
                            this._lbCustom.setText(this.message_min);
                            this._lbCustom2.setText(this.message_max);
                        }
                    } else {
                        this._lbCustom2.setVisible(false);
                        this._tfCustom2.setVisible(false);
                        if (bDate) {
                            this._lbCustom.setText(this.message_date);
                        } else if (bTime) {
                            this._lbCustom.setText(this.message_time);
                        } else if (bTextLength) {
                            this._lbCustom.setText(this.message_length);
                        } else {
                            this._lbCustom.setText(this.message_value);
                        }
                    }
                }
            } else {
                this._cbxType.setSelectedItem((Object)this.message_any);
                this._cbxQualify.setSelectedItem((Object)this.message_between);
                this._cbxQualify.setEnabled(false);
                this._ckbIgnoreBlank.setSelected(true);
                this._ckbIgnoreBlank.setEnabled(false);
                this._ckbCellRangeList.setVisible(false);
                this._lbCustom.setVisible(false);
                this._tfCustom.setVisible(false);
                this._tfCustom.setText("");
                this._lbCustom2.setVisible(false);
                this._tfCustom2.setVisible(false);
                this._tfCustom2.setText("");
            }
            this._cbxType.addItemListener(this._itemHandler);
            this._cbxQualify.addItemListener(this._itemHandler);
        }

        private int updateValidate(Validate validate, Sheet sheet) {
            Object o = this._cbxType.getSelectedItem();
            if (this.message_any.equals(o)) {
                return 2;
            }
            if (this.message_whole.equals(o)) {
                validate.setType(Validate.Type_Whole);
            } else if (this.message_decimal.equals(o)) {
                validate.setType(Validate.Type_Decimal);
            } else if (this.message_list.equals(o)) {
                validate.setType(Validate.Type_List);
            } else if (this.message_date.equals(o)) {
                validate.setType(Validate.Type_Date);
            } else if (this.message_time.equals(o)) {
                validate.setType(Validate.Type_Time);
            } else if (this.message_textLength.equals(o)) {
                validate.setType(Validate.Type_TextLength);
            } else if (this.message_custom.equals(o)) {
                validate.setType(Validate.Type_Custom);
            }
            o = this._cbxQualify.getSelectedItem();
            if (this.message_between.equals(o)) {
                validate.setQualifier(Validate.Between);
            } else if (this.message_notbetween.equals(o)) {
                validate.setQualifier(Validate.NotBetween);
            } else if (this.message_equal.equals(o)) {
                validate.setQualifier(Validate.Equal);
            } else if (this.message_notequal.equals(o)) {
                validate.setQualifier(Validate.NotEqual);
            } else if (this.message_greater.equals(o)) {
                validate.setQualifier(Validate.Greater);
            } else if (this.message_less.equals(o)) {
                validate.setQualifier(Validate.Less);
            } else if (this.message_greaterorequal.equals(o)) {
                validate.setQualifier(Validate.GreaterOrEqual);
            } else if (this.message_lessorequal.equals(o)) {
                validate.setQualifier(Validate.LessOrEqual);
            }
            if (this._ckbIgnoreBlank.isEnabled()) {
                validate.setUseBlank(!this._ckbIgnoreBlank.isSelected());
            }
            if (this._ckbCellRangeList.isEnabled()) {
                validate.setCellRangeList(this._ckbCellRangeList.isSelected());
            }
            String min = null;
            String max = null;
            if (this._tfCustom.isVisible()) {
                min = this._tfCustom.getText();
            }
            if (this._tfCustom2.isVisible()) {
                max = this._tfCustom2.getText();
            }
            int check = validate.setMinMax(min, max, sheet);
            return check;
        }

        private boolean isEmptyValidate() {
            return this.message_any.equals(this._cbxType.getSelectedItem());
        }

        private void initComps() {
            this._lbCondition = new KDLabel(this.message_condition);
            this._sep = new KDSeparator();
            this._lbType = new KDLabel(this.message_allow);
            this._cbxType = new KDComboBox();
            this._cbxType.addItem((Object)this.message_any);
            this._cbxType.addItem((Object)this.message_whole);
            this._cbxType.addItem((Object)this.message_decimal);
            this._cbxType.addItem((Object)this.message_list);
            this._cbxType.addItem((Object)this.message_date);
            this._cbxType.addItem((Object)this.message_time);
            this._cbxType.addItem((Object)this.message_textLength);
            this._cbxType.addItem((Object)this.message_custom);
            this._ckbIgnoreBlank = new KDCheckBox(this.message_ignoreBlank);
            this._ckbCellRangeList = new KDCheckBox(this.message_cellrangelist);
            this._lbQualify = new KDLabel(this.message_data);
            this._cbxQualify = new KDComboBox();
            this._cbxQualify.addItem((Object)this.message_between);
            this._cbxQualify.addItem((Object)this.message_notbetween);
            this._cbxQualify.addItem((Object)this.message_equal);
            this._cbxQualify.addItem((Object)this.message_notequal);
            this._cbxQualify.addItem((Object)this.message_greater);
            this._cbxQualify.addItem((Object)this.message_less);
            this._cbxQualify.addItem((Object)this.message_greaterorequal);
            this._cbxQualify.addItem((Object)this.message_lessorequal);
            this._lbCustom = new KDLabel(this.message_min);
            this._tfCustom = this._context.getFacadeManager().createRangeSelector("");
            this._tfCustom.setWithOpreatorEqual(true);
            this._lbCustom2 = new KDLabel(this.message_max);
            this._tfCustom2 = this._context.getFacadeManager().createRangeSelector("");
            this._tfCustom2.setWithOpreatorEqual(true);
            this._ckbSetAllSames = new KDCheckBox(this.message_setallsame);
        }

        private void layoutComps() {
            this.setLayout(null);
            this.add((Component)this._lbCondition);
            this.add((Component)this._sep);
            this.add((Component)this._lbType);
            this.add((Component)this._cbxType);
            this.add((Component)this._ckbIgnoreBlank);
            this.add((Component)this._ckbCellRangeList);
            this.add((Component)this._lbQualify);
            this.add((Component)this._cbxQualify);
            this.add((Component)this._lbCustom);
            this.add(this._tfCustom);
            this.add((Component)this._lbCustom2);
            this.add(this._tfCustom2);
            this._lbCondition.setBounds(5, 5, 100, 20);
            this._sep.setBounds(120, 5, 310, 20);
            this._lbType.setBounds(20, 30, 150, 20);
            this._cbxType.setBounds(20, 55, 150, 20);
            this._ckbIgnoreBlank.setBounds(250, 55, 150, 20);
            this._ckbCellRangeList.setBounds(250, 80, 150, 20);
            this._lbQualify.setBounds(20, 80, 150, 20);
            this._cbxQualify.setBounds(20, 105, 150, 20);
            this._lbCustom.setBounds(20, 130, 150, 20);
            this._tfCustom.setBounds(20, 155, 150, 20);
            this._lbCustom2.setBounds(20, 180, 150, 20);
            this._tfCustom2.setBounds(20, 205, 150, 20);
            this._ckbSetAllSames.setBounds(20, 235, 400, 20);
        }

        private void initListeners() {
            this._itemHandler = new AllowItemHandler();
            this._cbxType.addItemListener(this._itemHandler);
            this._cbxQualify.addItemListener(this._itemHandler);
        }

        private void updateBySelectChange(Object allow, Object data) {
            this._cbxQualify.removeItemListener(this._itemHandler);
            if (this.message_any.equals(allow)) {
                this._cbxQualify.setEnabled(false);
                this._cbxQualify.setSelectedIndex(0);
                this._ckbIgnoreBlank.setEnabled(false);
                this._ckbCellRangeList.setVisible(false);
                this._lbCustom.setVisible(false);
                this._tfCustom.setVisible(false);
                this._lbCustom2.setVisible(false);
                this._tfCustom2.setVisible(false);
                this._tfCustom.setText("");
                this._tfCustom.setAbsRangeName(false);
                this._tfCustom2.setText("");
            } else if (this.message_list.equals(allow)) {
                this._cbxQualify.setEnabled(false);
                this._cbxQualify.setSelectedIndex(0);
                this._ckbIgnoreBlank.setEnabled(true);
                this._ckbCellRangeList.setVisible(true);
                this._ckbCellRangeList.setSelected(true);
                this._lbCustom.setVisible(true);
                this._tfCustom.setVisible(true);
                this._lbCustom.setText(this.message_source);
                this._lbCustom2.setVisible(false);
                this._tfCustom2.setVisible(false);
                this._tfCustom.setText("");
                this._tfCustom.setAbsRangeName(true);
                this._tfCustom2.setText("");
            } else if (this.message_custom.equals(allow)) {
                this._cbxQualify.setEnabled(false);
                this._cbxQualify.setSelectedIndex(0);
                this._ckbIgnoreBlank.setEnabled(true);
                this._ckbCellRangeList.setVisible(false);
                this._lbCustom.setVisible(true);
                this._tfCustom.setVisible(true);
                this._lbCustom.setText(this.message_formula);
                this._lbCustom2.setVisible(false);
                this._tfCustom2.setVisible(false);
                this._tfCustom.setText("");
                this._tfCustom.setAbsRangeName(false);
                this._tfCustom2.setText("");
            } else {
                boolean bWhole = this.message_whole.equals(allow);
                boolean bDecimal = bWhole ? false : this.message_decimal.equals(allow);
                boolean bDate = bWhole || bDecimal ? false : this.message_date.equals(allow);
                boolean bTime = bWhole || bDecimal || bDate ? false : this.message_time.equals(allow);
                boolean bTextLength = bWhole || bDecimal || bDate || bTime ? false : this.message_textLength.equals(allow);
                this._cbxQualify.setEnabled(true);
                this._ckbIgnoreBlank.setEnabled(true);
                this._ckbCellRangeList.setVisible(false);
                this._lbCustom.setVisible(true);
                this._tfCustom.setVisible(true);
                if (this.message_between.equals(data) || this.message_notbetween.equals(data)) {
                    this._lbCustom2.setVisible(true);
                    this._tfCustom2.setVisible(true);
                    if (bDate) {
                        this._lbCustom.setText(this.message_mindate);
                        this._lbCustom2.setText(this.message_maxdate);
                    } else if (bTime) {
                        this._lbCustom.setText(this.message_mintime);
                        this._lbCustom2.setText(this.message_maxtime);
                    } else {
                        this._lbCustom.setText(this.message_min);
                        this._lbCustom2.setText(this.message_max);
                    }
                } else {
                    this._lbCustom2.setVisible(false);
                    this._tfCustom2.setVisible(false);
                    if (bDate) {
                        this._lbCustom.setText(this.message_date);
                    } else if (bTime) {
                        this._lbCustom.setText(this.message_time);
                    } else if (bTextLength) {
                        this._lbCustom.setText(this.message_length);
                    } else {
                        this._lbCustom.setText(this.message_value);
                    }
                }
                this._tfCustom.setText("");
                this._tfCustom.setAbsRangeName(false);
                this._tfCustom2.setText("");
            }
            this._cbxQualify.addItemListener(this._itemHandler);
        }

        private class AllowItemHandler
        implements ItemListener {
            private AllowItemHandler() {
            }

            @Override
            public void itemStateChanged(ItemEvent e) {
                ValidatePanel.this.updateBySelectChange(ValidatePanel.this._cbxType.getSelectedItem(), ValidatePanel.this._cbxQualify.getSelectedItem());
            }
        }
    }

    private static class InputTextPanel
    extends KDPanel {
        private final String message_heading = MultiLanguageKeys.getLocalText("KEY_VALIDATION_Input_heading", "\u9009\u5b9a\u5355\u5143\u683c\u65f6\u663e\u793a\u8f93\u5165\u4fe1\u606f");
        private final String message_subheading = MultiLanguageKeys.getLocalText("KEY_VALIDATION_Input_subheading", "\u9009\u5b9a\u5355\u5143\u683c\u65f6\u663e\u793a\u4e0b\u5217\u8f93\u5165\u4fe1\u606f");
        private final String message_title = MultiLanguageKeys.getLocalText("KEY_VALIDATION_Input_title", "\u6807\u9898");
        private final String message_content = MultiLanguageKeys.getLocalText("KEY_VALIDATION_Input_text", "\u8f93\u5165\u4fe1\u606f");
        private KDCheckBox _ckbHeading;
        private KDLabel _lbSubheading;
        private KDLabel _lbTitle;
        private KDLabel _lbContent;
        private KDTextField _tfTitle;
        private KDScrollPane _scrollPane;
        private KDTextArea _taContent;
        private ItemListener _ckbActionListener;

        private InputTextPanel() {
            this.initComps();
            this.initListeners();
            this.layoutComps();
        }

        private void initComps() {
            this._ckbHeading = new KDCheckBox(this.message_heading);
            this._lbSubheading = new KDLabel(this.message_subheading + ":");
            this._lbTitle = new KDLabel(this.message_title + ":");
            this._lbContent = new KDLabel(this.message_content + ":");
            this._tfTitle = new KDTextField();
            this._taContent = new KDTextArea();
            this._scrollPane = new KDScrollPane((Component)this._taContent);
            this._ckbHeading.setSelected(true);
            this.add((Component)this._ckbHeading);
            this.add((Component)this._lbSubheading);
            this.add((Component)this._lbTitle);
            this.add((Component)this._lbContent);
            this.add((Component)this._tfTitle);
            this.add((Component)this._scrollPane);
        }

        private void initListeners() {
            this._ckbActionListener = new CheckBoxItemListener();
            this._ckbHeading.addItemListener(this._ckbActionListener);
        }

        private void layoutComps() {
            this.setLayout(null);
            this._ckbHeading.setBounds(5, 5, 300, 20);
            this._lbSubheading.setBounds(10, 30, 300, 20);
            this._lbTitle.setBounds(20, 55, 300, 20);
            this._tfTitle.setBounds(20, 80, 400, 20);
            this._lbContent.setBounds(20, 105, 400, 20);
            this._scrollPane.setBounds(20, 130, 400, 100);
        }

        private void updateValidate(MessagedValidate validate, Sheet activeSheet) {
            validate.setInputHide(!this._ckbHeading.isSelected());
            validate.setInputTitle(this._tfTitle.getText());
            validate.setInputMessage(this._taContent.getText());
        }

        private boolean isEmptyValidate() {
            return this._tfTitle.getText().equals("") && this._taContent.getText().equals("") && this._ckbHeading.isSelected();
        }

        private void updatePanelByValidate(MessagedValidate mv) {
            if (mv != null) {
                this._ckbHeading.setSelected(!mv.isInputHide());
                this._tfTitle.setText(mv.getInputTitle());
                this._taContent.setText(mv.getInputMessage());
            } else {
                this._ckbHeading.setSelected(true);
                this._tfTitle.setText("");
                this._taContent.setText("");
            }
        }

        private class CheckBoxItemListener
        implements ItemListener {
            private CheckBoxItemListener() {
            }

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    InputTextPanel.this._tfTitle.setEnabled(true);
                    InputTextPanel.this._taContent.setEnabled(true);
                } else {
                    InputTextPanel.this._tfTitle.setEnabled(false);
                    InputTextPanel.this._taContent.setEnabled(false);
                }
            }
        }
    }

    private static class ErrorTextPanel
    extends KDPanel {
        private final String message_heading = MultiLanguageKeys.getLocalText("KEY_VALIDATION_Alert_heading", "\u8f93\u5165\u65e0\u6548\u6570\u636e\u65f6\u663e\u793a\u51fa\u9519\u8b66\u544a");
        private final String message_subheading = MultiLanguageKeys.getLocalText("KEY_VALIDATION_Alert_subheading", "\u8f93\u5165\u65e0\u6548\u6570\u636e\u65f6\u663e\u793a\u4e0b\u5217\u51fa\u9519\u8b66\u544a");
        private final String message_title = MultiLanguageKeys.getLocalText("KEY_VALIDATION_Alert_title", "\u6807\u9898");
        private final String message_content = MultiLanguageKeys.getLocalText("KEY_VALIDATION_Alert_content", "\u9519\u8bef\u4fe1\u606f");
        private final String message_style = MultiLanguageKeys.getLocalText("KEY_VALIDATION_Alert_style", "\u6837\u5f0f");
        private final String message_stopstyle = MultiLanguageKeys.getLocalText("KEY_VALIDATION_Alert_stopstyle", "\u505c\u6b62");
        private final String message_warningstyle = MultiLanguageKeys.getLocalText("KEY_VALIDATION_Alert_warningstyle", "\u8b66\u544a");
        private final String message_informationstyle = MultiLanguageKeys.getLocalText("KEY_VALIDATION_Alert_informationstyle", "\u4fe1\u606f");
        private KDCheckBox _ckbHeading;
        private KDLabel _lbSubheading;
        private KDLabel _lbTitle;
        private KDLabel _lbContent;
        private KDTextField _tfTitle;
        private KDScrollPane _scrollPane;
        private KDTextArea _taContent;
        private KDLabel _lbStyle;
        private KDComboBox _cbStyle;
        private KDLabel _lbIconStyle;
        private ItemListener _ckbActionListener;
        private ItemListener _cbActionListener;

        private ErrorTextPanel() {
            this.initComps();
            this.initListeners();
            this.layoutComps();
        }

        private void initComps() {
            this._ckbHeading = new KDCheckBox(this.message_heading);
            this._lbSubheading = new KDLabel(this.message_subheading + ":");
            this._lbTitle = new KDLabel(this.message_title + ":");
            this._lbContent = new KDLabel(this.message_content + ":");
            this._tfTitle = new KDTextField();
            this._taContent = new KDTextArea();
            this._scrollPane = new KDScrollPane((Component)this._taContent);
            this._lbStyle = new KDLabel(this.message_style + ":");
            this._cbStyle = new KDComboBox();
            this._cbStyle.addItem((Object)this.message_stopstyle);
            this._cbStyle.addItem((Object)this.message_warningstyle);
            this._cbStyle.addItem((Object)this.message_informationstyle);
            this._lbIconStyle = new KDLabel((Icon)ResourceManager.getImageIcon("validate_stop.gif"));
            this._ckbHeading.setSelected(true);
            this.add((Component)this._ckbHeading);
            this.add((Component)this._lbSubheading);
            this.add((Component)this._lbTitle);
            this.add((Component)this._lbContent);
            this.add((Component)this._tfTitle);
            this.add((Component)this._scrollPane);
            this.add((Component)this._lbStyle);
            this.add((Component)this._cbStyle);
            this.add((Component)this._lbIconStyle);
        }

        private void initListeners() {
            this._ckbActionListener = new CheckBoxItemListener();
            this._ckbHeading.addItemListener(this._ckbActionListener);
            this._cbActionListener = new ComboBoxItemListener();
            this._cbStyle.addItemListener(this._cbActionListener);
        }

        private void layoutComps() {
            this.setLayout(null);
            this._ckbHeading.setBounds(5, 5, 300, 20);
            this._lbSubheading.setBounds(10, 30, 300, 20);
            this._lbStyle.setBounds(20, 55, 100, 20);
            this._cbStyle.setBounds(20, 80, 100, 20);
            this._lbIconStyle.setBounds(40, 125, 34, 34);
            this._lbTitle.setBounds(130, 55, 290, 20);
            this._tfTitle.setBounds(130, 80, 290, 20);
            this._lbContent.setBounds(130, 105, 290, 20);
            this._scrollPane.setBounds(130, 130, 290, 100);
        }

        private void updatePanelByValidate(MessagedValidate mv) {
            if (mv != null) {
                this._ckbHeading.setSelected(!mv.isErrorHide());
                this._cbStyle.setSelectedIndex(MessagedValidate.STOP_STYLE.equals(mv.getErrorStyle()) ? 0 : (MessagedValidate.WARNING_STYLE.equals(mv.getErrorStyle()) ? 1 : 2));
                this._tfTitle.setText(mv.getErrorTitle());
                this._taContent.setText(mv.getErrorMessage());
            } else {
                this._ckbHeading.setSelected(true);
                this._cbStyle.setSelectedIndex(0);
                this._tfTitle.setText("");
                this._taContent.setText("");
            }
        }

        private void updateValidate(MessagedValidate validate, Sheet activeSheet) {
            validate.setErrorHide(!this._ckbHeading.isSelected());
            switch (this._cbStyle.getSelectedIndex()) {
                case 0: {
                    validate.setErrorStyle(MessagedValidate.STOP_STYLE);
                    break;
                }
                case 1: {
                    validate.setErrorStyle(MessagedValidate.WARNING_STYLE);
                    break;
                }
                case 2: {
                    validate.setErrorStyle(MessagedValidate.INFORMATION_STYLE);
                    break;
                }
            }
            validate.setErrorTitle(this._tfTitle.getText());
            validate.setErrorMessage(this._taContent.getText());
        }

        private boolean isEmptyValidate() {
            return this._tfTitle.getText().equals("") && this._taContent.getText().equals("") && this._cbStyle.getSelectedIndex() == 0 && this._ckbHeading.isSelected();
        }

        private class ComboBoxItemListener
        implements ItemListener {
            private ComboBoxItemListener() {
            }

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    if (e.getItem().equals(ErrorTextPanel.this.message_warningstyle)) {
                        ErrorTextPanel.this._lbIconStyle.setIcon((Icon)ResourceManager.getImageIcon("validate_warning.gif"));
                    } else if (e.getItem().equals(ErrorTextPanel.this.message_informationstyle)) {
                        ErrorTextPanel.this._lbIconStyle.setIcon((Icon)ResourceManager.getImageIcon("validate_information.gif"));
                    } else if (e.getItem().equals(ErrorTextPanel.this.message_stopstyle)) {
                        ErrorTextPanel.this._lbIconStyle.setIcon((Icon)ResourceManager.getImageIcon("validate_stop.gif"));
                    }
                }
            }
        }

        private class CheckBoxItemListener
        implements ItemListener {
            private CheckBoxItemListener() {
            }

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    ErrorTextPanel.this._tfTitle.setEnabled(true);
                    ErrorTextPanel.this._taContent.setEnabled(true);
                    ErrorTextPanel.this._cbStyle.setEnabled(true);
                    ErrorTextPanel.this._lbIconStyle.setVisible(true);
                } else {
                    ErrorTextPanel.this._tfTitle.setEnabled(false);
                    ErrorTextPanel.this._taContent.setEnabled(false);
                    ErrorTextPanel.this._cbStyle.setEnabled(false);
                    ErrorTextPanel.this._lbIconStyle.setVisible(false);
                }
            }
        }
    }

    class ImeModePanel
    extends KDPanel {
        ImeModePanel() {
        }
    }
}

