/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.impl.state;

import com.kingdee.bos.ctrl.excel.impl.SpreadContext;
import com.kingdee.bos.ctrl.excel.impl.facade.PromptPanel;
import com.kingdee.bos.ctrl.excel.impl.facade.editor.CellTextEditor;
import com.kingdee.bos.ctrl.excel.impl.facade.rangesel.IRangeSelector;
import com.kingdee.bos.ctrl.excel.impl.render.SparkRender;
import com.kingdee.bos.ctrl.excel.impl.state.DefaultState;
import com.kingdee.bos.ctrl.excel.impl.state.SpreadStateManager;
import com.kingdee.bos.ctrl.excel.model.struct.Selection;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.event.BookChangeEvent;
import com.kingdee.bos.ctrl.excel.model.struct.event.SheetChangeEvent;
import javax.swing.SwingUtilities;

public class RangeSelectState
extends DefaultState {
    private IRangeSelector _rs;
    private Sheet _sheet;
    private boolean _focusInGrid = true;

    RangeSelectState(SpreadContext context, IRangeSelector rs) {
        super(context);
        this.init(rs);
    }

    void init(IRangeSelector rs) {
        this._rs = rs;
        if (this._rs != null && this._rs instanceof CellTextEditor) {
            this._sheet = ((CellTextEditor)this._rs).getSheet();
        }
    }

    @Override
    public int getKey() {
        return SpreadStateManager.Key_Range_Select;
    }

    @Override
    public boolean start(int preKey) {
        SparkRender sr = this._context.getRenderManager().getSparkRender();
        sr.setSparkBlocks(this._rs.getSelection());
        this._context.getRenderManager().getSparkRender().start();
        return true;
    }

    @Override
    public boolean stop(int forceKey) {
        this._context.getRenderManager().getSparkRender().stop();
        this._rs = null;
        return true;
    }

    @Override
    public boolean cancel(int forceKey) {
        return this.stop(forceKey);
    }

    public boolean hasFocusInGrid() {
        return this._focusInGrid;
    }

    public void setFocusInGrid(boolean focusPosition) {
        this._focusInGrid = focusPosition;
    }

    public Selection getSelection() {
        return this._rs.getSelection();
    }

    @Override
    public void changed(SheetChangeEvent e) {
        if (e.hasState(SheetChangeEvent.Changed_Selection)) {
            this._context.getRenderManager().getSparkRender().setSparkBlocks(this._rs.getSelection());
        }
    }

    @Override
    public void changed(BookChangeEvent e) {
        if (e.isSheetActive()) {
            if (this._rs != null && this._rs instanceof CellTextEditor) {
                final CellTextEditor editor = (CellTextEditor)this._rs;
                if (this._sheet == e.getSheet()) {
                    editor.setVisible(true);
                } else {
                    editor.setVisible(false);
                }
                this._rs.getSelection().copyFrom(e.getSheet().getSheetOption().getSelection());
                this._focusInGrid = false;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        PromptPanel.LeftPromptPanel lpp = RangeSelectState.this._context.getFacadeManager().getPromptPanel().getLeftPane();
                        lpp.setSyncEnabled(false);
                        lpp.setCaretPosition(editor.getCaretPosition());
                        lpp.setSyncEnabled(true);
                        lpp.focusEditor();
                    }
                });
            }
            this._context.getRenderManager().getSparkRender().setSparkBlocks(this._rs.getSelection());
        }
    }
}

