/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.io.clipboard;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Row;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.SortedRowArray;
import com.kingdee.bos.ctrl.excel.model.util.SortedCellBlockArray;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.Arrays;

public class KDSTransferable
implements Transferable {
    private DataFlavor[] flavors;
    private String text;

    public KDSTransferable(Sheet sheet) {
        this.text = KDSTransferable.getClipboardString(sheet, sheet.getSheetOption().getSelection().toSortedBlocks());
    }

    public static String getClipboardString(Sheet sheet, SortedCellBlockArray sa) {
        CellBlock bounds = sa.getBounds();
        int iCells = Math.min(Math.max(1, sheet.getMaxColIndex()), bounds.getWidth());
        int iRows = Math.min(Math.max(1, sheet.getMaxRowIndex()), bounds.getHeight());
        char[] emptyCells = new char[iCells];
        char[] emptyRows = new char[iRows];
        Arrays.fill(emptyCells, '\t');
        Arrays.fill(emptyRows, '\n');
        StringBuffer buf = new StringBuffer(iRows);
        SortedRowArray rows = sheet.getRows();
        int blockColNum = sa.getBlocksColumnNum();
        int blockRowNum = sa.size() / blockColNum;
        int lastRow = bounds.getRow();
        for (int rBlock = 0; rBlock < blockRowNum; ++rBlock) {
            int rPos;
            int leftBlockIndex = rBlock * blockColNum;
            CellBlock leftB = sa.getBlock(leftBlockIndex);
            int rowStart = leftB.getRow();
            int rowEnd = leftB.getRow2();
            if (lastRow < rowStart) {
                buf.append(emptyRows, 0, rowStart - lastRow);
            }
            lastRow = rowEnd + 1;
            int rPos2 = rows.getProperPos(rowEnd, true);
            if (rPos2 < rPos) {
                buf.append(emptyRows, 0, Math.min(emptyRows.length, rowEnd - rowStart + 1));
                continue;
            }
            for (rPos = rows.getProperPos(rowStart, false); rPos <= rPos2; ++rPos) {
                Row rowObj = rows.getAt(rPos);
                int row = rowObj.getRow();
                if (rowStart < row) {
                    buf.append(emptyRows, 0, row - rowStart);
                }
                rowStart = row + 1;
                int lastCol = bounds.getCol();
                for (int cBlock = 0; cBlock < blockColNum; ++cBlock) {
                    int cPos;
                    CellBlock block = sa.getBlock(leftBlockIndex + cBlock);
                    int colStart = block.getCol();
                    int colEnd = block.getCol2();
                    if (lastCol < colStart) {
                        buf.append(emptyCells, 0, colStart - lastCol);
                    }
                    lastCol = colEnd + 1;
                    int cPos2 = rowObj.getProperPos(colEnd, true);
                    if (cPos2 < cPos) {
                        buf.append(emptyCells, 0, 1);
                        continue;
                    }
                    for (cPos = rowObj.getProperPos(colStart, false); cPos <= cPos2; ++cPos) {
                        Cell cll = rowObj.getAt(cPos);
                        int col = cll.getCol();
                        if (colStart < col) {
                            buf.append(emptyCells, 0, col - colStart);
                        }
                        buf.append(KDSTransferable.makeClipboardString(cll.getText()));
                        buf.append('\t');
                        colStart = col + 1;
                    }
                }
                buf.setCharAt(buf.length() - 1, '\n');
            }
            if (rowStart >= rowEnd) continue;
            buf.append(emptyRows, 0, Math.min(emptyRows.length, rowEnd - rowStart));
        }
        return buf.toString();
    }

    private static String makeClipboardString(String text) {
        if (!StringUtil.isEmptyString((String)text) && text.indexOf(10) != -1) {
            StringBuffer buf = new StringBuffer(text.length() + 16);
            buf.append('\"');
            buf.append(text);
            int index = buf.indexOf("\"", 1);
            while (index != -1) {
                buf.insert(index, '\"');
                index = buf.indexOf("\"", index + 2);
            }
            buf.append('\"');
            text = buf.toString();
        }
        return text;
    }

    DataFlavor[] getDataFlavors() {
        if (this.flavors == null) {
            this.flavors = new DataFlavor[1];
            this.flavors[0] = DataFlavor.stringFlavor;
        }
        return this.flavors;
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (this.isDataFlavorSupported(flavor)) {
            return this.text;
        }
        return null;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return this.getDataFlavors();
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return flavor == DataFlavor.stringFlavor;
    }
}

