/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.io.kds;

import com.kingdee.bos.ctrl.common.hyperlink.HyperLink;
import com.kingdee.bos.ctrl.common.util.SectionByteOutputStream;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.expans.model.ExtProps;
import com.kingdee.bos.ctrl.excel.expans.model.collection.SortedExtPropFormulasArray;
import com.kingdee.bos.ctrl.excel.expans.model.data.ExtColumn;
import com.kingdee.bos.ctrl.excel.expans.model.data.ExtDataSet;
import com.kingdee.bos.ctrl.excel.expans.model.data.ExtDataSetManager;
import com.kingdee.bos.ctrl.excel.io.BookIOController;
import com.kingdee.bos.ctrl.excel.io.PrintHelper;
import com.kingdee.bos.ctrl.excel.io.kds.KDSConstants;
import com.kingdee.bos.ctrl.excel.io.kds.SectionJarOutputStream;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.BookProtection;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Column;
import com.kingdee.bos.ctrl.excel.model.struct.Comment;
import com.kingdee.bos.ctrl.excel.model.struct.DiagonalHeader;
import com.kingdee.bos.ctrl.excel.model.struct.ISheet;
import com.kingdee.bos.ctrl.excel.model.struct.MergeBlocks;
import com.kingdee.bos.ctrl.excel.model.struct.PrintSetup;
import com.kingdee.bos.ctrl.excel.model.struct.Protection;
import com.kingdee.bos.ctrl.excel.model.struct.Row;
import com.kingdee.bos.ctrl.excel.model.struct.Selection;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.SheetBaseMath;
import com.kingdee.bos.ctrl.excel.model.struct.SheetOption;
import com.kingdee.bos.ctrl.excel.model.struct.SheetProxy;
import com.kingdee.bos.ctrl.excel.model.struct.SortedAttributeSpanArray;
import com.kingdee.bos.ctrl.excel.model.struct.SortedColumnArray;
import com.kingdee.bos.ctrl.excel.model.struct.SortedRowArray;
import com.kingdee.bos.ctrl.excel.model.struct.SortedUserObjectArray;
import com.kingdee.bos.ctrl.excel.model.struct.UserObject;
import com.kingdee.bos.ctrl.excel.model.struct.ViewSplitInfo;
import com.kingdee.bos.ctrl.excel.model.struct.borders.Border;
import com.kingdee.bos.ctrl.excel.model.struct.borders.BorderSpan;
import com.kingdee.bos.ctrl.excel.model.struct.borders.Borders;
import com.kingdee.bos.ctrl.excel.model.struct.borders.BordersSpan;
import com.kingdee.bos.ctrl.excel.model.struct.borders.SortedBorderSpanArray;
import com.kingdee.bos.ctrl.excel.model.struct.borders.SortedBordersSpanArray;
import com.kingdee.bos.ctrl.excel.model.struct.cformat.ConditionFormatFurtherList;
import com.kingdee.bos.ctrl.excel.model.struct.cformat.ConditionalFormat;
import com.kingdee.bos.ctrl.excel.model.struct.cformat.ConditionalFormatList;
import com.kingdee.bos.ctrl.excel.model.struct.cformat.util.Condition;
import com.kingdee.bos.ctrl.excel.model.struct.cformat.util.CtrlUserObjectTrans;
import com.kingdee.bos.ctrl.excel.model.struct.embed.EmbedObject;
import com.kingdee.bos.ctrl.excel.model.struct.embed.EmbedhLayer;
import com.kingdee.bos.ctrl.excel.model.struct.filter.AbstractAutoFilter;
import com.kingdee.bos.ctrl.excel.model.struct.filter.CellValueModel;
import com.kingdee.bos.ctrl.excel.model.struct.filter.ISheetAutoFilter;
import com.kingdee.bos.ctrl.excel.model.struct.filter.SheetCustomAutoFilter;
import com.kingdee.bos.ctrl.excel.model.struct.filter.SheetDynamicAutoFilter;
import com.kingdee.bos.ctrl.excel.model.struct.filter.SheetFirstNAutoFilter;
import com.kingdee.bos.ctrl.excel.model.struct.filter.SheetItemAutoFilter;
import com.kingdee.bos.ctrl.excel.model.struct.filter.SheetMultipleItemAutoFilter;
import com.kingdee.bos.ctrl.excel.model.struct.node.NamedObjectNode;
import com.kingdee.bos.ctrl.excel.model.struct.node.SortedNamedObjectNodeArray;
import com.kingdee.bos.ctrl.excel.model.struct.validate.Validation;
import com.kingdee.bos.ctrl.excel.model.struct.validate.ValidationList;
import com.kingdee.bos.ctrl.excel.model.struct.validate.util.MessagedValidate;
import com.kingdee.bos.ctrl.excel.model.util.SortedCellBlockArray;
import com.kingdee.bos.ctrl.excel.model.util.SortedObjectArray;
import com.kingdee.bos.ctrl.excel.util.KDSDataOutputStream;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootRow;
import com.kingdee.bos.ctrl.kdf.util.CloseUtil;
import com.kingdee.bos.ctrl.kdf.util.render.splitrectangle.TriangleInfo;
import com.kingdee.bos.ctrl.kdf.util.style.LineStyle;
import com.kingdee.bos.ctrl.kdf.util.style.Pattern;
import com.kingdee.bos.ctrl.kdf.util.style.PenStyle;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.print.printjob.table.PlugablePaginationAdvice;
import java.awt.Color;
import java.io.Closeable;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class BookToKds
extends KDSConstants {
    private final byte[] _intBufs = new byte[4];
    private BookIOController _ctrl;

    public void setBookIOController(BookIOController ctrl) {
        this._ctrl = ctrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void export(Book book, String fileName) throws IOException {
        FileOutputStream fos = null;
        KDSDataOutputStream kos = null;
        try {
            fos = new FileOutputStream(fileName);
            kos = new KDSDataOutputStream(fos);
            this.export(book, kos);
        }
        catch (Throwable throwable) {
            CloseUtil.close((Closeable[])new Closeable[]{kos, fos});
            throw throwable;
        }
        CloseUtil.close((Closeable[])new Closeable[]{kos, fos});
    }

    public void export(Book book, KDSDataOutputStream os) throws IOException {
        this.writeBook(book, os);
    }

    private void writeBook(Book book, KDSDataOutputStream out) throws IOException {
        SectionJarOutputStream sos = new SectionJarOutputStream();
        this.writeBookWithJar(book, sos);
        out.write(sos.output());
        Arrays.fill(this._intBufs, (byte)0);
    }

    private void writeBookWithJar(Book book, SectionJarOutputStream sos) throws IOException {
        int i;
        SectionByteOutputStream sBook = new SectionByteOutputStream();
        this.writeBookPrefix(book, new KDSDataOutputStream((OutputStream)sBook));
        sos.addSection(sBook);
        int count = book.getSheetCount();
        int fileVersion = book.getFileVersion();
        if (fileVersion != 0 && KDSConstants.isOlderVersion(fileVersion)) {
            for (i = 0; i < count; ++i) {
                book.getSheet(i);
            }
        }
        for (i = 0; i < count; ++i) {
            ISheet sheet = book.getISheet(i);
            if (sheet instanceof Sheet) {
                SectionByteOutputStream sSheet = new SectionByteOutputStream();
                this.writeSheet((Sheet)sheet, new KDSDataOutputStream((OutputStream)sSheet));
                sos.addSection(sSheet);
                continue;
            }
            SheetProxy sp = (SheetProxy)sheet;
            sos.addSection(sp.getZipBytes());
        }
    }

    private void writeBookPrefix(Book book, KDSDataOutputStream out) throws IOException {
        out.writeString(book.getName());
        int count = book.getSheetCount();
        out.writeInt(count);
        out.writeInt(book.getActiveSheetIndex());
        for (int i = 0; i < count; ++i) {
            ISheet sheet = book.getISheet(i);
            out.writeString(sheet.getID());
            out.writeString(sheet.getSheetName(), false);
            byte flags = 0;
            flags = (byte)(flags | (sheet.isHide() ? 1 : 0));
            flags = (byte)(flags | (sheet.isSelected() ? 2 : 0));
            flags = (byte)(flags | (sheet.hasData() ? 4 : 0));
            out.write(flags);
            Color c = sheet.getTabColor();
            if (c == null) {
                out.writeInt(0xFFAFAF);
            } else {
                out.writeInt(c.getRGB());
            }
            out.writeInt(sheet.getSheetType());
        }
        this.writeBookExtendMode(book, out);
        this.writeBookProtection(book, out);
        this.writeUserObjects(book.getUserObjects(), (byte)2, out);
        this.writeComment(book.getComment(), (byte)3, out);
        this.writeNames(book.getNames(), (byte)4, out);
    }

    private void writeBookProtection(Book book, KDSDataOutputStream out) throws IOException {
        BookProtection bp = book.getProtection();
        if (bp.isProtected()) {
            out.write(1);
            out.writeInt(bp.getOperations());
            out.writeString(bp.getEncryptedPassword());
        }
    }

    private void writeBookExtendMode(Book book, KDSDataOutputStream out) throws IOException {
        out.write(5);
        out.writeBoolean(book.getDeps().isExtendMode());
    }

    private void writeStyles(HashMap styles, KDSDataOutputStream out) throws IOException {
        Iterator iterStyles = styles.entrySet().iterator();
        out.write(5);
        while (iterStyles.hasNext()) {
            String numFormat;
            String str;
            Color c;
            Styles.Position pos;
            LineStyle lineStyle;
            Map.Entry e = iterStyles.next();
            ShareStyleAttributes ssa = (ShareStyleAttributes)e.getValue();
            if (ssa == null) {
                return;
            }
            out.write(0);
            out.writeInt(ssa.getUID());
            if (ssa.hasFontAttributes()) {
                out.write(1);
                String fontName = ssa.getFontName();
                out.writeString(fontName);
                int size = -1;
                if (ssa.hasAttributes(ShareStyleAttributes.FONT_SIZE)) {
                    size = ssa.getFontSize();
                }
                out.writeInt(size);
                Color fc = ssa.getFontColor();
                if (fc == null) {
                    out.writeInt(0xFFAFAF);
                } else {
                    out.writeInt(fc.getRGB());
                }
                byte flags = 0;
                flags = (byte)(flags | ((ssa.hasAttributes(ShareStyleAttributes.FONT_UNDERLINE) ? ssa.isUnderline() : false) ? 1 : 0));
                flags = (byte)(flags | (ssa.hasAttributes(ShareStyleAttributes.FONT_BOLD) ? (ssa.isBold() ? 2 : 0) : 0));
                flags = (byte)(flags | (ssa.hasAttributes(ShareStyleAttributes.FONT_ITALIC) ? (ssa.isItalic() ? 4 : 0) : 0));
                flags = (byte)(flags | (ssa.hasAttributes(ShareStyleAttributes.FONT_STRIKETHROUGH) ? (ssa.isStrikeThrough() ? 8 : 0) : 0));
                out.write(flags);
            }
            if (ssa.hasAlignmentAttributes()) {
                out.write(2);
                Styles.HorizontalAlignment ha = ssa.getHorizontalAlign();
                out.writeInt(ha == null ? -1 : ha.getValue());
                Styles.VerticalAlignment va = ssa.getVerticalAlign();
                out.writeInt(va == null ? -1 : va.getValue());
                out.writeInt(ssa.hasAttributes(ShareStyleAttributes.ROTATION) ? ssa.getRotation() : -1);
                byte flags = 0;
                flags = (byte)(flags | ((ssa.hasAttributes(ShareStyleAttributes.WRAP_TEXT) ? ssa.isWrapText() : false) ? 1 : 0));
                flags = (byte)(flags | (ssa.hasAttributes(ShareStyleAttributes.SHRINK_TEXT) ? (ssa.isShrinkText() ? 2 : 0) : 0));
                flags = (byte)(flags | (ssa.hasAttributes(ShareStyleAttributes.VERTICAL_TEXT) ? (ssa.isVerticalText() ? 4 : 0) : 0));
                out.write(flags);
            }
            if ((lineStyle = ssa.getBorderLineStyle(pos = Styles.Position.TOP)) != null && lineStyle != LineStyle.NULL_LINE) {
                out.write(4);
                out.writeInt(lineStyle.getBits());
                c = ssa.getBorderColor(pos);
                if (c == null) {
                    out.writeInt(0xFFAFAF);
                } else {
                    out.writeInt(c.getRGB());
                }
                PenStyle ps = ssa.getBorderPenStyle(pos);
                str = "";
                if (ps != null) {
                    str = ps.getName();
                }
                out.writeString(str);
            }
            if ((lineStyle = ssa.getBorderLineStyle(pos = Styles.Position.BOTTOM)) != null && lineStyle != LineStyle.NULL_LINE) {
                out.write(5);
                out.writeInt(lineStyle.getBits());
                c = ssa.getBorderColor(pos);
                if (c == null) {
                    out.writeInt(0xFFAFAF);
                } else {
                    out.writeInt(c.getRGB());
                }
                PenStyle ps = ssa.getBorderPenStyle(pos);
                str = "";
                if (ps != null) {
                    str = ps.getName();
                }
                out.writeString(str);
            }
            if ((lineStyle = ssa.getBorderLineStyle(pos = Styles.Position.LEFT)) != null && lineStyle != LineStyle.NULL_LINE) {
                out.write(6);
                out.writeInt(lineStyle.getBits());
                c = ssa.getBorderColor(pos);
                if (c == null) {
                    out.writeInt(0xFFAFAF);
                } else {
                    out.writeInt(c.getRGB());
                }
                PenStyle ps = ssa.getBorderPenStyle(pos);
                str = "";
                if (ps != null) {
                    str = ps.getName();
                }
                out.writeString(str);
            }
            if ((lineStyle = ssa.getBorderLineStyle(pos = Styles.Position.RIGHT)) != null && lineStyle != LineStyle.NULL_LINE) {
                out.write(7);
                out.writeInt(lineStyle.getBits());
                c = ssa.getBorderColor(pos);
                if (c == null) {
                    out.writeInt(0xFFAFAF);
                } else {
                    out.writeInt(c.getRGB());
                }
                PenStyle ps = ssa.getBorderPenStyle(pos);
                str = "";
                if (ps != null) {
                    str = ps.getName();
                }
                out.writeString(str);
            }
            if ((lineStyle = ssa.getBorderLineStyle(pos = Styles.Position.DIAGONALLEFT)) != null && lineStyle != LineStyle.NULL_LINE) {
                out.write(8);
                out.writeInt(lineStyle.getBits());
                c = ssa.getBorderColor(pos);
                if (c == null) {
                    out.writeInt(0xFFAFAF);
                } else {
                    out.writeInt(c.getRGB());
                }
                PenStyle ps = ssa.getBorderPenStyle(pos);
                str = "";
                if (ps != null) {
                    str = ps.getName();
                }
                out.writeString(str);
            }
            if ((lineStyle = ssa.getBorderLineStyle(pos = Styles.Position.DIAGONALRIGHT)) != null && lineStyle != LineStyle.NULL_LINE) {
                out.write(9);
                out.writeInt(lineStyle.getBits());
                c = ssa.getBorderColor(pos);
                if (c == null) {
                    out.writeInt(0xFFAFAF);
                } else {
                    out.writeInt(c.getRGB());
                }
                PenStyle ps = ssa.getBorderPenStyle(pos);
                str = "";
                if (ps != null) {
                    str = ps.getName();
                }
                out.writeString(str);
            }
            Color bgcolor = ssa.getBackground();
            Pattern pattern = ssa.getPattern();
            Color pccolor = ssa.getPatternColor();
            if (bgcolor != null || pattern != null && pattern != Pattern.None || pccolor != null) {
                out.write(10);
                out.writeInt(bgcolor == null ? 0xFFAFAF : bgcolor.getRGB());
                if (pattern == null) {
                    out.writeInt(-1);
                } else {
                    out.writeInt(pattern.getID());
                }
                out.writeInt(pccolor == null ? 0xFFAFAF : pccolor.getRGB());
            }
            if (!StringUtil.isEmptyString((String)(numFormat = ssa.getNumberFormat()))) {
                out.write(11);
                out.writeString(numFormat);
            }
            if (ssa.hasProtectionAttributes()) {
                out.write(3);
                byte flags = 0;
                flags = (byte)(flags | (ssa.hasAttributes(ShareStyleAttributes.PROTECTION_HIDDED) ? 1 : 0));
                flags = (byte)(flags | (ssa.hasAttributes(ShareStyleAttributes.PROTECTION_HIDDED) ? (ssa.isHided() ? 2 : 0) : 0));
                flags = (byte)(flags | (ssa.hasAttributes(ShareStyleAttributes.PROTECTION_LOCKED) ? 4 : 0));
                flags = (byte)(flags | (ssa.hasAttributes(ShareStyleAttributes.PROTECTION_LOCKED) ? (ssa.isLocked() ? 8 : 0) : 0));
                out.write(flags);
            }
            out.write(127);
        }
        out.write(127);
    }

    private void writeSheetBorders(Sheet sheet, KDSDataOutputStream out) throws IOException {
        Borders bdrs = sheet.getBorders();
        SortedObjectArray bdArray = bdrs.collectBorderObjs();
        if (bdArray.isEmpty()) {
            return;
        }
        out.write(6);
        out.write(1);
        int iEnd = bdArray.size();
        for (int i = 0; i < iEnd; ++i) {
            Border bdr = (Border)bdArray.get(i);
            out.write(0);
            out.writeInt(bdr.getUID());
            out.writeInt(bdr.getLineStyle().getBits());
            out.writeInt(bdr.getColor().getRGB());
            out.writeString(bdr.getPenStyle().getName());
            out.write(127);
        }
        out.write(127);
        this.writeBordersRoot(bdrs.getRoot(true), (byte)2, out);
        this.writeBordersRoot(bdrs.getRoot(false), (byte)3, out);
        out.write(127);
    }

    private void writeBordersRoot(SortedBordersSpanArray root, byte rootID, KDSDataOutputStream out) throws IOException {
        if (root.isEmpty()) {
            return;
        }
        out.write(rootID);
        int iEnd = root.size();
        for (int i = 0; i < iEnd; ++i) {
            BordersSpan bss = root.getBordersSpan(i);
            out.write(0);
            out.writeInt(bss.getStart());
            out.writeInt(bss.getEnd());
            SortedBorderSpanArray bssArray = bss.getBorderArray();
            int jEnd = bssArray.size();
            for (int j = 0; j < jEnd; ++j) {
                BorderSpan bs = bssArray.getBorderSpan(j);
                out.write(0);
                out.writeInt(bs.getStart());
                out.writeInt(bs.getEnd());
                out.writeInt(bs.getBorder().getUID());
                out.write(127);
            }
            out.write(127);
        }
        out.write(127);
    }

    private void writeSheet(Sheet sheet, KDSDataOutputStream out) throws IOException {
        out.write(0);
        this.writeStyles(this.scanStyle(sheet), out);
        this.writeStyleID(sheet.getSSA(), out);
        this.writeSheetBorders(sheet, out);
        this.writeSheetExtends(sheet, out);
        this.writeSheetOption(sheet.getSheetOption(), out);
        this.writeCols(sheet.getCols(), out);
        this.writeRows(sheet.getRows(), out);
        out.write(127);
    }

    private void writeSheetExtends(Sheet sheet, KDSDataOutputStream out) throws IOException {
        out.write(3);
        this.writeNames(sheet.getNames(), (byte)5, out);
        this.writeUserObjects(sheet.getUserObjects(), (byte)3, out);
        this.writeFurtherCondition(sheet.getConditionFormatFurthers(), (byte)3, out);
        this.writeComment(sheet.getComment(), (byte)4, out);
        this.writeConditionalFormats(sheet.getConditionalFormats(), 8, out);
        this.writeValidations(sheet.getValidations(), out);
        this.writeAttributeSpans(sheet, (byte)2, out, true);
        this.writeAttributeSpans(sheet, (byte)1, out, false);
        this.writeGraphs(sheet.getEmbedments(false), (byte)7, out);
        this.writePageView(sheet, (byte)9, out);
        this.writeFilters(sheet, (byte)10, out);
        this.writeDataSet(sheet, (byte)11, out);
        out.write(127);
    }

    private void writeFurtherCondition(ConditionFormatFurtherList conditionFormatFurthers, byte idSeUserobject, KDSDataOutputStream out) throws IOException {
        if (conditionFormatFurthers != null && conditionFormatFurthers.size() > 0) {
            CtrlUserObjectTrans trans = null;
            trans = new CtrlUserObjectTrans();
            String outStr = trans.getString("ConditionFormatFurtherList", conditionFormatFurthers);
            this.writeKeyValue(idSeUserobject, "ConditionFormatFurtherList", outStr, out);
        }
    }

    private void writeFilters(Sheet sheet, byte id, KDSDataOutputStream out) throws IOException {
        CellBlock autocb = sheet.getAutoFilterArea();
        if (autocb != null) {
            out.write(id);
            out.write(0);
            out.writeInt(autocb.getRow());
            out.writeInt(autocb.getRow2());
            out.writeInt(autocb.getCol());
            out.writeInt(autocb.getCol2());
            List autoFilters = sheet.getAutoFilters();
            out.writeInt(autoFilters.size());
            for (ISheetAutoFilter autoFilter : autoFilters) {
                AbstractAutoFilter ref;
                out.writeInt(autoFilter.getAutoFilterType());
                out.writeInt(autoFilter.getColIndex());
                if (autoFilter instanceof SheetFirstNAutoFilter) {
                    ref = (SheetFirstNAutoFilter)autoFilter;
                    out.writeInt(((SheetFirstNAutoFilter)ref).getAmount());
                    out.writeBoolean(((SheetFirstNAutoFilter)ref).isAsc());
                    out.writeBoolean(((SheetFirstNAutoFilter)ref).isPercent());
                    continue;
                }
                if (autoFilter instanceof SheetItemAutoFilter) {
                    ref = (SheetItemAutoFilter)autoFilter;
                    this.writeVaraint(((SheetItemAutoFilter)ref).getValue(), out);
                    out.writeString(((SheetItemAutoFilter)ref).getText());
                    continue;
                }
                if (autoFilter instanceof SheetMultipleItemAutoFilter) {
                    ref = (SheetMultipleItemAutoFilter)autoFilter;
                    SortedObjectArray values = ((SheetMultipleItemAutoFilter)ref).getSelectedCellValueModels();
                    out.writeInt(values.size());
                    for (int index = 0; index < values.size(); ++index) {
                        CellValueModel model = (CellValueModel)values.get(index);
                        Variant value = model.getValue();
                        if (value.getVt() == 16) {
                            this.wirteErrorVaiaint(value, out);
                        } else {
                            this.writeVaraint(value, out);
                        }
                        out.writeString(model.getText());
                    }
                    continue;
                }
                if (autoFilter instanceof SheetDynamicAutoFilter) {
                    ref = (SheetDynamicAutoFilter)autoFilter;
                    out.writeByte(((SheetDynamicAutoFilter)ref).getCustomType());
                    continue;
                }
                if (!(autoFilter instanceof SheetCustomAutoFilter)) continue;
                ref = (SheetCustomAutoFilter)autoFilter;
                out.writeByte(((SheetCustomAutoFilter)ref).getOperator1());
                out.writeString(((SheetCustomAutoFilter)ref).getValue1());
                out.writeByte(((SheetCustomAutoFilter)ref).getLink());
                out.writeByte(((SheetCustomAutoFilter)ref).getOperator2());
                out.writeString(((SheetCustomAutoFilter)ref).getValue2());
            }
        }
    }

    private void writeDataSet(Sheet sheet, byte id, KDSDataOutputStream out) throws IOException {
        ExtDataSetManager dsm = sheet.getDataSetManager();
        int size = dsm.size();
        if (size == 0) {
            return;
        }
        out.write(id);
        out.writeInt(size);
        for (int i = 0; i < size; ++i) {
            ExtDataSet ds = dsm.getAt(i);
            out.write(1);
            out.writeString(ds.getName());
            out.write(2);
            out.writeString(ds.getAlias());
            out.write(3);
            out.writeString(ds.getDefine());
            this.writeDataSetColumns(ds, (byte)4, out);
            this.writeDataSetData(ds, (byte)5, out);
            out.write(127);
        }
    }

    private void writeDataSetColumns(ExtDataSet ds, byte id, KDSDataOutputStream out) throws IOException {
        SortedObjectArray so = ds.getColumns();
        int size = so.size();
        if (size == 0) {
            return;
        }
        out.write(id);
        out.writeInt(size);
        for (int i = 0; i < size; ++i) {
            ExtColumn col = (ExtColumn)so.get(i);
            out.write(1);
            out.writeString(col.getName());
            out.write(2);
            out.writeString(col.getAlias());
            out.write(3);
            out.writeInt((Integer)col.getIndex().getValue());
            out.write(4);
            out.writeInt(col.getDataType());
            out.write(127);
        }
    }

    private void writeDataSetData(ExtDataSet ds, byte id, KDSDataOutputStream out) throws IOException {
    }

    private void writePageView(Sheet sheet, byte id, KDSDataOutputStream out) throws IOException {
        boolean isPageView = sheet.isPageView();
        PlugablePaginationAdvice ppa = sheet.getPlugablePaginationAdvice(false);
        if (!isPageView && ppa == null) {
            return;
        }
        out.write(id);
        out.writeBoolean(isPageView);
        if (isPageView) {
            int i;
            int[] snap = sheet.getRowPaginationPointsSnapshot();
            out.writeInt(snap.length);
            for (i = 0; i < snap.length; ++i) {
                out.writeInt(snap[i]);
            }
            snap = sheet.getColPaginationPointsSnapshot();
            out.writeInt(snap.length);
            for (i = 0; i < snap.length; ++i) {
                out.writeInt(snap[i]);
            }
        }
        int maxRowId = sheet.getMaxRowIndex();
        int maxColId = sheet.getMaxColIndex();
        if (ppa != null) {
            int i;
            int count = 0;
            out.writeBoolean(true);
            int[] temp = ppa.getRowShrinkedBreaks();
            if (temp != null) {
                for (i = 0; i < temp.length && temp[i] <= maxRowId; ++i) {
                    ++count;
                }
            }
            out.writeInt(count);
            for (i = 0; i < count; ++i) {
                out.writeInt(temp[i]);
            }
            count = 0;
            temp = ppa.getRowExtendedBreaks();
            if (temp != null) {
                for (i = 0; i < temp.length && temp[i] <= maxRowId; ++i) {
                    ++count;
                }
            }
            out.writeInt(count);
            for (i = 0; i < count; ++i) {
                out.writeInt(temp[i]);
            }
            count = 0;
            temp = ppa.getColShrinkedBreaks();
            if (temp != null) {
                for (i = 0; i < temp.length && temp[i] <= maxColId; ++i) {
                    ++count;
                }
            }
            out.writeInt(count);
            for (i = 0; i < count; ++i) {
                out.writeInt(temp[i]);
            }
            count = 0;
            temp = ppa.getColExtendedBreaks();
            if (temp != null) {
                for (i = 0; i < temp.length && temp[i] <= maxColId; ++i) {
                    ++count;
                }
            }
            out.writeInt(count);
            for (i = 0; i < count; ++i) {
                out.writeInt(temp[i]);
            }
        } else {
            out.writeBoolean(false);
        }
    }

    private void writeGraphs(EmbedhLayer gl, byte id, KDSDataOutputStream out) throws IOException {
        if (gl == null) {
            return;
        }
        int size = gl.size();
        for (int i = 0; i < size; ++i) {
            out.write(id);
            EmbedObject gr = gl.getEmbed(i);
            out.writeString(gr.getClass().getName());
            out.writeLengthBytes(gr.save());
        }
    }

    private void writeAttributeSpans(Sheet sheet, byte id, KDSDataOutputStream out, boolean isRow) throws IOException {
        SortedAttributeSpanArray spans = isRow ? sheet.getRowSpans() : sheet.getColSpans();
        int size = spans.size();
        for (int i = 0; i < size; ++i) {
            SortedAttributeSpanArray.AttributeSpan span = spans.getAttributeSpan(i);
            out.write(id);
            out.writeInt(span.getStart());
            out.writeInt(span.getExtent());
            this.writeStyleID(span.getSSA(), out);
            int length = span.getOriginalLength();
            out.writeInt(length);
            out.write(span.isVisible() ? 1 : 0);
            out.writeBoolean(sheet.isAboveOfOutlineGroup());
            out.writeBoolean(sheet.isLeftToOutlineGroup());
            out.writeInt(span.getOutlineGroupLevel());
            out.writeBoolean(span.isCollapse());
        }
    }

    private void writeConditionalFormats(ConditionalFormatList cfl, int id, KDSDataOutputStream out) throws IOException {
        if (cfl == null) {
            return;
        }
        out.write(id);
        int size = cfl.size();
        out.writeInt(size);
        for (int i = 0; i < size; ++i) {
            ConditionalFormat cf = cfl.getConditionalFormat(i);
            SortedCellBlockArray blocks = cf.getBlocks();
            ShareStyleAttributes[] ssas = cf.getSSAs();
            Condition[] cds = cf.getConditions();
            int valve = ssas.length;
            out.writeInt(valve);
            out.writeString(SheetBaseMath.getBlocksA1Name(blocks, true));
            for (int m = 0; m < valve; ++m) {
                if (ssas[m] == null) {
                    out.writeInt(-1);
                } else {
                    out.writeInt(ssas[m].getUID());
                }
                Condition cd = cds[m];
                out.writeInt(cd.getTypeIndex());
                int qua = cd.getQualifierIndex();
                out.writeInt(qua);
                String min = cd.getMin();
                out.writeString(min);
                if (qua > 1) continue;
                String max = cd.getMax();
                out.writeString(max);
            }
        }
    }

    private void writeValidations(ValidationList vals, KDSDataOutputStream out) throws IOException {
        if (vals == null) {
            return;
        }
        vals.reduce();
        int size = vals.size();
        for (int i = 0; i < size; ++i) {
            Validation va = vals.getValidation(i);
            MessagedValidate validate = va.getMessagedValidate();
            out.write(6);
            out.writeInt(validate.getTypeIndex());
            int qua = validate.getQualifierIndex();
            out.writeInt(qua);
            String range = SheetBaseMath.getBlocksA1Name(va.getBlocks(), true);
            out.writeString(range);
            out.write((byte)validate.getImeMode());
            byte flags = 0;
            flags = (byte)(flags | (validate.hasCellRangeList() ? 1 : 0));
            flags = (byte)(flags | (validate.isUseBlank() ? 2 : 0));
            flags = (byte)(flags | (validate.isInputHide() ? 4 : 0));
            flags = (byte)(flags | (validate.isErrorHide() ? 8 : 0));
            out.write(flags);
            String min = validate.getMin();
            out.writeString(min);
            if (qua <= 1) {
                String max = validate.getMax();
                out.writeString(max);
            }
            String it = validate.getInputTitle();
            out.writeString(it);
            String im = validate.getInputMessage();
            out.writeString(im);
            String es = validate.getErrorStyle();
            out.writeString(es);
            String et = validate.getErrorTitle();
            out.writeString(et);
            String em = validate.getErrorMessage();
            out.writeString(em);
        }
    }

    private void writeSheetOption(SheetOption so, KDSDataOutputStream out) throws IOException {
        out.write(4);
        out.writeInt(so.getScale());
        Color c = so.getGridLineColor();
        if (c == null) {
            out.writeInt(0xFFAFAF);
        } else {
            out.writeInt(c.getRGB());
        }
        byte flags = 0;
        flags = (byte)(flags | (so.isShowHoriLines() ? 1 : 0));
        flags = (byte)(flags | (so.isShowVertLines() ? 2 : 0));
        out.write(flags);
        this.writePrintSetup(so.getPrintSetup(false), out);
        this.writeSheetProtection(so.getProtection(false), out);
        this.writeSheetProtectionEditBlocks(so.getProtection(false), out);
        this.writeSelection(so.getSelection(), out);
        this.writeSplit(so, so.getViewSplitInfo(), out);
        this.writeMerge(so.getMerger(false), out);
        out.write(127);
    }

    private void writePrintSetup(PrintSetup ps, KDSDataOutputStream out) throws IOException {
        if (ps == null) {
            return;
        }
        out.write(6);
        boolean isLandScape = ps.isLandScape();
        boolean isRowFirst = ps.isRowFirst();
        boolean isBlackWhite = ps.isBlackWhite();
        boolean hasGrid = ps.hasGrid();
        boolean hasHead = ps.hasRowHead();
        boolean hasColHead = ps.hasColHead();
        int flags = 0;
        flags = (byte)(flags | (hasColHead ? 2 : 0));
        flags = (byte)(flags | (hasHead ? 1 : 0));
        flags = (byte)(flags | (hasGrid ? 4 : 0));
        flags = (byte)(flags | (isBlackWhite ? 8 : 0));
        flags = (byte)(flags | (isRowFirst ? 16 : 0));
        flags = (byte)(flags | (isLandScape ? 32 : 0));
        out.write(flags);
        int centerHori = ps.getCenterHorizontal();
        out.writeInt(centerHori);
        int centerVert = ps.getCenterVertical();
        out.writeInt(centerVert);
        float topMargin = ps.getTopMargin();
        out.writeInt(Float.floatToIntBits(topMargin));
        float bottomMargin = ps.getBottomMargin();
        out.writeInt(Float.floatToIntBits(bottomMargin));
        float leftMargin = ps.getLeftMargin();
        out.writeInt(Float.floatToIntBits(leftMargin));
        float rightMargin = ps.getRightMargin();
        out.writeInt(Float.floatToIntBits(rightMargin));
        int pageSizeIndex = ps.getPagesizeIndex();
        out.writeInt(pageSizeIndex);
        float pageSizeX = ps.getPagesizeX();
        out.writeInt(Float.floatToIntBits(pageSizeX));
        float pageSizeY = ps.getPagesizeY();
        out.writeInt(Float.floatToIntBits(pageSizeY));
        boolean autoFit = ps.isAutoFit();
        out.writeBoolean(autoFit);
        int scale = ps.getScale();
        out.writeInt(scale);
        int autoFitWidth = ps.getAutoFitWidth();
        out.writeInt(autoFitWidth);
        int autoFitHeight = ps.getAutoFitHeight();
        out.writeInt(autoFitHeight);
        float headMargin = ps.getHeadMargin();
        out.writeInt(Float.floatToIntBits(headMargin));
        String headData = PrintHelper.getHeadFootString(ps.getHeadData(), true);
        out.writeString(headData);
        int footAlign = ps.getFootAlign();
        out.writeInt(footAlign);
        int headAlign = ps.getHeadAlign();
        out.writeInt(headAlign);
        float footMargin = ps.getFootMargin();
        out.writeInt(Float.floatToIntBits(footMargin));
        String footData = PrintHelper.getHeadFootString(ps.getFootData(), true);
        out.writeString(footData);
        out.writeString(ps.getBackGroundUrl());
    }

    private void writeSheetProtection(Protection pro, KDSDataOutputStream out) throws IOException {
        if (pro == null) {
            return;
        }
        int opers = pro.getOperations();
        out.write(1);
        out.write(pro.isProtected() ? 1 : 0);
        out.writeInt(opers);
        String pw = pro.getEncryptedPassword();
        out.writeString(pw);
    }

    private void writeSheetProtectionEditBlocks(Protection pro, KDSDataOutputStream out) throws IOException {
        if (pro == null) {
            return;
        }
        Protection.SortedEditalbeAreaArray blocks = pro.getEditableBlocks();
        if (blocks != null) {
            int size = blocks.size();
            for (int i = 0; i < size; ++i) {
                out.write(2);
                Protection.EditableArea ea = (Protection.EditableArea)blocks.get(i);
                String name = ea.getName();
                out.writeString(name);
                String pw = ea.getEncryptedPassword();
                out.writeString(pw);
                String range = SheetBaseMath.getBlocksA1Name(ea, true);
                out.writeString(range);
            }
        }
    }

    private void writeSelection(Selection sel, KDSDataOutputStream out) throws IOException {
        int row = sel.getActiveRow();
        int col = sel.getActiveCol();
        if (row == 0 && col == 0 && sel.isBaseUnit()) {
            return;
        }
        out.write(4);
        out.writeInt(row);
        out.writeInt(col);
        String range = SheetBaseMath.getBlocksA1Name(sel.toSelectionBlocks(), true);
        out.writeString(range);
    }

    private void writeSplit(SheetOption so, ViewSplitInfo vs, KDSDataOutputStream out) throws IOException {
        out.write(3);
        byte flags = 0;
        flags = (byte)(flags | (so.isHide() ? 1 : 0));
        flags = (byte)(flags | (so.isSelected() ? 2 : 0));
        flags = (byte)(flags | (vs.isFreezed() ? 4 : 0));
        out.write(flags);
        out.writeInt(vs.getActivePane());
        out.writeInt(vs.getFirstRow());
        out.writeInt(vs.getFirstCol());
        out.writeInt(vs.getFirstRow2());
        out.writeInt(vs.getFirstCol2());
        out.writeInt(vs.getRowSplit());
        out.writeInt(vs.getColSplit());
    }

    private void writeMerge(MergeBlocks mb, KDSDataOutputStream out) throws IOException {
        if (mb == null || mb.isEmpty()) {
            return;
        }
        out.write(5);
        out.writeString(SheetBaseMath.getBlocksA1Name(mb, false));
    }

    private void writeCols(SortedColumnArray cols, KDSDataOutputStream out) throws IOException {
        int size = cols.size();
        for (int c = 0; c < size; ++c) {
            Column col = cols.getAt(c);
            out.write(2);
            out.writeInt(col.getCol());
            this.writeUserObjects(col.getUserObjects(), (byte)1, out);
            out.write(127);
        }
    }

    private void writeRows(SortedRowArray rows, KDSDataOutputStream out) throws IOException {
        int size = rows.size();
        for (int r = 0; r < size; ++r) {
            Row row = rows.getAt(r);
            out.write(1);
            out.writeInt(row.getRow());
            this.writeUserObjects(row.getUserObjects(), (byte)1, out);
            int justColIndex = 0;
            int rsize = row.size();
            for (int c = 0; c < rsize; ++c) {
                Cell cell = row.getAt(c);
                this.writeCell(cell, justColIndex, out);
                justColIndex = cell.getCol() + 1;
            }
            out.write(127);
        }
    }

    private void writeCell(Cell cell, int justColIndex, KDSDataOutputStream out) throws IOException {
        ExtProps ep;
        Comment comm;
        DiagonalHeader dh;
        SortedUserObjectArray uos;
        ShareStyleAttributes ssa;
        out.write(2);
        int col = cell.getCol();
        if (col != justColIndex) {
            out.write(1);
            out.writeInt(col);
        }
        if ((ssa = cell.getSSA2()) != null && !ssa.isEmpty()) {
            out.write(2);
            out.writeInt(ssa.getUID());
        }
        String formula = cell.getFormula();
        if (cell.hasFormula()) {
            out.write(3);
            out.writeString(formula, false);
        }
        this.writeVaraint(cell.getValue(), out);
        HyperLink link = cell.getHyperLink();
        if (link != null && !StringUtil.isEmptyString((String)link.getLinkTo())) {
            out.write(5);
            out.writeString(link.getLinkTo(), false);
        }
        if ((uos = cell.getUserObjects(false)) != null && !uos.isEmpty()) {
            this.writeUserObjects(uos, (byte)6, out);
        }
        if ((dh = cell.getDiagonalHeader()) != null) {
            this.writeDiagonalHeader(dh, out);
        }
        if ((comm = cell.getComment()) != null) {
            this.writeComment(comm, (byte)7, out);
        }
        if ((ep = cell.getExtProps(false)) != null) {
            out.write(9);
            this.writeExtProps(ep, out);
        }
        if (cell.isFirstMergedCell()) {
            out.write(10);
            out.writeBoolean(true);
        }
        out.write(127);
    }

    private void wirteErrorVaiaint(Variant var, KDSDataOutputStream out) throws IOException {
        if (var == null || var.getVt() != 16) {
            return;
        }
        out.write(4);
        out.write(9);
        String sval = var.toString();
        out.writeString(sval, false);
    }

    private void writeVaraint(Variant var, KDSDataOutputStream out) throws IOException {
        if (var != Variant.nullVariant) {
            int dataType = 1;
            int vt = var.getVt();
            switch (vt) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 9: 
                case 10: {
                    dataType = 4;
                    break;
                }
                case 8: {
                    dataType = 2;
                    break;
                }
                case 12: 
                case 13: {
                    dataType = 8;
                    break;
                }
                case 0: 
                case 16: 
                case 8192: 
                case 16384: {
                    dataType = 0;
                    break;
                }
            }
            if (dataType != 0) {
                out.write(4);
                out.write(dataType);
                if (dataType == 8) {
                    Object value = var.getValue();
                    long lValue = vt == 12 ? ((Date)value).getTime() : ((Calendar)value).getTimeInMillis();
                    out.writeString(Long.toString(lValue), false);
                } else if (dataType == 2) {
                    out.writeBoolean((Boolean)var.getValue());
                } else {
                    String sval = var.toString();
                    out.writeString(sval, false);
                }
            }
        }
    }

    private void writeDiagonalHeader(DiagonalHeader dh, KDSDataOutputStream out) throws IOException {
        int i;
        if (dh == null) {
            return;
        }
        out.write(8);
        out.write(dh.getPosition().byteValue());
        out.writeInt(dh.getRow());
        out.writeInt(dh.getCol());
        out.writeInt(dh.getRow2());
        out.writeInt(dh.getCol2());
        int[] rowOffs = dh.getRowOffs();
        if (rowOffs != null && rowOffs.length > 0) {
            StringBuffer sb = new StringBuffer();
            int size = rowOffs.length;
            for (i = 0; i < size - 1; ++i) {
                sb.append(String.valueOf(rowOffs[i])).append(',');
            }
            sb.append(String.valueOf(rowOffs[size - 1]));
            out.writeString(sb.toString(), false);
        } else {
            out.writeShort(0);
        }
        int[] colOffs = dh.getColOffs();
        if (colOffs != null && colOffs.length > 0) {
            StringBuffer sb = new StringBuffer();
            int size = colOffs.length;
            for (int i2 = 0; i2 < size - 1; ++i2) {
                sb.append(String.valueOf(colOffs[i2])).append(',');
            }
            sb.append(String.valueOf(colOffs[size - 1]));
            out.writeString(sb.toString(), false);
        } else {
            out.writeShort(0);
        }
        int size = dh.size();
        for (i = 0; i < size; ++i) {
            TriangleInfo ti = dh.getTriangleInfo(i);
            byte flags = 0;
            flags = (byte)(flags | (ti.isLean() ? 1 : 0));
            flags = (byte)(flags | (ti.isAutoZoom() ? 2 : 0));
            flags = (byte)(flags | (ti.isDrawBackground() ? 4 : 0));
            out.write(flags);
            this.writeStyleID((ShareStyleAttributes)ti.getStyle(), out);
            out.writeString(ti.getText());
        }
    }

    private void writeUserObjects(SortedUserObjectArray uos, byte userObjectID, KDSDataOutputStream out) throws IOException {
        if (uos == null) {
            return;
        }
        int size = uos.size();
        for (int i = 0; i < size; ++i) {
            String outStr;
            UserObject uo = uos.getUserObject(i);
            String key = uo.getKey();
            Object value = uo.getValue();
            if (value == null) continue;
            Book.IUserObjectProvider trans = null;
            if (this._ctrl != null) {
                trans = this._ctrl.getKmlUOTrans();
            }
            if (trans != null) {
                outStr = trans.getString(key, value);
                if (outStr == null) {
                    continue;
                }
            } else {
                outStr = value.toString();
            }
            this.writeKeyValue(userObjectID, key, outStr, out);
        }
    }

    private void writeNames(SortedNamedObjectNodeArray names, byte nameNodeID, KDSDataOutputStream out) throws IOException {
        if (names == null) {
            return;
        }
        int size = names.size();
        for (int i = 0; i < size; ++i) {
            NamedObjectNode node = names.getObjectNode(i);
            if (!node.isVisible() || node.isUndefined() || node.isNullExpr()) continue;
            this.writeKeyValue(nameNodeID, node.getName(), node.getRefersTo(), out);
        }
    }

    private void writeComment(Comment comment, byte commentID, KDSDataOutputStream out) throws IOException {
        if (comment == null) {
            return;
        }
        this.writeKeyValue(commentID, comment.getAuthor(), comment.getText(), out);
    }

    private void writeExtProps(ExtProps ep, KDSDataOutputStream out) throws IOException {
        SortedExtPropFormulasArray formulas;
        this.writeExtPropsHead(ep.getHead(true, false), (byte)1, out);
        this.writeExtPropsHead(ep.getHead(false, false), (byte)2, out);
        int ext = ep.getExtensible(false);
        if (ext == 1 || ext == 2) {
            out.write(3);
            out.writeInt(ext);
        }
        if ((formulas = ep.getFormulas(false)) != null) {
            int size = formulas.size();
            for (int i = 0; i < size; ++i) {
                SortedExtPropFormulasArray.Node node = (SortedExtPropFormulasArray.Node)formulas.get(i);
                this.writeKeyValue((byte)4, node.getAction().getStringKey(), node.getFormula(), out);
            }
        }
        out.write(127);
    }

    private void writeExtPropsHead(ExtProps head, byte id, KDSDataOutputStream out) throws IOException {
        if (head == null || head.isCell00()) {
            return;
        }
        out.write(id);
        Cell cll = head.getCell();
        long row = cll.getRow();
        out.writeLong(row << 32 | (long)cll.getCol());
    }

    private HashMap scanStyle(Sheet sheet) {
        int j;
        HashMap styles = new HashMap();
        PrintSetup ps = sheet.getSheetOption().getPrintSetup(false);
        if (ps != null) {
            this.scanHeadFooterStyleImpl(ps.getHeadData(), styles);
            this.scanHeadFooterStyleImpl(ps.getFootData(), styles);
        }
        this.addSSA(sheet.getSSA(), styles);
        Sheet.ICellsIterator iter = sheet.getCellsIterator(null, false, false);
        while (iter.hasNext()) {
            Cell cell = iter.next();
            DiagonalHeader dh = cell.getDiagonalHeader();
            if (dh != null) {
                int size = dh.size();
                for (j = 0; j < size; ++j) {
                    Style ssa = dh.getTriangleInfo(j).getStyle();
                    if (ssa == null || ssa.isEmpty()) continue;
                    this.addSSA((ShareStyleAttributes)ssa, styles);
                }
            }
            this.addSSA(cell.getSSA2(), styles);
        }
        SortedAttributeSpanArray rowSpans = sheet.getRowSpans();
        int size = rowSpans.size();
        for (int j2 = 0; j2 < size; ++j2) {
            this.addSSA(rowSpans.getAttributeSpan(j2).getSSA(), styles);
        }
        SortedAttributeSpanArray colSpans = sheet.getColSpans();
        size = colSpans.size();
        for (j = 0; j < size; ++j) {
            this.addSSA(colSpans.getAttributeSpan(j).getSSA(), styles);
        }
        ConditionalFormatList cfl = sheet.getConditionalFormats();
        if (cfl != null) {
            int valve = cfl.size();
            for (int i = 0; i < valve; ++i) {
                ShareStyleAttributes[] ssas = cfl.getConditionalFormat(i).getSSAs();
                if (ssas == null) continue;
                for (int j3 = 0; j3 < ssas.length; ++j3) {
                    this.addSSA(ssas[j3], styles);
                }
            }
        }
        return styles;
    }

    private void scanHeadFooterStyleImpl(List listData, HashMap styles) {
        if (listData == null) {
            return;
        }
        ListIterator iter = listData.listIterator();
        while (iter.hasNext()) {
            HeadFootRow row = (HeadFootRow)iter.next();
            StyleAttributes sa = row.getSA();
            if (sa == null) continue;
            ShareStyleAttributes ssa = Styles.getSSA((StyleAttributes)sa);
            this.addSSA(ssa, styles);
        }
    }

    private void addSSA(ShareStyleAttributes ssa, HashMap styles) {
        if (ssa != null && !ssa.isEmpty()) {
            Integer key = new Integer(ssa.getUID());
            styles.put(key, ssa);
        }
    }

    private void writeKeyValue(byte id, String key, String value, KDSDataOutputStream out) throws IOException {
        out.write(id);
        out.writeString(key);
        out.writeString(value);
    }

    public void writeStyleID(ShareStyleAttributes ssa, KDSDataOutputStream out) throws IOException {
        int uid = -1;
        if (ssa != null && !ssa.isEmpty()) {
            uid = ssa.getUID();
        }
        out.writeInt(uid);
    }
}

