/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.io.kml;

import com.kingdee.bos.ctrl.common.hyperlink.HyperLink;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.common.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.io.BookIOController;
import com.kingdee.bos.ctrl.excel.io.IBookFieldFlags;
import com.kingdee.bos.ctrl.excel.io.PrintHelper;
import com.kingdee.bos.ctrl.excel.io.kml.IKmlConstants;
import com.kingdee.bos.ctrl.excel.io.kml.KmlStyleParser;
import com.kingdee.bos.ctrl.excel.io.kml.KmlUtil;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.BookFormulaHelper;
import com.kingdee.bos.ctrl.excel.model.struct.BookProtection;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Column;
import com.kingdee.bos.ctrl.excel.model.struct.Comment;
import com.kingdee.bos.ctrl.excel.model.struct.DiagonalHeader;
import com.kingdee.bos.ctrl.excel.model.struct.PrintSetup;
import com.kingdee.bos.ctrl.excel.model.struct.Protection;
import com.kingdee.bos.ctrl.excel.model.struct.Row;
import com.kingdee.bos.ctrl.excel.model.struct.Selection;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.SheetBaseMath;
import com.kingdee.bos.ctrl.excel.model.struct.SheetOption;
import com.kingdee.bos.ctrl.excel.model.struct.SortedAttributeSpanArray;
import com.kingdee.bos.ctrl.excel.model.struct.SortedUserObjectArray;
import com.kingdee.bos.ctrl.excel.model.struct.UserObject;
import com.kingdee.bos.ctrl.excel.model.struct.ViewSplitInfo;
import com.kingdee.bos.ctrl.excel.model.struct.cformat.ConditionalFormat;
import com.kingdee.bos.ctrl.excel.model.struct.cformat.ConditionalFormatList;
import com.kingdee.bos.ctrl.excel.model.struct.cformat.util.Condition;
import com.kingdee.bos.ctrl.excel.model.struct.node.NamedObjectNode;
import com.kingdee.bos.ctrl.excel.model.struct.node.SortedNamedObjectNodeArray;
import com.kingdee.bos.ctrl.excel.model.struct.validate.Validation;
import com.kingdee.bos.ctrl.excel.model.struct.validate.ValidationList;
import com.kingdee.bos.ctrl.excel.model.struct.validate.util.MessagedValidate;
import com.kingdee.bos.ctrl.excel.model.struct.validate.util.Validate;
import com.kingdee.bos.ctrl.excel.model.util.SortedCellBlockArray;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootRow;
import com.kingdee.bos.ctrl.kdf.util.CloseUtil;
import com.kingdee.bos.ctrl.kdf.util.render.splitrectangle.AbstractTableSplitRectInfo;
import com.kingdee.bos.ctrl.kdf.util.render.splitrectangle.TriangleInfo;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.StyleParser;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.print.printjob.table.PlugablePaginationAdvice;
import java.awt.Color;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import javax.print.attribute.standard.OrientationRequested;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public final class BookToKml
extends IBookFieldFlags
implements IKmlConstants {
    static final char LeftBracket = '<';
    static final char RightBracket = '>';
    static final char Diagonal = '/';
    static final char Blank = ' ';
    static final char QuotationMark = '\"';
    static final char Colon = ':';
    static final char Equal = '=';
    static final String NewLine = "\r\n";
    static final String InitSource = "<?xml version=\"1.0\"?>\r\n<?mso-application progid=\"Excel.Sheet\" version=\"1.0\"?>\r\n";
    private static final String Xmlns = "xmlns";
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'.'SSS");
    private StringBuffer _reuseSb = new StringBuffer();
    private HashMap _saCache;
    private BookIOController _ctrl;
    private Book _book;

    public void setBookIOController(BookIOController ctrl) {
        this._ctrl = ctrl;
    }

    private boolean touchControllerFlag(int flag) {
        if (this._ctrl == null) {
            return true;
        }
        return this._ctrl.touchModeFlag(flag);
    }

    private boolean isToClipboard() {
        if (this._ctrl == null) {
            return false;
        }
        return this._ctrl.isToClipboard();
    }

    private boolean isForExcel() {
        if (this._ctrl == null) {
            return false;
        }
        return this._ctrl.isForExcel();
    }

    private Book.IUserObjectProvider getKmlUOTrans() {
        if (this._ctrl == null) {
            return null;
        }
        return this._ctrl.getKmlUOTrans();
    }

    public void export(Book book, String fileName) throws IOException {
        this.export(book, fileName, null);
    }

    public void export(Book book, Writer writer) throws IOException {
        this.export(book, writer, null);
    }

    public void export(Book book, OutputStream os) throws IOException {
        this.export(book, os, null);
    }

    public void export(Book book, OutputStream os, String[] sheetNames) throws FileNotFoundException, IOException {
        KmlOutputter outter = this.createKmlOutputter();
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new BufferedOutputStream(os), "UTF-8"));
        this.export(book, writer, sheetNames);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void export(Book book, String fileName, String[] sheetNames) throws FileNotFoundException, IOException {
        FileOutputStream fos = null;
        BufferedOutputStream bos = null;
        OutputStreamWriter osw = null;
        BufferedWriter writer = null;
        try {
            int index;
            if (this._ctrl != null && this._ctrl.isShouldReplaceSuffix() && (index = fileName.lastIndexOf(".")) != -1) {
                fileName = fileName.substring(0, index) + ".xls";
            }
            fos = new FileOutputStream(fileName);
            bos = new BufferedOutputStream(fos);
            osw = new OutputStreamWriter((OutputStream)bos, "UTF-8");
            writer = new BufferedWriter(osw);
            this.export(book, writer, sheetNames);
        }
        catch (Throwable throwable) {
            CloseUtil.close((Closeable[])new Closeable[]{writer, osw, bos, fos});
            throw throwable;
        }
        CloseUtil.close((Closeable[])new Closeable[]{writer, osw, bos, fos});
    }

    public void export(Book book, Writer writer, String[] sheetNames) throws IOException {
        this._book = book;
        KmlOutputter outter = this.createKmlOutputter();
        boolean old = book.setA1Style(false);
        Book cloneBook = this.cloneBook(book);
        this.exportImpl(cloneBook, outter, writer, sheetNames);
        book.setA1Style(old);
    }

    private Book cloneBook(Book book) {
        if (book == null) {
            return book;
        }
        UserObject created = book.getUserObject("CREATE_BORDER");
        if (created != null) {
            return book;
        }
        Book cloneBook = Book.Manager.getNewBook(book.getName());
        SheetBaseMath.cloneBookForBorders(book, cloneBook);
        return cloneBook;
    }

    private String getNamespaceString(String prefix, String uri) {
        this._reuseSb.delete(0, this._reuseSb.length());
        if (StringUtil.isEmptyString((String)prefix)) {
            this._reuseSb.append(Xmlns).append('=').append('\"').append(uri).append('\"');
        } else {
            this._reuseSb.append(Xmlns).append(':').append(prefix).append('=').append('\"').append(uri).append('\"');
        }
        return this._reuseSb.toString();
    }

    private String getNamespaceString(Namespace ns) {
        return this.getNamespaceString(ns.getPrefix(), ns.getURI());
    }

    private String getAttributeString(String name, String value, Namespace ns) {
        this._reuseSb.delete(0, this._reuseSb.length());
        String prefix = ns.getPrefix();
        if (StringUtil.isEmptyString((String)prefix)) {
            this._reuseSb.append(name).append('=').append('\"').append(value).append('\"');
        } else {
            this._reuseSb.append(prefix).append(':').append(name).append('=').append('\"').append(value).append('\"');
        }
        return this._reuseSb.toString();
    }

    private HashMap getSaCache() {
        if (this._saCache == null) {
            this._saCache = new HashMap();
        }
        return this._saCache;
    }

    private boolean needImported(String sheetName, String[] sheetNames) {
        boolean importSheet = true;
        if (sheetNames != null) {
            importSheet = false;
            int c = sheetNames.length;
            for (int j = 0; j < c; ++j) {
                if (!sheetNames[j].equals(sheetName)) continue;
                importSheet = true;
                break;
            }
        }
        return importSheet;
    }

    private void scanStyle(Book book, String[] sheetNames) {
        if (this.touchControllerFlag(IBookFieldFlags.FLAG_STYLE)) {
            int count = book.getSheetCount();
            for (int i = 0; i < count; ++i) {
                int j;
                Sheet sheet = book.getSheet(i);
                boolean importSheet = this.needImported(sheet.getSheetName(), sheetNames);
                if (!importSheet) continue;
                PrintSetup ps = sheet.getSheetOption().getPrintSetup(false);
                if (ps != null) {
                    this.scanHeadFooterStyleImpl(ps.getHeadData());
                    this.scanHeadFooterStyleImpl(ps.getFootData());
                }
                this.addSSA(sheet.getSSA());
                Sheet.ICellsIterator iter = sheet.getCellsIterator(0, 0, sheet.getMaxRowIndex(), sheet.getMaxColIndex(), false, false);
                while (iter.hasNext()) {
                    Cell cell = iter.next();
                    DiagonalHeader dh = cell.getDiagonalHeader();
                    if (dh != null) {
                        int size = dh.size();
                        for (j = 0; j < size; ++j) {
                            Style ssa = dh.getTriangleInfo(j).getStyle();
                            if (ssa == null || ssa.isEmpty()) continue;
                            this.addSSA((ShareStyleAttributes)ssa);
                        }
                    }
                    this.addSSA(cell.getSSA2());
                }
                SortedAttributeSpanArray rowSpans = sheet.getRowSpans();
                int size = rowSpans.size();
                for (int j2 = 0; j2 < size; ++j2) {
                    this.addSSA(rowSpans.getAttributeSpan(j2).getSSA());
                }
                SortedAttributeSpanArray colSpans = sheet.getColSpans();
                size = colSpans.size();
                for (j = 0; j < size; ++j) {
                    this.addSSA(colSpans.getAttributeSpan(j).getSSA());
                }
                ConditionalFormatList formatList = sheet.getConditionalFormats();
                for (int j3 = 0; j3 < formatList.size(); ++j3) {
                    ConditionalFormat format = formatList.getConditionalFormat(j3);
                    for (ShareStyleAttributes attribute : format.getSSAs()) {
                        this.addSSA(attribute);
                    }
                }
            }
        }
    }

    private void scanHeadFooterStyleImpl(List listData) {
        if (listData == null) {
            return;
        }
        ListIterator iter = listData.listIterator();
        while (iter.hasNext()) {
            HeadFootRow row = (HeadFootRow)iter.next();
            StyleAttributes sa = row.getSA();
            if (sa == null) continue;
            ShareStyleAttributes ssa = Styles.getSSA((StyleAttributes)sa);
            this.addSSA(ssa);
        }
    }

    private void addSSA(ShareStyleAttributes ssa) {
        if (ssa != null && !ssa.isEmpty()) {
            Integer key = new Integer(ssa.getUID());
            this.getSaCache().put(key, ssa);
        }
    }

    private KmlOutputter createKmlOutputter() {
        Format format = Format.getPrettyFormat();
        format.setEncoding("UTF-8");
        format.setIndent("\t");
        format.setTextMode(Format.TextMode.TRIM_FULL_WHITE);
        KmlOutputter outter = new KmlOutputter(format);
        return outter;
    }

    private void exportImpl(Book book, KmlOutputter outter, Writer writer, String[] sheetNames) throws IOException {
        outter.writeString(InitSource, writer);
        this.buildBook(book, sheetNames, outter, writer);
        writer.flush();
    }

    private void buildBook(Book book, String[] sheetNames, KmlOutputter outter, Writer writer) throws IOException {
        boolean oldA1style = book.getDeps().isA1Style();
        book.setA1Style(false);
        book.clearEmptyCells();
        StringBuffer sb = new StringBuffer(200);
        sb.append(' ');
        sb.append(this.getNamespaceString(NS_DEFAULT));
        sb.append(NewLine);
        sb.append(this.getNamespaceString(NS_OFFICE));
        sb.append(NewLine);
        sb.append(this.getNamespaceString(NS_EXCEL));
        sb.append(NewLine);
        sb.append(this.getNamespaceString(NS_SHEET));
        sb.append(NewLine);
        sb.append(this.getNamespaceString(NS_HTML));
        outter.writeStart("Workbook", sb.toString(), writer);
        this.buildBookExtends(book, outter, writer);
        this.buildExcelBook(book, outter, writer);
        if (this.touchControllerFlag(IBookFieldFlags.FLAG_STYLE)) {
            this.scanStyle(book, sheetNames);
            Element stylesE = new Element("Styles");
            KmlStyleParser.buildStylesElement(stylesE, this.getSaCache().entrySet().iterator());
            outter.output(stylesE, writer);
            outter.writeString(NewLine, writer);
        }
        if (this.touchControllerFlag(FLAG_BOOK_NAMES)) {
            this.buildNames(book, book.getNames(), outter, writer);
        }
        int count = book.getSheetCount();
        for (int i = 0; i < count; ++i) {
            Sheet sheet = book.getSheet(i);
            if (!this.needImported(sheet.getSheetName(), sheetNames)) continue;
            this.buildSheet(sheet, outter, writer);
        }
        outter.writeEnd("Workbook", writer);
        book.setA1Style(oldA1style);
        this.getSaCache().clear();
    }

    private void buildBookExtends(Book book, KmlOutputter outter, Writer writer) throws IOException {
        boolean buo = this.touchControllerFlag(FLAG_BOOK_USEROBJECT);
        boolean bcom = this.touchControllerFlag(FLAG_BOOK_COMMENT);
        if (!buo && !bcom) {
            return;
        }
        Comment comment = book.getComment();
        SortedUserObjectArray uos = book.getUserObjects();
        if ((uos == null || uos.isEmpty()) && comment == null) {
            return;
        }
        outter.writeStart("KingdeeDefined", writer);
        if (buo) {
            this.buildUserObjects(uos, outter, writer);
        }
        if (bcom) {
            this.buildComment(comment, outter, writer);
        }
        outter.writeEnd("KingdeeDefined", writer);
    }

    private void buildExcelBook(Book book, KmlOutputter outter, Writer writer) throws IOException {
        outter.writeStart("ExcelWorkbook", ' ' + this.getNamespaceString(NS_EXCEL_DEFAULT), writer);
        int aIndex = book.getActiveSheetIndex();
        if (aIndex != 0) {
            outter.writeElementWithData("ActiveSheet", String.valueOf(aIndex), writer);
        }
        if (this.touchControllerFlag(FLAG_BOOK_PROTECTION)) {
            BookProtection pro = book.getProtection();
            if (!pro.allowOperatorStruct()) {
                outter.writeElementWithData("ProtectStructure", "True", writer);
            }
            if (!pro.allowOperatorWindow()) {
                outter.writeElementWithData("ProtectWindows", "True", writer);
            }
            String pw = pro.getEncryptedPassword();
            if (pro.isProtected() && !StringUtil.isEmptyString((String)pw)) {
                String attr = " BookProtectionFlag=\"md5\"";
                outter.writeElementWithData("Password", attr, KmlUtil.toXmlString(pw), writer);
            }
        }
        outter.writeEnd("ExcelWorkbook", writer);
    }

    private void buildSheet(Sheet sheet, KmlOutputter outter, Writer writer) throws IOException {
        Protection pro;
        StringBuffer sb = new StringBuffer(30);
        sb.append(' ').append(this.getAttributeString("Name", KmlUtil.toXmlString(sheet.getSheetName()), NS_SHEET));
        if (this.touchControllerFlag(FLAG_SHEET_PROTECTION) && (pro = sheet.getSheetOption().getProtection(false)) != null && pro.isProtected()) {
            sb.append(' ').append(this.getAttributeString("Protected", "1", NS_SHEET));
        }
        if (!sheet.getSheetOption().isShowHoriLines() && !sheet.getSheetOption().isShowVertLines()) {
            sb.append(' ').append(this.getAttributeString("Gridlines", KmlUtil.toXmlString("false"), NS_SHEET));
        } else {
            sb.append(' ').append(this.getAttributeString("Gridlines", KmlUtil.toXmlString("true"), NS_SHEET));
        }
        outter.writeStart("Worksheet", sb.toString(), writer);
        this.buildSheetExtends(sheet, outter, writer);
        if (this.touchControllerFlag(FLAG_SHEET_NAMES)) {
            this.buildNames(sheet.getBook(), sheet.getNames(), outter, writer);
        }
        this.buildSheetTable(sheet, outter, writer);
        this.buildSheetOptionElement(sheet, outter, writer);
        this.buildConditionalFormats(sheet, outter, writer);
        if (this.touchControllerFlag(FLAG_SHEET_VALIDATION)) {
            this.buildValidations(sheet, outter, writer);
        }
        outter.writeEnd("Worksheet", writer);
    }

    private void buildSheetExtends(Sheet sheet, KmlOutputter outter, Writer writer) throws IOException {
        boolean buo = this.touchControllerFlag(FLAG_SHEET_USEROBJECT);
        boolean bcom = this.touchControllerFlag(FLAG_SHEET_COMMENT);
        if (!buo && !bcom) {
            return;
        }
        SortedUserObjectArray uos = sheet.getUserObjects();
        Comment comment = sheet.getComment();
        String id = sheet.getID();
        if ((uos == null || uos.isEmpty()) && comment == null && StringUtil.isEmptyString((String)id)) {
            return;
        }
        outter.writeStart("KingdeeDefined", writer);
        if (!StringUtil.isEmptyString((String)id)) {
            outter.writeElementWithData("ID", KmlUtil.toXmlString(id), writer);
        }
        if (buo) {
            this.buildUserObjects(uos, outter, writer);
        }
        if (bcom) {
            this.buildComment(comment, outter, writer);
        }
        outter.writeEnd("KingdeeDefined", writer);
    }

    private void buildSheetTable(Sheet sheet, KmlOutputter outter, Writer writer) throws IOException {
        int rindex;
        int cindex;
        ShareStyleAttributes ssa;
        StringBuffer sb = new StringBuffer(100);
        sb.append(' ');
        if (this.touchControllerFlag(FLAG_STYLE) && (ssa = sheet.getSSA()) != null && !ssa.isEmpty()) {
            sb.append(this.getAttributeString("StyleID", KmlStyleParser.buildStyleID(ssa), NS_SHEET));
        }
        if (this.isToClipboard()) {
            CellBlock cb = sheet.getSheetOption().getSelection().toSortedBlocks().getBounds();
            cindex = cb.getCol2() + 1;
            rindex = cb.getRow2() + 1;
        } else {
            cindex = Math.max(0, sheet.getMaxColIndex(true) + 1);
            rindex = Math.max(0, sheet.getMaxRowIndex(true) + 1);
        }
        sb.append(' ').append(this.getAttributeString("ExpandedColumnCount", String.valueOf(cindex), NS_SHEET)).append(' ').append(this.getAttributeString("ExpandedRowCount", String.valueOf(rindex), NS_SHEET)).append(' ').append(this.getAttributeString("DefaultRowHeight", String.valueOf(KmlUtil.toStoreValue(sheet.getOriginalDefRowHeight())), NS_SHEET)).append(' ').append(this.getAttributeString("DefaultColumnWidth", String.valueOf(KmlUtil.toStoreValue(sheet.getOriginalDefColWidth())), NS_SHEET));
        if (cindex > 0 || rindex > 0) {
            outter.writeStart("Table", sb.toString(), writer);
            this.buildAllColumns(sheet, outter, writer);
            this.buildAllRows(sheet, outter, writer);
            outter.writeEnd("Table", writer);
        } else {
            outter.writeSingleElement("Table", sb.toString(), writer);
        }
    }

    private void buildSheetOptionElement(Sheet sheet, KmlOutputter outter, Writer writer) throws IOException {
        Color tc;
        Element soe = new Element("WorksheetOptions", NS_EXCEL_DEFAULT);
        int scale = sheet.getSheetOption().getScale();
        if (scale != 100) {
            Element e = new Element("Zoom", soe.getNamespace());
            e.addContent(String.valueOf(scale));
            soe.addContent((Content)e);
        }
        if ((tc = sheet.getSheetOption().getTabColor()) != null && !tc.equals(Color.white)) {
            Element e = new Element("TabColor", soe.getNamespace());
            e.addContent(StyleParser.colorToHex((Color)tc));
            soe.addContent((Content)e);
        }
        if (this.touchControllerFlag(FLAG_SHEET_PRINTSETUP)) {
            this.buildPrintSetupElement(sheet, soe);
            this.buildPrintElement(sheet, soe);
            this.buildPageViewElement(sheet, soe);
        }
        if (this.touchControllerFlag(FLAG_SHEET_SPLITINFO)) {
            this.buildSplitElement(sheet, soe);
        }
        if (this.touchControllerFlag(FLAG_SHEET_SELECTION)) {
            this.buildSelectionElement(sheet, soe);
        }
        if (this.touchControllerFlag(FLAG_SHEET_PROTECTION)) {
            this.buildSheetProtectionElement(sheet, soe);
        }
        outter.output(soe, writer);
        outter.writeString(NewLine, writer);
    }

    private void buildValidations(Sheet sheet, KmlOutputter outter, Writer out) throws IOException {
        ValidationList validations = sheet.getValidations();
        int size = validations.size();
        for (int i = 0; i < size; ++i) {
            String et;
            String em;
            String im;
            String it;
            SortedCellBlockArray sa;
            String sheetName;
            outter.writeStart("DataValidation", ' ' + this.getNamespaceString(NS_EXCEL_DEFAULT), out);
            Validation va = validations.getValidation(i);
            MessagedValidate validate = va.getMessagedValidate();
            String range = SheetBaseMath.getBlocksName(va.getBlocks(), false, true);
            outter.writeElementWithData("Range", range, out);
            String type = validate.getType();
            String qua = validate.getQualifier();
            if (!Validate.Type_ANY.equals(type)) {
                outter.writeElementWithData("Type", type, out);
            }
            if (!StringUtil.equals((String)qua, (String)Validate.Between)) {
                outter.writeElementWithData("Qualifier", qua, out);
            }
            if (validate.getImeMode() > 0) {
                outter.writeElementWithData("IMEMode", String.valueOf(validate.getImeMode()), out);
            }
            if (validate.hasCellRangeList()) {
                outter.writeSingleElement("CellRangeList", out);
            }
            if (validate.isUseBlank()) {
                outter.writeSingleElement("UseBlank", out);
            }
            String min = validate.getMin();
            String max = validate.getMax();
            if ((Validate.Between.equals(qua) || Validate.NotBetween.equals(qua)) && !Validate.Type_List.equals(type) && !Validate.Type_ANY.equals(type)) {
                if (Validate.Type_Date.equals(type) && min.indexOf("=") < 0) {
                    try {
                        outter.writeElementWithData("Min", String.valueOf(com.kingdee.bos.ctrl.common.digitalstyle.Format.parseData((String)min, (boolean)true).doubleValue() + 1.0), out);
                    }
                    catch (SyntaxErrorException e) {
                        e.printStackTrace();
                    }
                } else if (Validate.Type_Time.equals(type) && min.indexOf("=") < 0) {
                    try {
                        min = "0." + String.valueOf(com.kingdee.bos.ctrl.common.digitalstyle.Format.parseData((String)min, (boolean)true).doubleValue() + 1.0).split("\\.")[1];
                        outter.writeElementWithData("Min", min, out);
                    }
                    catch (SyntaxErrorException e) {
                        e.printStackTrace();
                    }
                } else if (min.startsWith("=")) {
                    sheetName = min.split("!")[0].replaceFirst("=", "");
                    sa = SheetBaseMath.getSortedBlocks(sheet, min, true);
                    min = SheetBaseMath.getBlocksName(sa, false, true);
                    min = sheetName + "!" + min;
                    outter.writeElementWithData("Min", KmlUtil.toXmlString(min), out);
                } else {
                    outter.writeElementWithData("Min", KmlUtil.toXmlString(min), out);
                }
                if (Validate.Type_Date.equals(type) && max.indexOf("=") < 0) {
                    try {
                        outter.writeElementWithData("Max", String.valueOf(com.kingdee.bos.ctrl.common.digitalstyle.Format.parseData((String)max, (boolean)true).doubleValue() + 1.0), out);
                    }
                    catch (SyntaxErrorException e) {
                        e.printStackTrace();
                    }
                } else if (Validate.Type_Time.equals(type) && max.indexOf("=") < 0) {
                    try {
                        max = "0." + String.valueOf(com.kingdee.bos.ctrl.common.digitalstyle.Format.parseData((String)max, (boolean)true).doubleValue() + 1.0).split("\\.")[1];
                        outter.writeElementWithData("Max", max, out);
                    }
                    catch (SyntaxErrorException e) {
                        e.printStackTrace();
                    }
                } else if (max.startsWith("=")) {
                    sheetName = min.split("!")[0].replaceFirst("=", "");
                    sa = SheetBaseMath.getSortedBlocks(sheet, max, true);
                    max = SheetBaseMath.getBlocksName(sa, false, true);
                    max = sheetName + "!" + max;
                    outter.writeElementWithData("Max", KmlUtil.toXmlString(max), out);
                } else {
                    outter.writeElementWithData("Max", KmlUtil.toXmlString(max), out);
                }
            } else if (Validate.Type_List.equals(type)) {
                if (!StringUtil.isEmptyString((String)min)) {
                    if (min.indexOf(44) < 0 && min.indexOf(61) >= 0) {
                        sheetName = min.split("!")[0].replaceFirst("=", "");
                        sa = SheetBaseMath.getSortedBlocks(sheet, min, true);
                        min = SheetBaseMath.getBlocksName(sa, false, true);
                        min = sheetName + "!" + min;
                    } else {
                        min = "\"" + min + "\"";
                    }
                }
                outter.writeElementWithData("Value", KmlUtil.toXmlString(min), out);
            } else if (Validate.Type_Date.equals(type) && !min.startsWith("=")) {
                try {
                    outter.writeElementWithData("Value", String.valueOf(com.kingdee.bos.ctrl.common.digitalstyle.Format.parseData((String)min, (boolean)true).doubleValue() + 1.0), out);
                }
                catch (SyntaxErrorException e) {
                    e.printStackTrace();
                }
            } else if (Validate.Type_Time.equals(type) && !min.startsWith("=")) {
                try {
                    outter.writeElementWithData("Value", String.valueOf(com.kingdee.bos.ctrl.common.digitalstyle.Format.parseData((String)min, (boolean)true).doubleValue() + 1.0).split(".")[1], out);
                }
                catch (SyntaxErrorException e) {
                    e.printStackTrace();
                }
            } else if (!Validate.Type_ANY.equals(type)) {
                if (min.startsWith("=")) {
                    sheetName = min.split("!")[0].replaceFirst("=", "");
                    sa = SheetBaseMath.getSortedBlocks(sheet, min, true);
                    min = SheetBaseMath.getBlocksName(sa, false, true);
                    min = sheetName + "!" + min;
                }
                outter.writeElementWithData("Min", KmlUtil.toXmlString(min), out);
            }
            if (validate.isInputHide()) {
                outter.writeSingleElement("InputHide", out);
            }
            if (!StringUtil.isEmptyString((String)(it = validate.getInputTitle()))) {
                outter.writeElementWithData("InputTitle", it, out);
            }
            if (!StringUtil.isEmptyString((String)(im = validate.getInputMessage()))) {
                outter.writeElementWithData("InputMessage", im, out);
            }
            if (validate.isErrorHide()) {
                outter.writeSingleElement("ErrorHide", out);
            }
            String es = validate.getErrorStyle();
            if (!StringUtil.isEmptyString((String)(es = this.switchErrorStyle(es)))) {
                outter.writeElementWithData("ErrorStyle", es, out);
            }
            if (!StringUtil.isEmptyString((String)(em = validate.getErrorMessage()))) {
                outter.writeElementWithData("ErrorMessage", em, out);
            }
            if (!StringUtil.isEmptyString((String)(et = validate.getErrorTitle()))) {
                outter.writeElementWithData("ErrorTitle", et, out);
            }
            outter.writeEnd("DataValidation", out);
        }
    }

    private String switchErrorStyle(String es) {
        if (MessagedValidate.STOP_STYLE.equals(es)) {
            return "Stop";
        }
        if (MessagedValidate.WARNING_STYLE.equals(es)) {
            return "Warn";
        }
        if (MessagedValidate.INFORMATION_STYLE.equals(es)) {
            return "Info";
        }
        return "Stop";
    }

    private void buildAllColumns(Sheet sheet, KmlOutputter outter, Writer out) throws IOException {
        Sheet.ColsIterator ci = sheet.getColsIterator(0, 16383, false);
        while (ci.hasNext()) {
            Column col = ci.next();
            this.buildColumn2(col, outter, out);
        }
        int defaultColSpanIndex = 0;
        SortedAttributeSpanArray colSpans = sheet.getColSpans();
        int colspanN = colSpans.size();
        for (int i = 0; i < colspanN; ++i) {
            this.buildColSpanElement(colSpans.getAttributeSpan(i), defaultColSpanIndex, outter, out);
            defaultColSpanIndex = colSpans.getSpan(i).getEnd() + 1;
        }
    }

    private void buildColSpanElement(SortedAttributeSpanArray.AttributeSpan colSpan, int defaultColSpanIndex, KmlOutputter outter, Writer out) throws IOException {
        double length;
        ShareStyleAttributes ssa;
        StringBuffer sb = new StringBuffer();
        int index = colSpan.getStart();
        if (index != defaultColSpanIndex) {
            sb.append(' ').append(this.getAttributeString("Index", String.valueOf(index + 1), NS_SHEET));
        }
        if (colSpan.getExtent() > 1) {
            sb.append(' ').append(this.getAttributeString("Span", String.valueOf(colSpan.getExtent() - 1), NS_SHEET));
        }
        if (this.touchControllerFlag(FLAG_STYLE) && (ssa = colSpan.getSSA()) != null && !ssa.isEmpty()) {
            sb.append(' ').append(this.getAttributeString("StyleID", KmlStyleParser.buildStyleID(ssa), NS_SHEET));
        }
        if ((length = (double)colSpan.getOriginalLength()) != 0.0) {
            length = KmlUtil.toStoreValue(length);
            sb.append(' ').append(this.getAttributeString("Width", String.valueOf(length), NS_SHEET));
        }
        if (!colSpan.isVisible()) {
            sb.append(' ').append(this.getAttributeString("Hidden", "1", NS_SHEET));
        }
        outter.writeSingleElement("Column", sb.toString(), out);
    }

    private void buildAllRows(Sheet sheet, KmlOutputter outter, Writer out) throws IOException {
        int defaultRowIndex = 0;
        SortedAttributeSpanArray rowSpans = sheet.getRowSpans();
        int numOfRowSpans = rowSpans.size();
        for (int i = 0; i < numOfRowSpans; ++i) {
            SortedAttributeSpanArray.AttributeSpan rowSpan = rowSpans.getAttributeSpan(i);
            if (rowSpan.getStart() - 1 >= defaultRowIndex) {
                Sheet.RowsIterator iter = sheet.getRowsIterator(defaultRowIndex, rowSpan.getStart() - 1, false);
                while (iter.hasNext()) {
                    Row row = iter.next();
                    this.buildRow(row, defaultRowIndex, outter, out);
                    defaultRowIndex = row.getRow() + 1;
                }
            }
            int start = rowSpan.getStart();
            Sheet.RowsIterator iter = sheet.getRowsIterator(defaultRowIndex, rowSpan.getEnd(), false);
            while (iter.hasNext()) {
                Row row = iter.next();
                int end = row.getRow() - 1;
                if (start <= end) {
                    this.buildRowSpan(rowSpan, null, start, end, defaultRowIndex, outter, out);
                    defaultRowIndex = end + 1;
                }
                this.buildRowSpan(rowSpan, row, row.getRow(), row.getRow(), defaultRowIndex, outter, out);
                start = defaultRowIndex = row.getRow() + 1;
            }
            if (start <= rowSpan.getEnd()) {
                this.buildRowSpan(rowSpan, null, start, rowSpan.getEnd(), defaultRowIndex, outter, out);
            }
            defaultRowIndex = rowSpan.getEnd() + 1;
        }
        if (defaultRowIndex <= sheet.getMaxRowIndex()) {
            Sheet.RowsIterator iter = sheet.getRowsIterator(defaultRowIndex, sheet.getMaxRowIndex(), false);
            while (iter.hasNext()) {
                Row row = iter.next();
                this.buildRow(row, defaultRowIndex, outter, out);
                defaultRowIndex = row.getRow() + 1;
            }
        }
    }

    private void buildRowSpan(SortedAttributeSpanArray.AttributeSpan rowSpan, Row row, int start, int end, int defaultRowIndex, KmlOutputter outter, Writer out) throws IOException {
        double length;
        ShareStyleAttributes ssa;
        StringBuffer sb = new StringBuffer(100);
        if (start > defaultRowIndex) {
            sb.append(' ').append(this.getAttributeString("Index", String.valueOf(start + 1), NS_SHEET));
        }
        if (end > start) {
            sb.append(' ').append(this.getAttributeString("Span", String.valueOf(end - start), NS_SHEET));
        }
        if (this.touchControllerFlag(FLAG_STYLE) && (ssa = rowSpan.getSSA()) != null && !ssa.isEmpty()) {
            sb.append(' ').append(this.getAttributeString("StyleID", KmlStyleParser.buildStyleID(ssa), NS_SHEET));
        }
        if ((length = (double)rowSpan.getOriginalLength()) != 0.0) {
            sb.append(' ');
            length = KmlUtil.toStoreValue(length);
            sb.append(this.getAttributeString("Height", String.valueOf(length), NS_SHEET));
        }
        if (!rowSpan.isVisible()) {
            sb.append(' ').append(this.getAttributeString("Hidden", "1", NS_SHEET));
        }
        if (row != null) {
            outter.writeStart("Row", sb.toString(), out);
            this.buildRowExtends(row, outter, out);
            this.buildCells(row, outter, out);
            outter.writeEnd("Row", out);
        } else {
            outter.writeSingleElement("Row", sb.toString(), out);
        }
    }

    private void buildColumn2(Column col, KmlOutputter outter, Writer out) throws IOException {
        SortedUserObjectArray uos = col.getUserObjects();
        if (uos == null || uos.isEmpty()) {
            return;
        }
        String str = ' ' + this.getAttributeString("Index", String.valueOf(col.getCol() + 1), NS_SHEET);
        outter.writeStart("Column2", str, out);
        outter.writeStart("KingdeeDefined", out);
        if (this.touchControllerFlag(FLAG_COL_USEROBJECT)) {
            this.buildUserObjects(uos, outter, out);
        }
        outter.writeEnd("KingdeeDefined", out);
        outter.writeEnd("Column2", out);
    }

    private void buildRow(Row row, int defaultRowIndex, KmlOutputter outter, Writer out) throws IOException {
        String str = "";
        if (row.getRow() > defaultRowIndex) {
            str = ' ' + this.getAttributeString("Index", String.valueOf(row.getRow() + 1), NS_SHEET);
        }
        outter.writeStart("Row", str, out);
        this.buildRowExtends(row, outter, out);
        this.buildCells(row, outter, out);
        outter.writeEnd("Row", out);
    }

    private void buildRowExtends(Row row, KmlOutputter outter, Writer out) throws IOException {
        SortedUserObjectArray uos = row.getUserObjects();
        if (uos == null || uos.isEmpty()) {
            return;
        }
        outter.writeStart("KingdeeDefined", out);
        if (this.touchControllerFlag(FLAG_ROW_USEROBJECT)) {
            this.buildUserObjects(uos, outter, out);
        }
        outter.writeEnd("KingdeeDefined", out);
    }

    private void buildCells(Row row, KmlOutputter outter, Writer out) throws IOException {
        if (!row.isEmptyContent()) {
            int defaultCellIndex = 0;
            Sheet.ICellsIterator iter = row.getCellsIterator(0, row.getMaxIntMark(), false, false);
            while (iter.hasNext()) {
                Cell cell = iter.next();
                if (!this.buildCell(cell, defaultCellIndex, outter, out)) continue;
                defaultCellIndex = cell.getCol() + 1;
            }
        }
    }

    private boolean isOutputFomula(Cell cell, String formula) {
        return this._ctrl == null || this._ctrl.isToClipboard() || !this._ctrl.isForExcel() || BookFormulaHelper.isExcelFunction(cell.getSheet().getBook(), cell.getSheet(), formula);
    }

    private boolean buildCell(Cell cell, int defaultCellIndex, KmlOutputter outter, Writer out) throws IOException {
        HyperLink link;
        ShareStyleAttributes ssa;
        boolean bInnerMerger;
        int r = cell.getRow();
        int c = cell.getCol();
        CellBlock mb = cell.getSheet().getMergeBlock(cell);
        StringBuffer sb = new StringBuffer(100);
        boolean bl = bInnerMerger = mb != null && (mb.getRow() != r || mb.getCol() != c);
        if (bInnerMerger && this.isForExcel()) {
            return false;
        }
        if (c > defaultCellIndex || bInnerMerger) {
            sb.append(' ').append(this.getAttributeString("Index", String.valueOf(c + 1), NS_SHEET));
        }
        if (this.touchControllerFlag(FLAG_STYLE) && (ssa = cell.getSSA2()) != null && !ssa.isEmpty()) {
            sb.append(' ').append(this.getAttributeString("StyleID", KmlStyleParser.buildStyleID(ssa), NS_SHEET));
        }
        String formula = cell.getFormula();
        if (this.touchControllerFlag(FLAG_FORMULA) && cell.hasFormula() && this.isOutputFomula(cell, formula)) {
            sb.append(' ').append(this.getAttributeString("Formula", KmlUtil.toXmlString(formula), NS_SHEET));
        }
        if ((link = cell.getHyperLink()) != null) {
            sb.append(' ').append(this.getAttributeString("HRef", KmlUtil.toXmlString(link.getLinkTo()), NS_SHEET));
        }
        if (mb != null && mb.getRow() == r && mb.getCol() == c) {
            if (mb.getWidth() - 1 > 0) {
                sb.append(' ').append(this.getAttributeString("MergeAcross", String.valueOf(mb.getWidth() - 1), NS_SHEET));
            }
            if (mb.getHeight() - 1 > 0) {
                sb.append(' ').append(this.getAttributeString("MergeDown", String.valueOf(mb.getHeight() - 1), NS_SHEET));
            }
        }
        outter.writeStart("Cell", sb.toString(), out);
        this.buildCellExtends(cell, outter, out);
        if (this.touchControllerFlag(FLAG_CELL_COMMENT)) {
            this.buildComment(cell.getComment(), outter, out);
        }
        if (this.touchControllerFlag(FLAG_DATA)) {
            if (this._ctrl != null && !this._ctrl.isShouldClone()) {
                cell = this._book.getSheet(cell.getSheet().getSheetIndex()).getCell(cell.getRow(), cell.getCol(), true);
            }
            this.buildCellData(cell, StringUtil.isEmptyString((String)formula) ? false : formula.startsWith("'"), outter, out);
        }
        outter.writeEnd("Cell", out);
        return true;
    }

    private void buildCellData(Cell cell, boolean ticked, KmlOutputter outter, Writer out) throws IOException {
        String data;
        if (cell.isEmptyContent()) {
            return;
        }
        String dataType = "String";
        Variant var = cell.getValue();
        int vt = var.getVt();
        switch (vt) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: {
                dataType = "Number";
                break;
            }
            case 8: {
                dataType = "Boolean";
                break;
            }
            case 12: 
            case 13: {
                dataType = "DateTime";
                break;
            }
            case 0: 
            case 16: 
            case 8192: 
            case 16384: {
                return;
            }
        }
        if ("Boolean".equals(dataType)) {
            data = (Boolean)var.getValue() != false ? "1" : "0";
        } else if ("DateTime".equals(dataType)) {
            try {
                Date date = var.toDate();
                data = sdf.format(date);
            }
            catch (SyntaxErrorException e) {
                data = KmlUtil.toXmlString(var.toString());
            }
        } else {
            data = KmlUtil.toXmlString(var.toString());
        }
        if (ticked || !StringUtil.isEmptyString((String)data)) {
            String attr = ' ' + this.getAttributeString("Type", dataType, NS_SHEET);
            if (ticked) {
                attr = attr + ' ' + this.getAttributeString("Ticked", "1", NS_EXCEL);
            }
            outter.writeElementWithData("Data", attr, data, out);
        }
    }

    private void buildCellExtends(Cell cell, KmlOutputter outter, Writer out) throws IOException {
        SortedUserObjectArray uos = cell.getUserObjects(false);
        DiagonalHeader d = cell.getDiagonalHeader();
        if ((uos == null || uos.isEmpty()) && d == null) {
            return;
        }
        outter.writeStart("KingdeeDefined", out);
        if (this.touchControllerFlag(FLAG_CELL_USEROBJECT)) {
            this.buildUserObjects(uos, outter, out);
        }
        this.buildDiagonalHeaderElement(d, outter, out);
        outter.writeEnd("KingdeeDefined", out);
    }

    private void buildPrintSetupElement(Sheet sheet, Element pe) {
        int cv;
        int ch;
        PrintSetup ps = sheet.getSheetOption().getPrintSetup(false);
        if (ps == null) {
            return;
        }
        Element setupE = new Element("PageSetup", pe.getNamespace());
        Element layoutE = null;
        String ori = "";
        if (ps.isLandScape()) {
            String str = OrientationRequested.LANDSCAPE.toString();
            StringBuffer sb = new StringBuffer(str);
            sb.setCharAt(0, Character.toUpperCase(sb.charAt(0)));
            ori = sb.toString();
        }
        if (!StringUtil.isEmptyString((String)ori)) {
            if (layoutE == null) {
                layoutE = new Element("Layout", pe.getNamespace());
            }
            layoutE.setAttribute("Orientation", ori, NS_EXCEL);
        }
        if ((ch = ps.getCenterHorizontal()) == 1) {
            if (layoutE == null) {
                layoutE = new Element("Layout", pe.getNamespace());
            }
            layoutE.setAttribute("CenterHorizontal", "" + ch, NS_EXCEL);
        }
        if ((cv = ps.getCenterVertical()) == 1) {
            if (layoutE == null) {
                layoutE = new Element("Layout", pe.getNamespace());
            }
            layoutE.setAttribute("CenterVertical", "" + cv, NS_EXCEL);
        }
        if (layoutE != null) {
            setupE.addContent((Content)layoutE);
        }
        Element he = new Element("Header", pe.getNamespace());
        he.setAttribute("Margin", String.valueOf(ps.getHeadMargin()), NS_EXCEL);
        String str = PrintHelper.getHeadFootString(ps.getHeadData(), false);
        if (!StringUtil.isEmptyString((String)str)) {
            he.setAttribute("Data", KmlUtil.toXmlString(str), NS_EXCEL);
        }
        setupE.addContent((Content)he);
        Element footE = new Element("Footer", pe.getNamespace());
        footE.setAttribute("Align", String.valueOf(ps.getFootAlign()), NS_EXCEL);
        footE.setAttribute("Align2", String.valueOf(ps.getHeadAlign()), NS_EXCEL);
        footE.setAttribute("Margin", String.valueOf(ps.getFootMargin()), NS_EXCEL);
        str = PrintHelper.getHeadFootString(ps.getFootData(), false);
        if (!StringUtil.isEmptyString((String)str)) {
            footE.setAttribute("Data", KmlUtil.toXmlString(str), NS_EXCEL);
        }
        setupE.addContent((Content)footE);
        Element pageE = new Element("PageMargins", pe.getNamespace());
        pageE.setAttribute("Bottom", String.valueOf(ps.getBottomMargin()), NS_EXCEL);
        pageE.setAttribute("Left", String.valueOf(ps.getLeftMargin()), NS_EXCEL);
        pageE.setAttribute("Right", String.valueOf(ps.getRightMargin()), NS_EXCEL);
        pageE.setAttribute("Top", String.valueOf(ps.getTopMargin()), NS_EXCEL);
        setupE.addContent((Content)pageE);
        pe.addContent((Content)setupE);
    }

    private void buildPrintElement(Sheet sheet, Element pe) {
        int scale;
        int index;
        PrintSetup ps = sheet.getSheetOption().getPrintSetup(false);
        if (ps == null) {
            return;
        }
        Element printE = new Element("Print", pe.getNamespace());
        if (ps.isRowFirst()) {
            printE.addContent((Content)new Element("LeftToRight", pe.getNamespace()));
        }
        if (ps.isBlackWhite()) {
            printE.addContent((Content)new Element("BlackAndWhite", pe.getNamespace()));
        }
        if ((index = ps.getPagesizeIndex()) >= 0) {
            Element e = new Element("PaperSizeIndex", pe.getNamespace());
            e.addContent(String.valueOf(index));
            float x = ps.getPagesizeX();
            float y = ps.getPagesizeY();
            if (x > 0.0f) {
                e.setAttribute("x", "" + x);
                e.setAttribute("y", "" + y);
            }
            printE.addContent((Content)e);
        }
        if ((scale = ps.getScale()) >= 0) {
            Element e = new Element("Scale", pe.getNamespace());
            e.addContent(String.valueOf(scale));
            if (ps.isAutoFit()) {
                e.setAttribute("AutoFit", "true");
                e.setAttribute("Height", String.valueOf(ps.getAutoFitHeight()));
                e.setAttribute("Width", String.valueOf(ps.getAutoFitWidth()));
            }
            printE.addContent((Content)e);
        }
        if (ps.hasGrid()) {
            printE.addContent((Content)new Element("Gridlines", pe.getNamespace()));
        }
        if (ps.hasRowHead() || ps.hasColHead()) {
            Element e = new Element("RowColHeadings", pe.getNamespace());
            if (!ps.hasRowHead()) {
                e.setAttribute("RowHead", "False");
            }
            if (!ps.hasColHead()) {
                e.setAttribute("ColHead", "False");
            }
            printE.addContent((Content)e);
        }
        pe.addContent((Content)printE);
    }

    private void buildPageViewElement(Sheet sheet, Element pe) {
        PlugablePaginationAdvice advice = sheet.getPlugablePaginationAdvice(false);
        if (advice != null) {
            Element e = new Element("PageView", pe.getNamespace());
            String sTemp = KmlUtil.intArrayToString(advice.getColExtendedBreaks());
            if (sTemp != null) {
                e.setAttribute("ColExtended", sTemp);
            }
            if ((sTemp = KmlUtil.intArrayToString(advice.getRowExtendedBreaks())) != null) {
                e.setAttribute("RowExtended", sTemp);
            }
            if ((sTemp = KmlUtil.intArrayToString(advice.getColShrinkedBreaks())) != null) {
                e.setAttribute("ColShrinked", sTemp);
            }
            if ((sTemp = KmlUtil.intArrayToString(advice.getRowShrinkedBreaks())) != null) {
                e.setAttribute("RowShrinked", sTemp);
            }
            pe.addContent((Content)e);
        }
    }

    private void buildSplitElement(Sheet sheet, Element pe) {
        int ap;
        int cs;
        int rs;
        int fc2;
        int fr2;
        int fc;
        int fr;
        boolean b;
        Element e;
        SheetOption so = sheet.getSheetOption();
        ViewSplitInfo vs = sheet.getSheetOption().getViewSplitInfo();
        boolean bHide = so.isHide();
        if (bHide) {
            e = new Element("Visible", pe.getNamespace());
            e.addContent("SheetHidden");
            pe.addContent((Content)e);
        }
        if (b = so.isSelected()) {
            pe.addContent((Content)new Element("Selected", pe.getNamespace()));
        }
        if (b = vs.isFreezed()) {
            pe.addContent((Content)new Element("FreezePanes", pe.getNamespace()));
        }
        if ((fr = vs.getFirstRow()) != 0) {
            e = new Element("TopRowVisible", pe.getNamespace());
            e.addContent(String.valueOf(fr));
            pe.addContent((Content)e);
        }
        if ((fc = vs.getFirstCol()) != 0) {
            e = new Element("LeftColumnVisible", pe.getNamespace());
            e.addContent(String.valueOf(fc));
            pe.addContent((Content)e);
        }
        if ((fr2 = vs.getFirstRow2()) != 0) {
            e = new Element("TopRowBottomPane", pe.getNamespace());
            e.addContent(String.valueOf(fr2));
            pe.addContent((Content)e);
        }
        if ((fc2 = vs.getFirstCol2()) != 0) {
            e = new Element("LeftColumnRightPane", pe.getNamespace());
            e.addContent(String.valueOf(fc2));
            pe.addContent((Content)e);
        }
        if ((rs = vs.getRowSplit()) != 0) {
            e = new Element("SplitHorizontal", pe.getNamespace());
            if (b) {
                e.addContent(String.valueOf(rs));
            } else {
                e.addContent(String.valueOf(KmlUtil.toStoreHoriSplit(rs)));
            }
            pe.addContent((Content)e);
        }
        if ((cs = vs.getColSplit()) != 0) {
            e = new Element("SplitVertical", pe.getNamespace());
            if (b) {
                e.addContent(String.valueOf(cs));
            } else {
                e.addContent(String.valueOf(KmlUtil.toStoreVertSplit(cs)));
            }
            pe.addContent((Content)e);
        }
        if ((ap = vs.getActivePane()) != 3) {
            e = new Element("ActivePane", pe.getNamespace());
            e.addContent(String.valueOf(ap));
            pe.addContent((Content)e);
        }
    }

    private void buildSheetProtectionElement(Sheet sheet, Element pe) {
        Protection.SortedEditalbeAreaArray blocks;
        Protection pro = sheet.getSheetOption().getProtection(false);
        Element e = new Element("ProtectObjects", pe.getNamespace());
        if (pro == null || pro.allowEditObjects()) {
            e.addContent("False");
        } else {
            e.addContent("True");
        }
        pe.addContent((Content)e);
        e = new Element("ProtectScenarios", pe.getNamespace());
        if (pro == null || pro.allowEditScenarios()) {
            e.addContent("False");
        } else {
            e.addContent("True");
        }
        pe.addContent((Content)e);
        if (pro == null) {
            return;
        }
        if (!pro.hasOperation(1)) {
            e = new Element("EnableSelection", pe.getNamespace());
            if (!pro.hasOperation(2)) {
                e.addContent("NoSelection");
            } else {
                e.addContent("UnlockedCells");
            }
            pe.addContent((Content)e);
        }
        if (pro.hasOperation(4)) {
            pe.addContent((Content)new Element("AllowFormatCells", pe.getNamespace()));
        }
        if (pro.hasOperation(8)) {
            pe.addContent((Content)new Element("AllowSizeCols", pe.getNamespace()));
        }
        if (pro.hasOperation(16)) {
            pe.addContent((Content)new Element("AllowSizeRows", pe.getNamespace()));
        }
        if (pro.hasOperation(32)) {
            pe.addContent((Content)new Element("AllowInsertCols", pe.getNamespace()));
        }
        if (pro.hasOperation(64)) {
            pe.addContent((Content)new Element("AllowInsertRows", pe.getNamespace()));
        }
        if (pro.hasOperation(128)) {
            pe.addContent((Content)new Element("AllowInsertHyperlinks", pe.getNamespace()));
        }
        if (pro.hasOperation(256)) {
            pe.addContent((Content)new Element("AllowDeleteCols", pe.getNamespace()));
        }
        if (pro.hasOperation(512)) {
            pe.addContent((Content)new Element("AllowDeleteRows", pe.getNamespace()));
        }
        if (pro.hasOperation(1024)) {
            pe.addContent((Content)new Element("AllowSort", pe.getNamespace()));
        }
        if (pro.hasOperation(2048)) {
            pe.addContent((Content)new Element("AllowFilter", pe.getNamespace()));
        }
        if (pro.hasOperation(4096)) {
            pe.addContent((Content)new Element("AllowUsePivotTables", pe.getNamespace()));
        }
        if (pro.hasOperation(32768)) {
            pe.addContent((Content)new Element("AllowCommont", pe.getNamespace()));
        }
        String pw = pro.getEncryptedPassword();
        if (pro.isProtected() && !StringUtil.isEmptyString((String)pw)) {
            e = new Element("Protection", pe.getNamespace());
            e.setAttribute("BookProtectionFlag", "md5");
            e.setAttribute("Password", KmlUtil.toXmlString(pw));
            pe.addContent((Content)e);
        }
        if ((blocks = pro.getEditableBlocks()) != null) {
            int size = blocks.size();
            for (int i = 0; i < size; ++i) {
                Protection.EditableArea ea = (Protection.EditableArea)blocks.get(i);
                e = new Element("EditBlocks", pe.getNamespace());
                e.setAttribute("Name", KmlUtil.toXmlString(ea.getName()));
                e.setAttribute("BookProtectionFlag", "md5");
                pw = ea.getEncryptedPassword();
                if (!StringUtil.isEmptyString((String)pw)) {
                    e.setAttribute("Password", KmlUtil.toXmlString(pw));
                }
                String range = SheetBaseMath.getBlocksA1Name(ea, true);
                e.setAttribute("RangeSelection", range);
                pe.addContent((Content)e);
            }
        }
    }

    private void buildSelectionElement(Sheet sheet, Element pe) {
        Selection sel = sheet.getSheetOption().getSelection();
        Element panesE = new Element("Panes", pe.getNamespace());
        Element paneE = new Element("Pane", pe.getNamespace());
        Element numberE = new Element("Number", pe.getNamespace());
        numberE.addContent(String.valueOf(sheet.getSheetOption().getViewSplitInfo().getActivePane()));
        Element activeRowE = new Element("ActiveRow", pe.getNamespace());
        activeRowE.addContent(String.valueOf(sel.getActiveRow()));
        Element activeColE = new Element("ActiveCol", pe.getNamespace());
        activeColE.addContent(String.valueOf(sel.getActiveCol()));
        Element rangeSelE = new Element("RangeSelection", pe.getNamespace());
        rangeSelE.addContent(SheetBaseMath.getBlocksName(sel.toSortedBlocks(), false, true));
        paneE.addContent((Content)numberE);
        paneE.addContent((Content)activeRowE);
        paneE.addContent((Content)activeColE);
        paneE.addContent((Content)rangeSelE);
        panesE.addContent((Content)paneE);
        pe.addContent((Content)panesE);
    }

    private void buildDiagonalHeaderElement(AbstractTableSplitRectInfo dh, KmlOutputter outter, Writer out) throws IOException {
        int[] colOffs;
        int i;
        int size;
        if (dh == null) {
            return;
        }
        Element dhe = new Element("DiagonalHeader");
        dhe.setAttribute("Position", dh.getPosition().toString());
        dhe.setAttribute("Row", String.valueOf(dh.getRow()));
        dhe.setAttribute("Col", String.valueOf(dh.getCol()));
        dhe.setAttribute("Row2", String.valueOf(dh.getRow2()));
        dhe.setAttribute("Col2", String.valueOf(dh.getCol2()));
        int[] rowOffs = dh.getRowOffs();
        if (rowOffs != null && rowOffs.length > 0) {
            StringBuilder sb = new StringBuilder();
            size = rowOffs.length;
            for (i = 0; i < size - 1; ++i) {
                sb.append(String.valueOf(rowOffs[i])).append(',');
            }
            sb.append(String.valueOf(rowOffs[size - 1]));
            dhe.setAttribute("RowOffers", sb.toString());
        }
        if ((colOffs = dh.getColOffs()) != null && colOffs.length > 0) {
            StringBuilder sb = new StringBuilder();
            int size2 = colOffs.length;
            for (int i2 = 0; i2 < size2 - 1; ++i2) {
                sb.append(String.valueOf(colOffs[i2])).append(',');
            }
            sb.append(String.valueOf(colOffs[size2 - 1]));
            dhe.setAttribute("ColOffers", sb.toString());
        }
        size = dh.size();
        for (i = 0; i < size; ++i) {
            this.buildTraingleInfoElement(dh, i, dhe);
        }
        outter.output(dhe, out);
    }

    private void buildTraingleInfoElement(AbstractTableSplitRectInfo dh, int index, Element pElement) {
        Style ssa;
        Element te = new Element("Triangle", pElement.getNamespace());
        TriangleInfo ti = dh.getTriangleInfo(index);
        if (this.touchControllerFlag(FLAG_STYLE) && (ssa = ti.getStyle()) != null && !ssa.isEmpty()) {
            te.setAttribute("StyleID", KmlStyleParser.buildStyleID((ShareStyleAttributes)ssa));
        }
        te.setAttribute("Index", String.valueOf(index));
        if (!StringUtil.isEmptyString((String)ti.getText())) {
            te.setAttribute("String", KmlUtil.toXmlString(ti.getText()));
        }
        te.setAttribute("Lean", ti.isLean() ? "True" : "False");
        te.setAttribute("Zoom", ti.isAutoZoom() ? "True" : "False");
        te.setAttribute("DrawBack", ti.isDrawBackground() ? "True" : "False");
        pElement.addContent((Content)te);
    }

    private void buildComment(Comment comment, KmlOutputter outter, Writer out) throws IOException {
        if (comment != null) {
            String author = "";
            if (comment.getAuthor() != null) {
                author = comment.getAuthor();
            }
            author = KmlUtil.toXmlString(author);
            outter.writeStart("Comment", ' ' + this.getAttributeString("Author", author, NS_SHEET), false, out);
            String text = "";
            if (comment.getAuthor() != null) {
                text = comment.getText();
            }
            text = KmlUtil.toXmlString(text);
            outter.writeElementWithData(NS_SHEET.getPrefix() + ':' + "Data", text, out);
            outter.writeEnd("Comment", out);
        }
    }

    private void buildNames(Book book, SortedNamedObjectNodeArray names, KmlOutputter outter, Writer out) throws IOException {
        if (names != null && !names.isEmpty()) {
            outter.writeStart("Names", out);
            int size = names.size();
            for (int i = 0; i < size; ++i) {
                NamedObjectNode node = names.getObjectNode(i);
                if (!node.isVisible() || node.isUndefined()) continue;
                StringBuilder sb = new StringBuilder(50);
                sb.append(' ');
                sb.append(this.getAttributeString("Name", KmlUtil.toXmlString(node.getName()), NS_SHEET));
                sb.append(' ');
                sb.append(this.getAttributeString("RefersTo", KmlUtil.toXmlString(node.getRefersTo()), NS_SHEET));
                outter.writeSingleElement("NamedRange", sb.toString(), out);
            }
            outter.writeEnd("Names", out);
        }
    }

    private void buildUserObjects(SortedUserObjectArray uos, KmlOutputter outter, Writer out) throws IOException {
        if (uos != null && !uos.isEmpty()) {
            int size = uos.size();
            for (int i = 0; i < size; ++i) {
                String outStr;
                UserObject uo = uos.getUserObject(i);
                String key = uo.getKey();
                Object value = uo.getValue();
                if (value == null) continue;
                Book.IUserObjectProvider trans = this.getKmlUOTrans();
                if (trans != null) {
                    outStr = trans.getString(key, value);
                    if (outStr == null) {
                        continue;
                    }
                } else {
                    outStr = value.toString();
                }
                if (outStr == null) continue;
                outStr = KmlUtil.toXmlString(outStr);
                outter.writeElementWithData("UserObject", ' ' + this.getAttributeString("Key", KmlUtil.toXmlString(key), NS_DEFAULT), outStr, out);
            }
        }
    }

    public void buildConditionalFormats(Sheet sheet, KmlOutputter outter, Writer out) throws IOException {
        ConditionalFormatList formatList = sheet.getConditionalFormats();
        for (int i = 0; i < formatList.size(); ++i) {
            ConditionalFormat format = formatList.getConditionalFormat(i);
            Element conditionalFormatElement = new Element("conditionalFormatting");
            conditionalFormatElement.setAttribute("dxfId", this.getSsaIDs(format.getSSAs()));
            conditionalFormatElement.setAttribute("sqref", SheetBaseMath.getBlocksA1Name(format.getBlocks(), false));
            Condition[] conditions = format.getConditions();
            for (int j = 0; j < conditions.length; ++j) {
                Element rule = this.createRuleElement(conditions[j], j);
                conditionalFormatElement.addContent((Content)rule);
            }
            outter.output(conditionalFormatElement, out);
        }
    }

    public void buildConditionalFormats(Sheet sheet, XMLOutputter outter, Writer out) throws IOException {
        this.buildConditionalFormats(sheet, new KmlOutputter(outter), out);
    }

    private Element createRuleElement(Condition condition, int index) {
        Element rule = new Element("cfRule");
        rule.setAttribute("priority", index + "");
        if (!StringUtil.isEmptyString((String)condition.getQualifier())) {
            rule.setAttribute("operator", condition.getQualifier());
        }
        rule.setAttribute("Type", condition.getType());
        Element formula1 = new Element("Formula");
        if (Condition.Type_Formula.equals(condition.getType()) && !StringUtil.isEmptyString((String)condition.getMin()) && condition.getMin().startsWith("=")) {
            formula1.setText(condition.getMin().substring(1));
        } else {
            formula1.setText(condition.getMin());
        }
        rule.addContent((Content)formula1);
        if (!StringUtil.isEmptyString((String)condition.getMax())) {
            Element formula2 = new Element("Formula");
            formula2.setText(condition.getMax());
            rule.addContent((Content)formula2);
        }
        return rule;
    }

    private String getSsaIDs(ShareStyleAttributes[] attributes) {
        StringBuilder sb = new StringBuilder();
        for (int j = 0; j < attributes.length; ++j) {
            sb.append(KmlStyleParser.buildStyleID(null == attributes[j] ? Styles.getEmptySSA() : attributes[j]));
            if (j >= attributes.length - 1) continue;
            sb.append(' ');
        }
        return sb.toString();
    }

    private class KmlOutputter {
        XMLOutputter xmlOutputter;

        public KmlOutputter(Format format) {
            this.xmlOutputter = new XMLOutputter(format);
        }

        public KmlOutputter(XMLOutputter out) {
            this.xmlOutputter = out;
        }

        private void writeString(String str, Writer out) throws IOException {
            out.write(str);
        }

        private void writeString(char c, Writer out) throws IOException {
            out.write(c);
        }

        public void writeElementWithData(String name, String data, Writer out) throws IOException {
            this.writeElementWithData(name, "", data, out);
        }

        public void writeElementWithData(String name, String userStr, String data, Writer out) throws IOException {
            this.writeStart(name, userStr, false, out);
            this.writeString(data, out);
            this.writeEnd(name, out);
        }

        public void writeSingleElement(String name, String userStr, Writer out) throws IOException {
            this.writeSingleElement(name, userStr, true, out);
        }

        public void writeSingleElement(String name, Writer out) throws IOException {
            this.writeSingleElement(name, "", true, out);
        }

        public void writeSingleElement(String name, boolean bnewline, Writer out) throws IOException {
            this.writeSingleElement(name, "", bnewline, out);
        }

        public void writeSingleElement(String name, String userStr, boolean bnewline, Writer out) throws IOException {
            this.writeString('<', out);
            this.writeString(name, out);
            this.writeString(userStr, out);
            this.writeString('/', out);
            this.writeString('>', out);
            if (bnewline) {
                this.writeString(BookToKml.NewLine, out);
            }
        }

        public void writeStart(String name, String userStr, Writer out) throws IOException {
            this.writeStart(name, userStr, true, out);
        }

        public void writeStart(String name, boolean bnewline, Writer out) throws IOException {
            this.writeStart(name, "", bnewline, out);
        }

        public void writeStart(String name, Writer out) throws IOException {
            this.writeStart(name, "", true, out);
        }

        public void writeStart(String name, String userStr, boolean bnewline, Writer out) throws IOException {
            this.writeString('<', out);
            this.writeString(name, out);
            this.writeString(userStr, out);
            this.writeString('>', out);
            if (bnewline) {
                this.writeString(BookToKml.NewLine, out);
            }
        }

        public void writeEnd(String name, boolean bnewline, Writer out) throws IOException {
            this.writeString('<', out);
            this.writeString('/', out);
            this.writeString(name, out);
            this.writeString('>', out);
            if (bnewline) {
                this.writeString(BookToKml.NewLine, out);
            }
        }

        public void writeEnd(String name, Writer out) throws IOException {
            this.writeEnd(name, true, out);
        }

        public void output(Element e, Writer out) {
            try {
                this.xmlOutputter.output(e, out);
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
    }
}

