/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.io.kml;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.excel.io.kml.AbsElement;
import com.kingdee.bos.ctrl.excel.io.kml.BasicElement;
import com.kingdee.bos.ctrl.excel.io.kml.DefaultElement;
import com.kingdee.bos.ctrl.excel.io.kml.KmlToBook;
import com.kingdee.bos.ctrl.excel.io.kml.KmlUtil;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.SheetBaseMath;
import com.kingdee.bos.ctrl.excel.model.struct.validate.Validation;
import com.kingdee.bos.ctrl.excel.model.struct.validate.util.MessagedValidate;
import com.kingdee.bos.ctrl.excel.model.struct.validate.util.Validate;
import com.kingdee.bos.ctrl.excel.model.util.SortedCellBlockArray;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

class DataValidationElement
extends BasicElement {
    private AbsElement rge;
    private AbsElement typee;
    private AbsElement quale;
    private AbsElement imeme;
    private AbsElement mine;
    private AbsElement ve;
    private AbsElement maxe;
    private AbsElement ite;
    private AbsElement ime;
    private AbsElement ese;
    private AbsElement ete;
    private AbsElement eme;

    DataValidationElement() {
    }

    private static boolean isRef(String formula) {
        block4: {
            try {
                Integer.parseInt(formula);
            }
            catch (NumberFormatException nfe) {
                try {
                    Double.parseDouble(formula);
                }
                catch (NumberFormatException nfe1) {
                    if (formula.indexOf("\"") >= 0) break block4;
                    return true;
                }
            }
        }
        return false;
    }

    private String double2DateTime(Double d, String type) {
        String t = null;
        Calendar base = Calendar.getInstance();
        SimpleDateFormat outFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        outFormat = Validate.Type_Date.equals(type) ? new SimpleDateFormat("yyyy-MM-dd") : new SimpleDateFormat("HH:mm:ss");
        int dates = d.intValue();
        double dHours = (d - (double)dates) * 24.0;
        int hours = (int)dHours;
        double dMins = (dHours - (double)hours) * 60.0;
        int mins = (int)dMins;
        double dSecs = (dMins - (double)mins) * 60.0;
        int secs = (int)dSecs;
        double dMilis = (dSecs - (double)secs) * 1000.0;
        int milis = (int)dMilis;
        base.set(1899, 11, 30, 0, 0, 0);
        base.add(5, dates);
        base.add(11, hours);
        base.add(12, mins);
        base.add(13, secs);
        base.add(14, milis);
        t = outFormat.format(base.getTime());
        return t;
    }

    private String switchErrorStyle(String es) {
        if ("Stop".equals(es)) {
            return MessagedValidate.STOP_STYLE;
        }
        if ("Warn".equals(es)) {
            return MessagedValidate.WARNING_STYLE;
        }
        if ("Info".equals(es)) {
            return MessagedValidate.INFORMATION_STYLE;
        }
        return MessagedValidate.STOP_STYLE;
    }

    private AbsElement getFitParser(String uri, String localName, String qName) {
        if ("Range".equals(KmlUtil.getLocalName(qName))) {
            if (this.rge == null) {
                this.rge = new RangeElement();
            }
            return this.rge;
        }
        if ("Type".equals(KmlUtil.getLocalName(qName))) {
            if (this.typee == null) {
                this.typee = new TypeElement();
            }
            return this.typee;
        }
        if ("Qualifier".equals(KmlUtil.getLocalName(qName))) {
            if (this.quale == null) {
                this.quale = new QualifierElement();
            }
            return this.quale;
        }
        if ("IMEMode".equals(KmlUtil.getLocalName(qName))) {
            if (this.imeme == null) {
                this.imeme = new IMEModeElement();
            }
            return this.imeme;
        }
        if ("Value".equals(KmlUtil.getLocalName(qName))) {
            if (this.ve == null) {
                this.ve = new ValueElement();
            }
            return this.ve;
        }
        if ("Min".equals(KmlUtil.getLocalName(qName))) {
            if (this.mine == null) {
                this.mine = new MinElement();
            }
            return this.mine;
        }
        if ("Max".equals(KmlUtil.getLocalName(qName))) {
            if (this.maxe == null) {
                this.maxe = new MaxElement();
            }
            return this.maxe;
        }
        if ("InputTitle".equals(KmlUtil.getLocalName(qName))) {
            if (this.ite == null) {
                this.ite = new InputTitleElement();
            }
            return this.ite;
        }
        if ("InputMessage".equals(KmlUtil.getLocalName(qName))) {
            if (this.ime == null) {
                this.ime = new InputMessageElement();
            }
            return this.ime;
        }
        if ("ErrorStyle".equals(KmlUtil.getLocalName(qName))) {
            if (this.ese == null) {
                this.ese = new ErrorStyleElement();
            }
            return this.ese;
        }
        if ("ErrorTitle".equals(KmlUtil.getLocalName(qName))) {
            if (this.ete == null) {
                this.ete = new ErrorTitleElement();
            }
            return this.ete;
        }
        if ("ErrorMessage".equals(KmlUtil.getLocalName(qName))) {
            if (this.eme == null) {
                this.eme = new ErrorMessageElement();
            }
            return this.eme;
        }
        return null;
    }

    @Override
    boolean isCurrentElement(String uri, String localName, String qName) {
        return "DataValidation".equals(KmlUtil.getLocalName(qName));
    }

    @Override
    void startElement(String uri, String localName, String qName, Attributes attributes, KmlToBook.ElementStack parserCache, KmlToBook.DataCache dataCache, KmlToBook ktb) throws SAXException {
        String qqname = KmlUtil.getLocalName(qName);
        if (this.isCurrentElement(uri, localName, qName)) {
            Validation val = new Validation();
            dataCache.getCurSheet().getValidations().addValidation(val);
            dataCache.setCurValidation(val);
        } else if ("UseBlank".equals(qqname)) {
            MessagedValidate mv = dataCache.getCurValidation().getMessagedValidate();
            if (mv == null) {
                mv = new MessagedValidate();
            }
            mv.setUseBlank(true);
        } else if ("CellRangeList".equals(qqname)) {
            MessagedValidate mv = dataCache.getCurValidation().getMessagedValidate();
            if (mv == null) {
                mv = new MessagedValidate();
            }
            mv.setCellRangeList(true);
        } else if ("InputHide".equals(qqname)) {
            MessagedValidate mv = dataCache.getCurValidation().getMessagedValidate();
            if (mv == null) {
                mv = new MessagedValidate();
            }
            mv.setInputHide(true);
        } else if ("ErrorHide".equals(qqname)) {
            MessagedValidate mv = dataCache.getCurValidation().getMessagedValidate();
            if (mv == null) {
                mv = new MessagedValidate();
            }
            mv.setErrorHide(true);
        } else {
            AbsElement parser = this.getFitParser(uri, localName, qName);
            if (parser != null) {
                parserCache.push(parser);
                parser.startElement(uri, localName, qName, attributes, parserCache, dataCache, ktb);
            }
        }
    }

    class ErrorMessageElement
    extends DefaultElement {
        ErrorMessageElement() {
        }

        @Override
        boolean isCurrentElement(String uri, String localName, String qName) {
            return "ErrorMessage".equals(KmlUtil.getLocalName(qName));
        }

        @Override
        void startElement(String uri, String localName, String qName, Attributes attributes, KmlToBook.ElementStack parserCache, KmlToBook.DataCache dataCache, KmlToBook ktb) throws SAXException {
            if (this.isCurrentElement(uri, localName, qName)) {
                this.bufString.delete(0, this.bufString.length());
            }
        }

        @Override
        void characters(char[] ch, int start, int length, KmlToBook.ElementStack parserCache, KmlToBook.DataCache dataCache, KmlToBook ktb) throws SAXException {
            this.bufString.append(ch, start, length);
        }

        @Override
        void endElement(String uri, String localName, String qName, KmlToBook.ElementStack parserCache, KmlToBook.DataCache dataCache, KmlToBook ktb) throws SAXException {
            super.endElement(uri, localName, qName, parserCache, dataCache, ktb);
            if (this.isCurrentElement(uri, localName, qName)) {
                Validation val = dataCache.getCurValidation();
                MessagedValidate mv = val.getMessagedValidate();
                if (mv == null) {
                    mv = new MessagedValidate();
                }
                mv.setErrorMessage(this.bufString.toString());
                val.setMessagedValidate(mv);
            }
        }
    }

    class ErrorTitleElement
    extends DefaultElement {
        ErrorTitleElement() {
        }

        @Override
        boolean isCurrentElement(String uri, String localName, String qName) {
            return "ErrorTitle".equals(KmlUtil.getLocalName(qName));
        }

        @Override
        void startElement(String uri, String localName, String qName, Attributes attributes, KmlToBook.ElementStack parserCache, KmlToBook.DataCache dataCache, KmlToBook ktb) throws SAXException {
            if (this.isCurrentElement(uri, localName, qName)) {
                this.bufString.delete(0, this.bufString.length());
            }
        }

        @Override
        void characters(char[] ch, int start, int length, KmlToBook.ElementStack parserCache, KmlToBook.DataCache dataCache, KmlToBook ktb) throws SAXException {
            this.bufString.append(ch, start, length);
        }

        @Override
        void endElement(String uri, String localName, String qName, KmlToBook.ElementStack parserCache, KmlToBook.DataCache dataCache, KmlToBook ktb) throws SAXException {
            super.endElement(uri, localName, qName, parserCache, dataCache, ktb);
            if (this.isCurrentElement(uri, localName, qName)) {
                Validation val = dataCache.getCurValidation();
                MessagedValidate mv = val.getMessagedValidate();
                if (mv == null) {
                    mv = new MessagedValidate();
                }
                mv.setErrorTitle(this.bufString.toString());
                val.setMessagedValidate(mv);
            }
        }
    }

    class ErrorStyleElement
    extends DefaultElement {
        ErrorStyleElement() {
        }

        @Override
        boolean isCurrentElement(String uri, String localName, String qName) {
            return "ErrorStyle".equals(KmlUtil.getLocalName(qName));
        }

        @Override
        void startElement(String uri, String localName, String qName, Attributes attributes, KmlToBook.ElementStack parserCache, KmlToBook.DataCache dataCache, KmlToBook ktb) throws SAXException {
            if (this.isCurrentElement(uri, localName, qName)) {
                this.bufString.delete(0, this.bufString.length());
            }
        }

        @Override
        void characters(char[] ch, int start, int length, KmlToBook.ElementStack parserCache, KmlToBook.DataCache dataCache, KmlToBook ktb) throws SAXException {
            this.bufString.append(ch, start, length);
        }

        @Override
        void endElement(String uri, String localName, String qName, KmlToBook.ElementStack parserCache, KmlToBook.DataCache dataCache, KmlToBook ktb) throws SAXException {
            super.endElement(uri, localName, qName, parserCache, dataCache, ktb);
            if (this.isCurrentElement(uri, localName, qName)) {
                Validation val = dataCache.getCurValidation();
                MessagedValidate mv = val.getMessagedValidate();
                if (mv == null) {
                    mv = new MessagedValidate();
                }
                mv.setErrorStyle(DataValidationElement.this.switchErrorStyle(this.bufString.toString()));
                val.setMessagedValidate(mv);
            }
        }
    }

    class InputMessageElement
    extends DefaultElement {
        InputMessageElement() {
        }

        @Override
        boolean isCurrentElement(String uri, String localName, String qName) {
            return "InputMessage".equals(KmlUtil.getLocalName(qName));
        }

        @Override
        void startElement(String uri, String localName, String qName, Attributes attributes, KmlToBook.ElementStack parserCache, KmlToBook.DataCache dataCache, KmlToBook ktb) throws SAXException {
            if (this.isCurrentElement(uri, localName, qName)) {
                this.bufString.delete(0, this.bufString.length());
            }
        }

        @Override
        void characters(char[] ch, int start, int length, KmlToBook.ElementStack parserCache, KmlToBook.DataCache dataCache, KmlToBook ktb) throws SAXException {
            this.bufString.append(ch, start, length);
        }

        @Override
        void endElement(String uri, String localName, String qName, KmlToBook.ElementStack parserCache, KmlToBook.DataCache dataCache, KmlToBook ktb) throws SAXException {
            super.endElement(uri, localName, qName, parserCache, dataCache, ktb);
            if (this.isCurrentElement(uri, localName, qName)) {
                Validation val = dataCache.getCurValidation();
                MessagedValidate mv = val.getMessagedValidate();
                if (mv == null) {
                    mv = new MessagedValidate();
                }
                mv.setInputMessage(this.bufString.toString());
                val.setMessagedValidate(mv);
            }
        }
    }

    class InputTitleElement
    extends DefaultElement {
        InputTitleElement() {
        }

        @Override
        boolean isCurrentElement(String uri, String localName, String qName) {
            return "InputTitle".equals(KmlUtil.getLocalName(qName));
        }

        @Override
        void startElement(String uri, String localName, String qName, Attributes attributes, KmlToBook.ElementStack parserCache, KmlToBook.DataCache dataCache, KmlToBook ktb) throws SAXException {
            if (this.isCurrentElement(uri, localName, qName)) {
                this.bufString.delete(0, this.bufString.length());
            }
        }

        @Override
        void characters(char[] ch, int start, int length, KmlToBook.ElementStack parserCache, KmlToBook.DataCache dataCache, KmlToBook ktb) throws SAXException {
            this.bufString.append(ch, start, length);
        }

        @Override
        void endElement(String uri, String localName, String qName, KmlToBook.ElementStack parserCache, KmlToBook.DataCache dataCache, KmlToBook ktb) throws SAXException {
            super.endElement(uri, localName, qName, parserCache, dataCache, ktb);
            if (this.isCurrentElement(uri, localName, qName)) {
                Validation val = dataCache.getCurValidation();
                MessagedValidate mv = val.getMessagedValidate();
                if (mv == null) {
                    mv = new MessagedValidate();
                }
                mv.setInputTitle(this.bufString.toString());
                val.setMessagedValidate(mv);
            }
        }
    }

    class MaxElement
    extends DefaultElement {
        MaxElement() {
        }

        @Override
        boolean isCurrentElement(String uri, String localName, String qName) {
            return "Max".equals(KmlUtil.getLocalName(qName));
        }

        @Override
        void startElement(String uri, String localName, String qName, Attributes attributes, KmlToBook.ElementStack parserCache, KmlToBook.DataCache dataCache, KmlToBook ktb) throws SAXException {
            if (this.isCurrentElement(uri, localName, qName)) {
                this.bufString.delete(0, this.bufString.length());
            }
        }

        @Override
        void characters(char[] ch, int start, int length, KmlToBook.ElementStack parserCache, KmlToBook.DataCache dataCache, KmlToBook ktb) throws SAXException {
            this.bufString.append(ch, start, length);
        }

        @Override
        void endElement(String uri, String localName, String qName, KmlToBook.ElementStack parserCache, KmlToBook.DataCache dataCache, KmlToBook ktb) throws SAXException {
            super.endElement(uri, localName, qName, parserCache, dataCache, ktb);
            if (this.isCurrentElement(uri, localName, qName)) {
                String str;
                Validation val = dataCache.getCurValidation();
                MessagedValidate mv = val.getMessagedValidate();
                if (mv == null) {
                    mv = new MessagedValidate();
                }
                if (!StringUtil.isEmptyString((String)(str = KmlUtil.toBookString(this.bufString.toString())))) {
                    if (!str.startsWith("=") && DataValidationElement.isRef(str)) {
                        String sheetName = "=" + str.split("!")[0];
                        SortedCellBlockArray sa = SheetBaseMath.getSortedBlocks(dataCache.getCurSheet(), str, false);
                        str = SheetBaseMath.getBlocksName(sa, true, false);
                        str = sheetName + "!" + str;
                    } else if (Validate.Type_Date.equals(mv.getType()) || Validate.Type_Time.equals(mv.getType())) {
                        try {
                            str = DataValidationElement.this.double2DateTime(Double.valueOf(str), mv.getType());
                        }
                        catch (NumberFormatException nfe) {
                            SortedCellBlockArray sa = SheetBaseMath.getSortedBlocks(dataCache.getCurSheet(), str, false);
                            str = SheetBaseMath.getBlocksName(sa, true, false);
                            str = "=" + str;
                        }
                    }
                }
                mv.setMax(str);
                dataCache.put("ValidateMin", null);
                val.setMessagedValidate(mv);
            }
        }
    }

    class MinElement
    extends DefaultElement {
        MinElement() {
        }

        @Override
        boolean isCurrentElement(String uri, String localName, String qName) {
            return "Min".equals(KmlUtil.getLocalName(qName));
        }

        @Override
        void startElement(String uri, String localName, String qName, Attributes attributes, KmlToBook.ElementStack parserCache, KmlToBook.DataCache dataCache, KmlToBook ktb) throws SAXException {
            if (this.isCurrentElement(uri, localName, qName)) {
                this.bufString.delete(0, this.bufString.length());
            }
        }

        @Override
        void characters(char[] ch, int start, int length, KmlToBook.ElementStack parserCache, KmlToBook.DataCache dataCache, KmlToBook ktb) throws SAXException {
            this.bufString.append(ch, start, length);
        }

        @Override
        void endElement(String uri, String localName, String qName, KmlToBook.ElementStack parserCache, KmlToBook.DataCache dataCache, KmlToBook ktb) throws SAXException {
            super.endElement(uri, localName, qName, parserCache, dataCache, ktb);
            if (this.isCurrentElement(uri, localName, qName)) {
                String str;
                Validation val = dataCache.getCurValidation();
                MessagedValidate mv = val.getMessagedValidate();
                if (mv == null) {
                    mv = new MessagedValidate();
                }
                if (!StringUtil.isEmptyString((String)(str = KmlUtil.toBookString(this.bufString.toString())))) {
                    if (!str.startsWith("=") && DataValidationElement.isRef(str)) {
                        String sheetName = "=" + str.split("!")[0];
                        SortedCellBlockArray sa = SheetBaseMath.getSortedBlocks(dataCache.getCurSheet(), str, false);
                        str = SheetBaseMath.getBlocksName(sa, true, false);
                        str = sheetName + "!" + str;
                    } else if (Validate.Type_Date.equals(mv.getType()) || Validate.Type_Time.equals(mv.getType())) {
                        try {
                            str = DataValidationElement.this.double2DateTime(Double.valueOf(str), mv.getType());
                        }
                        catch (NumberFormatException nfe) {
                            SortedCellBlockArray sa = SheetBaseMath.getSortedBlocks(dataCache.getCurSheet(), str, false);
                            str = SheetBaseMath.getBlocksName(sa, true, false);
                            str = "=" + str;
                        }
                    }
                }
                mv.setMin(str);
                dataCache.put("ValidateMin", str);
                val.setMessagedValidate(mv);
            }
        }
    }

    class ValueElement
    extends DefaultElement {
        ValueElement() {
        }

        @Override
        boolean isCurrentElement(String uri, String localName, String qName) {
            return "Value".equals(KmlUtil.getLocalName(qName));
        }

        @Override
        void startElement(String uri, String localName, String qName, Attributes attributes, KmlToBook.ElementStack parserCache, KmlToBook.DataCache dataCache, KmlToBook ktb) throws SAXException {
            if (this.isCurrentElement(uri, localName, qName)) {
                this.bufString.delete(0, this.bufString.length());
            }
        }

        @Override
        void characters(char[] ch, int start, int length, KmlToBook.ElementStack parserCache, KmlToBook.DataCache dataCache, KmlToBook ktb) throws SAXException {
            this.bufString.append(ch, start, length);
        }

        @Override
        void endElement(String uri, String localName, String qName, KmlToBook.ElementStack parserCache, KmlToBook.DataCache dataCache, KmlToBook ktb) throws SAXException {
            super.endElement(uri, localName, qName, parserCache, dataCache, ktb);
            if (this.isCurrentElement(uri, localName, qName)) {
                String str;
                Validation val = dataCache.getCurValidation();
                MessagedValidate mv = val.getMessagedValidate();
                if (mv == null) {
                    mv = new MessagedValidate();
                }
                if (!(str = KmlUtil.toBookString(this.bufString.toString())).startsWith("=") && DataValidationElement.isRef(str)) {
                    String sheetName = "=" + str.split("!")[0];
                    SortedCellBlockArray sa = SheetBaseMath.getSortedBlocks(dataCache.getCurSheet(), str, false);
                    str = SheetBaseMath.getBlocksName(sa, true, false);
                    str = sheetName + "!" + str;
                } else if (Validate.Type_List.equals(mv.getType()) && str.indexOf("\"") >= 0) {
                    str = str.replaceAll("\"", "");
                } else if (Validate.Type_List.equals(mv.getType())) {
                    SortedCellBlockArray sa = SheetBaseMath.getSortedBlocks(dataCache.getCurSheet(), str, false);
                    str = SheetBaseMath.getBlocksName(sa, true, false);
                    str = "=" + dataCache.getCurSheet().getSheetName() + "!" + str;
                } else if (Validate.Type_Date.equals(mv.getType()) || Validate.Type_Time.equals(mv.getType())) {
                    try {
                        str = DataValidationElement.this.double2DateTime(Double.valueOf(str), mv.getType());
                    }
                    catch (NumberFormatException nfe) {
                        SortedCellBlockArray sa = SheetBaseMath.getSortedBlocks(dataCache.getCurSheet(), str, false);
                        str = SheetBaseMath.getBlocksName(sa, true, false);
                        str = "=" + str;
                    }
                }
                mv.setMin(str);
                dataCache.put("ValidateMin", null);
                val.setMessagedValidate(mv);
            }
        }
    }

    class IMEModeElement
    extends DefaultElement {
        IMEModeElement() {
        }

        @Override
        boolean isCurrentElement(String uri, String localName, String qName) {
            return "IMEMode".equals(KmlUtil.getLocalName(qName));
        }

        @Override
        void startElement(String uri, String localName, String qName, Attributes attributes, KmlToBook.ElementStack parserCache, KmlToBook.DataCache dataCache, KmlToBook ktb) throws SAXException {
            if (this.isCurrentElement(uri, localName, qName)) {
                this.bufString.delete(0, this.bufString.length());
            }
        }

        @Override
        void characters(char[] ch, int start, int length, KmlToBook.ElementStack parserCache, KmlToBook.DataCache dataCache, KmlToBook ktb) throws SAXException {
            this.bufString.append(ch, start, length);
        }

        @Override
        void endElement(String uri, String localName, String qName, KmlToBook.ElementStack parserCache, KmlToBook.DataCache dataCache, KmlToBook ktb) throws SAXException {
            super.endElement(uri, localName, qName, parserCache, dataCache, ktb);
            if (this.isCurrentElement(uri, localName, qName)) {
                Validation val = dataCache.getCurValidation();
                MessagedValidate mv = val.getMessagedValidate();
                if (mv == null) {
                    mv = new MessagedValidate();
                }
                mv.setImeMode(Integer.parseInt(this.bufString.toString()));
                val.setMessagedValidate(mv);
            }
        }
    }

    class QualifierElement
    extends DefaultElement {
        QualifierElement() {
        }

        @Override
        boolean isCurrentElement(String uri, String localName, String qName) {
            return "Qualifier".equals(KmlUtil.getLocalName(qName));
        }

        @Override
        void startElement(String uri, String localName, String qName, Attributes attributes, KmlToBook.ElementStack parserCache, KmlToBook.DataCache dataCache, KmlToBook ktb) throws SAXException {
            if (this.isCurrentElement(uri, localName, qName)) {
                this.bufString.delete(0, this.bufString.length());
            }
        }

        @Override
        void characters(char[] ch, int start, int length, KmlToBook.ElementStack parserCache, KmlToBook.DataCache dataCache, KmlToBook ktb) throws SAXException {
            this.bufString.append(ch, start, length);
        }

        @Override
        void endElement(String uri, String localName, String qName, KmlToBook.ElementStack parserCache, KmlToBook.DataCache dataCache, KmlToBook ktb) throws SAXException {
            super.endElement(uri, localName, qName, parserCache, dataCache, ktb);
            if (this.isCurrentElement(uri, localName, qName)) {
                Validation val = dataCache.getCurValidation();
                MessagedValidate mv = val.getMessagedValidate();
                if (mv == null) {
                    mv = new MessagedValidate();
                }
                mv.setQualifier(this.bufString.toString());
                val.setMessagedValidate(mv);
            }
        }
    }

    class TypeElement
    extends DefaultElement {
        TypeElement() {
        }

        @Override
        boolean isCurrentElement(String uri, String localName, String qName) {
            return "Type".equals(KmlUtil.getLocalName(qName));
        }

        @Override
        void startElement(String uri, String localName, String qName, Attributes attributes, KmlToBook.ElementStack parserCache, KmlToBook.DataCache dataCache, KmlToBook ktb) throws SAXException {
            if (this.isCurrentElement(uri, localName, qName)) {
                this.bufString.delete(0, this.bufString.length());
            }
        }

        @Override
        void characters(char[] ch, int start, int length, KmlToBook.ElementStack parserCache, KmlToBook.DataCache dataCache, KmlToBook ktb) throws SAXException {
            this.bufString.append(ch, start, length);
        }

        @Override
        void endElement(String uri, String localName, String qName, KmlToBook.ElementStack parserCache, KmlToBook.DataCache dataCache, KmlToBook ktb) throws SAXException {
            super.endElement(uri, localName, qName, parserCache, dataCache, ktb);
            if (this.isCurrentElement(uri, localName, qName)) {
                Validation val = dataCache.getCurValidation();
                MessagedValidate mv = val.getMessagedValidate();
                if (mv == null) {
                    mv = new MessagedValidate();
                }
                mv.setType(this.bufString.toString());
                val.setMessagedValidate(mv);
            }
        }
    }

    class RangeElement
    extends DefaultElement {
        RangeElement() {
        }

        @Override
        boolean isCurrentElement(String uri, String localName, String qName) {
            return "Range".equals(KmlUtil.getLocalName(qName));
        }

        @Override
        void startElement(String uri, String localName, String qName, Attributes attributes, KmlToBook.ElementStack parserCache, KmlToBook.DataCache dataCache, KmlToBook ktb) throws SAXException {
            if (this.isCurrentElement(uri, localName, qName)) {
                this.bufString.delete(0, this.bufString.length());
            }
        }

        @Override
        void characters(char[] ch, int start, int length, KmlToBook.ElementStack parserCache, KmlToBook.DataCache dataCache, KmlToBook ktb) throws SAXException {
            this.bufString.append(ch, start, length);
        }

        @Override
        void endElement(String uri, String localName, String qName, KmlToBook.ElementStack parserCache, KmlToBook.DataCache dataCache, KmlToBook ktb) throws SAXException {
            super.endElement(uri, localName, qName, parserCache, dataCache, ktb);
            if (this.isCurrentElement(uri, localName, qName)) {
                SortedCellBlockArray sa;
                Sheet sheet = dataCache.getCurSheet();
                String str = this.bufString.toString();
                try {
                    sa = SheetBaseMath.getSortedBlocks(sheet, str, false);
                }
                catch (Exception e) {
                    sa = SheetBaseMath.getSortedBlocks(sheet, str, true);
                }
                if (sa != null) {
                    dataCache.getCurValidation().setBlocks(sa);
                }
            }
        }
    }
}

