/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.model.expr;

import com.kingdee.bos.ctrl.common.KDToolkit;
import com.kingdee.bos.ctrl.common.digitalstyle.Formats;
import com.kingdee.bos.ctrl.common.util.DateUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.common.variant.ExprErr;
import com.kingdee.bos.ctrl.common.variant.IVarReferences;
import com.kingdee.bos.ctrl.common.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.common.variant.Util;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.expans.model.data.ExtGroup;
import com.kingdee.bos.ctrl.excel.impl.facade.MultiLanguageKeys;
import com.kingdee.bos.ctrl.excel.model.expr.CellIteratorWrap;
import com.kingdee.bos.ctrl.excel.model.expr.Expr;
import com.kingdee.bos.ctrl.excel.model.expr.ExprConst;
import com.kingdee.bos.ctrl.excel.model.expr.ExprContext;
import com.kingdee.bos.ctrl.excel.model.expr.IExprNode;
import com.kingdee.bos.ctrl.excel.model.expr.IInnerFuncProvider;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.ICalculable;
import com.kingdee.bos.ctrl.excel.model.struct.Row;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.SheetBaseMath;
import com.kingdee.bos.ctrl.excel.model.struct.node.CellBlock3DNode;
import com.kingdee.bos.ctrl.excel.model.struct.node.CellBlockNode;
import com.kingdee.bos.ctrl.excel.model.struct.node.NamedObjectNode;
import com.kingdee.bos.ctrl.excel.model.util.LinkedTreeMap;
import com.kingdee.bos.ctrl.excel.model.util.ObjectArray;
import com.kingdee.bos.ctrl.excel.model.util.ObjectCache;
import com.kingdee.bos.ctrl.excel.model.util.SortedIntArray;
import com.kingdee.bos.ctrl.excel.model.util.SortedObjectArray;
import com.kingdee.bos.ctrl.excel.model.util.TimeSpan;
import java.math.BigDecimal;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;

public class ExcelFuncProvider
implements IInnerFuncProvider {
    private static final SecureRandom _rand = new SecureRandom();
    private static final long _oneHour = 3600000L;
    private static final long _oneDay = 86400000L;
    private static final int Sum = 0;
    private static final int Count = 1;
    private static final int Max = 2;
    private static final int Min = 3;
    private static final int Product = 4;
    private static final int Stdev = 5;
    private static final int Stats = 6;
    private static final int LOOPNUM = 20;
    private static final double ABSOLUTEACCURACY = 1.0E-7;

    public Variant EDATE(Object[] args) throws SyntaxErrorException {
        ExcelFuncProvider.validParamCount(args, 2, 2);
        Variant date = (Variant)args[0];
        Variant months = (Variant)args[1];
        if (date == null || date.isEmpty()) {
            return Variant.getNewEmptyVariant();
        }
        if (date.isReferences() && StringUtil.isEmptyString((String)date.toString())) {
            return Variant.getNewEmptyVariant();
        }
        if (months == null) {
            return date;
        }
        if (months.isNumeric()) {
            Variant temp = Variant.getNewEmptyVariant();
            months.isNumeric(temp);
            int month = temp.intValue();
            Calendar cal = (Calendar)date.toCalendar().clone();
            cal.add(2, month);
            return new Variant((Object)cal);
        }
        ExprErr.goError((long)16L, (Object)"\u53c2\u6570\u7c7b\u578b\u9519\u8bef\uff01");
        return null;
    }

    public Variant QUARTER(Object[] args) throws SyntaxErrorException {
        ExcelFuncProvider.validParamCount(args, 1, 1);
        Variant date = (Variant)args[0];
        Calendar cal = (Calendar)date.toCalendar().clone();
        int month = cal.get(2);
        int quarter = 0;
        switch (month) {
            case 0: 
            case 1: 
            case 2: {
                quarter = 1;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                quarter = 2;
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                quarter = 3;
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                quarter = 4;
                break;
            }
        }
        return new Variant(quarter);
    }

    public Variant ISBLANK(Variant arg) {
        return new Variant(arg.isNull() || arg.isEmpty());
    }

    public Variant ISEMPTY(Variant arg) {
        if (arg.isNull() || arg.isEmpty()) {
            return new Variant(true);
        }
        Object value = arg.getValue();
        if (value == null) {
            return new Variant(true);
        }
        if (value instanceof String) {
            return new Variant(StringUtil.isEmptyString((String)value.toString()));
        }
        return new Variant(false);
    }

    public Variant ISERROR(Variant arg) {
        return new Variant(arg.isError());
    }

    public Variant ISERR(Variant arg) {
        if (arg.isError()) {
            return new Variant(((SyntaxErrorException)((Object)arg.getValue())).getErrorCode() != 524288L);
        }
        return new Variant(false);
    }

    public Variant ISNA(Variant arg) {
        if (arg.isError()) {
            return new Variant(((SyntaxErrorException)((Object)arg.getValue())).getErrorCode() == 524288L);
        }
        return new Variant(false);
    }

    public Variant ISLOGICAL(Variant arg) {
        return new Variant(arg.getVt() == 8);
    }

    public Variant ISNUMBER(Variant arg) {
        return new Variant(arg.isNumber());
    }

    public Variant ISNONTEXT(Variant arg) {
        return new Variant(arg.getVt() != 11);
    }

    public Variant ISTEXT(Variant arg) {
        return new Variant(arg.getVt() == 11);
    }

    public Variant ISREF(Object[] args) throws SyntaxErrorException {
        ExcelFuncProvider.validParamCount(args, 1, 1);
        return new Variant(((Variant)args[0]).isReferences());
    }

    public Variant OR(Object[] args) throws SyntaxErrorException {
        Variant varResult = new Variant(false);
        for (int i = 0; i < args.length; ++i) {
            if (!((Variant)args[i]).booleanValue()) continue;
            varResult.setBoolean(true);
            return varResult;
        }
        return varResult;
    }

    public Variant AND(Object[] args) throws SyntaxErrorException {
        Variant varResult = new Variant(true);
        for (int i = 0; i < args.length; ++i) {
            if (((Variant)args[i]).booleanValue()) continue;
            varResult.setBoolean(false);
            break;
        }
        return varResult;
    }

    public Variant NOT(Variant arg) throws SyntaxErrorException {
        return new Variant(!arg.booleanValue());
    }

    public Variant TRUE() throws SyntaxErrorException {
        return new Variant(true);
    }

    public Variant FALSE() throws SyntaxErrorException {
        return new Variant(false);
    }

    public Variant IF(Object[] args) throws SyntaxErrorException {
        ExcelFuncProvider.validParamCount(args, 2, 3);
        Variant varResult = null;
        try {
            int argCount = args.length;
            Variant isTrue = (Variant)args[0];
            Variant variant = isTrue.booleanValue() ? (Variant)args[1] : (varResult = argCount == 3 ? (Variant)args[2] : Variant.nullVariant);
            if (varResult.isNull()) {
                varResult = new Variant(0);
            }
        }
        catch (Exception e) {
            ExprErr.goError((long)64L, (Object)MultiLanguageKeys.getLocalText("notSupportCalculationWithUnknownDataType", "\u4e0d\u652f\u6301\u672a\u77e5\u6570\u636e\u7c7b\u578b\u7684\u8fd0\u7b97"));
        }
        return varResult;
    }

    public Variant NOW() throws SyntaxErrorException {
        return new Variant((Object)new Date(), 12);
    }

    static Variant timeGet(Variant time, int index) throws SyntaxErrorException {
        if (time.isString()) {
            time = ExcelFuncProvider.DATEVALUE(time);
        }
        Calendar cal = time.toCalendar();
        return new Variant(cal.get(index));
    }

    public Variant YEAR(Variant time) throws SyntaxErrorException {
        return ExcelFuncProvider.timeGet(time, 1);
    }

    public Variant MONTH(Variant time) throws SyntaxErrorException {
        Variant varResult = ExcelFuncProvider.timeGet(time, 2);
        if (varResult.isNumber()) {
            varResult.add(new Variant(1));
        }
        return varResult;
    }

    public Variant DAY(Object[] args) throws SyntaxErrorException {
        ExcelFuncProvider.validParamCount(args, 1, 1);
        Variant time = (Variant)args[0];
        return ExcelFuncProvider.timeGet(time, 5);
    }

    public Variant HOUR(Variant time) throws SyntaxErrorException {
        Calendar cal = time.toCalendar();
        int hour = cal.get(11);
        return new Variant(hour);
    }

    public Variant MINUTE(Variant time) throws SyntaxErrorException {
        Calendar cal = time.toCalendar();
        int minute = cal.get(12);
        return new Variant(minute);
    }

    public Variant SECOND(Variant time) throws SyntaxErrorException {
        Calendar cal = time.toCalendar();
        int second = cal.get(13);
        return new Variant(second);
    }

    public Variant YEARDAY(Variant time) throws SyntaxErrorException {
        return ExcelFuncProvider.timeGet(time, 6);
    }

    public Variant WEEKDAY(Object[] args) throws SyntaxErrorException {
        ExcelFuncProvider.validParamCount(args, 1, 2);
        Variant ret = ExcelFuncProvider.timeGet((Variant)args[0], 7);
        if (args.length == 2) {
            int day = ret.intValue();
            Variant var = (Variant)args[1];
            ExcelFuncProvider.validNumericParam("returnType", var);
            int returnType = var.intValue();
            switch (returnType) {
                case 1: {
                    break;
                }
                case 2: {
                    if (--day == 0) {
                        day = 7;
                    }
                    ret = new Variant(day);
                    break;
                }
                case 3: {
                    if ((day -= 2) < 0) {
                        day = 6;
                    }
                    ret = new Variant(day);
                    break;
                }
                default: {
                    ExprErr.goError((long)16L, (Object)"returnType");
                }
            }
        }
        return ret;
    }

    public static Variant DATEVALUE(Variant time) throws SyntaxErrorException {
        if (!time.isString()) {
            ExprErr.goError((long)16L, (Object)"NOT STRING");
        }
        Variant days = ExcelFuncProvider.timeSpan(time, "DAYS");
        days.add(new Variant(25568L));
        return days;
    }

    public Variant DATE(Object[] args) throws SyntaxErrorException {
        ExcelFuncProvider.validParamCount(args, 3, 3);
        Variant varYear = (Variant)args[0];
        Variant varMonth = (Variant)args[1];
        Variant varDay = (Variant)args[2];
        ExcelFuncProvider.validNumericParam("year", varYear);
        ExcelFuncProvider.validNumericParam("month", varMonth);
        ExcelFuncProvider.validNumericParam("day", varDay);
        Calendar cal = (Calendar)Util.BASE_DATE.clone();
        int year = varYear.intValue();
        if (year < 1900) {
            cal.add(1, year);
        } else {
            cal.set(1, year - 1);
        }
        cal.add(2, varMonth.intValue() - 1);
        cal.add(6, varDay.intValue());
        if (cal.before(Util.BASE_DATE)) {
            ExprErr.goError((long)4L, null);
        }
        return new Variant((Object)cal.getTime(), 12);
    }

    public Variant YEARFRAC(Object[] args) throws SyntaxErrorException {
        ExcelFuncProvider.validParamCount(args, 2, 3);
        Variant start = (Variant)args[0];
        Variant end = (Variant)args[1];
        double basis = 360.0;
        boolean isDay360 = false;
        boolean isNASD = false;
        if (args.length == 3) {
            Variant varBasis = Variant.getNewEmptyVariant();
            ((Variant)args[2]).isNumeric(varBasis);
            switch (varBasis.intValue()) {
                case 0: {
                    isNASD = true;
                    isDay360 = true;
                    break;
                }
                case 2: {
                    break;
                }
                case 4: {
                    isDay360 = true;
                    break;
                }
                case 3: {
                    basis = 365.0;
                    break;
                }
                case 1: {
                    basis = 1.0;
                    break;
                }
                default: {
                    ExprErr.goError((long)16L, (Object)"Basis");
                    break;
                }
            }
        } else {
            isNASD = true;
            isDay360 = true;
        }
        BigDecimal days = null;
        if (isDay360) {
            days = DateUtil.days360((Variant)start, (Variant)end, (!isNASD ? 1 : 0) != 0).toBigDecimal();
        } else {
            BigDecimal bdStart = this.getDateDecimalValue(start);
            BigDecimal bdEnd = this.getDateDecimalValue(end);
            days = bdEnd.subtract(bdStart);
        }
        days = days.divide(BigDecimal.valueOf(basis), 15, 4);
        return new Variant((Object)days, 10);
    }

    public Variant DATEDIF(Object[] args) throws SyntaxErrorException {
        ExcelFuncProvider.validParamCount(args, 3, 3);
        Calendar c = ((Variant)args[0]).toCalendar();
        Calendar c2 = ((Variant)args[1]).toCalendar();
        boolean neg = false;
        if (c2.before(c)) {
            neg = true;
            Calendar cTmp = c;
            c = c2;
            c2 = cTmp;
        }
        int value = 0;
        String unit = args[2].toString().toUpperCase(Locale.ENGLISH);
        if (unit.equals("Y")) {
            int year2 = c2.get(1);
            int year = c.get(1);
            value = year2 - year;
            int month2 = c2.get(2);
            int month = c.get(2);
            int day2 = c2.get(5);
            int day = c.get(5);
            if (value > 0 && (month2 < month || month2 == month && day2 < day)) {
                --value;
            }
        } else if (unit.equals("M")) {
            value = c2.get(1) * 12 + c2.get(2) - (c.get(1) * 12 + c.get(2));
            if (c2.get(5) < c.get(5)) {
                --value;
            }
        } else if (unit.equals("D")) {
            value = (int)(c2.getTimeInMillis() / 86400000L - c.getTimeInMillis() / 86400000L);
        } else if (unit.equals("MD")) {
            int d = c.get(5);
            int d2 = c2.get(5);
            if (d2 >= d) {
                value = d2 - d;
            } else {
                Calendar c3 = (Calendar)c2.clone();
                c3.set(2, c2.get(2) - 1);
                value = d2 + c3.getActualMaximum(5) - d;
            }
        } else if (unit.equals("YM")) {
            int m = c.get(2);
            int m2 = c2.get(2);
            if (m2 >= m) {
                m2 -= m;
                if (c.get(5) > c2.get(5) && --m2 < 0) {
                    m2 += 12;
                }
            } else {
                m2 += 12 - m;
                if (c.get(5) > c2.get(5)) {
                    --m2;
                }
            }
            value = m2;
        } else if (unit.equals("YD")) {
            int d = c.get(6);
            int d2 = c2.get(6);
            if (c2.get(2) + 1 == 3 && c2.get(5) >= c.get(5) || c2.get(2) + 1 != 3) {
                Calendar c3 = (Calendar)c2.clone();
                c3.set(1, c.get(1));
                d2 = c3.get(6);
                value = d2 - d;
                if (value < 0) {
                    c3.set(1, c.get(1) + 1);
                    d2 = c3.get(6);
                    value = d2 + c3.getActualMaximum(6) - d;
                }
            } else if (c2.get(2) + 1 == 3 && c2.get(5) < c.get(5)) {
                Calendar c3 = (Calendar)c.clone();
                c3.set(1, c2.get(1));
                d = c3.get(6);
                value = d2 - d;
                if (value < 0) {
                    c3.set(1, c2.get(1) - 1);
                    d = c3.get(6);
                    value = d2 + c3.getActualMaximum(6) - d;
                }
            }
        } else {
            ExprErr.goError((long)16L, (Object)unit);
        }
        return new Variant((Object)new BigDecimal(neg ? -value : value), 10);
    }

    private BigDecimal getDateDecimalValue(Variant var) throws SyntaxErrorException {
        int vt = var.getVt();
        BigDecimal bd = vt == 13 ? Util.calendarToBigDecimal((Calendar)((Calendar)var.getValue())) : (vt == 12 ? Util.dateToBigDecimal((Date)((Date)var.getValue())) : var.toBigDecimal());
        return bd;
    }

    static Variant timeSpan(Variant time, String strIndex) throws SyntaxErrorException {
        Calendar cal = time.toCalendar();
        TimeSpan ts = new TimeSpan(cal.getTimeInMillis() * 10000L);
        Variant rvarResult = Variant.getNewEmptyVariant();
        if (StringUtil.equals((String)strIndex, (String)"DAYS")) {
            rvarResult.setLong((long)ts.getDays());
        } else if (StringUtil.equals((String)strIndex, (String)"HOURS")) {
            rvarResult.setLong((long)ts.getHours());
        } else if (StringUtil.equals((String)strIndex, (String)"MILLISECONDS")) {
            rvarResult.setLong((long)ts.getMilliseconds());
        } else if (StringUtil.equals((String)strIndex, (String)"MINUTES")) {
            rvarResult.setLong((long)ts.getMinutes());
        } else if (StringUtil.equals((String)strIndex, (String)"SECONDS")) {
            rvarResult.setLong((long)ts.getSeconds());
        } else if (StringUtil.equals((String)strIndex, (String)"TICKS")) {
            rvarResult.setLong(ts.getTicks());
        } else if (StringUtil.equals((String)strIndex, (String)"TOTALDAYS")) {
            rvarResult.setDouble(ts.getTotalDays());
        } else if (StringUtil.equals((String)strIndex, (String)"TOTALHOURS")) {
            rvarResult.setDouble(ts.getTotalHours());
        } else if (StringUtil.equals((String)strIndex, (String)"TOTALMILLISECONDS")) {
            rvarResult.setDouble(ts.getTotalMilliseconds());
        } else if (StringUtil.equals((String)strIndex, (String)"TOTALMINUTES")) {
            rvarResult.setDouble(ts.getTotalMinutes());
        } else if (StringUtil.equals((String)strIndex, (String)"TOTALSECONDS")) {
            rvarResult.setDouble(ts.getTotalSeconds());
        } else {
            ExprErr.goError((long)16L, (Object)"ERROR TIMESPAN FUNC");
        }
        return rvarResult;
    }

    public Variant DAYS(Variant time) throws SyntaxErrorException {
        return ExcelFuncProvider.timeSpan(time, "DAYS");
    }

    public Variant DAYS360(Variant start_date, Variant end_date) throws SyntaxErrorException {
        return this.DAYS360(start_date, end_date, false);
    }

    public Variant DAYS360(Variant start_date, Variant end_date, boolean method) throws SyntaxErrorException {
        return DateUtil.days360((Variant)start_date, (Variant)end_date, (boolean)method);
    }

    public Variant HOURS(Variant time) throws SyntaxErrorException {
        return ExcelFuncProvider.timeSpan(time, "HOURS");
    }

    public Variant MILLISECONDS(Variant time) throws SyntaxErrorException {
        return ExcelFuncProvider.timeSpan(time, "MILLISECONDS");
    }

    public Variant MINUTES(Variant time) throws SyntaxErrorException {
        return ExcelFuncProvider.timeSpan(time, "MINUTES");
    }

    public Variant SECONDS(Variant time) throws SyntaxErrorException {
        return ExcelFuncProvider.timeSpan(time, "SECONDS");
    }

    public Variant TICKS(Variant time) throws SyntaxErrorException {
        return ExcelFuncProvider.timeSpan(time, "TICKS");
    }

    public Variant TOTALDAYS(Variant time) throws SyntaxErrorException {
        return ExcelFuncProvider.timeSpan(time, "TOTALDAYS");
    }

    public Variant TOTALHOURS(Variant time) throws SyntaxErrorException {
        return ExcelFuncProvider.timeSpan(time, "TOTALHOURS");
    }

    public Variant TOTALMILLISECONDS(Variant time) throws SyntaxErrorException {
        return ExcelFuncProvider.timeSpan(time, "TOTALMILLISECONDS");
    }

    public Variant TOTALMINUTES(Variant time) throws SyntaxErrorException {
        return ExcelFuncProvider.timeSpan(time, "TOTALMINUTES");
    }

    public Variant TOTALSECONDS(Variant time) throws SyntaxErrorException {
        return ExcelFuncProvider.timeSpan(time, "TOTALSECONDS");
    }

    public static void validNumericParam(String varName, Variant value) throws SyntaxErrorException {
        if (!value.isNumeric()) {
            if (value.isError()) {
                throw (SyntaxErrorException)((Object)value.getValue());
            }
            String errMsg = "Parameter [" + varName + "] = " + value.toString() + " NOT NUMBER";
            ExprErr.goError((long)16L, (Object)errMsg);
        }
    }

    public static BigDecimal getNumericParam(String varName, Variant value) throws SyntaxErrorException {
        ExcelFuncProvider.validNumericParam(varName, value);
        return value.toBigDecimal();
    }

    public static void validParamCount(Object[] args, int min, int max) throws SyntaxErrorException {
        if (args.length < min || args.length > max) {
            ExprErr.goError((long)8L, (Object)(args.length + ":[" + min + "," + max + "]"));
        }
    }

    public Variant SIGN(Variant value) throws SyntaxErrorException {
        ExcelFuncProvider.validNumericParam("value", value);
        return new Variant(value.compareTo(new Variant(0)));
    }

    public Variant ABS(Variant value) throws SyntaxErrorException {
        ExcelFuncProvider.validNumericParam("value", value);
        return new Variant((Object)value.toBigDecimal().abs(), 10);
    }

    private Variant decimalValue(double value) {
        return new Variant((Object)BigDecimal.valueOf(value), 10);
    }

    private Variant decimalValue(Variant value) {
        Variant ret;
        try {
            ret = new Variant((Object)value.toBigDecimal(), 10);
        }
        catch (SyntaxErrorException e) {
            ret = this.decimalValue(0.0);
        }
        return ret;
    }

    private static CellBlockNode cellblockValue(Variant var, String errMsg) throws SyntaxErrorException {
        Object value = null;
        if (!var.isReferences() || !((value = var.getValue()) instanceof CellBlockNode)) {
            ExprErr.goError((long)16L, (Object)errMsg);
        }
        return (CellBlockNode)value;
    }

    public Variant ROUND(Variant value, Variant digit) throws SyntaxErrorException {
        ExcelFuncProvider.validNumericParam("value", value);
        ExcelFuncProvider.validNumericParam("digit", digit);
        BigDecimal bd = value.toBigDecimal();
        int iDigit = (int)digit.doubleValue();
        if (iDigit >= 0) {
            if (bd.scale() > 15) {
                Variant varTmp = new Variant((Object)bd.setScale(15, 4), 10);
                bd = (BigDecimal)varTmp.getValue();
            }
            return new Variant((Object)bd.setScale(digit.intValue(), 4), 10);
        }
        BigDecimal pow = BigDecimal.valueOf(StrictMath.pow(10.0, -iDigit));
        bd = bd.divide(pow, 0, 4);
        bd = bd.multiply(pow);
        return new Variant((Object)bd, 10);
    }

    public Variant FIX(Object[] args) throws SyntaxErrorException {
        BigDecimal bdValue;
        ExcelFuncProvider.validParamCount(args, 1, 2);
        Variant value = (Variant)args[0];
        ExcelFuncProvider.validNumericParam("value", value);
        if (args.length == 1) {
            return this.decimalValue(value.toBigDecimal().longValue());
        }
        Variant digit = (Variant)args[1];
        ExcelFuncProvider.validNumericParam("digit", digit);
        Util.reduceScale((Variant)value);
        int dfDecimalNum = digit.intValue();
        if (dfDecimalNum < -15) {
            dfDecimalNum = -15;
        } else if (dfDecimalNum > 15) {
            dfDecimalNum = 15;
        }
        if (dfDecimalNum > 0) {
            bdValue = value.toBigDecimal();
            bdValue = bdValue.setScale(dfDecimalNum, 4);
        } else {
            double dfValue = value.doubleValue();
            String str = String.valueOf(dfValue *= StrictMath.pow(10.0, dfDecimalNum));
            dfValue = Math.floor(Double.parseDouble(str));
            bdValue = new BigDecimal(dfValue *= StrictMath.pow(10.0, -dfDecimalNum));
        }
        return new Variant((Object)bdValue, 10);
    }

    public Variant SQRT(Variant value) throws SyntaxErrorException {
        ExcelFuncProvider.validNumericParam("value", value);
        double dfValue = value.doubleValue();
        if (dfValue < 0.0) {
            ExprErr.goError((long)32L, (Object)"value");
        }
        return this.decimalValue(StrictMath.sqrt(dfValue));
    }

    public Variant INT(Variant value) throws SyntaxErrorException {
        ExcelFuncProvider.validNumericParam("value", value);
        Variant varResult = new Variant(value.doubleValue());
        varResult.intpart();
        return this.decimalValue(varResult);
    }

    public Variant LN(Variant value) throws SyntaxErrorException {
        ExcelFuncProvider.validNumericParam("value", value);
        return this.decimalValue(StrictMath.log(value.doubleValue()));
    }

    public static double log(double value, double base) {
        return StrictMath.log(value) / StrictMath.log(base);
    }

    public Variant LOG(Variant base, Variant value) throws SyntaxErrorException {
        ExcelFuncProvider.validNumericParam("base", base);
        ExcelFuncProvider.validNumericParam("value", value);
        return this.decimalValue(ExcelFuncProvider.log(value.doubleValue(), base.doubleValue()));
    }

    public Variant LOG10(Variant value) throws SyntaxErrorException {
        ExcelFuncProvider.validNumericParam("value", value);
        return this.decimalValue(ExcelFuncProvider.log(value.doubleValue(), 10.0));
    }

    public Variant EXP(Variant value) throws SyntaxErrorException {
        ExcelFuncProvider.validNumericParam("value", value);
        return this.decimalValue(StrictMath.exp(value.doubleValue()));
    }

    public Variant POWER(Variant x, Variant y) throws SyntaxErrorException {
        ExcelFuncProvider.validNumericParam("value", x);
        ExcelFuncProvider.validNumericParam("value", y);
        return this.decimalValue(StrictMath.pow(x.doubleValue(), y.doubleValue()));
    }

    public Variant MOD(Variant n, Variant d) throws SyntaxErrorException {
        ExcelFuncProvider.validNumericParam("value", n);
        ExcelFuncProvider.validNumericParam("value", d);
        Variant varResult = new Variant(n.doubleValue());
        Variant newN = new Variant(n);
        newN.divide(d);
        newN.intpart();
        newN.multiply(d);
        varResult.subtract(newN);
        return this.decimalValue(varResult);
    }

    public Variant PI() throws SyntaxErrorException {
        return this.decimalValue(Math.PI);
    }

    public Variant RAND() throws SyntaxErrorException {
        return this.decimalValue(_rand.nextDouble());
    }

    public Variant DEGREES(Variant value) throws SyntaxErrorException {
        ExcelFuncProvider.validNumericParam("value", value);
        return this.decimalValue(value.doubleValue() * 180.0 / Math.PI);
    }

    public Variant RADIANS(Variant value) throws SyntaxErrorException {
        ExcelFuncProvider.validNumericParam("value", value);
        return this.decimalValue(value.doubleValue() * Math.PI / 180.0);
    }

    public Variant SIN(Variant value) throws SyntaxErrorException {
        ExcelFuncProvider.validNumericParam("value", value);
        return this.decimalValue(StrictMath.sin(value.doubleValue()));
    }

    public Variant ASIN(Variant value) throws SyntaxErrorException {
        ExcelFuncProvider.validNumericParam("value", value);
        return this.decimalValue(StrictMath.asin(value.doubleValue()));
    }

    public Variant COS(Variant value) throws SyntaxErrorException {
        ExcelFuncProvider.validNumericParam("value", value);
        return this.decimalValue(StrictMath.cos(value.doubleValue()));
    }

    public Variant ACOS(Variant value) throws SyntaxErrorException {
        ExcelFuncProvider.validNumericParam("value", value);
        return this.decimalValue(StrictMath.acos(value.doubleValue()));
    }

    public Variant TAN(Variant value) throws SyntaxErrorException {
        ExcelFuncProvider.validNumericParam("value", value);
        return this.decimalValue(StrictMath.tan(value.doubleValue()));
    }

    public Variant ATAN(Variant value) throws SyntaxErrorException {
        ExcelFuncProvider.validNumericParam("value", value);
        return this.decimalValue(StrictMath.atan(value.doubleValue()));
    }

    public Variant LEN(Variant value) throws SyntaxErrorException {
        return this.decimalValue(value.toString().length());
    }

    public Variant LOWER(Variant value) throws SyntaxErrorException {
        return new Variant((Object)value.toString().toLowerCase(), 11);
    }

    public Variant UPPER(Variant value) throws SyntaxErrorException {
        return new Variant((Object)value.toString().toUpperCase(), 11);
    }

    public Variant TRIM(Variant value) throws SyntaxErrorException {
        return new Variant((Object)value.toString().trim(), 11);
    }

    static Variant stringOP(Variant varStr, Variant varCount, String strOP) throws SyntaxErrorException {
        String str = varStr.toString();
        Variant rvarResult = Variant.getNewEmptyVariant();
        ExcelFuncProvider.validNumericParam("count", varCount);
        int iChars = (int)varCount.doubleValue();
        if (iChars < 0) {
            ExprErr.goError((long)32L, (Object)"count");
        }
        if (StringUtil.equals((String)strOP, (String)"left")) {
            iChars = StrictMath.min(iChars, str.length());
            rvarResult.setObject((Object)str.substring(0, iChars), 11);
        } else if (StringUtil.equals((String)strOP, (String)"right")) {
            iChars = StrictMath.min(iChars, str.length());
            int start = 0;
            if (str.length() > iChars) {
                start = str.length() - iChars;
            } else {
                iChars = str.length();
            }
            rvarResult.setObject((Object)str.substring(start, start + iChars), 11);
        } else {
            long count = str.length() * iChars;
            if (count > 32767L) {
                ExprErr.goError((long)2048L, (Object)("String Length: " + String.valueOf(count)));
            }
            StringBuffer sb = new StringBuffer((int)count);
            for (int i = 0; i < iChars; ++i) {
                sb.append(str);
            }
            rvarResult.setObject((Object)sb.toString(), 11);
        }
        return rvarResult;
    }

    public Variant LEFT(Variant value, Variant count) throws SyntaxErrorException {
        return ExcelFuncProvider.stringOP(value, count, "left");
    }

    public Variant RIGHT(Variant value, Variant count) throws SyntaxErrorException {
        return ExcelFuncProvider.stringOP(value, count, "right");
    }

    public Variant REPT(Variant value, Variant count) throws SyntaxErrorException {
        return ExcelFuncProvider.stringOP(value, count, "repeat");
    }

    public Variant REPLACE(Variant old, Variant start, Variant num, Variant newStr) throws SyntaxErrorException {
        int startPos = start.intValue();
        int numChars = num.intValue();
        if (startPos < 1 || numChars < 0) {
            ExprErr.goError((long)64L, null);
        }
        String newText = newStr.toString();
        StringBuffer sb = new StringBuffer(old.toString());
        int len = sb.length();
        if (startPos >= len) {
            sb.append(newText);
        } else if (numChars == 0) {
            sb.insert(startPos - 1, newText);
        } else {
            sb.replace(startPos - 1, startPos + numChars - 1, newText);
        }
        return new Variant((Object)sb.toString(), 11);
    }

    public Variant MID(Variant value, Variant start, Variant num) throws SyntaxErrorException {
        String str;
        ExcelFuncProvider.validNumericParam("start", start);
        ExcelFuncProvider.validNumericParam("num", num);
        int from = (int)start.doubleValue();
        int end = (int)num.doubleValue();
        if (from < 1 || end < 0) {
            ExprErr.goError((long)64L, null);
        }
        if (StringUtil.isEmptyString((String)(str = value.toString())) || str.length() < from - 1) {
            return Variant.getNewEmptyVariant();
        }
        end = Math.min(str.length(), from - 1 + end);
        return new Variant((Object)str.substring(from - 1, end), 11);
    }

    public Variant SEARCH(Object[] args) throws SyntaxErrorException {
        ExcelFuncProvider.validParamCount(args, 2, 3);
        int start = 1;
        if (args.length == 3) {
            Variant var = (Variant)args[2];
            ExcelFuncProvider.validNumericParam("start", var);
            start = (int)var.doubleValue();
            if (start <= 0) {
                ExprErr.goError((long)64L, null);
            }
        }
        String text = args[0].toString().toLowerCase();
        String within = args[1].toString().toLowerCase();
        int pos = within.indexOf(text, start - 1);
        if (pos < 0) {
            ExprErr.goError((long)64L, null);
        }
        return new Variant(pos + 1);
    }

    public Variant SUBSTITUTE(Object[] args) throws SyntaxErrorException {
        ExcelFuncProvider.validParamCount(args, 3, 4);
        String within = args[0].toString();
        String oldText = args[1].toString();
        String newText = args[2].toString();
        int iNum = Integer.MAX_VALUE;
        if (args.length == 4) {
            ExcelFuncProvider.validNumericParam("num", (Variant)args[3]);
            iNum = (int)((Variant)args[3]).doubleValue();
            if (iNum <= 0) {
                ExprErr.goError((long)64L, null);
            }
        }
        String ret = oldText;
        int fromIndex = 0;
        if (iNum == Integer.MAX_VALUE) {
            oldText = "\\Q" + oldText + "\\E";
            ret = within.replaceAll(oldText, newText);
        } else {
            int pos;
            while ((pos = within.indexOf(newText, fromIndex)) >= 0) {
                fromIndex = pos + newText.length();
                if (--iNum != 0) continue;
                ret = within.substring(0, pos) + newText + within.substring(pos + newText.length());
                break;
            }
        }
        return new Variant((Object)ret, 11);
    }

    public Variant CONCATENATE(Object[] args) throws SyntaxErrorException {
        ExcelFuncProvider.validParamCount(args, 1, Integer.MAX_VALUE);
        Variant result = null;
        StringBuffer sb = new StringBuffer(args.length * 10);
        for (int i = 0; i < args.length; ++i) {
            result = (Variant)args[i];
            Object obj = result.getValue();
            if (obj instanceof CellBlockNode) {
                Cell cll;
                CellBlockNode cb = (CellBlockNode)obj;
                if (!cb.isSingleCell()) {
                    ExprErr.goError((long)64L, null);
                }
                if ((cll = cb.getSheet().getFirstCell(cb, false)) == null) continue;
                result = cll.getValue2();
                if (result.isPending()) break;
                sb.append(cll.getText());
                continue;
            }
            if (result.isPending()) break;
            if (obj == null) continue;
            sb.append(obj.toString());
        }
        if (result != null && !result.isPending()) {
            result = new Variant((Object)sb.toString(), 11);
        }
        return result;
    }

    public Variant TEXT(Variant value, Variant format) {
        String formatString = format.toString();
        if (StringUtil.isEmptyString((String)formatString)) {
            return Variant.getNewEmptyVariant();
        }
        return new Variant((Object)Formats.getFormat((String)formatString).format(value).toString(), 11);
    }

    public Variant FIND(Object[] args) throws SyntaxErrorException {
        int pos;
        Variant varTrans;
        Variant var;
        ExcelFuncProvider.validParamCount(args, 2, 3);
        String find = args[0].toString();
        if (StringUtil.isEmptyString((String)find)) {
            return new Variant(1);
        }
        String in = args[1].toString();
        if (StringUtil.isEmptyString((String)in)) {
            ExprErr.goError((long)64L, null);
        }
        int offset = 0;
        if (!(args.length != 3 || (var = (Variant)args[2]).isNumeric(varTrans = Variant.getNewEmptyVariant()) && (offset = varTrans.intValue() - 1) >= 0)) {
            ExprErr.goError((long)64L, null);
        }
        if ((pos = in.indexOf(find, offset)) < 0) {
            ExprErr.goError((long)64L, null);
        }
        return this.decimalValue(pos + 1);
    }

    public Variant ROW(ExprContext ctx, Object[] args) throws SyntaxErrorException {
        CellBlock cb = this._getPosition(ctx, args);
        return new Variant((Object)(cb.getRow() + 1), 3);
    }

    public Variant RGB(int r, int g, int b) {
        int value = (r & 0xFF) << 16 | (g & 0xFF) << 8 | (b & 0xFF) << 0;
        return new Variant(value);
    }

    public Variant COLUMN(ExprContext ctx, Object[] args) throws SyntaxErrorException {
        CellBlock cb = this._getPosition(ctx, args);
        return new Variant(cb.getCol() + 1);
    }

    private CellBlock _getPosition(ExprContext ctx, Object[] args) throws SyntaxErrorException {
        CellBlock cb;
        Variant var = null;
        if (args.length > 1) {
            ExprErr.goError((long)8L, null);
        }
        if (args.length == 1) {
            if (!(args[0] instanceof Variant)) {
                ExprErr.goError((long)16L, null);
            }
            if ((var = (Variant)args[0]).getVt() != 18 || !(var.getValue() instanceof CellBlock)) {
                ExprErr.goError((long)16L, null);
            }
        }
        if (args.length > 0) {
            cb = (CellBlock)var.getValue();
        } else {
            ICalculable exprOwner = ctx.getExprOwner();
            if (exprOwner instanceof Cell) {
                Cell cll = (Cell)exprOwner;
                cb = CellBlock.getNewCellBlock(cll.getRow(), cll.getCol());
            } else {
                Sheet sheet = exprOwner.getSheet();
                cb = CellBlock.getNewCellBlock(sheet.getActiveRow(), sheet.getActiveCol());
            }
        }
        return cb;
    }

    public Variant DEC2HEX(Object[] args) throws SyntaxErrorException {
        ExcelFuncProvider.validParamCount(args, 1, 2);
        Variant value = (Variant)args[0];
        ExcelFuncProvider.validNumericParam("value", value);
        double dfValue = value.doubleValue();
        if (dfValue - (double)((long)dfValue) != 0.0) {
            ExprErr.goError((long)16L, (Object)"VALUE SHOULD BE INTEGER");
        }
        if (args.length == 1) {
            return new Variant((Object)Integer.toHexString((int)dfValue), 11);
        }
        Variant len = (Variant)args[1];
        ExcelFuncProvider.validNumericParam("len", len);
        int digit = (int)len.doubleValue();
        if (digit < 0) {
            ExprErr.goError((long)32L, (Object)"LEN");
        }
        String str = Integer.toHexString((int)dfValue);
        StringBuffer sb = new StringBuffer(str);
        int count = digit - str.length();
        for (int i = 0; i < count; ++i) {
            sb.insert(0, '0');
        }
        return new Variant((Object)sb.toString(), 11);
    }

    private Variant lookup(Object[] args, boolean bV) throws SyntaxErrorException {
        int valueIndex;
        ExcelFuncProvider.validParamCount(args, 3, 4);
        Variant searchValue = (Variant)args[0];
        if (searchValue.isNull()) {
            ExprErr.goError((long)524288L, (Object)"search");
        } else if (searchValue.getValue() instanceof CellBlockNode) {
            CellBlockNode node = (CellBlockNode)searchValue.getValue();
            Cell cell = node.getSheet().getCell(node.getRow(), node.getCol(), false);
            searchValue = cell == null ? Variant.nullVariant : cell.getValue();
        }
        Object obj = ((Variant)args[1]).getValue();
        if (!(obj instanceof CellBlockNode)) {
            ExprErr.goError((long)16L, (Object)"range");
        }
        CellBlockNode range = (CellBlockNode)obj;
        Variant varIndex = (Variant)args[2];
        Variant varTrans = Variant.getNewEmptyVariant();
        if (!varIndex.isNumeric(varTrans)) {
            ExprErr.goError((long)16L, (Object)"Value Index");
        }
        if ((valueIndex = varTrans.intValue()) < 1 || valueIndex > (bV ? range.getWidth() : range.getHeight())) {
            ExprErr.goError((long)262144L, null);
        }
        boolean exact = false;
        if (args.length == 4) {
            exact = !((Variant)args[3]).booleanValue();
        }
        int row = range.getRow();
        int col = range.getCol();
        boolean normal = true;
        Sheet.ICellsIterator ci = range.getSheet().getCellsIterator(row, col, bV ? range.getRow2() : row, bV ? col : range.getCol2(), false, true);
        CellValue cv = null;
        cv = exact ? this.hashSearch(ci, searchValue, normal) : this.treeSortAndTreeSearch(ci, searchValue, normal);
        if (null == cv || !exact && searchValue.compareTo(cv._value) < 0) {
            ExprErr.goError((long)524288L, null);
        }
        row = cv._cll.getRow();
        col = cv._cll.getCol();
        Cell cll = range.getSheet().getCell(bV ? row : row + valueIndex - 1, bV ? col + valueIndex - 1 : col, false);
        return cll == null ? Variant.getNewEmptyVariant() : cll.getValue();
    }

    private CellValue hashSearch(Sheet.ICellsIterator ci, Variant searchValue, boolean normal) throws SyntaxErrorException {
        Cell ret;
        ConcurrentHashMap<String, Cell> map = new ConcurrentHashMap<String, Cell>(1000);
        while (ci.hasNext()) {
            Cell cll = ci.next();
            Variant v = cll.getValue();
            if (v.isError()) {
                throw (SyntaxErrorException)((Object)v.getValue());
            }
            if (normal) {
                normal = !v.isPending();
            }
            map.putIfAbsent(v.toString(), cll);
        }
        if (map.size() == 0) {
            ExprErr.goError((long)524288L, null);
        }
        if (null == (ret = (Cell)map.get(searchValue.toString()))) {
            if (normal) {
                ExprErr.goError((long)524288L, null);
            } else {
                ExprErr.goError((long)0x100000L, null);
            }
        }
        return new CellValue(searchValue, ret);
    }

    private CellValue insertSortAndBinarySearch(Sheet.ICellsIterator ci, Variant searchValue, Boolean exact, boolean normal) throws SyntaxErrorException {
        int pos;
        SortedObjectArray so = new SortedObjectArray();
        while (ci.hasNext()) {
            Cell cll = ci.next();
            Variant v = cll.getValue();
            if (v.isError()) {
                throw (SyntaxErrorException)((Object)v.getValue());
            }
            if (normal) {
                normal = !v.isPending();
            }
            so.insert((Object)new CellValue(cll.getValue(), cll));
        }
        if (so.size() == 0) {
            ExprErr.goError((long)524288L, null);
        }
        if ((pos = so.search((Object)searchValue)) < 0 && !exact.booleanValue()) {
            pos = Math.max(0, -(pos + 1) - 1);
        }
        if (pos < 0) {
            if (normal) {
                ExprErr.goError((long)524288L, null);
            } else {
                ExprErr.goError((long)0x100000L, null);
            }
        }
        return (CellValue)so.get(pos);
    }

    private CellValue treeSortAndTreeSearch(Sheet.ICellsIterator ci, Variant searchValue, boolean normal) throws SyntaxErrorException {
        LinkedTreeMap.Node ret;
        LinkedTreeMap map = new LinkedTreeMap();
        Variant first = null;
        int i = 0;
        while (ci.hasNext()) {
            Cell cll = ci.next();
            Variant v = cll.getValue();
            if (i == 0) {
                first = v;
            }
            ++i;
            if (v.isError()) {
                throw (SyntaxErrorException)((Object)v.getValue());
            }
            if (normal) {
                boolean bl = normal = !v.isPending();
            }
            if (map.containsKey((Object)v)) continue;
            map.put((Object)v, (Object)new CellValue(v, cll));
        }
        if (map.size() == 0) {
            ExprErr.goError((long)524288L, null);
        }
        if (((CellValue)(ret = map.findFuzzy((Object)searchValue)).getValue())._value.equals(first) && ((CellValue)ret.getValue())._value.compareTo(searchValue) < 0) {
            if (normal) {
                ExprErr.goError((long)524288L, null);
            } else {
                ExprErr.goError((long)0x100000L, null);
            }
        }
        return (CellValue)ret.getValue();
    }

    public Variant VLOOKUP(Object[] args) throws SyntaxErrorException {
        return this.lookup(args, true);
    }

    public Variant HLOOKUP(Object[] args) throws SyntaxErrorException {
        return this.lookup(args, false);
    }

    private void stat(Object[] objs, Variant[] stats, boolean excludeHidden, boolean onlyNumber, boolean excludeSubTotal) throws SyntaxErrorException {
        ExcelFuncProvider.validParamCount(objs, 1, Integer.MAX_VALUE);
        boolean statCount = stats[1] != null;
        Variant number = Variant.getNewEmptyVariant();
        Variant one = statCount ? this.decimalValue(1.0) : null;
        int i = 0;
        while (i < objs.length) {
            CellBlockNode cb;
            Variant arg;
            if ((arg = (Variant)objs[i++]).isError()) {
                throw (SyntaxErrorException)((Object)arg.getValue());
            }
            Object obj = arg.getValue();
            Book book = null;
            int sht = 0;
            int shtEnd = -1;
            if (obj instanceof CellBlock3DNode) {
                cb = (CellBlock3DNode)obj;
                book = cb.getSheet().getBook();
                sht = cb.getSheet().getSheetIndex();
                shtEnd = ((CellBlock3DNode)cb).getSheet2().getSheetIndex();
            } else if (obj instanceof CellBlockNode) {
                cb = (CellBlockNode)obj;
                book = cb.getSheet().getBook();
                sht = shtEnd = cb.getSheet().getSheetIndex();
            }
            Variant sum = stats[0];
            Variant count = stats[1];
            Variant max = stats[2];
            Variant min = stats[3];
            Variant product = stats[4];
            Variant stdev = stats[5];
            if (book != null) {
                while (sht <= shtEnd) {
                    Sheet sheet = book.getSheet(sht);
                    CellBlock cb2 = (CellBlock)obj;
                    if (cb2.isSingleCell()) {
                        Cell cll = sheet.getFirstCell(cb2, false);
                        if (!(cll == null || excludeHidden && cll.isHidden() || excludeSubTotal && cll.hasSubTotalMethod())) {
                            this.statCell(cll, sum, count, max, min, product, stdev, number, one, onlyNumber, statCount);
                        }
                    } else {
                        Sheet.ICellsIterator ci = sheet.getCellsIterator(cb2, false, true);
                        while (ci.hasNext()) {
                            Cell cll = ci.next();
                            if (excludeHidden && cll.isHidden() || excludeSubTotal && cll.hasSubTotalMethod()) continue;
                            this.statCell(cll, sum, count, max, min, product, stdev, number, one, onlyNumber, statCount);
                        }
                    }
                    ++sht;
                }
                continue;
            }
            if (arg.isArray()) {
                this.statArray(arg, stats, excludeHidden, onlyNumber);
                continue;
            }
            if (arg.isObject() && arg.getValue() instanceof ExtGroup) {
                Variant[] values = ((ExtGroup)arg.getValue()).getValues();
                if (values == null) continue;
                this.statArray(new Variant((Object)values, 527), stats, excludeHidden, onlyNumber);
                continue;
            }
            boolean isNumber = arg.isNumeric(number);
            if (isNumber) {
                this.statOne(number, sum, count, max, min, product, stdev, one, isNumber);
                continue;
            }
            if (onlyNumber) continue;
            this.statOne(arg, sum, count, max, min, product, stdev, one, isNumber);
        }
    }

    private void sumProduct(Object[] objs, Variant[] stats, boolean excludeHidden, boolean onlyNumber, boolean excludeSubTotal) throws SyntaxErrorException {
        Variant number = Variant.getNewEmptyVariant();
        Variant sum = stats[0];
        boolean isBlock = false;
        int wBlock = 0;
        int hBlock = 0;
        for (int i = 0; i < objs.length; ++i) {
            Object obj;
            Variant arg = (Variant)objs[i];
            if (arg.isError()) {
                Object value = arg.getValue();
                if (value instanceof SyntaxErrorException) {
                    throw (SyntaxErrorException)((Object)value);
                }
                ExprErr.goError((long)64L, (Object)value);
            }
            if ((obj = arg.getValue()) instanceof CellBlock) {
                CellBlock cb = (CellBlock)obj;
                if (i == 0) {
                    isBlock = true;
                    wBlock = cb.getWidth();
                    hBlock = cb.getHeight();
                    continue;
                }
                if (isBlock && wBlock == cb.getWidth() && hBlock == cb.getHeight()) continue;
                ExprErr.goError((long)16L, null);
                continue;
            }
            if (obj.getClass().isArray()) {
                for (Object o : (Object[])obj) {
                    if (!(o instanceof Variant)) continue;
                    this.statOne((Variant)o, sum, null, null, null, null, null, null, true);
                }
                continue;
            }
            if (i == 0) {
                isBlock = false;
            } else if (isBlock) {
                ExprErr.goError((long)16L, null);
            }
            if (!arg.isNumeric(number)) continue;
            this.statOne(number, sum, null, null, null, null, null, null, true);
        }
        if (!isBlock) {
            return;
        }
        CellIteratorWrap[] cells = new CellIteratorWrap[objs.length];
        for (int i = 0; i < objs.length; ++i) {
            CellBlockNode cb = (CellBlockNode)((Variant)objs[i]).getValue();
            Book book = cb.getSheet().getBook();
            Sheet sheet = book.getSheet(cb.getSheet().getSheetIndex());
            cells[i] = new CellIteratorWrap(sheet.getCellsIterator(cb, false, true), cb);
        }
        CellIteratorWrap curCells = cells[0];
        while (curCells.hasNext()) {
            Cell cell = curCells.next();
            Variant value = cell.getValue();
            Variant product = stats[4];
            value.isNumeric(product);
            int pos = curCells.getCellPosition();
            for (int i = 1; i < objs.length; ++i) {
                cell = cells[i].getCell(pos);
                if (cell == null) {
                    product = null;
                    break;
                }
                value = cell.getValue();
                if (value.isNull()) {
                    product = null;
                    break;
                }
                if (!value.isNumeric(number)) {
                    product = null;
                    break;
                }
                this.statOne(number, null, null, null, null, product, null, null, true);
            }
            if (product == null || !product.isNumeric(number)) continue;
            this.statOne(number, sum, null, null, null, null, null, null, true);
        }
    }

    private void statCell(Cell cll, Variant sum, Variant count, Variant max, Variant min, Variant product, Variant stdev, Variant number, Variant one, boolean onlyNumber, boolean statCount) throws SyntaxErrorException {
        Variant value;
        if (cll.isNeedRecalc() || !cll.isHasValue()) {
            cll.getSheet().getDeps().calcReferTo(cll);
        }
        if ((value = cll.getValue()) == Variant.nullVariant) {
            return;
        }
        if (value.isPending()) {
            ExprErr.goError((long)0x100000L, null);
        }
        if (value.isNumeric(number)) {
            this.statOne(number, sum, count, max, min, product, stdev, one, true);
        } else if (!onlyNumber) {
            if (value.getVt() == 8 && value.booleanValue()) {
                if (sum != null) {
                    sum.add(one);
                }
                if (max != null && one.compareTo(max) > 0) {
                    max.setVariant(one);
                }
                if (min != null && one.compareTo(min) < 0) {
                    min.setVariant(one);
                }
                if (stdev != null) {
                    stdev.add(one);
                }
            }
            if (statCount) {
                count.add(one);
            }
        }
    }

    private void statArray(Variant var, Variant[] stats, boolean excludeHidden, boolean onlyNumber) throws SyntaxErrorException {
        Object[] objs = (Object[])var.getValue();
        Object[] objOne = new Object[]{null};
        for (int i = 0; i < objs.length; ++i) {
            Variant v = (Variant)objs[i];
            Object obj = v.getValue();
            if (obj instanceof ExtGroup) {
                ExtGroup grp = (ExtGroup)obj;
                if (grp.isNullGroup()) continue;
                objOne[0] = grp.getValues()[0];
            } else {
                objOne[0] = v;
            }
            this.stat(objOne, stats, excludeHidden, onlyNumber, false);
        }
    }

    private void statOne(Variant var, Variant sum, Variant count, Variant max, Variant min, Variant product, Variant stdev, Variant one, boolean isNumber) throws SyntaxErrorException {
        if (isNumber) {
            if (sum != null) {
                sum.add(var);
            }
            if (product != null) {
                product.multiply(var);
            }
            if (count != null) {
                count.add(one);
            }
            if (max != null && var.compareTo(max) > 0) {
                max.setVariant(var);
            }
            if (min != null && var.compareTo(min) < 0) {
                min.setVariant(var);
            }
            if (stdev != null) {
                Variant tmp = Variant.getNewEmptyVariant();
                var.multiply(var, tmp);
                stdev.add(tmp);
            }
        } else {
            if (var.getVt() == 8 && var.booleanValue()) {
                if (sum != null) {
                    sum.add(one);
                }
                if (max != null && one.compareTo(max) > 0) {
                    max.setVariant(one);
                }
                if (min != null && one.compareTo(min) < 0) {
                    min.setVariant(one);
                }
                if (stdev != null) {
                    stdev.add(one);
                }
            }
            if (count != null) {
                count.add(one);
            }
        }
    }

    private Variant sum(Object[] args, boolean hidden, boolean excludeSubTotal) throws SyntaxErrorException {
        Variant sum;
        Variant[] stats = new Variant[6];
        stats[0] = sum = this.decimalValue(0.0);
        this.stat(args, stats, hidden, true, excludeSubTotal);
        return sum;
    }

    public Variant SUM(Object[] args) throws SyntaxErrorException {
        return this.sum(args, false, false);
    }

    public Variant SumProduct(Object[] args) throws SyntaxErrorException {
        Variant sum;
        Variant[] stats = new Variant[6];
        stats[0] = sum = this.decimalValue(0.0);
        stats[4] = Variant.getNewEmptyVariant();
        this.sumProduct(args, stats, false, true, false);
        return sum;
    }

    private Variant max(Object[] args, boolean hidden, boolean excludeSubTotal) throws SyntaxErrorException {
        Variant max;
        Variant[] stats = new Variant[6];
        stats[2] = max = new Variant(-1.7976931348623157E308);
        this.stat(args, stats, hidden, true, excludeSubTotal);
        if (max.doubleValue() == -1.7976931348623157E308) {
            max.setDouble(0.0);
        }
        return this.decimalValue(max);
    }

    public Variant MAX(Object[] args) throws SyntaxErrorException {
        return this.max(args, false, false);
    }

    private Variant min(Object[] args, boolean hidden, boolean excludeSubTotal) throws SyntaxErrorException {
        Variant min;
        Variant[] stats = new Variant[6];
        stats[3] = min = new Variant(Double.MAX_VALUE);
        this.stat(args, stats, hidden, true, excludeSubTotal);
        if (min.doubleValue() == Double.MAX_VALUE) {
            min.setDouble(0.0);
        }
        return this.decimalValue(min);
    }

    public Variant MIN(Object[] args) throws SyntaxErrorException {
        return this.min(args, false, false);
    }

    private Variant count(Object[] args, boolean hidden, boolean onlyNumber, boolean excludeSubTotal) throws SyntaxErrorException {
        Variant count;
        Variant[] stats = new Variant[6];
        stats[1] = count = this.decimalValue(0.0);
        this.stat(args, stats, hidden, onlyNumber, excludeSubTotal);
        return count;
    }

    public Variant COUNT(Object[] args) throws SyntaxErrorException {
        return this.count(args, false, true, false);
    }

    public Variant COUNTA(Object[] args) throws SyntaxErrorException {
        return this.count(args, false, false, false);
    }

    private Variant average(Object[] args, boolean hidden, boolean excludeSubTotal) throws SyntaxErrorException {
        Variant[] stats = new Variant[6];
        Variant count = this.decimalValue(0.0);
        Variant sum = this.decimalValue(0.0);
        stats[1] = count;
        stats[0] = sum;
        this.stat(args, stats, hidden, true, excludeSubTotal);
        if (count.longValue() == 0L) {
            return count;
        }
        sum.divide(count);
        return sum;
    }

    public Variant AVERAGE(Object[] args) throws SyntaxErrorException {
        return this.average(args, false, false);
    }

    public Variant MEDIAN(Object[] args) throws SyntaxErrorException {
        Variant ret;
        ObjectArray values = this._collectD1Numbers(args, 0, args.length, 0, true);
        if (values.isEmpty()) {
            ExprErr.goError((long)64L, null);
        }
        Arrays.sort(values.getArray(), 0, values.size());
        int len = values.size();
        Object[] array = values.getArray();
        if ((len & 1) != 0) {
            ret = (Variant)array[len >> 1];
        } else {
            int i = len >> 1;
            ret = Variant.getNewEmptyVariant();
            ((Variant)array[i]).add((Variant)array[i - 1], ret);
            ret.divide(Variant.twoVariant);
        }
        return ret;
    }

    private ObjectArray _collectD1Numbers(Object[] args, int from, int to, int rowcol, boolean skipNotNumber) throws SyntaxErrorException {
        ObjectArray array = new ObjectArray(to - from);
        Variant number = null;
        for (int i = from; i < to; ++i) {
            CellBlockNode cb;
            Variant arg = (Variant)args[i];
            if (arg.isError()) {
                throw (SyntaxErrorException)((Object)arg.getValue());
            }
            Object obj = arg.getValue();
            Book book = null;
            int sht = 0;
            int shtEnd = -1;
            if (obj instanceof CellBlock3DNode) {
                cb = (CellBlock3DNode)obj;
                book = cb.getSheet().getBook();
                sht = cb.getSheet().getSheetIndex();
                shtEnd = ((CellBlock3DNode)cb).getSheet2().getSheetIndex();
            } else if (obj instanceof CellBlockNode) {
                cb = (CellBlockNode)obj;
                book = cb.getSheet().getBook();
                sht = shtEnd = cb.getSheet().getSheetIndex();
            }
            if (book != null) {
                while (sht <= shtEnd) {
                    Sheet sheet = book.getSheet(sht);
                    CellBlock cb2 = (CellBlock)obj;
                    if (cb2.isSingleCell()) {
                        Cell cll = sheet.getFirstCell(cb2, false);
                        if (cll == null && !skipNotNumber) {
                            ExprErr.goError((long)64L, null);
                        }
                        number = this._appendNumber(array, ExcelFuncProvider._getValidCellValue(cll), number, skipNotNumber);
                    } else {
                        CellBlock block;
                        if (rowcol == 0) {
                            block = cb2;
                        } else {
                            block = (CellBlock)cb2.clone();
                            if (rowcol == 1) {
                                block.setRow2(block.getRow());
                            } else {
                                block.setCol2(block.getCol());
                            }
                        }
                        if (skipNotNumber) {
                            Sheet.ICellsIterator ci = sheet.getCellsIterator(block, false, true);
                            while (ci.hasNext()) {
                                number = this._appendNumber(array, ExcelFuncProvider._getValidCellValue(ci.next()), number, skipNotNumber);
                            }
                        } else {
                            int cStart = block.getCol();
                            int cEnd = block.getCol2() + 1;
                            int rEnd = block.getRow2() + 1;
                            for (int r = block.getRow(); r < rEnd; ++r) {
                                Row rowObj = sheet.getRow(r, false);
                                if (rowObj == null) {
                                    ExprErr.goError((long)64L, null);
                                }
                                for (int c = cStart; c < cEnd; ++c) {
                                    Cell cll = rowObj.getCell(c, false);
                                    if (cll == null) {
                                        ExprErr.goError((long)64L, null);
                                    }
                                    number = this._appendNumber(array, ExcelFuncProvider._getValidCellValue(cll), number, skipNotNumber);
                                }
                            }
                        }
                    }
                    ++sht;
                }
                continue;
            }
            if (arg.isArray()) {
                Variant[] vars = (Variant[])arg.getValue();
                for (int j = 0; j < vars.length; ++j) {
                    number = this._appendNumber(array, vars[j], number, skipNotNumber);
                }
                continue;
            }
            number = this._appendNumber(array, arg, number, skipNotNumber);
        }
        return array;
    }

    public static Variant[][] collectD2Numbers(Variant arg, boolean skipNotNumber) throws SyntaxErrorException {
        Variant[][] array;
        if (arg.isError()) {
            throw (SyntaxErrorException)((Object)arg.getValue());
        }
        Object obj = arg.getValue();
        CellBlockNode cb = null;
        if (obj instanceof CellBlockNode) {
            cb = (CellBlockNode)obj;
        }
        if (cb != null) {
            int height = cb.getHeight();
            int width = cb.getWidth();
            array = new Variant[height][width];
            Sheet sheet = cb.getSheet();
            int colStart = cb.getCol();
            int r = cb.getRow();
            int i = 0;
            while (i < height) {
                Variant[] line = array[i];
                Row rowObj = sheet.getRow(r, false);
                if (rowObj != null) {
                    int c = colStart;
                    int j = 0;
                    while (j < width) {
                        Cell cll = rowObj.getCell(c, false);
                        line[j] = ExcelFuncProvider.getCellNumber(cll, skipNotNumber);
                        ++j;
                        ++c;
                    }
                } else if (skipNotNumber) {
                    for (int j = 0; j < width; ++j) {
                        line[j] = new Variant(Variant.zeroVariant);
                    }
                } else {
                    ExprErr.goError((long)64L, null);
                }
                ++i;
                ++r;
            }
        } else if (arg.isArray()) {
            if (obj instanceof Variant[][]) {
                Variant[][] src = (Variant[][])obj;
                int rows = src.length;
                int cols = src[0].length;
                array = new Variant[rows][cols];
                for (int i = 0; i < rows; ++i) {
                    Variant[] srcLine = src[i];
                    Variant[] dstLine = array[i];
                    for (int j = 0; j < cols; ++j) {
                        dstLine[j] = ExcelFuncProvider.getNumber(srcLine[j], skipNotNumber);
                    }
                }
            } else {
                Variant[] src = (Variant[])obj;
                int rows = src.length;
                Variant varLine = src[0];
                if (varLine.isArray()) {
                    int cols = ((Variant[])varLine.getValue()).length;
                    array = new Variant[rows][cols];
                    for (int i = 0; i < rows; ++i) {
                        Variant[] srcLine = (Variant[])src[i].getValue();
                        Variant[] dstLine = array[i];
                        for (int j = 0; j < cols; ++j) {
                            dstLine[j] = ExcelFuncProvider.getNumber(srcLine[j], skipNotNumber);
                        }
                    }
                } else {
                    array = new Variant[rows][1];
                    for (int i = 0; i < rows; ++i) {
                        array[i][0] = ExcelFuncProvider.getNumber(src[i], skipNotNumber);
                    }
                }
            }
        } else if (arg.isObject() && obj instanceof ExtGroup) {
            ExtGroup group = (ExtGroup)arg.getValue();
            Variant[] values = group.getValues();
            int rows = values.length;
            array = new Variant[rows][1];
            for (int i = 0; i < rows; ++i) {
                array[i][0] = ExcelFuncProvider.getNumber(values[i], skipNotNumber);
            }
        } else {
            array = new Variant[][]{{ExcelFuncProvider.getNumber(arg, skipNotNumber)}};
        }
        return array;
    }

    public static Variant getCellNumber(Cell cll, boolean skipNotNumber) throws SyntaxErrorException {
        return cll == null ? ExcelFuncProvider.getNumber(null, skipNotNumber) : ExcelFuncProvider.getNumber(ExcelFuncProvider._getValidCellValue(cll), skipNotNumber);
    }

    public static Variant getNumber(Variant value, boolean skipNotNumber) throws SyntaxErrorException {
        Variant number = null;
        if (value == null) {
            if (skipNotNumber) {
                number = new Variant(Variant.zeroVariant);
            } else {
                ExprErr.goError((long)64L, null);
            }
        } else {
            number = new Variant();
            if (!value.isNumeric(number)) {
                if (skipNotNumber) {
                    number = new Variant(Variant.zeroVariant);
                } else {
                    ExprErr.goError((long)64L, null);
                }
            }
        }
        return number;
    }

    private Variant _appendNumber(ObjectArray array, Variant value, Variant number, boolean skipNotNumber) throws SyntaxErrorException {
        if (number == null) {
            number = Variant.getNewEmptyVariant();
        }
        if (value.isNumeric(number)) {
            array.append((Object)number);
            number = null;
        } else if (!skipNotNumber) {
            ExprErr.goError((long)64L, null);
        }
        return number;
    }

    private static Variant _getValidCellValue(Cell cll) throws SyntaxErrorException {
        Variant value;
        if (cll.isQueueLast()) {
            throw SyntaxErrorException.CALC_LAST;
        }
        if (cll.isNeedRecalc() || !cll.isHasValue()) {
            cll.getSheet().getDeps().calcReferTo(cll);
        }
        if ((value = cll.getValue()).isError()) {
            throw (SyntaxErrorException)((Object)value.getValue());
        }
        return value;
    }

    private Variant product(Object[] args, boolean hidden, boolean excludeSubTotal) throws SyntaxErrorException {
        Variant[] stats = new Variant[6];
        Variant count = this.decimalValue(0.0);
        Variant product = this.decimalValue(1.0);
        stats[1] = count;
        stats[4] = product;
        this.stat(args, stats, hidden, true, excludeSubTotal);
        if (count.longValue() == 0L) {
            return count;
        }
        return product;
    }

    public Variant PRODUCT(Object[] args) throws SyntaxErrorException {
        return this.product(args, false, false);
    }

    public Variant STDEV(Object[] args) throws SyntaxErrorException {
        Variant stdev = this.var(args, false, true, false);
        return this.decimalValue(Math.sqrt(stdev.doubleValue()));
    }

    public Variant STDEVP(Object[] args) throws SyntaxErrorException {
        Variant stdev = this.var(args, false, true, true);
        return this.decimalValue(Math.sqrt(stdev.doubleValue()));
    }

    private Variant var(Object[] args, boolean hidden, boolean onlyNumber, boolean varp) throws SyntaxErrorException {
        Variant[] stats = new Variant[6];
        Variant count = this.decimalValue(0.0);
        Variant sum = this.decimalValue(0.0);
        Variant stdev = this.decimalValue(0.0);
        stats[1] = count;
        stats[0] = sum;
        stats[5] = stdev;
        this.stat(args, stats, hidden, onlyNumber, false);
        stdev.multiply(count);
        sum.multiply(sum);
        stdev.subtract(sum);
        stdev.divide(count);
        if (!varp) {
            count.subtract(this.decimalValue(1.0));
        }
        stdev.divide(count);
        return stdev;
    }

    public Variant VAR(Object[] args) throws SyntaxErrorException {
        return this.var(args, false, true, false);
    }

    public Variant VARA(Object[] args) throws SyntaxErrorException {
        return this.var(args, false, false, false);
    }

    public Variant VARP(Object[] args) throws SyntaxErrorException {
        return this.var(args, false, false, true);
    }

    public Variant COVAR(Object[] args) throws SyntaxErrorException {
        Object[] rets = new Object[4];
        this._vars(args, rets);
        Variant[] array = (Variant[])rets[0];
        Variant[] array2 = (Variant[])rets[1];
        Variant u = (Variant)rets[2];
        Variant u2 = (Variant)rets[3];
        Variant x = Variant.getNewEmptyVariant();
        Variant y = Variant.getNewEmptyVariant();
        Variant sum = this.decimalValue(0.0);
        for (int i = 0; i < array.length; ++i) {
            array[i].subtract(u, x);
            array2[i].subtract(u2, y);
            x.multiply(y);
            sum.add(x);
        }
        sum.divide(this.decimalValue(array.length));
        return sum;
    }

    public Variant CORREL(Object[] args) throws SyntaxErrorException {
        Object[] rets = new Object[4];
        this._vars(args, rets);
        Variant[] array = (Variant[])rets[0];
        Variant[] array2 = (Variant[])rets[1];
        Variant u = (Variant)rets[2];
        Variant u2 = (Variant)rets[3];
        Variant x = Variant.getNewEmptyVariant();
        Variant y = Variant.getNewEmptyVariant();
        Variant d = Variant.getNewEmptyVariant();
        Variant sumD = this.decimalValue(0.0);
        Variant sumX = this.decimalValue(0.0);
        Variant sumY = this.decimalValue(0.0);
        for (int i = 0; i < array.length; ++i) {
            array[i].subtract(u, x);
            array2[i].subtract(u2, y);
            x.multiply(y, d);
            sumD.add(d);
            x.multiply(x);
            sumX.add(x);
            y.multiply(y);
            sumY.add(y);
        }
        sumX.multiply(sumY);
        double df = Math.sqrt(sumX.doubleValue());
        sumX = this.decimalValue(df);
        sumD.divide(sumX);
        return sumD;
    }

    public Variant PEARSON(Object[] args) throws SyntaxErrorException {
        Object[] rets = new Object[4];
        this._vars(args, rets);
        Variant[] array = (Variant[])rets[0];
        Variant[] array2 = (Variant[])rets[1];
        Variant u = (Variant)rets[2];
        Variant u2 = (Variant)rets[3];
        Variant x = Variant.getNewEmptyVariant();
        Variant y = Variant.getNewEmptyVariant();
        Variant xy = Variant.getNewEmptyVariant();
        Variant sumXY = this.decimalValue(0.0);
        Variant sumX = this.decimalValue(0.0);
        Variant sumY = this.decimalValue(0.0);
        for (int i = 0; i < array.length; ++i) {
            array[i].subtract(u, x);
            array2[i].subtract(u2, y);
            x.multiply(y, xy);
            sumXY.add(xy);
            x.multiply(x);
            sumX.add(x);
            y.multiply(y);
            sumY.add(y);
        }
        sumX.multiply(sumY);
        sumX = this.decimalValue(Math.sqrt(sumX.doubleValue()));
        sumXY.divide(sumX);
        return sumXY;
    }

    public Variant RSQ(Object[] args) throws SyntaxErrorException {
        Variant x = this.PEARSON(args);
        x.multiply(x);
        return x;
    }

    public Variant SUMX2MY2(Object[] args) throws SyntaxErrorException {
        Object[] rets = new Object[4];
        this._vars(args, rets);
        Variant[] array = (Variant[])rets[0];
        Variant[] array2 = (Variant[])rets[1];
        Variant x = Variant.getNewEmptyVariant();
        Variant y = Variant.getNewEmptyVariant();
        Variant sum = this.decimalValue(0.0);
        for (int i = 0; i < array.length; ++i) {
            array[i].multiply(array[i], x);
            array2[i].multiply(array2[i], y);
            x.subtract(y);
            sum.add(x);
        }
        return sum;
    }

    private void _vars(Object[] args, Object[] rets) throws SyntaxErrorException {
        ExcelFuncProvider.validParamCount(args, 2, 2);
        Object[] array = null;
        Object[] array2 = null;
        Object var = (Variant)args[0];
        Variant var2 = (Variant)args[1];
        if (var.isNull() || var2.isNull()) {
            ExprErr.goError((long)2L, null);
        }
        rets[0] = array = this._getArrayData((Variant)var);
        rets[1] = array2 = this._getArrayData(var2);
        if (array == null || array2 == null || array.length == 0 || array2.length == 0) {
            ExprErr.goError((long)64L, null);
        }
        if (array.length != array2.length) {
            ExprErr.goError((long)524288L, null);
        }
        Variant x = Variant.getNewEmptyVariant();
        Variant y = Variant.getNewEmptyVariant();
        if (array.length > 1) {
            int count = 0;
            for (int i = 0; i < array.length; ++i) {
                if (!array[i].isNumeric(x) || !array2[i].isNumeric(y)) {
                    array[i] = null;
                    continue;
                }
                array[i] = x;
                array2[i] = y;
                x = Variant.getNewEmptyVariant();
                y = Variant.getNewEmptyVariant();
                ++count;
            }
            if (count < array.length) {
                Variant[] newArray = new Variant[count];
                Variant[] newArray2 = new Variant[count];
                int n = 0;
                for (int i = 0; i < array.length; ++i) {
                    var = array[i];
                    if (var == null) continue;
                    newArray[n] = var;
                    newArray2[n++] = array2[i];
                }
                array = newArray;
                rets[0] = newArray;
                array2 = newArray2;
                rets[1] = newArray2;
            }
        }
        if (array.length > 1) {
            rets[2] = this.AVERAGE(array);
            rets[3] = this.AVERAGE(array2);
        } else {
            if (!array[0].isNumeric(x) || !array2[0].isNumeric(y)) {
                ExprErr.goError((long)64L, null);
            }
            rets[2] = x;
            rets[3] = y;
        }
    }

    private Variant[] _getArrayData(Variant var) throws SyntaxErrorException {
        Variant[] array = null;
        if (var.isReferences()) {
            Object obj = var.getValue();
            if (obj instanceof CellBlockNode) {
                CellBlockNode cb = (CellBlockNode)obj;
                Sheet sheet = cb.getSheet();
                int height = cb.getHeight();
                int width = cb.getWidth();
                if (height > sheet.getMaxRowIndex() || width > sheet.getMaxColIndex()) {
                    ExprErr.goError((long)1024L, null);
                }
                array = new Variant[height * width];
                int rEnd = cb.getRow2() + 1;
                int i = 0;
                for (int r = cb.getRow(); r < rEnd; ++r) {
                    Row rowObj = sheet.getRow(r, false);
                    int cEnd = cb.getCol2() + 1;
                    for (int c = cb.getCol(); c < cEnd; ++c) {
                        Variant value;
                        Cell cll = sheet.getCell(rowObj, c, false);
                        array[i++] = cll == null || (value = cll.getValue()).isNull() ? Variant.emptyVariant : value;
                    }
                }
            }
        } else {
            Variant number;
            array = var.isArray() ? (Variant[])var.getValue() : (var.isNumeric(number = Variant.getNewEmptyVariant()) ? new Variant[]{number} : new Variant[]{});
        }
        return array;
    }

    public Variant VALUE(ExprContext ctx, Object[] args) throws SyntaxErrorException {
        ExcelFuncProvider.validParamCount(args, 0, 1);
        if (args.length == 0) {
            return ctx.getExprOwner().getValue();
        }
        BigDecimal bd = new BigDecimal(args[0].toString());
        return new Variant((Object)bd, 10);
    }

    public Variant SUBTOTAL(Object[] args) throws SyntaxErrorException {
        Variant var;
        int fnNum;
        ExcelFuncProvider.validParamCount(args, 2, 64);
        boolean excludeHidden = false;
        Variant var2 = (Variant)args[0];
        Variant varTrans = Variant.getNewEmptyVariant();
        if (!var2.isNumeric(varTrans)) {
            ExprErr.goError((long)16L, (Object)"Function Number");
        }
        if ((fnNum = varTrans.intValue()) < 1 || fnNum > 11 && fnNum < 101 || fnNum > 111) {
            ExprErr.goError((long)16L, (Object)"Function Number");
        }
        if (fnNum > 11) {
            excludeHidden = true;
            fnNum -= 100;
        }
        for (int i = 1; i < args.length; ++i) {
            Object obj = ((Variant)args[i]).getValue();
            if (obj instanceof CellBlockNode && !(obj instanceof CellBlock3DNode)) continue;
            ExprErr.goError((long)16L, (Object)"Not Range");
        }
        Object[] pureArgs = new Object[args.length - 1];
        System.arraycopy(args, 1, pureArgs, 0, pureArgs.length);
        switch (fnNum) {
            case 1: {
                var = this.average(pureArgs, excludeHidden, true);
                break;
            }
            case 2: {
                var = this.count(pureArgs, excludeHidden, true, true);
                break;
            }
            case 3: {
                var = this.count(pureArgs, excludeHidden, false, true);
                break;
            }
            case 4: {
                var = this.max(pureArgs, excludeHidden, true);
                break;
            }
            case 5: {
                var = this.min(pureArgs, excludeHidden, true);
                break;
            }
            case 6: {
                var = this.product(pureArgs, excludeHidden, true);
                break;
            }
            case 7: 
            case 8: {
                var = this.var(args, excludeHidden, true, fnNum == 8);
                double df = var.doubleValue();
                var.setObject((Object)new BigDecimal(Math.sqrt(df)), 10);
                break;
            }
            case 9: {
                var = this.sum(pureArgs, excludeHidden, true);
                break;
            }
            default: {
                var = this.var(pureArgs, excludeHidden, true, true);
            }
        }
        return var;
    }

    public Variant SUMIF(ExprContext ctx, Object[] args) throws SyntaxErrorException {
        ExcelFuncProvider.validParamCount(args, 2, 3);
        Variant sum = this.decimalValue(0.0);
        Object sumRange = args.length == 3 ? args[2] : args[0];
        this._statif(ctx, sumRange, args, 0, 2, sum, null, true);
        return sum;
    }

    public Variant COUNTIF(ExprContext ctx, Object[] args) throws SyntaxErrorException {
        ExcelFuncProvider.validParamCount(args, 2, 2);
        Variant count = this.decimalValue(0.0);
        this._statif(ctx, args[0], args, 0, args.length, null, count, false);
        return count;
    }

    public Variant SUMIFS(ExprContext ctx, Object[] args) throws SyntaxErrorException {
        ExcelFuncProvider.validParamCount(args, 3, 255);
        Variant sum = this.decimalValue(0.0);
        this._statif(ctx, args[0], args, 1, args.length, sum, null, true);
        return sum;
    }

    public Variant COUNTIFS(ExprContext ctx, Object[] args) throws SyntaxErrorException {
        ExcelFuncProvider.validParamCount(args, 2, 255);
        Variant count = this.decimalValue(0.0);
        this._statif(ctx, args[0], args, 0, args.length, null, count, false);
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _statif(ExprContext ctx, Object sumRangeObj, Object[] criteriaObjs, int start, int end, Variant varSum, Variant varCount, boolean skipEmpty) throws SyntaxErrorException {
        Object obj;
        int criterias = end - start;
        if (criterias % 2 != 0) {
            ExprErr.goError((long)8L, (Object)"Param odd");
        }
        if (!((obj = ((Variant)sumRangeObj).getValue()) instanceof CellBlockNode)) {
            ExprErr.goError((long)16L, (Object)"range");
        }
        CellBlockNode sumRange = (CellBlockNode)obj;
        Sheet[] criteriaSheet = new Sheet[criterias / 2];
        int sheetIndex = 0;
        int[] criteriaOffsets = new int[criterias];
        int width = sumRange.getWidth();
        int height = sumRange.getHeight();
        int row = sumRange.getRow();
        int col = sumRange.getCol();
        int off = 0;
        for (int i = start; i < end; i += 2) {
            Object obj2 = ((Variant)criteriaObjs[i]).getValue();
            if (!(obj2 instanceof CellBlockNode)) {
                ExprErr.goError((long)16L, (Object)"range");
            }
            CellBlockNode range = (CellBlockNode)obj2;
            criteriaSheet[sheetIndex++] = range.getSheet();
            if (width != range.getWidth() || height != range.getHeight()) {
                ExprErr.goError((long)16L, (Object)"range shape");
            }
            criteriaOffsets[off++] = range.getCol() - col;
            criteriaOffsets[off++] = range.getRow() - row;
        }
        String strNode = SheetBaseMath.getBlockA1Name(1048575, 16383, true, true);
        Sheet sheet = sumRange.getSheet();
        Sheet exprSheet = null;
        boolean isMatchEmpty = true;
        Object[] criteriaExprs = new Object[criterias];
        int e = 0;
        for (int i = start + 1; i < end; i += 2) {
            String criteria = null;
            int compareString = 0;
            Object obj3 = ((Variant)criteriaObjs[i]).getValue();
            if (obj3 instanceof CellBlockNode) {
                Cell cll;
                CellBlockNode cb = (CellBlockNode)obj3;
                if (!cb.isSingleCell()) {
                    ExprErr.goError((long)16L, (Object)(cb.getBlockName(true, (Cell)null) + " not cell"));
                }
                if ((cll = cb.getFirstCell(false)) != null) {
                    if (cll.isHasValue()) {
                        Variant value = cll.getValue();
                        compareString = 1;
                        criteria = value.toString();
                        criteria = "=\"" + criteria.toLowerCase() + '\"';
                    } else {
                        char ch;
                        criteria = cll.getFormula();
                        exprSheet = cll.getSheet();
                        if (!StringUtil.isEmptyString((String)criteria) && (ch = criteria.charAt(0)) != '=' && ch != '>' && ch != '<' && ch != '-' && ch != '+') {
                            compareString = 1;
                            criteria = "=\"" + criteria.toLowerCase() + '\"';
                        }
                    }
                }
            } else if (obj3 instanceof Variant[]) {
                Variant[] array = (Variant[])obj3;
                StringBuilder builder = new StringBuilder();
                builder.append(strNode).append(',');
                for (int n = 0; n < array.length; ++n) {
                    String temp = array[n].toString();
                    builder.append('\"');
                    builder.append(temp);
                    builder.append('\"');
                    if (n >= array.length - 1) continue;
                    builder.append(',');
                }
                criteria = "=IN(" + builder.toString() + ')';
                compareString = 2;
            } else {
                criteria = obj3.toString();
                if (!StringUtil.isEmptyString((String)criteria)) {
                    if (!StringUtil.isNumber((String)criteria) && this.isRegex(this.transfer2ExcelRegex(criteria))) {
                        compareString = 3;
                        criteria = "=REGEX(" + strNode + ",\"" + this.transfer2ExcelRegex(criteria) + "\")";
                    } else {
                        String tempCri = this.parseCriteria(criteria, false);
                        if (!criteria.equals(tempCri)) {
                            compareString = 1;
                            criteria = tempCri;
                        }
                    }
                } else {
                    compareString = 1;
                    criteria = "=\"\"";
                }
            }
            if (StringUtil.isEmptyString((String)criteria)) {
                return;
            }
            String formula = compareString == 1 ? "LOWER(" + strNode + ")" + criteria : (compareString == 0 ? strNode + criteria : criteria);
            Expr expr = exprSheet != null ? exprSheet.getExpr(null, formula) : sheet.getExpr(null, formula);
            if (expr.isSyntaxError()) {
                return;
            }
            if (null != varCount && isMatchEmpty) {
                Expr pr = null;
                pr = exprSheet != null ? exprSheet.getExpr(null, formula) : sheet.getExpr(null, formula);
                pr.getParameters()[0] = ExprConst.NULL;
                Variant cond = pr.execute(ctx, null);
                if (!cond.booleanValue() || cond.isCompareError()) {
                    isMatchEmpty = false;
                }
            }
            boolean findThisNode = false;
            IExprNode[] nodes = expr.getParameters();
            for (int n = 0; n < nodes.length; ++n) {
                CellBlockNode cb;
                IExprNode node = nodes[n];
                if (node.getExprType() != 4 || !(cb = (CellBlockNode)node).isSingleCell() || cb.getRow() != 1048575 || cb.getCol() != 16383) continue;
                criteriaExprs[e++] = expr;
                criteriaExprs[e++] = n;
                findThisNode = true;
                break;
            }
            if (findThisNode) continue;
            ExprErr.goError((long)16L, (Object)"no MAX CELL");
        }
        Variant number = Variant.getNewEmptyVariant();
        int count = 0;
        Sheet.ICellsIterator it = sheet.getCellsIterator(sumRange, false, true, skipEmpty);
        int paramPos = 0;
        int cellCount = 0;
        while (it.hasNext()) {
            boolean calcSum;
            Cell cllSum = it.next();
            ++cellCount;
            boolean bl = calcSum = varSum != null;
            if (!calcSum && varCount == null) continue;
            int row2 = cllSum.getRow();
            int col2 = cllSum.getCol();
            boolean pass = true;
            boolean nestCalc = ctx.isNestCalc();
            try {
                ctx.setNestCalc(true);
                sheetIndex = 0;
                for (int i = 0; i < criterias; i += 2) {
                    int c = col2 + criteriaOffsets[i];
                    int r = row2 + criteriaOffsets[i + 1];
                    Sheet cSheet = criteriaSheet[sheetIndex++];
                    CellBlockNode cb = CellBlockNode.getNewBlock(cSheet, r, c, r, c, 15);
                    paramPos = (Integer)criteriaExprs[i + 1];
                    Expr expr = (Expr)criteriaExprs[i];
                    expr.getParameters()[paramPos] = cb;
                    Variant cond = expr.execute(ctx, null);
                    if (cond.isPending()) {
                        throw (SyntaxErrorException)((Object)cond.getValue());
                    }
                    if (cond.booleanValue() && !cond.isCompareError()) continue;
                    pass = false;
                    break;
                }
            }
            finally {
                ctx.setNestCalc(nestCalc);
            }
            if (!pass) continue;
            Variant value = cllSum.getValue();
            if (value.isError()) {
                throw (SyntaxErrorException)((Object)value.getValue());
            }
            if (calcSum && value.isNumeric(number)) {
                varSum.add(number);
            }
            if (varCount == null) continue;
            ++count;
        }
        if (varCount != null) {
            int rangeSize = sumRange.getWidth() * sumRange.getHeight();
            int outRangeSize = rangeSize - cellCount;
            if (outRangeSize > 0 && isMatchEmpty) {
                count += outRangeSize;
            }
            varCount.setInt(count);
        }
    }

    private String parseCriteria(String criteria, boolean isFormual) {
        char ch = criteria.charAt(0);
        if (!isFormual) {
            if (criteria.startsWith("<>") || criteria.startsWith("<=") || criteria.startsWith(">=")) {
                String text = criteria.substring(2, criteria.length());
                try {
                    Double.valueOf(text);
                }
                catch (NumberFormatException nfe) {
                    if (!text.startsWith("\"") && !text.endsWith("\"")) {
                        criteria = criteria.substring(0, 2) + "\"" + text.toLowerCase() + "\"";
                    }
                }
            } else if (ch == '=' || ch == '>' || ch == '<') {
                String text = criteria.substring(1, criteria.length());
                try {
                    Double.valueOf(text);
                }
                catch (NumberFormatException nfe) {
                    if (!text.startsWith("\"") && !text.endsWith("\"")) {
                        criteria = criteria.charAt(0) + "\"" + text.toLowerCase() + "\"";
                    }
                }
            } else if (ch != '-' && ch != '+') {
                criteria = !criteria.startsWith("\"") && !criteria.endsWith("\"") ? "=\"" + criteria.toLowerCase() + '\"' : "=" + criteria.toLowerCase();
            }
        } else if (ch != '=' && ch != '>' && ch != '<' && ch != '-' && ch != '+') {
            criteria = "=\"" + criteria.toLowerCase() + '\"';
        }
        return criteria;
    }

    public Variant RANK(ExprContext ctx, Object[] args) throws SyntaxErrorException {
        ExcelFuncProvider.validParamCount(args, 2, 3);
        Variant number = (Variant)args[0];
        ExcelFuncProvider.validNumericParam("value", number);
        Variant ref = (Variant)args[1];
        SortedObjectArray values = null;
        final class VarCount
        extends Variant
        implements Comparable {
            private static final long serialVersionUID = 8610304049829344756L;
            int _rank;

            VarCount(Variant var) {
                super(var);
                this._rank = 1;
            }

            public int compareTo(Object right) {
                return super.compareTo(right);
            }

            void insert(SortedObjectArray array) {
                int pos = array.search((Object)this);
                if (pos >= 0) {
                    ++((VarCount)array.get((int)pos))._rank;
                } else {
                    array.insert(pos, (Object)this);
                }
            }

            void insertBlock(SortedObjectArray array, CellBlockNode cb) {
                Sheet.ICellsIterator i = cb.getCellsIterator(false, true);
                while (i.hasNext()) {
                    Variant value = i.next().getValue();
                    if (!value.isNumber()) continue;
                    new VarCount(value).insert(array);
                }
            }
        }
        VarCount op = new VarCount(null);
        if (ref.isArray()) {
            Variant value;
            int i;
            values = new SortedObjectArray();
            Variant[] aVar = (Variant[])ref.getValue();
            if (aVar[0].getValue() instanceof CellBlockNode) {
                for (i = 0; i < aVar.length; ++i) {
                    value = aVar[i];
                    op.insertBlock(values, (CellBlockNode)value.getValue());
                }
            } else {
                for (i = 0; i < aVar.length; ++i) {
                    value = aVar[i];
                    if (!value.isNumber()) continue;
                    new VarCount(value).insert(values);
                }
            }
        } else {
            Object obj = ref.getValue();
            if (obj instanceof CellBlockNode) {
                values = new SortedObjectArray();
                op.insertBlock(values, (CellBlockNode)obj);
            }
        }
        if (values == null || values.isEmpty()) {
            if (ref.isCalcLast()) {
                return ref;
            }
            ExprErr.goError((long)524288L, (Object)"");
        }
        int rank = 0;
        int iEnd = values.size();
        for (int i = 0; i < iEnd; ++i) {
            VarCount var = (VarCount)values.get(i);
            var._rank = rank += var._rank;
        }
        int pos = values.search((Object)number);
        if (pos < 0) {
            ExprErr.goError((long)524288L, (Object)"");
        }
        VarCount varRank = (VarCount)values.get(pos);
        boolean desc = true;
        if (args.length == 3) {
            desc = ((Variant)args[2]).intValue() == 0;
        }
        rank = varRank._rank;
        if (desc) {
            varRank = (VarCount)values.get(values.size() - 1);
            rank = varRank._rank - rank + 1;
        }
        return new Variant(rank);
    }

    public Variant DVAR(ExprContext ctx, Object[] args) throws SyntaxErrorException {
        Object[] data = this._dData(ctx, args);
        return this.var(data, false, true, false);
    }

    public Variant DVARP(ExprContext ctx, Object[] args) throws SyntaxErrorException {
        Object[] data = this._dData(ctx, args);
        return this.var(data, false, true, true);
    }

    public Variant DCOUNT(ExprContext ctx, Object[] args) throws SyntaxErrorException {
        Object[] data = this._dData(ctx, args);
        return this.count(data, false, true, false);
    }

    public Variant DCOUNTA(ExprContext ctx, Object[] args) throws SyntaxErrorException {
        Object[] data = this._dData(ctx, args);
        return this.count(data, false, false, false);
    }

    public Variant DMAX(ExprContext ctx, Object[] args) throws SyntaxErrorException {
        Object[] data = this._dData(ctx, args);
        return this.max(data, false, false);
    }

    public Variant DMIN(ExprContext ctx, Object[] args) throws SyntaxErrorException {
        Object[] data = this._dData(ctx, args);
        return this.min(data, false, false);
    }

    public Variant DSUM(ExprContext ctx, Object[] args) throws SyntaxErrorException {
        Object[] data = this._dData(ctx, args);
        return this.sum(data, false, false);
    }

    public Variant DPRODUCT(ExprContext ctx, Object[] args) throws SyntaxErrorException {
        Object[] data = this._dData(ctx, args);
        return this.product(data, false, false);
    }

    public Variant DAVERAGE(ExprContext ctx, Object[] args) throws SyntaxErrorException {
        Object[] data = this._dData(ctx, args);
        return this.average(data, false, false);
    }

    public Variant DSTDEV(ExprContext ctx, Object[] args) throws SyntaxErrorException {
        Object[] data = this._dData(ctx, args);
        Variant stdev = this.var(data, false, true, false);
        return this.decimalValue(Math.sqrt(stdev.doubleValue()));
    }

    public Variant DSTDEVP(ExprContext ctx, Object[] args) throws SyntaxErrorException {
        Object[] data = this._dData(ctx, args);
        Variant stdev = this.var(data, false, true, true);
        return this.decimalValue(Math.sqrt(stdev.doubleValue()));
    }

    public Variant DGET(ExprContext ctx, Object[] args) throws SyntaxErrorException {
        Variant[] data = this._dData(ctx, args);
        if (data.length == 0) {
            ExprErr.goError((long)64L, null);
        } else if (data.length > 1) {
            ExprErr.goError((long)1024L, null);
        }
        return data[0];
    }

    private Variant[] _dData(ExprContext ctx, Object[] args) throws SyntaxErrorException {
        Object[] aRet;
        ExcelFuncProvider.validParamCount(args, 3, 3);
        CellBlockNode cbData = ExcelFuncProvider.cellblockValue((Variant)args[0], null);
        Sheet sheet = cbData.getSheet();
        int width = cbData.getWidth();
        SortedObjectArray fields = new SortedObjectArray(width);
        SortedIntArray aPos = new SortedIntArray(width);
        int row = cbData.getRow();
        int col = cbData.getCol();
        int col2 = cbData.getCol2();
        Sheet.ICellsIterator ci = sheet.getCellsIterator(row, col, row, col2, false, true);
        while (ci.hasNext()) {
            Object fieldName;
            int pos;
            Cell cll = ci.next();
            Variant value = cll.getValue();
            if (!value.isString() || (pos = fields.search(fieldName = value.getValue())) >= 0) continue;
            pos = -(pos + 1);
            fields.insert(pos, fieldName);
            aPos.insert(pos, cll.getCol() - col);
        }
        if (fields.isEmpty()) {
            ExprErr.goError((long)16L, (Object)"Field Name");
        }
        int field = this._dField(fields, aPos, width, true, (Variant)args[1]);
        ObjectArray aCriteria = new ObjectArray();
        CellBlockNode cbCriteria = ExcelFuncProvider.cellblockValue((Variant)args[2], "criteria");
        int row2 = cbCriteria.getRow();
        int row22 = cbCriteria.getRow2();
        int col3 = cbCriteria.getCol();
        int col22 = cbCriteria.getCol2();
        int height = cbCriteria.getHeight();
        if (height < 2) {
            ExprErr.goError((long)64L, (Object)"criteria");
        }
        Sheet.ICellsIterator ci2 = sheet.getCellsIterator(row2, col3, row2, col22, false, true);
        while (ci2.hasNext()) {
            Cell cll = ci2.next();
            int fld = this._dField(fields, aPos, width, false, cll.getValue());
            if (fld <= -1 || fld >= width) continue;
            Object[] ors = null;
            int c = cll.getCol();
            Sheet.ICellsIterator cr = sheet.getCellsIterator(row2 + 1, c, row22, c, false, true);
            while (cr.hasNext()) {
                cll = cr.next();
                Variant value = cll.getValue();
                if (value.isString()) {
                    String formula = (String)value.getValue();
                    if (StringUtil.isEmptyString((String)formula)) continue;
                    char ch = formula.charAt(0);
                    if (ch != '=' && ch != '>' && ch != '<' && ch != '-' && ch != '+') {
                        formula = "=\"" + formula + '\"';
                    }
                    if (ors == null) {
                        ors = new Object[height];
                    }
                    ors[cll.getRow() - row2] = formula;
                    continue;
                }
                if (value.isNull()) continue;
                if (ors == null) {
                    ors = new Object[height];
                }
                ors[cll.getRow() - row2] = value;
            }
            if (ors == null) continue;
            ors[0] = ObjectCache.getInteger((int)fld);
            aCriteria.append(ors);
        }
        ObjectArray aOR = new ObjectArray();
        Expr exprEqual = null;
        ICalculable exprOwner = ctx.getExprOwner();
        if (!aCriteria.isEmpty()) {
            int andCount = aCriteria.size();
            for (int i = 1; i < height; ++i) {
                ObjectArray aAnd = null;
                for (int j = 0; j < andCount; ++j) {
                    Object[] ors = (Object[])aCriteria.get(j);
                    Object cObj = ors[i];
                    if (cObj == null) continue;
                    if (aAnd == null) {
                        aAnd = new ObjectArray();
                    }
                    aAnd.append(ors[0]);
                    if (cObj instanceof String) {
                        Expr expr = sheet.getExpr(exprOwner, "$Data$ " + cObj);
                        aAnd.append((Object)expr);
                        continue;
                    }
                    if (exprEqual == null) {
                        exprEqual = sheet.getExpr(exprOwner, "$Data$ = $Value$");
                    }
                    aAnd.append(cObj);
                }
                if (aAnd == null) continue;
                aOR.append(aAnd);
            }
        }
        ObjectArray array = new ObjectArray();
        int row3 = cbData.getRow();
        int row23 = cbData.getRow2();
        int col4 = cbData.getCol();
        int fleldCol = col4 + field;
        if (aOR.isEmpty()) {
            Sheet.ICellsIterator ci3 = sheet.getCellsIterator(row3 + 1, fleldCol, row23, fleldCol, false, true);
            while (ci3.hasNext()) {
                array.append((Object)ci3.next().getValue());
            }
        } else {
            NamedObjectNode noData = sheet.getNamedObject("$Data$", false);
            NamedObjectNode noValue = sheet.getNamedObject("$Value$", false);
            int aORCount = aOR.size();
            for (int r = row3 + 1; r <= row23; ++r) {
                Variant fldValue;
                Row rowObj = sheet.getRow(r, false);
                Cell cll = sheet.getCell(rowObj, fleldCol, false);
                if (cll == null || (fldValue = cll.getValue()).isNull()) continue;
                boolean isTrue = false;
                block7: for (int i = 0; i < aORCount; ++i) {
                    ObjectArray aAnd = (ObjectArray)aOR.get(i);
                    int jEnd = aAnd.size();
                    for (int j = 0; j < jEnd; j += 2) {
                        int fld = (Integer)aAnd.get(j);
                        cll = sheet.getCell(rowObj, col4 + fld, false);
                        Variant value = cll == null ? Variant.nullVariant : cll.getValue();
                        noData.setValue(value);
                        Expr expr = exprEqual;
                        Object obj = aAnd.get(j + 1);
                        if (obj instanceof Expr) {
                            expr = (Expr)obj;
                        } else {
                            noValue.setValue((Variant)obj);
                        }
                        if (expr != null && !expr.execute(ctx, exprOwner).booleanValue()) continue block7;
                    }
                    isTrue = true;
                    break;
                }
                if (!isTrue) continue;
                array.append((Object)fldValue);
            }
            if (noData != null) {
                sheet.getNames().remove(noData);
            }
            if (noValue != null) {
                sheet.getNames().remove(noValue);
            }
        }
        if (array.isEmpty()) {
            aRet = new Variant[]{};
        } else {
            aRet = new Variant[array.size()];
            array.toArray(aRet, 0);
        }
        return aRet;
    }

    private int _dField(SortedObjectArray fields, SortedIntArray aPos, int width, boolean bValid, Variant var) throws SyntaxErrorException {
        int field = -1;
        if (var.isString()) {
            int pos = fields.search(var.getValue());
            if (pos >= 0) {
                field = aPos.getAt(pos);
            }
        } else {
            Variant number = Variant.getNewEmptyVariant();
            if (!var.isNumeric(number) && bValid) {
                ExprErr.goError((long)16L, (Object)"Field");
            }
            field = number.intValue() - 1;
        }
        if (bValid && (field < 0 || field >= width)) {
            ExprErr.goError((long)16L, (Object)"Field");
        }
        return field;
    }

    public Variant LINEST(Object[] args) throws SyntaxErrorException {
        return new Variant((Object)this._trend(args, true, false, null), 527);
    }

    public Variant TREND(Object[] args) throws SyntaxErrorException {
        Object[] ret = new Object[1];
        Variant[] factors = this._trend(args, true, true, ret);
        ObjectArray aXs = (ObjectArray)ret[0];
        int xsCount = aXs.size();
        Object[] newXs = aXs.getArray();
        Variant m = factors[0];
        Variant b = factors[1];
        Variant[] array = new Variant[xsCount];
        for (int i = 0; i < xsCount; ++i) {
            Variant v = new Variant();
            m.multiply((Variant)newXs[i], v);
            v.add(b);
            array[i] = v;
        }
        return new Variant((Object)array, 527);
    }

    public Variant LOGEST(Object[] args) throws SyntaxErrorException {
        return new Variant((Object)this._trend(args, false, false, null), 527);
    }

    public Variant GROWTH(Object[] args) throws SyntaxErrorException {
        Object[] ret = new Object[1];
        Variant[] factors = this._trend(args, false, true, ret);
        ObjectArray aXs = (ObjectArray)ret[0];
        int xsCount = aXs.size();
        Object[] newXs = aXs.getArray();
        double dfm = factors[0].doubleValue();
        Variant b = factors[1];
        Variant[] array = new Variant[xsCount];
        for (int i = 0; i < xsCount; ++i) {
            Variant v = new Variant();
            double df = StrictMath.pow(dfm, ((Variant)newXs[i]).doubleValue());
            b.multiply(this.decimalValue(df), v);
            array[i] = v;
        }
        return new Variant((Object)array, 527);
    }

    private Variant[] _trend(Object[] args, boolean linest, boolean getData, Object[] newXs) throws SyntaxErrorException {
        ObjectArray Xs;
        ExcelFuncProvider.validParamCount(args, 1, getData ? 3 : 2);
        ObjectArray Ys = this._collectD1Numbers(args, 0, 1, 0, false);
        int len = Ys.size();
        if (len == 0) {
            ExprErr.goError((long)64L, null);
        }
        if (args.length > 1) {
            Variant var = (Variant)args[1];
            if (var.isNull()) {
                Xs = this._createDefaultXs(len, getData, newXs);
            } else {
                Xs = this._collectD1Numbers(args, 1, 2, 0, false);
                if (Xs.size() != len) {
                    ExprErr.goError((long)512L, null);
                }
                if (getData) {
                    newXs[0] = Xs;
                }
            }
            if (args.length > 2) {
                newXs[0] = this._collectD1Numbers(args, 2, 3, 0, false);
            }
        } else {
            Xs = this._createDefaultXs(len, getData, newXs);
        }
        return this._trendFactor(Ys.getArray(), Xs.getArray(), len, linest);
    }

    private ObjectArray _createDefaultXs(int len, boolean getData, Object[] newXs) {
        ObjectArray Xs = new ObjectArray(len);
        for (int i = 1; i <= len; ++i) {
            Xs.append((Object)new Variant((Object)new BigDecimal(i), 10));
        }
        if (getData) {
            newXs[0] = Xs;
        }
        return Xs;
    }

    private Variant[] _trendFactor(Object[] Ys, Object[] Xs, int count, boolean linest) throws SyntaxErrorException {
        double df;
        if (count == 1) {
            return new Variant[]{Variant.zeroVariant, (Variant)Ys[0]};
        }
        Variant X = new Variant((Object)Variant.zeroBigDecimal, 10);
        Variant Y = new Variant((Object)Variant.zeroBigDecimal, 10);
        Variant XY = new Variant((Object)Variant.zeroBigDecimal, 10);
        Variant X2 = new Variant((Object)Variant.zeroBigDecimal, 10);
        Variant y = new Variant();
        Variant x = new Variant();
        Variant x2 = new Variant();
        Variant xy = new Variant();
        for (int i = 0; i < count; ++i) {
            y = (Variant)Ys[i];
            if (!linest) {
                double df2 = y.doubleValue();
                y.setObject((Object)new BigDecimal(String.valueOf(Math.log(df2))), 10);
            }
            Y.add(y);
            x = (Variant)Xs[i];
            X.add(x);
            x.multiply(x, x2);
            X2.add(x2);
            y.multiply(x, xy);
            XY.add(xy);
        }
        Variant c = new Variant(count);
        Variant den = new Variant(X2);
        den.multiply(c);
        Variant tmp = new Variant(X);
        tmp.multiply(tmp);
        den.subtract(tmp);
        Variant m = new Variant(XY);
        m.multiply(c);
        Variant tmp2 = new Variant(X);
        tmp2.multiply(Y);
        m.subtract(tmp2);
        if (den.doubleValue() == 0.0) {
            m = new Variant((Object)Variant.zeroBigDecimal, 10);
        } else {
            m.divide(den);
            if (!linest) {
                df = Math.exp(m.doubleValue());
                m.setObject((Object)new BigDecimal(String.valueOf(df)), 10);
            }
        }
        Variant b = new Variant(Y);
        if (linest) {
            b.divide(c);
            X.divide(c);
            X.multiply(m);
            b.subtract(X);
        } else {
            b.multiply(X2);
            tmp2 = new Variant(X);
            tmp2.multiply(XY);
            b.subtract(tmp2);
            b.divide(den);
            df = Math.exp(b.doubleValue());
            b.setObject((Object)new BigDecimal(String.valueOf(df)), 10);
        }
        return new Variant[]{m, b};
    }

    public Variant MINVERSE(Variant array) throws SyntaxErrorException {
        int n;
        Variant[][] src = ExcelFuncProvider.collectD2Numbers(array, false);
        if (src[0].length != (n = src.length)) {
            ExprErr.goError((long)16L, (Object)"Not Square");
        }
        Variant[][] result = new Variant[n][n];
        for (int i = 0; i < n; ++i) {
            int j;
            Variant[] line = result[i];
            for (j = 0; j < i; ++j) {
                line[j] = new Variant(Variant.zeroVariant);
            }
            line[i] = new Variant(Variant.oneVariant);
            for (j = i + 1; j < n; ++j) {
                line[j] = new Variant(Variant.zeroVariant);
            }
        }
        this._calCol(src, result, 0);
        this._calColBack(src, result, n - 1);
        this._reInit(src, result);
        Variant[] vars = new Variant[n];
        for (int i = 0; i < n; ++i) {
            vars[i] = new Variant((Object)result[i], 527);
        }
        return new Variant((Object)vars, 527);
    }

    public Variant MMULT(Variant array1, Variant array2) throws SyntaxErrorException {
        Variant[][] a2;
        Variant[][] a1 = ExcelFuncProvider.collectD2Numbers(array1, false);
        int a1Cols = a1[0].length;
        if (a1Cols != (a2 = ExcelFuncProvider.collectD2Numbers(array2, false)).length) {
            ExprErr.goError((long)64L, null);
        }
        int rows = a1.length;
        int cols = a2[0].length;
        Variant[][] result = new Variant[rows][cols];
        Variant v = new Variant();
        for (int i = 0; i < rows; ++i) {
            Variant[] a1Line = a1[i];
            Variant[] resultLine = result[i];
            for (int j = 0; j < cols; ++j) {
                Variant sum = new Variant(Variant.zeroVariant);
                for (int k = 0; k < a1Cols; ++k) {
                    a1Line[k].multiply(a2[k][j], v);
                    sum.add(v);
                }
                resultLine[j] = sum;
            }
        }
        Variant[] vars = new Variant[rows];
        for (int i = 0; i < rows; ++i) {
            vars[i] = new Variant((Object)result[i], 527);
        }
        return new Variant((Object)vars, 527);
    }

    private void _calCol(Variant[][] src, Variant[][] result, int col) throws SyntaxErrorException {
        Variant[] srcLineCol = src[col];
        Variant[] resultLineCol = result[col];
        int n = src.length;
        Variant coefficient = new Variant();
        Variant v = new Variant();
        for (int i = col + 1; i < n; ++i) {
            Variant[] srcLineI = src[i];
            srcLineI[col].negate(coefficient);
            coefficient.divide(srcLineCol[col]);
            Variant[] resultLineI = result[i];
            for (int z = 0; z < n; ++z) {
                coefficient.multiply(srcLineCol[z], v);
                srcLineI[z].add(v);
                coefficient.multiply(resultLineCol[z], v);
                resultLineI[z].add(v);
            }
        }
        if (col + 1 < n) {
            this._calCol(src, result, col + 1);
        }
    }

    private void _calColBack(Variant[][] src, Variant[][] result, int col) throws SyntaxErrorException {
        Variant[] srcLineCol = src[col];
        Variant[] resultLineCol = result[col];
        int n = src.length;
        Variant coefficient = new Variant();
        Variant v = new Variant();
        for (int i = col - 1; i > -1; --i) {
            Variant[] srcLineI = src[i];
            srcLineI[col].negate(coefficient);
            coefficient.divide(srcLineCol[col]);
            Variant[] resultLineI = result[i];
            for (int z = 0; z < n; ++z) {
                coefficient.multiply(srcLineCol[z], v);
                srcLineI[z].add(v);
                coefficient.multiply(resultLineCol[z], v);
                resultLineI[z].add(v);
            }
        }
        if (col > 0) {
            this._calColBack(src, result, col - 1);
        }
    }

    private void _reInit(Variant[][] src, Variant[][] result) throws SyntaxErrorException {
        Variant coefficient = new Variant();
        int n = src.length;
        for (int i = 0; i < n; ++i) {
            Variant.oneVariant.divide(src[i][i], coefficient);
            Variant[] resultLineI = result[i];
            for (int j = 0; j < n; ++j) {
                resultLineI[j].multiply(coefficient);
            }
        }
    }

    public Variant IFERROR(Variant value, Variant value_iferror) throws SyntaxErrorException {
        if (value.isError()) {
            return value_iferror;
        }
        return value;
    }

    private int _rowcolValue(ExprContext ctx, Variant var, Variant result, String msg) throws SyntaxErrorException {
        this.numberValue(ctx, var, result, msg);
        int v = result.intValue() - 1;
        if (v < -1) {
            ExprErr.goError((long)64L, (Object)msg);
        }
        return v;
    }

    public Variant numberValue(ExprContext ctx, Variant var, Variant result, String msg) throws SyntaxErrorException {
        if (!(var = this.execute(ctx, var)).isNumeric(result)) {
            ExprErr.goError((long)16L, (Object)msg);
        }
        return result;
    }

    public Variant numberValue(ExprContext ctx, Variant var, String msg) throws SyntaxErrorException {
        return this.numberValue(ctx, var, new Variant(), msg);
    }

    private Variant _getArrayDataFromBlock(CellBlockNode cb, int row, int col, int row2, int col2) throws SyntaxErrorException {
        Variant result;
        if (col == -1) {
            if (row == -1) {
                result = cb.getVarThis();
            } else {
                if (cb.getHeight() <= row) {
                    ExprErr.goError((long)512L, (Object)"rowIndex");
                }
                CellBlockNode block = (CellBlockNode)cb.clone();
                block.setRow(row + cb.getRow());
                block.setRow2(row2 + cb.getRow());
                result = block.getVarThis();
            }
        } else if (row == -1) {
            if (cb.getWidth() <= col) {
                ExprErr.goError((long)512L, (Object)"colIndex");
            }
            CellBlockNode block = (CellBlockNode)cb.clone();
            block.setCol(col + cb.getCol());
            block.setCol2(col2 + cb.getCol());
            result = block.getVarThis();
        } else {
            int size = cb.getHeight();
            if (size <= row || size <= row2) {
                ExprErr.goError((long)512L, (Object)"rowIndex");
            } else {
                size = cb.getWidth();
                if (size <= col || size <= col2) {
                    ExprErr.goError((long)512L, (Object)"colIndex");
                }
            }
            int baseRow = cb.getRow();
            int baseCol = cb.getCol();
            if (row == row2 && col == col2) {
                Cell cll = cb.getSheet().getCell(baseRow + row, baseCol + col, false);
                result = cll == null ? Variant.nullVariant : cll.getValue();
            } else {
                CellBlockNode block = (CellBlockNode)cb.clone();
                block.setRowCol(baseRow + row, baseCol + col, baseRow + row2, baseCol + col2);
                result = block.getVarThis();
            }
        }
        return result;
    }

    private Variant _getArrayData(Variant varSrc, Variant[] array, int row, int col) throws SyntaxErrorException {
        Variant result;
        if (col == -1) {
            if (row == -1) {
                result = varSrc;
            } else {
                if (array.length <= row) {
                    ExprErr.goError((long)512L, (Object)"rowIndex");
                }
                result = array[row];
            }
        } else if (row == -1) {
            Variant[] dstArray = new Variant[array.length];
            for (int r = 0; r < array.length; ++r) {
                Variant varRow = array[r];
                if (varRow.isArray()) {
                    Variant[] rowArray = (Variant[])varRow.getValue();
                    if (rowArray.length <= col) {
                        ExprErr.goError((long)512L, (Object)"dataArray");
                    }
                    dstArray[r] = rowArray[col];
                    continue;
                }
                if (col != 0) {
                    ExprErr.goError((long)512L, (Object)"colIndex");
                }
                dstArray[r] = varRow;
            }
            result = new Variant((Object)dstArray, 527);
        } else {
            Variant varRow;
            if (array.length <= row) {
                ExprErr.goError((long)512L, (Object)"rowIndex");
            }
            if ((varRow = array[row]).isArray()) {
                Variant[] rowArray = (Variant[])varRow.getValue();
                if (rowArray.length <= col) {
                    ExprErr.goError((long)512L, (Object)"dataArray");
                }
                result = rowArray[col];
            } else {
                if (col != 0) {
                    ExprErr.goError((long)512L, (Object)"colIndex");
                }
                result = varRow;
            }
        }
        return result;
    }

    private Variant execute(ExprContext ctx, Variant variant) {
        Object value = variant.getValue();
        if (value instanceof Expr) {
            Expr expr = (Expr)value;
            return expr.execute(ctx, ctx.getExprOwner());
        }
        return variant;
    }

    public Variant INDEX(ExprContext ctx, Object[] args) throws SyntaxErrorException {
        Variant varSrc;
        Object obj;
        int row2;
        ExcelFuncProvider.validParamCount(args, 2, 6);
        Variant result = Variant.getNewEmptyVariant();
        int col = -1;
        int col2 = -1;
        int area = -1;
        int row = row2 = this._rowcolValue(ctx, (Variant)args[1], result, "rowIndex");
        if (args.length > 2) {
            col = col2 = this._rowcolValue(ctx, (Variant)args[2], result, "colIndex");
            if (args.length > 3) {
                Variant var = this.execute(ctx, (Variant)args[3]);
                if (!var.isNull()) {
                    if (!var.isNumeric(result)) {
                        ExprErr.goError((long)16L, (Object)"areaIndex");
                    }
                    if ((area = result.intValue() - 1) < 0) {
                        ExprErr.goError((long)64L, (Object)"areaIndex");
                    }
                }
                if (args.length > 4) {
                    row2 = this._rowcolValue(ctx, (Variant)args[4], result, "rowIndex");
                    if (args.length > 5) {
                        col2 = this._rowcolValue(ctx, (Variant)args[5], result, "colIndex");
                    }
                }
            }
        }
        if (row > row2 || col > col2 || row == -1 && row2 != -1 || col == -1 && col2 != -1) {
            ExprErr.goError((long)64L, (Object)"rowcolIndex");
        }
        if ((obj = (varSrc = this.execute(ctx, (Variant)args[0]).getVariant()).getValue()) instanceof CellBlockNode && (varSrc.isReferences() || varSrc.isObject())) {
            if (area > -1) {
                ExprErr.goError((long)64L, (Object)"areaIndex");
            }
            result = this._getArrayDataFromBlock((CellBlockNode)obj, row, col, row2, col2);
        } else if (varSrc.isArray()) {
            Object[] array = (Variant[])obj;
            if (varSrc.isD2Array()) {
                result = this._getArrayData(varSrc, (Variant[])array, row, col);
            } else {
                boolean isArea = false;
                if (area > -1) {
                    if (array.length <= area) {
                        ExprErr.goError((long)512L, (Object)"areaIndex");
                    }
                    Variant varArea = array[area];
                    obj = varArea.getValue();
                    if (varArea.isReferences() && obj instanceof CellBlockNode) {
                        varSrc = varArea;
                        isArea = true;
                    } else if (area != 0) {
                        ExprErr.goError((long)512L, null);
                    }
                }
                if (isArea) {
                    result = this._getArrayDataFromBlock((CellBlockNode)obj, row, col, row2, col2);
                } else {
                    int index2;
                    int index;
                    if (col < 0) {
                        index = row;
                        index2 = row2;
                    } else {
                        if (row > 0 || row2 > 0) {
                            ExprErr.goError((long)512L, null);
                        }
                        index = col;
                        index2 = col2;
                    }
                    if (index >= array.length || index2 >= array.length) {
                        ExprErr.goError((long)512L, null);
                    }
                    if (index != index2) {
                        Object[] a = new Variant[index2 - index + 1];
                        KDToolkit.arraycopy((Object[])array, (int)index, (Object[])a, (int)0, (int)a.length);
                        result = new Variant((Object)a, 527);
                    } else {
                        result = array[index];
                    }
                }
            }
        } else {
            int index2;
            int index;
            if (varSrc.isError()) {
                throw (SyntaxErrorException)((Object)varSrc.getValue());
            }
            if (col < 0) {
                index = row;
                index2 = row2;
            } else {
                if (row > 0 || row2 > 0) {
                    ExprErr.goError((long)512L, null);
                }
                index = col;
                index2 = col2;
            }
            if (index >= 1 || index2 >= 1) {
                ExprErr.goError((long)512L, null);
            }
            result = varSrc;
        }
        return result;
    }

    public Variant INDIRECT(ExprContext ctx, Object[] args) throws SyntaxErrorException {
        ExcelFuncProvider.validParamCount(args, 1, 1);
        Object param = ((Variant)args[0]).getValue();
        Variant ret = null;
        ICalculable owner = ctx.getExprOwner();
        if (param instanceof CellBlockNode) {
            CellBlockNode cbn = (CellBlockNode)param;
            Cell cll = cbn.getSheet().getCell(cbn.getRow(), cbn.getCol(), false);
            ret = owner.getSheet().getExpr(owner, cll.getValue().toString()).execute(ctx, owner);
        } else if (param instanceof String) {
            ret = owner.getSheet().getExpr(owner, (String)param).execute(ctx, owner);
        }
        if (ret != null && (ret.isPending() || ret.isCalcLast())) {
            throw SyntaxErrorException.CALC_LAST;
        }
        return ret;
    }

    private void _insertBlock(SortedObjectArray array, CellBlockNode cb) {
        Sheet.ICellsIterator i = cb.getCellsIterator(false, true);
        while (i.hasNext()) {
            Variant value = i.next().getValue();
            array.insert((Object)value);
        }
    }

    private void _collectBlock(ObjectArray array, CellBlockNode cb) {
        Sheet.ICellsIterator i = cb.getCellsIterator(false, true);
        while (i.hasNext()) {
            Variant value = i.next().getValue();
            array.append((Object)value);
        }
    }

    public Variant MATCH(ExprContext ctx, Object[] args) throws SyntaxErrorException {
        int pos;
        ExcelFuncProvider.validParamCount(args, 2, 3);
        Variant lookup = (Variant)args[0];
        int matchType = 1;
        if (args.length == 3) {
            Variant type = (Variant)args[2];
            ExcelFuncProvider.validNumericParam("value", type);
            matchType = type.intValue();
        }
        Variant ref = (Variant)args[1];
        if (matchType != 0) {
            SortedObjectArray values = null;
            if (values == null) {
                if (ref.isCalcLast()) {
                    return ref;
                }
                values = new SortedObjectArray();
                if (ref.isArray()) {
                    Variant[] aVar = (Variant[])ref.getValue();
                    if (aVar[0].getValue() instanceof CellBlockNode) {
                        for (int i = 0; i < aVar.length; ++i) {
                            Variant value = aVar[i];
                            this._insertBlock(values, (CellBlockNode)value.getValue());
                        }
                    } else {
                        for (int i = 0; i < aVar.length; ++i) {
                            Variant value = aVar[i];
                            values.insert((Object)value);
                        }
                    }
                } else {
                    Object obj = ref.getValue();
                    if (obj instanceof CellBlockNode) {
                        this._insertBlock(values, (CellBlockNode)obj);
                    } else {
                        values.insert((Object)ref);
                    }
                }
                if (values == null || values.isEmpty()) {
                    ExprErr.goError((long)524288L, (Object)"");
                }
            }
            if ((pos = values.search((Object)lookup)) < 0) {
                boolean bError = false;
                pos = -(pos + 1);
                if (matchType > 0) {
                    bError = --pos < 0;
                } else {
                    boolean bl = bError = pos >= values.size();
                }
                if (bError) {
                    ExprErr.goError((long)524288L, (Object)"");
                }
            }
        } else {
            if (ref.isCalcLast()) {
                return ref;
            }
            ObjectArray values = new ObjectArray();
            values = new SortedObjectArray();
            if (ref.isArray()) {
                Variant value;
                int i;
                Variant[] aVar = (Variant[])ref.getValue();
                if (aVar[0].getValue() instanceof CellBlockNode) {
                    for (i = 0; i < aVar.length; ++i) {
                        value = aVar[i];
                        this._collectBlock(values, (CellBlockNode)value.getValue());
                    }
                } else {
                    for (i = 0; i < aVar.length; ++i) {
                        value = aVar[i];
                        values.append((Object)value);
                    }
                }
            } else {
                Object obj = ref.getValue();
                if (obj instanceof CellBlockNode) {
                    this._collectBlock(values, (CellBlockNode)obj);
                } else {
                    values.append((Object)ref);
                }
            }
            pos = -1;
            int iEnd = values.size();
            for (int i = 0; i < iEnd; ++i) {
                if (!values.get(i).equals(lookup)) continue;
                pos = i;
                break;
            }
            if (pos < 0) {
                ExprErr.goError((long)524288L, (Object)"");
            }
        }
        return new Variant((Object)ObjectCache.getInteger((int)(pos + 1)), 3);
    }

    public Variant CHAR(ExprContext ctx, Object[] args) throws SyntaxErrorException {
        ExcelFuncProvider.validParamCount(args, 1, 1);
        Variant ret = (Variant)args[0];
        Object param = ret.getValue();
        ICalculable owner = ctx.getExprOwner();
        if (param instanceof CellBlockNode) {
            Expr expr;
            CellBlockNode cbn = (CellBlockNode)param;
            Cell cll = cbn.getSheet().getCell(cbn.getRow(), cbn.getCol(), false);
            if (cll == null) {
                ExprErr.goError((long)64L, (Object)"");
            }
            if ((expr = owner.getSheet().getExpr(owner, cll.getValue().toString())) == null) {
                ExprErr.goError((long)64L, (Object)"");
            }
            ret = expr.execute(ctx, owner);
        }
        try {
            int intValue = ret.intValue();
            if (intValue > 255 || intValue < 1) {
                ExprErr.goError((long)64L, (Object)"");
            }
            return new Variant((Object)Character.valueOf((char)intValue), 7);
        }
        catch (Exception e) {
            ExprErr.goError((long)64L, (Object)"");
            return null;
        }
    }

    public Variant COLUMNS(ExprContext ctx, Object[] args) throws SyntaxErrorException {
        ExcelFuncProvider.validParamCount(args, 1, 1);
        Variant var = (Variant)args[0];
        Object value = var.getValue();
        if (value instanceof CellBlock) {
            CellBlock cb = (CellBlock)value;
            return this.decimalValue(cb.getCol2() + 1);
        }
        if (value.getClass().isArray()) {
            Object[] objs = (Object[])value;
            return this.decimalValue(objs.length);
        }
        ExprErr.goError((long)64L, (Object)"");
        return null;
    }

    static boolean isSingleByte(byte ch) {
        return ch >= 0 && ch <= 255;
    }

    static Variant stringBOP(Variant varStr, Variant varCount, String strOP) throws SyntaxErrorException {
        int j;
        String str = varStr.toString();
        Variant rvarResult = Variant.getNewEmptyVariant();
        ExcelFuncProvider.validNumericParam("count", varCount);
        int iChars = (int)varCount.doubleValue();
        byte[] b = str.getBytes();
        if (iChars >= b.length) {
            return varStr;
        }
        byte[] temp = new byte[2];
        String result = "";
        int i = 0;
        boolean isLeftStart = "left".equalsIgnoreCase(strOP);
        int n = j = isLeftStart ? 0 : b.length - 1;
        while (i < iChars) {
            byte nextByte;
            byte currentByte = b[j];
            byte by = nextByte = isLeftStart ? b[j + 1] : b[j - 1];
            if (ExcelFuncProvider.isSingleByte(currentByte)) {
                result = result + (char)currentByte;
                ++i;
                j = isLeftStart ? ++j : --j;
            } else if (i + 1 < iChars && !ExcelFuncProvider.isSingleByte(nextByte)) {
                if (isLeftStart) {
                    temp[0] = currentByte;
                    temp[1] = nextByte;
                    j += 2;
                } else {
                    temp[0] = nextByte;
                    temp[1] = currentByte;
                    j -= 2;
                }
                i += 2;
                result = result + new String(temp);
            }
            if (i + 1 != iChars || ExcelFuncProvider.isSingleByte(b[j])) continue;
            break;
        }
        if (result.length() > 1 && !isLeftStart) {
            result = new StringBuilder(result).reverse().toString();
        }
        rvarResult.setObject((Object)result, 11);
        return rvarResult;
    }

    public Variant LEFTB(Variant value, Variant count) throws SyntaxErrorException {
        return ExcelFuncProvider.stringBOP(value, count, "left");
    }

    public Variant RIGHTB(Variant value, Variant count) throws SyntaxErrorException {
        return ExcelFuncProvider.stringBOP(value, count, "right");
    }

    public Variant OFFSET(ExprContext ctx, Object[] args) throws SyntaxErrorException {
        ExcelFuncProvider.validParamCount(args, 3, 5);
        Variant ref = (Variant)args[0];
        Variant rows = (Variant)args[1];
        Variant cols = (Variant)args[2];
        Object value = ref.getValue();
        try {
            CellBlockNode cb = (CellBlockNode)value;
            int iHeight = cb.getRow2() - cb.getRow();
            int iWidth = cb.getCol2() - cb.getCol();
            if (args.length >= 4 && (iHeight = ((Variant)args[3]).intValue() - 1) < 0) {
                ExprErr.goError((long)64L, (Object)"");
            }
            if (args.length >= 5 && (iWidth = ((Variant)args[4]).intValue() - 1) < 0) {
                ExprErr.goError((long)64L, (Object)"");
            }
            int rowOffset = rows.intValue();
            int colOffset = cols.intValue();
            CellBlockNode cbNode = CellBlockNode.getNewBlock(cb.getSheet(), cb.getRow() + rowOffset, cb.getCol() + colOffset, cb.getRow() + rowOffset + iHeight, cb.getCol() + colOffset + iWidth, 15);
            return cbNode.getValue();
        }
        catch (Exception e) {
            ExprErr.goError((long)64L, (Object)"");
            return null;
        }
    }

    public Variant NPV(ExprContext ctx, Object[] args) throws SyntaxErrorException {
        int i;
        ExcelFuncProvider.validParamCount(args, 2, 255);
        Variant result = this.decimalValue(0.0);
        Variant rate = new Variant();
        ((Variant)args[0]).add(new Variant(1), rate);
        ArrayList<Variant> argsList = new ArrayList<Variant>();
        for (i = 1; i < args.length; ++i) {
            Object obj = ((Variant)args[i]).getValue();
            if (obj instanceof CellBlockNode) {
                CellBlockNode cb = (CellBlockNode)obj;
                Sheet sheet = cb.getSheet();
                Sheet.ICellsIterator it = sheet.getCellsIterator(cb, false, true);
                while (it.hasNext()) {
                    Cell cell = it.next();
                    if (!cell.getValue().isNumeric()) {
                        ExprErr.goError((long)0x400000L, (Object)"Param is not all number");
                    }
                    argsList.add(cell.getValue().getCopy());
                }
                continue;
            }
            if (!(args[i] instanceof Variant)) continue;
            if (!((Variant)args[i]).isNumeric()) {
                ExprErr.goError((long)0x400000L, (Object)"Param is not all number");
            }
            argsList.add(((Variant)args[i]).getCopy());
        }
        for (i = 0; i < argsList.size(); ++i) {
            Variant value = (Variant)argsList.get(i);
            Variant denominator = new Variant();
            rate.pow(new Variant(i + 1), denominator);
            result = result.add(value.divide(denominator));
        }
        return result;
    }

    public Variant IRR(ExprContext ctx, Object[] args) throws SyntaxErrorException {
        double x0;
        int i;
        ExcelFuncProvider.validParamCount(args, 1, 255);
        Variant guess = null;
        if (args.length > 1 && args[args.length - 1] instanceof Variant) {
            guess = (Variant)args[args.length - 1];
            ExcelFuncProvider.validNumericParam("guess", guess);
        }
        ObjectArray oa = ctx.getObjectArray(-1);
        ArrayList<Variant> argsList = new ArrayList<Variant>();
        int length = args.length;
        if (null != guess) {
            --length;
        }
        for (int i2 = 0; i2 < length; ++i2) {
            ExcelFuncProvider.platValues(oa, (Variant)args[i2]);
        }
        int valueCount = oa.size();
        for (i = 0; i < valueCount; ++i) {
            Variant v = (Variant)oa.get(i);
            if (!v.isNumeric()) continue;
            argsList.add(v);
        }
        double d = x0 = null == guess ? 0.1 : guess.doubleValue();
        for (i = 0; i < 20; ++i) {
            double fValue = 0.0;
            double fDerivative = 0.0;
            for (int k = 0; k < argsList.size(); ++k) {
                fValue += ((Variant)argsList.get(k)).doubleValue() / Math.pow(1.0 + x0, k);
                fDerivative += (double)(-k) * ((Variant)argsList.get(k)).doubleValue() / Math.pow(1.0 + x0, (double)k + 1.0);
            }
            if (fDerivative == 0.0) {
                ctx.recycleArray(oa);
                break;
            }
            double x1 = x0 - fValue / fDerivative;
            if (Math.abs(x1 - x0) <= 1.0E-7) {
                return new Variant(x1);
            }
            x0 = x1;
        }
        ctx.recycleArray(oa);
        ExprErr.goError((long)4L, null);
        return null;
    }

    private double _npv(double rate, double[] values, int valueCount) throws SyntaxErrorException {
        double result = 0.0;
        double rolledRate = rate;
        for (int i = 1; i < valueCount; ++i) {
            result += values[i] / rolledRate;
            rolledRate *= rate;
        }
        return result;
    }

    public static void platValues(ObjectArray al, Variant var) {
        Object value = var.getValue();
        if (var.isArray()) {
            Variant[] array = (Variant[])value;
            for (int i = 0; i < array.length; ++i) {
                ExcelFuncProvider.platValues(al, array[i]);
            }
        } else if (var.isReferences()) {
            if (value instanceof CellBlockNode) {
                if (value instanceof CellBlock3DNode) {
                    CellBlock3DNode cb3 = (CellBlock3DNode)value;
                    Book book = cb3.getSheet().getBook();
                    int iEnd = cb3.getSheet2().getSheetIndex() + 1;
                    for (int i = cb3.getSheet().getSheetIndex(); i < iEnd; ++i) {
                        Sheet sheet = book.getSheet(i);
                        Sheet.ICellsIterator ci = sheet.getCellsIterator(cb3, false, true);
                        while (ci.hasNext()) {
                            al.append((Object)ci.next().getValue());
                        }
                    }
                } else {
                    Sheet.ICellsIterator ci = ((CellBlockNode)value).getCellsIterator(false, true);
                    while (ci.hasNext()) {
                        al.append((Object)ci.next().getValue());
                    }
                }
            } else {
                ExcelFuncProvider.platValues(al, ((IVarReferences)value).getValue());
            }
        } else if (var.isObject()) {
            if (value instanceof ExtGroup) {
                ExtGroup group = (ExtGroup)value;
                al.appendAll((Object[])group.getValues());
            } else {
                al.append((Object)var);
            }
        } else {
            al.append((Object)var);
        }
    }

    public Variant ROUNDUP(Variant value, Variant digit) throws SyntaxErrorException {
        ExcelFuncProvider.validNumericParam("value", value);
        ExcelFuncProvider.validNumericParam("digit", digit);
        BigDecimal bd = value.toBigDecimal();
        int iDigit = (int)digit.doubleValue();
        if (iDigit >= 0) {
            return new Variant((Object)bd.setScale(digit.intValue(), 0), 10);
        }
        BigDecimal newValue = bd.setScale(0, 0);
        BigDecimal pow = new BigDecimal(StrictMath.pow(10.0, -iDigit));
        newValue = newValue.divide(pow, 0, 0);
        newValue = newValue.multiply(pow);
        return new Variant((Object)newValue, 10);
    }

    public Variant ROUNDDOWN(Variant value, Variant digit) throws SyntaxErrorException {
        ExcelFuncProvider.validNumericParam("value", value);
        ExcelFuncProvider.validNumericParam("digit", digit);
        BigDecimal bd = value.toBigDecimal();
        int iDigit = (int)digit.doubleValue();
        if (iDigit >= 0) {
            if (bd.scale() > 15) {
                Variant varTmp = new Variant((Object)bd.setScale(15, 4), 10);
                bd = (BigDecimal)varTmp.getValue();
            }
            return new Variant((Object)bd.setScale(digit.intValue(), 1), 10);
        }
        BigDecimal newValue = bd.setScale(0, 1);
        BigDecimal pow = new BigDecimal(StrictMath.pow(10.0, -iDigit));
        newValue = newValue.divide(pow, 0, 1);
        newValue = newValue.multiply(pow);
        return new Variant((Object)newValue, 10);
    }

    public Variant IN(ExprContext ctx, Object[] args) throws SyntaxErrorException {
        ExcelFuncProvider.validParamCount(args, 2, args.length);
        boolean pass = false;
        Object value = args[0];
        for (int i = 1; i < args.length; ++i) {
            Variant var = (Variant)args[i];
            ArrayList<String> criterias = new ArrayList<String>();
            if (var.getValue() instanceof CellBlockNode) {
                CellBlockNode node = (CellBlockNode)var.getValue();
                Sheet.ICellsIterator iterator = node.getCellsIterator(true, true);
                while (iterator.hasNext()) {
                    Cell cell = iterator.next();
                    if (!cell.isHasValue()) continue;
                    criterias.add(cell.getValue().toString());
                }
            } else {
                criterias.add(var.getValue().toString());
            }
            for (String criteria : criterias) {
                if (!StringUtil.isEmptyString((String)criteria)) {
                    char ch = criteria.charAt(0);
                    if (ch != '=' && ch != '>' && ch != '<' && ch != '-' && ch != '+') {
                        criteria = "=\"" + criteria.toLowerCase() + '\"';
                    }
                } else {
                    criteria = "=";
                }
                String formula = "=\"" + value.toString() + '\"' + criteria;
                Expr expr = ctx.getExprOwner().getSheet().getExpr(null, formula);
                Variant cond = expr.execute(ctx, null);
                if (cond.isPending()) {
                    throw (SyntaxErrorException)((Object)cond.getValue());
                }
                if (!cond.booleanValue()) continue;
                pass = true;
                break;
            }
            if (pass) break;
        }
        return pass ? Variant.trueVariant : Variant.falseVariant;
    }

    public Variant REGEX(Variant value, Variant pattern) throws SyntaxErrorException {
        String valueStr = value.toString();
        String patternStr = pattern.toString();
        if (StringUtil.isEmptyString((String)patternStr)) {
            ExprErr.goError((long)16L, (Object)"pattern parma must not null");
        }
        if (null == valueStr) {
            valueStr = "";
        }
        if (valueStr.matches(patternStr)) {
            return Variant.trueVariant;
        }
        return Variant.falseVariant;
    }

    private boolean isRegex(String str) {
        char ch = str.charAt(0);
        if (ch == '=' || ch == '<' || ch == '>' || ch == '!' || str.indexOf(42) == -1 && str.indexOf(63) == -1) {
            return false;
        }
        try {
            Pattern.compile(str);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private String transfer2ExcelRegex(String pattern) {
        return pattern.replace("*", "[\\S\\s]*").replace("?", "[\\S\\s]?");
    }

    public Variant PMT(Object[] args) throws SyntaxErrorException {
        ExcelFuncProvider.validParamCount(args, 3, 5);
        BigDecimal pmt = null;
        try {
            BigDecimal type;
            int argCount = args.length;
            BigDecimal rate = ExcelFuncProvider.getNumericParam("rate", (Variant)args[0]);
            if (rate.compareTo(BigDecimal.valueOf(-1L)) == 0) {
                String errMsg = "Parameter [rate] = " + rate.toString() + " ERROR NUMBER";
                ExprErr.goError((long)16L, (Object)errMsg);
            }
            BigDecimal nper = ExcelFuncProvider.getNumericParam("nper", (Variant)args[1]);
            BigDecimal pv = ExcelFuncProvider.getNumericParam("pv", (Variant)args[2]);
            BigDecimal fv = argCount > 3 ? ExcelFuncProvider.getNumericParam("fv", (Variant)args[3]) : BigDecimal.valueOf(0L);
            BigDecimal bigDecimal = type = argCount > 4 && ExcelFuncProvider.getNumericParam("type", (Variant)args[4]).compareTo(BigDecimal.valueOf(0L)) != 0 ? BigDecimal.valueOf(1L) : BigDecimal.valueOf(0L);
            if (rate.compareTo(BigDecimal.valueOf(0L)) == 0) {
                pmt = BigDecimal.valueOf(0L).subtract(fv).subtract(pv).divide(nper, 15, 4);
            } else {
                double drate = rate.doubleValue();
                double dnper = nper.doubleValue();
                BigDecimal pow = BigDecimal.valueOf(StrictMath.pow(1.0 + drate, dnper));
                pmt = BigDecimal.valueOf(0L).subtract(fv).subtract(pv.multiply(pow)).divide(BigDecimal.valueOf(1L).add(rate.multiply(type)).multiply(pow.subtract(BigDecimal.valueOf(1L))).divide(rate, 15, 4), 15, 4);
            }
        }
        catch (Exception e) {
            ExprErr.goError((long)64L, (Object)MultiLanguageKeys.getLocalText("notSupportCalculationWithUnknownDataType", "\u4e0d\u652f\u6301\u672a\u77e5\u6570\u636e\u7c7b\u578b\u7684\u8fd0\u7b97"));
        }
        return new Variant(pmt, 10);
    }

    public Variant PV(Object[] args) throws SyntaxErrorException {
        ExcelFuncProvider.validParamCount(args, 3, 5);
        BigDecimal pv = null;
        try {
            BigDecimal type;
            int argCount = args.length;
            BigDecimal rate = ExcelFuncProvider.getNumericParam("rate", (Variant)args[0]);
            if (rate.compareTo(BigDecimal.valueOf(-1L)) == 0) {
                String errMsg = "Parameter [rate] = " + rate.toString() + " ERROR NUMBER";
                ExprErr.goError((long)16L, (Object)errMsg);
            }
            BigDecimal nper = ExcelFuncProvider.getNumericParam("nper", (Variant)args[1]);
            BigDecimal pmt = ExcelFuncProvider.getNumericParam("pmt", (Variant)args[2]);
            BigDecimal fv = argCount > 3 ? ExcelFuncProvider.getNumericParam("fv", (Variant)args[3]) : BigDecimal.valueOf(0L);
            BigDecimal bigDecimal = type = argCount > 4 && ExcelFuncProvider.getNumericParam("type", (Variant)args[4]).compareTo(BigDecimal.valueOf(0L)) != 0 ? BigDecimal.valueOf(1L) : BigDecimal.valueOf(0L);
            if (rate.compareTo(BigDecimal.valueOf(0L)) == 0) {
                pv = BigDecimal.valueOf(0L).subtract(fv).subtract(pmt.multiply(nper));
            } else {
                double drate = rate.doubleValue();
                double dnper = nper.doubleValue();
                BigDecimal pow = BigDecimal.valueOf(StrictMath.pow(1.0 + drate, dnper));
                pv = BigDecimal.valueOf(0L).subtract(fv).subtract(pmt.multiply(BigDecimal.valueOf(1L).add(rate.multiply(type)).multiply(pow.subtract(BigDecimal.valueOf(1L))).divide(rate, 15, 4))).divide(pow, 15, 4);
            }
        }
        catch (Exception e) {
            ExprErr.goError((long)64L, (Object)MultiLanguageKeys.getLocalText("notSupportCalculationWithUnknownDataType", "\u4e0d\u652f\u6301\u672a\u77e5\u6570\u636e\u7c7b\u578b\u7684\u8fd0\u7b97"));
        }
        return new Variant(pv, 10);
    }

    public Variant FV(Object[] args) throws SyntaxErrorException {
        ExcelFuncProvider.validParamCount(args, 3, 5);
        BigDecimal fv = null;
        try {
            BigDecimal type;
            int argCount = args.length;
            BigDecimal rate = ExcelFuncProvider.getNumericParam("rate", (Variant)args[0]);
            if (rate.compareTo(BigDecimal.valueOf(-1L)) == 0) {
                String errMsg = "Parameter [rate] = " + rate.toString() + " ERROR NUMBER";
                ExprErr.goError((long)16L, (Object)errMsg);
            }
            BigDecimal nper = ExcelFuncProvider.getNumericParam("nper", (Variant)args[1]);
            BigDecimal pmt = ExcelFuncProvider.getNumericParam("pmt", (Variant)args[2]);
            BigDecimal pv = argCount > 3 ? ExcelFuncProvider.getNumericParam("pv", (Variant)args[3]) : BigDecimal.valueOf(0L);
            BigDecimal bigDecimal = type = argCount > 4 && ExcelFuncProvider.getNumericParam("type", (Variant)args[4]).compareTo(BigDecimal.valueOf(0L)) != 0 ? BigDecimal.valueOf(1L) : BigDecimal.valueOf(0L);
            if (rate.compareTo(BigDecimal.valueOf(0L)) == 0) {
                fv = BigDecimal.valueOf(0L).subtract(pv).subtract(pmt.multiply(nper));
            } else {
                double drate = rate.doubleValue();
                double dnper = nper.doubleValue();
                BigDecimal pow = BigDecimal.valueOf(StrictMath.pow(1.0 + drate, dnper));
                fv = BigDecimal.valueOf(0L).subtract(pmt.multiply(BigDecimal.valueOf(1L).add(rate.multiply(type)).multiply(pow.subtract(BigDecimal.valueOf(1L))).divide(rate, 15, 4))).subtract(pv.multiply(pow));
            }
        }
        catch (Exception e) {
            ExprErr.goError((long)64L, (Object)MultiLanguageKeys.getLocalText("notSupportCalculationWithUnknownDataType", "\u4e0d\u652f\u6301\u672a\u77e5\u6570\u636e\u7c7b\u578b\u7684\u8fd0\u7b97"));
        }
        return new Variant(fv, 10);
    }

    private class CellValue
    implements Comparable {
        private Variant _value;
        private Cell _cll;

        CellValue(Variant value, Cell cll) {
            this._value = value;
            this._cll = cll;
        }

        public int compareTo(Object obj) {
            if (this == obj) {
                return 0;
            }
            if (obj instanceof CellValue) {
                return this._value.compareTo((Object)((CellValue)obj)._value);
            }
            if (obj instanceof Variant) {
                return this._value.compareTo(obj);
            }
            return -1;
        }
    }
}

