/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.model.struct;

import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.SortedUserObjectArray;
import com.kingdee.bos.ctrl.excel.model.struct.UserObject;
import com.kingdee.bos.ctrl.excel.model.util.IntMarkEntry;

public class Column
implements IntMarkEntry {
    private Sheet _sheet;
    private int _col;
    private SortedUserObjectArray _userObjects;

    public Column(Sheet sheet, int col) {
        this._sheet = sheet;
        this._col = col;
    }

    public boolean isEmpty() {
        return this.isEmptyAttribute() && this.isEmptyContent();
    }

    public boolean isEmptyAttribute() {
        return this._sheet.getColSpans().searchSpan(this._col) < 0;
    }

    public boolean isEmptyContent() {
        Sheet.ICellsIterator ci = this._sheet.getCellsIterator(0, this._col, 1048575, this._col, false, false);
        return !ci.hasNext() && (this._userObjects == null || this._userObjects.size() == 0);
    }

    public String toString() {
        return Sheet.getColumnName(this._col, 0, true, true);
    }

    @Override
    public int getIntMark() {
        return this._col;
    }

    @Override
    public void setIntMark(int col) {
        this._col = col;
    }

    public int getCol() {
        return this._col;
    }

    public Sheet getSheet() {
        return this._sheet;
    }

    public Object getUserObjectValue(String key) {
        UserObject uo;
        if (this._userObjects != null && (uo = this._userObjects.getUserObject(key)) != null) {
            return uo.getValue();
        }
        return null;
    }

    public UserObject getUserObject(String key) {
        if (this._userObjects != null) {
            return this._userObjects.getUserObject(key);
        }
        return null;
    }

    public UserObject setUserObject(String key, Object obj) {
        UserObject uo = new UserObject(key, obj);
        if (this._userObjects == null) {
            this._userObjects = new SortedUserObjectArray();
        }
        return (UserObject)this._userObjects.insert(uo);
    }

    public UserObject removeUserObject(String key) {
        if (this._userObjects != null) {
            return this._userObjects.removeByKey(key);
        }
        return null;
    }

    public SortedUserObjectArray getUserObjects() {
        return this._userObjects;
    }
}

