/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.model.struct;

import com.kingdee.bos.ctrl.excel.model.expr.Expr;
import com.kingdee.bos.ctrl.excel.model.expr.ExprContext;
import com.kingdee.bos.ctrl.excel.model.expr.ExprOperator;
import com.kingdee.bos.ctrl.excel.model.expr.IExprNode;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.HilightCaretListener;
import com.kingdee.bos.ctrl.excel.model.struct.ICalculable;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.Span;
import com.kingdee.bos.ctrl.excel.model.struct.node.CellBlockNode;
import com.kingdee.bos.ctrl.excel.model.util.ObjectArray;
import java.awt.Color;
import javax.swing.JFrame;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;

public class HiLight {
    private static Color[] _colorSerials = new Color[]{Color.BLACK, new Color(0, 0, 255), new Color(0, 128, 0), new Color(153, 0, 204), new Color(128, 0, 0), new Color(0, 204, 51), new Color(255, 102, 0), new Color(204, 0, 153), new Color(204, 0, 153)};
    private ICalculable _owner;
    private ObjectArray _nodes;
    private ObjectArray _codes;
    private ObjectArray _positions;
    private ObjectArray _colors;
    private CaretListener _listener;

    static void addStylesToDocument(StyledDocument doc) {
        Style def = StyleContext.getDefaultStyleContext().getStyle("default");
        StyleConstants.setFontFamily(def, "\u5b8b\u4f53");
        StyleConstants.setFontSize(def, 16);
        for (int i = 0; i < _colorSerials.length; ++i) {
            Style regular = doc.addStyle("C" + i, def);
            StyleConstants.setForeground(regular, _colorSerials[i]);
            Style bold = doc.addStyle("B" + i, regular);
            StyleConstants.setBold(bold, true);
            StyleConstants.setBackground(bold, new Color(255, 202, 0));
        }
    }

    public HiLight(ICalculable owner, ObjectArray nodes) {
        this._owner = owner;
        this._nodes = nodes;
        int size = this._nodes.size();
        this._codes = new ObjectArray(size);
        this._positions = new ObjectArray(size);
        this._colors = new ObjectArray(size);
        this.refresh();
    }

    public CaretListener getCaretListener() {
        return this._listener;
    }

    public Span getCodePos(int index) {
        return (Span)this._positions.get(index);
    }

    public int getStyleIndex(int index) {
        return (Integer)this._colors.get(index);
    }

    public void setCaretListener(CaretListener listener) {
        this._listener = listener;
    }

    public void refresh() {
        ExprContext ctx = this._owner.getSheet().getDeps().getExprContext();
        int size = this._nodes.size();
        int pos = 0;
        int ref = 0;
        int par = 0;
        for (int i = 0; i < size; ++i) {
            IExprNode node = (IExprNode)this._nodes.get(i);
            String code = node.decode(ctx, this._owner);
            this._codes.append((Object)code);
            int len = code.length();
            this._positions.append((Object)new Span(pos, pos + len - 1));
            pos += len;
            int clr = 0;
            if (node instanceof CellBlockNode) {
                clr = ref++;
            } else if (node == ExprOperator.LP) {
                clr = par++;
            } else if (node == ExprOperator.RP) {
                clr = --par;
            }
            this._colors.append((Object)new Integer(clr));
        }
    }

    public Span getCaretParentheses(int pos) {
        Span span = null;
        int size = this._positions.size();
        block0: for (int i = 0; i < size; ++i) {
            Span sp = (Span)this._positions.get(i);
            if (!sp.contains(pos)) continue;
            Object node = this._nodes.get(i);
            if (node == ExprOperator.RP) {
                span = new Span(i, i);
                --i;
                int rp = 1;
                while (i >= 0) {
                    node = this._nodes.get(i);
                    if (node == ExprOperator.RP) {
                        ++rp;
                    } else if (node == ExprOperator.LP && --rp <= 0) {
                        span.setStart(i);
                        break block0;
                    }
                    --i;
                }
            } else {
                if (i <= 0 || sp.getStart() != pos || this._nodes.get(i - 1) != ExprOperator.LP) break;
                span = new Span(i - 1, i);
                int lp = 1;
                while (i < size) {
                    node = this._nodes.get(i);
                    if (node == ExprOperator.LP) {
                        ++lp;
                    } else if (node == ExprOperator.RP && --lp <= 0) {
                        span.setEnd(i);
                        break block0;
                    }
                    ++i;
                }
            }
            break;
        }
        return span;
    }

    public void addTextToDocument(StyledDocument doc, Span span) {
        try {
            int col = span == null ? -1 : span.getStart();
            int col2 = span == null ? -1 : span.getEnd();
            int size = this._nodes.size();
            for (int i = 0; i < size; ++i) {
                boolean bold = i == col || i == col2;
                doc.insertString(doc.getLength(), this._codes.get(i).toString(), doc.getStyle(HiLight.getStyle((Integer)this._colors.get(i), bold)));
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public static String getStyle(int pos, boolean bold) {
        String stl = bold ? "B" : "C";
        return stl + pos % _colorSerials.length;
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                HiLight.createAndShowGUI();
            }
        });
    }

    static void Move(int n, char x, char y) {
    }

    static void Hannoi(int n, char a, char b, char c) {
        if (n == 1) {
            HiLight.Move(1, a, c);
        } else {
            HiLight.Hannoi(n - 1, a, c, b);
            HiLight.Move(n, a, c);
            HiLight.Hannoi(n - 1, b, a, c);
        }
    }

    private static void createAndShowGUI() {
        JFrame.setDefaultLookAndFeelDecorated(true);
        JFrame frame = new JFrame("HiLight");
        frame.setDefaultCloseOperation(3);
        String formula = "=-1+A1--(((B1)^2^2+(C1))--1)^2 + SUM(1,2,-3)+D4+e5+f6+g3+h4+h5";
        Book book = Book.Manager.getNewBook();
        Sheet sheet = book.getSheet(0);
        sheet.getRange(0, 0).setFormula(formula);
        Cell cll = sheet.getCell(0, 0, false);
        Expr exp = sheet.getExpr(null, formula);
        ExprContext ctx = sheet.getDeps().getExprContext();
        HiLight ht = new HiLight(cll, exp.getDecodeList(ctx));
        ht.setCaretListener(new HilightCaretListener(ht));
        JTextPane text = new JTextPane();
        StyledDocument doc = text.getStyledDocument();
        HiLight.addStylesToDocument(doc);
        ht.addTextToDocument(doc, null);
        text.addCaretListener(ht.getCaretListener());
        text.setOpaque(true);
        text.setBackground(new Color(216, 208, 200));
        frame.setContentPane(text);
        frame.pack();
        frame.setVisible(true);
    }
}

