/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.model.struct;

import com.kingdee.bos.ctrl.common.util.SectionByteOutputStream;
import com.kingdee.bos.ctrl.common.util.ZipUtil;
import com.kingdee.bos.ctrl.excel.model.struct.FunctionManager;
import com.kingdee.bos.ctrl.excel.model.struct.IPackageQuery;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.bos.ctrl.excel.model.struct.QueryManager;
import com.kingdee.bos.ctrl.excel.model.util.SortedParameterArray;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class QueryPackage {
    private FunctionManager _funcManager;
    private QueryManager _queryManager;

    public QueryPackage(QueryManager queryManager) {
        this._queryManager = queryManager != null ? queryManager : new QueryManager(null, null);
    }

    public boolean isEmpty() {
        return this._queryManager.isEmpty();
    }

    public void setPackageListener(IPackageQuery packageListener) {
        this._queryManager.setPackageListener(packageListener);
    }

    public void setFunctionManager(FunctionManager funcManager) {
        this._funcManager = funcManager;
    }

    public QueryManager getQueryManager() {
        return this._queryManager;
    }

    public boolean query() {
        return this._queryManager.query(this._funcManager);
    }

    public byte[] save() {
        byte[] data = null;
        try {
            SectionByteOutputStream bytes = new SectionByteOutputStream();
            ObjectOutputStream out = new ObjectOutputStream((OutputStream)bytes);
            out.writeObject(this._queryManager);
            out.close();
            data = ZipUtil.pack((SectionByteOutputStream)bytes);
            bytes.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return data;
    }

    public boolean load(byte[] data) {
        if (data == null || data.length == 0) {
            return false;
        }
        try {
            InputStream stream = ZipUtil.unpack((byte[])data);
            ObjectInputStream in = new ObjectInputStream(stream);
            Object obj = in.readObject();
            in.close();
            this._queryManager = (QueryManager)obj;
            if (this._funcManager != null) {
                this._queryManager.resumeProviders(this._funcManager);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    public boolean load(List nodes) {
        if (nodes == null || nodes.isEmpty()) {
            return false;
        }
        HashMap batchs = this._queryManager.getBatchQueries();
        HashMap invokes = this._queryManager.getInvokeQueries();
        for (int i = nodes.size() - 1; i >= 0; --i) {
            Node node = (Node)nodes.get(i);
            HashMap quries = node.isBatchMethod() ? batchs : invokes;
            HashMap<String, SortedParameterArray> bag = null;
            bag = (HashMap<String, SortedParameterArray>)quries.get(node.getProviderName());
            if (bag == null) {
                bag = new HashMap<String, SortedParameterArray>();
                quries.put(node.getProviderName(), bag);
            }
            SortedParameterArray sa = null;
            sa = (SortedParameterArray)((Object)bag.get(node.getMethodName()));
            if (sa == null) {
                sa = new SortedParameterArray();
                bag.put(node.getMethodName(), sa);
            }
            sa.insert(node.getParameter());
        }
        return true;
    }

    public Iterator iterator() {
        return new PackageIterator();
    }

    private class PackageIterator
    implements Iterator {
        private boolean _batch = true;
        private Iterator _iPkg;
        private String _providerName;
        private Iterator _iBag;
        private String _methodName;
        private SortedParameterArray _sa;
        private int _pos = -1;
        private Node _node;

        PackageIterator() {
            this._iPkg = QueryPackage.this._queryManager.getBatchQueries().entrySet().iterator();
            if (!this._iPkg.hasNext()) {
                this._iPkg = QueryPackage.this._queryManager.getInvokeQueries().entrySet().iterator();
                this._batch = false;
            }
            if (this._iPkg.hasNext()) {
                this.nextBag();
            }
        }

        private void nextBag() {
            Map.Entry e = (Map.Entry)this._iPkg.next();
            this._providerName = (String)e.getKey();
            HashMap bag = (HashMap)e.getValue();
            this._iBag = bag.entrySet().iterator();
            if (this._iBag.hasNext()) {
                this.nextMethod();
            } else {
                this._pos = -1;
                this._iBag = null;
            }
        }

        private void nextMethod() {
            Map.Entry e = (Map.Entry)this._iBag.next();
            this._methodName = (String)e.getKey();
            this._sa = (SortedParameterArray)((Object)e.getValue());
            this._pos = this._sa.size() - 1;
        }

        @Override
        public boolean hasNext() {
            return this._iBag != null;
        }

        public Object next() {
            if (this._pos < 0) {
                this._node = null;
            } else {
                Parameter param = this._sa.getParameter(this._pos);
                this._node = new Node(this._batch, this._providerName, this._methodName, param, this._pos--);
                if (this._pos < 0) {
                    if (this._iBag.hasNext()) {
                        this.nextMethod();
                    } else if (this._iPkg.hasNext()) {
                        this.nextBag();
                    } else {
                        boolean hasNext = false;
                        if (this._batch) {
                            this._batch = false;
                            this._iPkg = QueryPackage.this._queryManager.getInvokeQueries().entrySet().iterator();
                            if (this._iPkg.hasNext()) {
                                hasNext = true;
                                this.nextBag();
                            }
                        }
                        if (!hasNext) {
                            this._pos = -1;
                            this._iBag = null;
                        }
                    }
                }
            }
            return this._node;
        }

        @Override
        public void remove() {
            if (this._node != null) {
                String providerName = this._node.getProviderName();
                HashMap bag = null;
                HashMap queries = QueryPackage.this._queryManager.getBatchQueries();
                bag = (HashMap)queries.get(providerName);
                if (bag == null) {
                    queries = QueryPackage.this._queryManager.getInvokeQueries();
                    bag = (HashMap)queries.get(providerName);
                }
                if (!bag.isEmpty()) {
                    String methodName = this._node.getMethodName();
                    SortedParameterArray sa = (SortedParameterArray)((Object)bag.get(methodName));
                    sa.removeByPos(this._node.getParameterPos());
                    if (sa.isEmpty()) {
                        bag.remove(methodName);
                        if (bag.isEmpty()) {
                            queries.remove(providerName);
                        }
                    }
                }
                this._node = null;
            }
        }
    }

    public static class Node {
        private String _providerName;
        private String _methodName;
        private Parameter _param;
        private int _paramPos;
        private boolean _batch;

        Node(boolean batch, String providerName, String methodName, Parameter param, int paramPos) {
            this._batch = batch;
            this._providerName = providerName;
            this._methodName = methodName;
            this._param = param;
            this._paramPos = paramPos;
        }

        public boolean isBatchMethod() {
            return this._batch;
        }

        public String getProviderName() {
            return this._providerName;
        }

        public String getMethodName() {
            return this._methodName;
        }

        public Parameter getParameter() {
            return this._param;
        }

        int getParameterPos() {
            return this._paramPos;
        }
    }

    static class ByteOutputStream
    extends ByteArrayOutputStream {
        ByteOutputStream() {
        }

        public synchronized byte[] detach() {
            byte[] data = this.buf;
            this.buf = new byte[16];
            this.count = 0;
            return data;
        }
    }
}

