/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.model.struct;

import com.kingdee.bos.ctrl.common.util.CollectionUtil;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.SheetAction;
import com.kingdee.bos.ctrl.excel.model.struct.SheetBaseMath;
import com.kingdee.bos.ctrl.excel.model.struct.URState;
import com.kingdee.bos.ctrl.excel.model.struct.event.SheetChangeEvent;
import com.kingdee.bos.ctrl.excel.model.struct.filter.AlgorithmUtil;
import java.util.ArrayList;
import java.util.List;

public class SheetAction_AutoFilter_Close
extends SheetAction {
    public SheetAction_AutoFilter_Close(Range rg) {
        super(rg, SheetChangeEvent.Changed_AutoFilter);
        if (rg.size() > 1) {
            throw new IllegalArgumentException("range should not be list");
        }
        if (rg.getBlock(0) == null) {
            throw new IllegalArgumentException("the cellblock in range should not be null");
        }
    }

    @Override
    protected void actionBlock(URState state, Sheet sheet, CellBlock cb) {
        this.showAll(sheet);
        state.setData("AutoFilterArea", sheet.getAutoFilterArea());
        sheet.setAutoFilterArea(null);
        state.setData("AutoFilters", CollectionUtil.cloneList((List)sheet.getAutoFilters()));
        sheet.getAutoFilters().clear();
        state.setData("orderBy", sheet.getOrderBy());
        state.setData("orderColIndex", sheet.getOrderColIndex());
    }

    @Override
    protected void resumeBlock(URState state, Sheet sheet, CellBlock cb) {
        sheet.setAutoFilterArea((CellBlock)state.get("AutoFilterArea"));
        List autoFilters = sheet.getAutoFilters();
        autoFilters.clear();
        autoFilters.addAll((List)state.get("AutoFilters"));
        byte orderBy = Byte.valueOf(state.get("orderBy").toString());
        int orderColIndex = Integer.valueOf(state.get("orderColIndex").toString());
        sheet.setOrderColIndex(orderColIndex);
        sheet.setOrderBy(orderBy);
    }

    protected void showAll(Sheet sheet) {
        if (sheet.getAutoFilterArea() != null) {
            ArrayList<Integer> list = AlgorithmUtil.getBeforeFilterArea(sheet, -1);
            ArrayList<Integer> showRows = new ArrayList<Integer>();
            for (int index : list) {
                if (!SheetBaseMath.isHideRow(sheet, index)) continue;
                showRows.add(index);
            }
            AlgorithmUtil.showRow(sheet, showRows, false);
            if (showRows.size() > 0) {
                sheet.getBook().fireSheetChange(sheet, null, SheetChangeEvent.Changed_Resize);
                sheet.calc();
            }
        }
    }
}

