/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.model.struct;

import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.SheetAction;
import com.kingdee.bos.ctrl.excel.model.struct.SheetBaseMath;
import com.kingdee.bos.ctrl.excel.model.struct.URState;
import com.kingdee.bos.ctrl.excel.model.struct.event.SheetChangeEvent;
import com.kingdee.bos.ctrl.excel.model.struct.filter.AlgorithmUtil;
import com.kingdee.bos.ctrl.excel.model.struct.filter.ISheetAutoFilter;
import java.util.ArrayList;
import java.util.List;

public class SheetAction_AutoFilter_DoFilter
extends SheetAction {
    private ISheetAutoFilter newFilter;
    private ISheetAutoFilter oldFilter;

    public SheetAction_AutoFilter_DoFilter(Range rg, ISheetAutoFilter newFilter, ISheetAutoFilter oldFilter) {
        super(rg, SheetChangeEvent.Changed_AutoFilter);
        if (rg.size() > 1) {
            throw new IllegalArgumentException("range should not be list");
        }
        this.newFilter = newFilter;
        this.oldFilter = oldFilter;
    }

    private void calcFilter(Sheet sheet, int beginIndex) {
        ArrayList<Integer> beforeFilterArea = AlgorithmUtil.getBeforeFilterArea(sheet, beginIndex - 1);
        ArrayList<Integer> afterFilterArea = AlgorithmUtil.calcFilterResult(sheet, beginIndex);
        ArrayList<Integer> showRows = new ArrayList<Integer>();
        ArrayList<Integer> hidewRows = new ArrayList<Integer>();
        int b_index = 0;
        int e_index = 0;
        int b_size = beforeFilterArea.size();
        int e_size = afterFilterArea.size();
        while (b_index < b_size || e_index < e_size) {
            int eRow;
            int bRow = b_index < b_size ? beforeFilterArea.get(b_index) : Integer.MAX_VALUE;
            int n = eRow = e_index < e_size ? afterFilterArea.get(e_index) : Integer.MAX_VALUE;
            if (bRow == Integer.MAX_VALUE) {
                if (SheetBaseMath.isHideRow(sheet, bRow)) {
                    showRows.add(bRow);
                }
                ++e_index;
                continue;
            }
            if (eRow == Integer.MAX_VALUE) {
                if (!SheetBaseMath.isHideRow(sheet, bRow)) {
                    hidewRows.add(bRow);
                }
                ++b_index;
                continue;
            }
            if (bRow == eRow) {
                if (SheetBaseMath.isHideRow(sheet, bRow)) {
                    showRows.add(bRow);
                }
                ++b_index;
                ++e_index;
                continue;
            }
            if (bRow < eRow) {
                if (!SheetBaseMath.isHideRow(sheet, bRow)) {
                    hidewRows.add(bRow);
                }
                ++b_index;
                continue;
            }
            if (bRow <= eRow) continue;
            ++e_index;
        }
        AlgorithmUtil.showRow(sheet, showRows, false);
        AlgorithmUtil.showRow(sheet, hidewRows, true);
        sheet.getBook().fireSheetChange(sheet, null, SheetChangeEvent.Changed_Resize);
        if (showRows.size() > 0 || hidewRows.size() > 0) {
            sheet.calc();
        }
    }

    @Override
    protected void actionBlock(URState state, Sheet sheet, CellBlock cb) {
        int oldFilterIndex;
        List autoFilters = sheet.getAutoFilters();
        if (this.oldFilter != null) {
            oldFilterIndex = autoFilters.indexOf(this.oldFilter);
            autoFilters.remove(this.oldFilter);
        } else {
            oldFilterIndex = autoFilters.size();
        }
        if (this.newFilter != null) {
            autoFilters.add(this.newFilter);
        }
        state.setData("oldFilterIndex", oldFilterIndex);
        this.calcFilter(sheet, oldFilterIndex);
    }

    @Override
    protected void resumeBlock(URState state, Sheet sheet, CellBlock cb) {
        sheet.getAutoFilters().remove(this.newFilter);
        int oldFilterIndex = Integer.valueOf(state.get("oldFilterIndex").toString());
        if (this.oldFilter != null) {
            sheet.getAutoFilters().add(oldFilterIndex, this.oldFilter);
            AlgorithmUtil.calcFilterResult(sheet, oldFilterIndex);
        }
    }
}

